/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.xmetadata;

import com.actionsoft.bpms.util.UtilIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

public class XFileVersionUtil {
    private static int BACKUP_MAX_INDEX;
    private static int BACKUP_MAX_INDEX_PROCESS;
    private static final FilenameFilter XML_FILE;

    static {
        BACKUP_MAX_INDEX_PROCESS = BACKUP_MAX_INDEX = 10;
        XML_FILE = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml") || name.toLowerCase().endsWith(".bpmn");
            }
        };
    }

    private static String getVersion(String name) {
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        int _i = name.lastIndexOf(95);
        int dot_i = name.lastIndexOf(46);
        if (_i == -1 || dot_i == -1) {
            return "";
        }
        return name.substring(_i + 1, dot_i);
    }

    public static int getNowVesion(File xmlFile) {
        File[] fs;
        int v = -1;
        if (xmlFile.exists() && (fs = xmlFile.listFiles(XML_FILE)) != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String vstr = XFileVersionUtil.getVersion(file.getName());
                int tag = 0;
                if (vstr != null && !"".equals(vstr)) {
                    try {
                        tag = Integer.parseInt(vstr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                v = Math.max(v, tag);
                ++n2;
            }
        }
        return v;
    }

    public static void backup(File nowModel, String id, File folder, boolean bakup) throws IOException {
        if (nowModel.exists() && bakup) {
            int version;
            int i = version = XFileVersionUtil.getNowVesion(folder);
            while (i >= 1) {
                File tmp = new File(folder, String.valueOf(id) + "_" + i + ".xml");
                File target = new File(folder, String.valueOf(id) + "_" + (i + 1) + ".xml");
                if (tmp.exists()) {
                    boolean bl = tmp.renameTo(target);
                }
                --i;
            }
            File tar = new File(folder, String.valueOf(id) + "_1" + ".xml");
            FileInputStream is = new FileInputStream(nowModel);
            try (FileOutputStream os = null;){
                os = new FileOutputStream(tar);
                UtilIO.copyAndCloseInput(is, os);
            }
            int c = 0;
            int i2 = 1;
            while (i2 <= version + 1) {
                File tmp = new File(folder, String.valueOf(id) + "_" + i2 + ".xml");
                if (tmp.exists()) {
                    ++c;
                }
                if (c > BACKUP_MAX_INDEX) {
                    tmp.delete();
                }
                ++i2;
            }
        }
    }

    public static void backupProcess(String id, File folder, boolean bakup) {
        if (bakup) {
            int version = XFileVersionUtil.getNowVesion(folder);
            String[] suffixs = new String[]{".bpmn", ".draw", "_small.png"};
            int i = version;
            while (i >= 1) {
                String[] stringArray = suffixs;
                int n = suffixs.length;
                int n2 = 0;
                while (n2 < n) {
                    String suffix = stringArray[n2];
                    File tmp = new File(folder, String.valueOf(id) + "_" + i + suffix);
                    File target = new File(folder, String.valueOf(id) + "_" + (i + 1) + suffix);
                    if (tmp.exists()) {
                        boolean bl = tmp.renameTo(target);
                    }
                    ++n2;
                }
                --i;
            }
            int c = 1;
            int i2 = 1;
            while (i2 <= version + 1) {
                File tmp = new File(folder, String.valueOf(id) + "_" + i2 + ".bpmn");
                if (tmp.exists()) {
                    ++c;
                }
                if (c > BACKUP_MAX_INDEX_PROCESS) {
                    String[] ss;
                    String[] stringArray = ss = new String[]{".bpmn", ".draw", "_small.png"};
                    int n = ss.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String suffix = stringArray[n3];
                        File t = new File(folder, String.valueOf(id) + "_" + i2 + suffix);
                        t.delete();
                        ++n3;
                    }
                }
                ++i2;
            }
        }
    }
}

