/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.repository;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bo.design.util.BOUtil;
import com.actionsoft.bpms.bo.design.web.BOWeb;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessDefUtil;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessDefVersionUtil;
import com.actionsoft.bpms.bpmn.engine.model.def.ActivityModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.def.UserTaskModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ext.FormSetModel;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.dictionary.model.DictModel;
import com.actionsoft.bpms.commons.dictionary.util.Xml2DictUtil;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelHelper;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.dw.design.cache.DWCache;
import com.actionsoft.bpms.dw.design.model.DWModel;
import com.actionsoft.bpms.dw.design.model.awsdw.DataViewModel;
import com.actionsoft.bpms.dw.design.util.DataWindowUtil;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.form.design.model.FormItemModel;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.repository.ModelRepositoryWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nMetadataUtil;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ModelRepositoryTreeJsonData
extends ActionWeb {
    private static final String TYPE_TEMPLATE = "template";
    private boolean hideNoChild = true;
    private String bizType = null;
    private String boDefId = null;

    public ModelRepositoryTreeJsonData(UserContext me) {
        super(me);
    }

    private Collection<String> getCategorysByApp(String appId) {
        return this.getCategorysByApp(appId, null);
    }

    private Collection<String> getCategorysByApp(String appId, String type) {
        HashSet<String> categories = new HashSet<String>();
        String uid = this.getContext().getUID();
        if (type == null || type.equals("process")) {
            Map ps = ProcessDefCache.getInstance().getListByApp(appId);
            for (ProcessDefinition model : ps.values()) {
                if (categories.contains(model.getCategoryName()) || !ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)model, (String)uid)) continue;
                categories.add(model.getCategoryName());
            }
        }
        if (type == null || type.equals("BO")) {
            Map bos = BOCache.getInstance().getListByApp(appId);
            for (ProcessDefinition model : bos.values()) {
                if (categories.contains(model.getCategoryName()) || !model.isAdministrator(uid)) continue;
                categories.add(model.getCategoryName());
            }
        }
        if (type == null || type.equals("form")) {
            Map forms = FormCache.getInstance().getListByApp(appId);
            for (ProcessDefinition model : forms.values()) {
                if (categories.contains(model.getCategoryName()) || !model.isAdministrator(uid)) continue;
                categories.add(model.getCategoryName());
            }
        }
        if (type == null || type.equals("DW")) {
            Map dws = DWCache.getInstance().getListByApp(appId);
            for (ProcessDefinition model : dws.values()) {
                String c;
                if (categories.contains(model.getCategoryName()) || !model.isAdministrator(uid) || UtilString.isEmpty(c = model.getCategoryName())) continue;
                categories.add(c);
            }
        }
        if ((type == null || type.equals("dict")) && AppsAPIManager.getInstance().isActive(appId)) {
            List dicts = Xml2DictUtil.getList((String)appId, (boolean)true);
            for (DictModel dict : dicts) {
                categories.add(dict.getCategoryName());
            }
            List dictDrs = Xml2DictUtil.getList((String)appId, (boolean)false);
            for (DictModel dr : dictDrs) {
                categories.add(dr.getCategoryName());
            }
        }
        ArrayList<String> categoryList = new ArrayList<String>(categories);
        Collections.sort(categoryList, Collator.getInstance(Locale.CHINA));
        return categoryList;
    }

    private Collection<String> getCategorysByTemplateApp(String appId) {
        HashSet<String> l = new HashSet<String>();
        Map bos = BOCache.getInstance().getListByApp(appId);
        for (BOModel model : bos.values()) {
            l.add(model.getCategoryName());
        }
        ArrayList<String> categoryList = new ArrayList<String>(l);
        Collections.sort(categoryList, Collator.getInstance(Locale.CHINA));
        return categoryList;
    }

    /*
     * WARNING - void declaration
     */
    public String getAWSBizModelTreeJsonData(String appId, String requestType, String param1, String param2, String param3, String param4) {
        boolean isTemplateNode = param3.equals("1");
        boolean isTemplateScene = TYPE_TEMPLATE.equals(this.getBizType());
        StringBuilder jsonStr = new StringBuilder("[");
        if (requestType.equals("BMRoot")) {
            jsonStr.append("{id: 'root',nocheck:true,name: '" + I18nRes.findValue("_bpm.platform", "\u5fae\u5e94\u7528") + "',open: true,iconFont:{code:'&#xe7b2;',color:'#616161'},iconCls:'tree_root',menu:false,type:'root'},");
            boolean b = AppPlatformConfig.hasValidTeam((String)super.getContext().getUID());
            if (b) {
                String type;
                int i = 0;
                String _me = this.getContext().getUID();
                if (isTemplateScene) {
                    void var15_68;
                    String templateApp = SDK.getAppAPI().getProperty("_bpm.platform", "templateApp");
                    String[] array = templateApp.trim().split(",");
                    boolean bl = false;
                    while (var15_68 < array.length) {
                        String id = array[var15_68];
                        if (!UtilString.isEmpty(id)) {
                            jsonStr.append(this.getBizModelAppsJson(++i, AppsAPIManager.getInstance().getAppContext(id), isTemplateNode)).append(',');
                        }
                        ++var15_68;
                    }
                }
                List<Object> apps = new ArrayList();
                String string = type = "isType".equals(param2) ? param1 : null;
                if ("dependencies".equals(param4)) {
                    AppsAPIManager.getInstance().getAppContext(appId);
                    AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
                    apps.add(appContext);
                    apps.addAll(AppsAPIManager.getInstance().queryDependencies(appContext));
                    AppsAPIManager.getInstance().sortAppByName(apps);
                } else {
                    apps = ModelRepositoryWeb.getVisibleInstalledDevAndManagementApps(_me);
                }
                for (AppContext appContext : apps) {
                    if (!this.isAppVisible(appContext, _me, type)) continue;
                    boolean superMaster = GradeSecurityUtil.isSuperMaster(_me);
                    if (HighSecurity.isON()) {
                        superMaster = HighSecurity.is3PSysAdmin(_me);
                    }
                    if (!superMaster && !isTemplateScene && !this.hasManageModel(appContext.getId(), _me)) continue;
                    jsonStr.append(this.getBizModelAppsJson(++i, appContext, isTemplateNode)).append(',');
                }
            }
        } else if (requestType.equals("BMApps")) {
            if (isTemplateScene) {
                Collection<String> cs = this.getCategorysByTemplateApp(appId);
                int i = 0;
                for (String c : cs) {
                    jsonStr.append(this.getBizModelCategorysJson(param1, ++i, appId, c, isTemplateNode)).append(',');
                }
            } else {
                Collection<String> cs = this.getCategorysByApp(appId);
                int i = 0;
                for (String c : cs) {
                    if (!this.isAppCategoryVisible(appId, c, this.getContext().getUID())) continue;
                    jsonStr.append(this.getBizModelCategorysJson(param1, ++i, appId, c, isTemplateNode)).append(',');
                }
            }
        } else if (requestType.equals("BMDWApps")) {
            Collection<String> cs = this.getCategorysByApp(appId, param1);
            int i = 0;
            for (String c : cs) {
                if (!this.isAppCategoryVisible(appId, c, this.getContext().getUID())) continue;
                jsonStr.append(this.getBizModelCategorysJson(param1, ++i, appId, c, false)).append(',');
            }
        } else if (requestType.equals("BMCategoryByApp")) {
            Collection<String> cs = this.getCategorysByApp(appId);
            for (String c : cs) {
                jsonStr.append(this.getCategoryJsonByAppId(appId, c)).append(',');
            }
            if ("dependencies".equals(param4)) {
                AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
                List dependencies = AppsAPIManager.getInstance().queryDependencies(appContext);
                for (AppContext context : dependencies) {
                    String string = context.getId();
                    cs = this.getCategorysByApp(string);
                    for (String c : cs) {
                        jsonStr.append(this.getCategoryJsonByAppId(string, c)).append(',');
                    }
                }
            }
        } else if (requestType.equals("BMCategory")) {
            String templateType = param2;
            if (templateType.toLowerCase().equals("all")) {
                jsonStr.append(this.getBizModelPDCategoryJson(param1, 1, appId, param4));
                jsonStr.append(this.getBizModelFormCategoryJson(param1, 2, appId, param4));
                jsonStr.append(this.getBizModelBOCategoryJson(param1, 3, appId, param4));
                jsonStr.append(this.getBizModelDataWindowJson(param1, 5, appId, param4));
                jsonStr.append(this.getBizModelDictionaryJson(param1, 6, appId, param4));
            } else {
                if (templateType.toLowerCase().equals("wf")) {
                    return this.getAWSBizModelTreeJsonData(appId, "BMPDCategory", param1, param4, param3, param4);
                }
                if (templateType.toLowerCase().equals("form")) {
                    return this.getAWSBizModelTreeJsonData(appId, "BMFormCategory", param1, param4, param3, param4);
                }
                if (templateType.toLowerCase().startsWith("bo")) {
                    return this.getAWSBizModelTreeJsonData(appId, "BMBOCategory", param4, param2, param3, param4);
                }
                if (templateType.toLowerCase().equals("report")) {
                    return this.getAWSBizModelTreeJsonData(appId, "BMReportCategory", param1, param4, param3, param4);
                }
                if (templateType.toLowerCase().equals("exp")) {
                    return this.getAWSBizModelTreeJsonData(appId, "BMBOCategory", param4, param2, param3, param4);
                }
            }
        } else if (requestType.equals("BMPDCategory")) {
            String categoryName = param2;
            String[] groups = ProcessDefCache.getInstance().getGroupIds(appId);
            if (groups != null) {
                ArrayList processAllList = new ArrayList();
                int iiii = 0;
                while (iiii < groups.length) {
                    List list;
                    String groupId = groups[iiii];
                    if (groupId != null && (list = ProcessDefCache.getInstance().getListOfProcessGroup(appId, groupId)).size() != 0) {
                        processAllList.addAll(list);
                    }
                    ++iiii;
                }
                ProcessDefCache.getInstance().sortByName(processAllList);
                JSONObject json = new JSONObject();
                for (ProcessDefinition processDef : processAllList) {
                    if (processDef == null || !processDef.getCategoryName().equals(categoryName) || processDef.getEngineType() == 1 || processDef == null || !ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)processDef, (String)super.getContext().getUID()) || json.containsKey((Object)processDef.getProcessGroupName())) continue;
                    jsonStr.append(this.getPDGroupJSon(appId, processDef, param1)).append(',');
                    json.put(processDef.getProcessGroupName(), (Object)1);
                }
            }
        } else if (requestType.equals("BMPDGroup")) {
            String categoryName = param1;
            String groupId = param2;
            List processList = ProcessDefCache.getInstance().getListOfProcessGroup(appId, groupId);
            ProcessDefCache.getInstance().sortByCreateTimeDesc(processList);
            for (ProcessDefinition processDef : processList) {
                if (!processDef.getCategoryName().equals(categoryName) || processDef != null && !ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)processDef, (String)super.getContext().getUID()) || processDef.getEngineType() == 1) continue;
                if (param4 == null || "".equals(param4)) {
                    param4 = "true";
                }
                jsonStr.append(this.getPDJson(appId, processDef, isTemplateNode, groupId, param4)).append(',');
            }
        } else if (requestType.equals("BMDIC")) {
            jsonStr.append(this.getDictionary(appId, true, param1, param4));
            jsonStr.append(this.getDictionary(appId, false, param1, param4));
        } else if (requestType.equals("BMPD")) {
            List tasks = ((ProcessDefinition)ProcessDefCache.getInstance().getModel(param1)).getTaskList();
            int ii = 0;
            while (tasks != null && ii < tasks.size()) {
                ActivityModel activityModel = (ActivityModel)tasks.get(ii);
                JSONObject taskJO = new JSONObject();
                taskJO.put("id", (Object)("task_" + activityModel.getId()));
                taskJO.put("name", (Object)I18nRes.findValue("_bpm.platform", activityModel.getName()));
                taskJO.put("pid", (Object)("AWS_NODE_WF_ID_" + activityModel.getProcessDefId()));
                if (activityModel instanceof UserTaskModel) {
                    taskJO.put("icon", (Object)"../apps/_bpm.platform/img/prm/tree/usertask.gif");
                } else {
                    taskJO.put("icon", (Object)"../apps/_bpm.platform/img/prm/tree/unusertask.gif");
                }
                taskJO.put("appid", (Object)appId);
                taskJO.put("taskId", (Object)activityModel.getId());
                taskJO.put("type", (Object)"BMTask");
                jsonStr.append(taskJO.toString()).append(',');
                ++ii;
            }
        } else if (requestType.equals("BMFormCategory")) {
            String categoryName = param2;
            List formList = FormCache.getInstance().getListByCategoryName(appId, categoryName);
            Collections.sort(formList, new Comparator<FormModel>(){

                @Override
                public int compare(FormModel o1, FormModel o2) {
                    Collator myCollator = Collator.getInstance(Locale.CHINA);
                    return myCollator.compare(o1.getTitle(), o2.getTitle());
                }
            });
            for (FormModel formModel : formList) {
                if (formModel != null && !formModel.isAdministrator(super.getContext().getUID())) continue;
                jsonStr.append(this.getFormJson(appId, formModel, isTemplateNode, param1)).append(',');
            }
        } else if (requestType.equals("BMBOCategory")) {
            int n;
            String categoryName = param1;
            String templateType = param2;
            String processGroupId = null;
            String dwViewId = null;
            boolean isDw = false;
            boolean bl = false;
            if (param4.endsWith("dwDataSourceType")) {
                String[] temp = param4.split("\\|");
                processGroupId = temp[0];
                dwViewId = temp[1];
                isDw = true;
                n = ProcessDefCache.getInstance().getEngineType(processGroupId);
            }
            if (n == 0 && isDw) {
                List formModelList = DataWindowUtil.getFormModels((String)appId, processGroupId);
                DataViewModel dataViewModel = DWCache.getInstance().getDataViewModel(appId, processGroupId, dwViewId);
                for (FormModel fm : formModelList) {
                    if (fm == null || !fm.getCategoryName().equals(categoryName)) continue;
                    String boId = ((FormItemModel)fm.getFormItems().get(0)).getBoModelId();
                    if (!BOUtil.isLocal((String)((BOModel)BOCache.getInstance().getModel(boId)).getTarget()) && dataViewModel.getImplClassName().indexOf("CommonDataView") == -1) continue;
                    jsonStr.append(this.getBOJson(appId, (BOModel)BOCache.getInstance().getModel(boId), isTemplateNode, templateType, param1)).append(',');
                }
            } else {
                List boList = BOCache.getInstance().getListByCategoryName(appId, categoryName);
                Collections.sort(boList, new Comparator<BOModel>(){

                    @Override
                    public int compare(BOModel o1, BOModel o2) {
                        Collator myCollator = Collator.getInstance(Locale.CHINA);
                        return myCollator.compare(o1.getName(), o2.getName());
                    }
                });
                for (BOModel boModel : boList) {
                    if (!boModel.isAdministrator(this.getContext().getUID())) continue;
                    jsonStr.append(this.getBOJson(appId, boModel, isTemplateNode, templateType, param1)).append(',');
                }
            }
        } else if (requestType.equals("BMBO")) {
            String id = param1;
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(id);
            List hMapList = BOCache.getInstance().getBOItemList(boModel);
            if (hMapList != null && hMapList.size() > 0) {
                for (BOItemModel mapModel : hMapList) {
                    jsonStr.append(this.getBOFieldJson(boModel, mapModel, isTemplateNode, param1)).append(',');
                }
            }
        } else if (!requestType.equals("BMReportCategory") && requestType.equals("BMDWCategory")) {
            String categoryName = param1;
            String templateType = param2;
            if (!UtilString.isEmpty(categoryName)) {
                List list = DWCache.getInstance().getListByAppAndCategoryName(appId, categoryName);
                for (DWModel dw : list) {
                    if (!dw.isAdministrator(this.getContext().getUID())) continue;
                    boolean bl = true;
                    ProcessDefinition processDef = null;
                    if (dw.getDwType() != 2) {
                        List processDefList = ProcessDefCache.getInstance().getListOfGroupId(appId, dw.getProcessGroupId());
                        if (processDefList != null && processDefList.size() == 0) {
                            AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                            AppsLogger.warn((AppContext)app, (String)(String.valueOf(I18nRes.findValue("_bpm.platform", "\u6570\u636e\u7a97\u53e3\u6a21\u578b")) + "\uff1a" + dw.getProcessGroupId() + I18nRes.findValue("_bpm.platform", "\u5bf9\u5e94\u7684\u6d41\u7a0b\u5df2\u4e22\u5931") + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u5982\u679c\u9700\u8981\u6062\u590d\u8be5\u6570\u636e\u7a97\u53e3\u6a21\u578b,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458") + "\u3002"));
                        } else {
                            ProcessDefCache.getInstance().sortByCreateTime(processDefList);
                            processDef = (ProcessDefinition)processDefList.get(0);
                        }
                    }
                    jsonStr.append(this.getDWJson(appId, processDef, isTemplateNode, templateType, dw, param4)).append(',');
                }
            }
        }
        if (jsonStr.toString().lastIndexOf(",") > -1) {
            jsonStr.setLength(jsonStr.length() - 1);
        }
        jsonStr.append(']');
        return jsonStr.toString();
    }

    public String getBMTreeJsonDataList(UserContext me, String appId, String requestType, String param1, String param2, String param3, String param4) {
        ResponseObject rs = ResponseObject.newOkResponse();
        boolean isTemplateScene = TYPE_TEMPLATE.equals(this.getBizType());
        String _me = me.getUID();
        AppContext oldApp = AppsAPIManager.getInstance().getAppContext(appId);
        List apps = new ArrayList();
        JSONArray newArr = new JSONArray();
        if ("BMApps".equals(requestType)) {
            String bmDatas = this.getAWSBizModelTreeJsonData(appId, requestType, param1, param2, param3, param4);
            JSONArray oldArr = JSONArray.parseArray((String)bmDatas);
            int i = 0;
            while (i < oldArr.size()) {
                JSONObject newObj = new JSONObject();
                JSONObject oldObj = (JSONObject)oldArr.get(i);
                if (!"root".equals(oldObj.get((Object)"type"))) {
                    newObj.put("id", oldObj.get((Object)"name"));
                    if (oldObj.get((Object)"name") != null) {
                        newObj.put("text", (Object)I18nRes.findValue("_bpm.platform", oldObj.get((Object)"name").toString()));
                    } else {
                        newObj.put("text", oldObj.get((Object)"name"));
                    }
                    newArr.add((Object)newObj);
                }
                ++i;
            }
        } else {
            apps = AppsAPIManager.getInstance().queryDependenciesIncludeSelfAndSort(oldApp);
            for (AppContext appContext : apps) {
                if (!this.isAppVisible(appContext, _me) || !GradeSecurityUtil.isSuperMaster(_me) && !isTemplateScene && !this.hasManageModel(appContext.getId(), _me)) continue;
                JSONObject newObj = new JSONObject();
                newObj.put("id", (Object)appContext.getId());
                newObj.put("text", (Object)I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName()));
                newArr.add((Object)newObj);
            }
            List childApps = AppsAPIManager.getInstance().getInstalledApps();
            for (AppContext appCont : childApps) {
                if (!GradeSecurityUtil.isSuperMaster(_me) && !isTemplateScene && !this.hasManageModel(appCont.getId(), _me) || appCont.getParentContext() == null || !appCont.getParentContext().getId().equals(appId)) continue;
                JSONObject newObj = new JSONObject();
                newObj.put("id", (Object)appCont.getId());
                newObj.put("text", (Object)I18nMetadataUtil.findValue(appCont.getId(), "APP_NAME_", appCont.getId(), this.getContext().getLanguage(), appCont.getName()));
                newArr.add((Object)newObj);
            }
        }
        rs.put("newArr", newArr);
        return rs.toString();
    }

    private boolean hasManageModel(String appId, String uid) {
        Collection<String> cs = this.getCategorysByApp(appId);
        for (String c : cs) {
            if (!this.isAppCategoryVisible(appId, c, uid)) continue;
            return true;
        }
        return false;
    }

    private String getBizModelDictionaryJson(String prefix, int index, String appId, String categoryname) {
        List models = Xml2DictUtil.getList((String)appId, (boolean)true, (String)categoryname, (String)this.getContext().getUID());
        List DR = Xml2DictUtil.getList((String)appId, (boolean)false, (String)categoryname, (String)this.getContext().getUID());
        if (models.size() == 0 && DR.size() == 0) {
            return "";
        }
        StringBuilder jsonStr = new StringBuilder();
        String id = "AWS_NODE_WC_DC_" + prefix + "_" + index;
        String pid = "AWS_NODE_BC_ID_" + prefix;
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(I18nRes.findValue("_bpm.platform", "\u5b57\u5178\u6a21\u578b"));
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("category:'").append(categoryname).append("',");
        jsonStr.append("type:'BMDIC',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#xe7dc;");
        ifj.put("color", (Object)"#fb9a66");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}').append(',');
        return jsonStr.toString();
    }

    private String getDictionary(String appId, boolean isDic, String categoryName, String pid) {
        StringBuilder jsonStr = new StringBuilder();
        List models = Xml2DictUtil.getList((String)appId, (boolean)isDic, (String)categoryName, (String)this.getContext().getUID());
        if (models != null) {
            for (DictModel dictModel : models) {
                JSONObject ifj;
                JSONObject json = new JSONObject();
                json.put("menu", (Object)false);
                if (isDic) {
                    json.put("id", (Object)("XD_" + dictModel.getId()));
                    json.put("pid", (Object)pid);
                    json.put("type", (Object)"BMDICXD");
                    ifj = new JSONObject();
                    ifj.put("code", (Object)"&#xe7dc;");
                    ifj.put("color", (Object)"#fb9a66");
                    json.put("iconFont", (Object)ifj);
                } else {
                    json.put("id", (Object)("CD_" + dictModel.getId()));
                    json.put("pid", (Object)pid);
                    json.put("type", (Object)"BMDICCD");
                    ifj = new JSONObject();
                    ifj.put("code", (Object)"&#59063;");
                    ifj.put("color", (Object)"#f87b79");
                    json.put("iconFont", (Object)ifj);
                }
                json.put("name", (Object)I18nRes.findValue("_bpm.platform", dictModel.getTitle()));
                json.put("appid", (Object)appId);
                json.put("isDic", (Object)isDic);
                json.put("xmlName", (Object)dictModel.getName());
                json.put("category", (Object)categoryName);
                jsonStr.append(json.toString()).append(',');
            }
        }
        return jsonStr.toString();
    }

    private String getBOJson(String appId, BOModel boModel, boolean isTemplateNode, String templateType, String categoryId) {
        StringBuilder json = new StringBuilder();
        json.append('{');
        json.append("id:'AWS_NODE_BO_ID_").append(boModel.getId()).append("',");
        json.append("name:'").append(BOWeb.getBOTitle((BOModel)boModel, (int)7)).append("',");
        if (boModel.getEntityType() == null) {
            return "";
        }
        JSONObject ifj = new JSONObject();
        if (boModel.getEntityType().equals("VIEW") && boModel.getViewType().equals("BOVIEW")) {
            ifj.put("code", (Object)"&#xe7cc;");
            ifj.put("color", (Object)"#f48552");
            json.append("iconClsName:'treeBMBOVBOView',");
        } else if (boModel.getEntityType().equals("VIEW") && boModel.getViewType().equals("COMMON")) {
            ifj.put("code", (Object)"&#xe7cc;");
            ifj.put("color", (Object)"#f48552");
            json.append("iconClsName:'treeBMBOVCommon',");
        } else if (boModel.getEntityType().equals("STRUCTURE")) {
            ifj.put("code", (Object)"&#59177;");
            ifj.put("color", (Object)"#9cc153");
            json.append("iconClsName:'treeBMBOStructure',");
        } else {
            ifj.put("code", (Object)"&#58898;");
            ifj.put("color", (Object)"#f5bd5e");
            json.append("iconClsName:'treeBMBO',");
        }
        json.append("iconFont:" + ifj + ",");
        json.append("qtip:'").append(boModel.getName()).append("',");
        json.append("menu:false,");
        if (!isTemplateNode) {
            json.append("nocheck:true,");
        } else if (isTemplateNode && templateType.equals("bo")) {
            json.append("templateNode:true,");
            json.append("nocheck:true,");
        } else if (isTemplateNode && templateType.equals("bofield")) {
            json.append("open:false,");
        } else if (isTemplateNode && templateType.equals("exp")) {
            json.append("nocheck:true,");
        }
        json.append("category:'").append(boModel.getCategoryName()).append("',");
        json.append("type:'BMBO',");
        json.append("draggable:false");
        if (!boModel.getEntityType().equals("STRUCTURE") && !BOUtil.hasTables((BOModel)boModel)) {
            json.append(",exist:false");
        }
        String pid = "AWS_NODE_BC_BO_" + appId + "_" + categoryId.replaceAll(" ", "");
        json.append(",appid:'").append(appId).append("',");
        json.append("title:'").append(boModel.getName()).append("',");
        json.append("pid:'" + pid + "'");
        json.append('}');
        return json.toString();
    }

    private String getDWJson(String appId, ProcessDefinition model, boolean isTemplateNode, String templateType, DWModel dw, String categoryId) {
        StringBuilder json = new StringBuilder();
        String processGroupName = model == null ? dw.getProcessGroupName() : model.getProcessGroupName();
        String processId = model == null ? dw.getId() : model.getId();
        json.append('{');
        json.append("id:'AWS_NODE_UV_ID_").append(processId).append("',");
        if (dw.getTitle() == null) {
            json.append("name:'").append(processGroupName).append("',");
        } else {
            json.append("name:'").append(dw.getTitle().getLabel()).append("',");
        }
        json.append("menu:false,");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#59804;");
        ifj.put("color", (Object)"#5bc376");
        json.append("iconFont:" + ifj + ",");
        json.append("qtip:'").append(processGroupName).append("',");
        json.append("leaf:true,");
        json.append("processGroupId:'").append(dw.getProcessGroupId()).append("',");
        json.append("category:'").append(dw.getCategoryName()).append("',");
        json.append("type:'DWDetailed',");
        json.append("draggable:false");
        String pid = "AWS_NODE_UC_UV_" + categoryId;
        json.append(",appid:'").append(appId).append("',");
        json.append("pid:'" + pid + "'");
        json.append(",menu:false");
        json.append('}');
        return json.toString();
    }

    private String getBOFieldJson(BOModel metaDataModel, BOItemModel boItemModel, boolean isTemplateNode, String categoryId) {
        if (metaDataModel == null) {
            return "";
        }
        if (UtilString.isEmpty(boItemModel.getId())) {
            return "";
        }
        StringBuilder json = new StringBuilder();
        json.append('{');
        json.append("id:'AWS_NODE_BO_ID_").append(boItemModel.getId()).append("',");
        json.append("name:'").append(boItemModel.getName());
        json.append("/").append(boItemModel.getTitle()).append("',");
        json.append("iconCls:'treeBMBOField',");
        json.append("qtip:'").append(boItemModel.getName());
        json.append("/").append(boItemModel.getTitle()).append("',");
        if (!isTemplateNode || this.isTemplateHasField(boItemModel)) {
            json.append("nocheck:true,");
        }
        json.append("category:'").append(metaDataModel.getCategoryName()).append("',");
        json.append("fieldName:'").append(boItemModel.getName()).append("',");
        json.append("type:'BMBOField',");
        json.append("pid:'AWS_NODE_BO_ID_").append(metaDataModel.getId()).append("',");
        json.append("draggable:false");
        json.append(",menu:false");
        json.append('}');
        return json.toString();
    }

    private String getFormJson(String appId, FormModel formModel, boolean isTemplateNode, String categoryId) {
        StringBuilder json = new StringBuilder();
        json.append('{');
        json.append("id:'AWS_NODE_FM_ID_").append(formModel.getId()).append("',");
        json.append("name:'").append(I18nMetadataUtil.findValue(appId, "FORM_NAME_", formModel.getId(), this.getContext().getLanguage(), formModel.getTitle()).replace("<", "&lt;").replace(">", "&gt;")).append("',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#xe706;");
        ifj.put("color", (Object)"#57c6bc");
        json.append("iconFont:" + ifj + ",");
        json.append("leaf:true,");
        json.append("menu:false,");
        if (isTemplateNode) {
            json.append("checked:false,");
        }
        json.append("category:'").append(formModel.getCategoryName()).append("',");
        json.append("type:'BMForm',");
        json.append("draggable:false");
        String pid = "AWS_NODE_FC_FM_" + categoryId;
        json.append(",appid:'").append(appId).append("',");
        json.append("pid:'" + pid + "'");
        json.append('}');
        return json.toString();
    }

    private String getPDGroupJSon(String appId, ProcessDefinition processDef, String param1) {
        StringBuilder json = new StringBuilder();
        String id = this.getGroupId(processDef);
        json.append('{');
        json.append("id:'AWS_NODE_WG_WF_").append(id).append("',");
        json.append("name:'").append(I18nMetadataUtil.findValue(appId, "PROCESS_GROUPNAME_", processDef.getProcessGroupId(), this.getContext().getLanguage(), processDef.getProcessGroupName())).append("',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#58981;");
        ifj.put("color", (Object)"#73abec");
        json.append("iconFont:" + ifj + ",");
        json.append("category:'").append(processDef.getCategoryName()).append("',");
        json.append("groupId:'").append(processDef.getProcessGroupId()).append("',");
        json.append("groupName:'").append(processDef.getProcessGroupName()).append("',");
        json.append("type:'BMPDGroup',");
        json.append("draggable:false");
        json.append(",open:false");
        String pid = "AWS_NODE_WC_WF_" + param1;
        json.append(",appid:'").append(appId).append("',");
        json.append("pid:'" + pid + "'");
        json.append(",menu:false");
        json.append('}');
        return json.toString();
    }

    private String getPDJson(String appId, ProcessDefinition processDef, boolean isTemplateNode, String groupId, String isLeaf) {
        Map groups = ProcessDefCache.getInstance().getGroups(appId);
        String processGroupName = (String)groups.get(groupId);
        StringBuilder json = new StringBuilder();
        json.append('{');
        json.append("id:'AWS_NODE_WF_ID_").append(processDef.getId()).append("',");
        String processNameStyle = ProcessDefVersionUtil.getProcessNameOfVersionStyle((String)this.getContext().getLanguage(), (ProcessDefinition)processDef);
        json.append("name:'").append(processNameStyle).append("',");
        json.append("processName:'").append(ProcessDefVersionUtil.getProcessNameOfVersion((ProcessDefinition)processDef)).append("',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#58981;");
        ifj.put("color", (Object)"#73abec");
        json.append("iconFont:" + ifj + ",");
        if (isTemplateNode) {
            json.append("templateNode:true,");
        }
        json.append("category:'").append(processDef.getCategoryName()).append("',");
        json.append("groupId:'").append(processDef.getProcessGroupId()).append("',");
        json.append("groupName:'").append(processDef.getProcessGroupName()).append("',");
        json.append("type:'BMPD',");
        json.append("processDefId:'" + processDef.getId() + "',");
        if (isLeaf != null && isLeaf.equals("false")) {
            json.append("open:false,");
        }
        json.append("draggable:false");
        String id = this.getGroupId(processDef);
        String pid = "AWS_NODE_WG_WF_" + id;
        json.append(",appid:'").append(appId).append("',");
        json.append("groupId:'").append(groupId).append("',");
        json.append("groupName:'").append(processGroupName).append("',");
        json.append("pid:'" + pid + "'");
        json.append(",menu:false");
        json.append('}');
        return json.toString();
    }

    private String getGroupId(ProcessDefinition processDef) {
        MD5 md5 = new MD5();
        StringBuilder id = new StringBuilder();
        id.append(processDef.getProcessGroupId()).append("_");
        id.append(processDef.getCategoryName().replaceAll(" ", "").replaceAll("\\.", "_").replaceAll("-", "_")).append("_");
        id.append(processDef.getProcessGroupName().replaceAll(" ", "").replaceAll("\\.", "_").replaceAll("-", "_"));
        return md5.toDigest(id.toString());
    }

    private String getBizModelCategorysJson(String index, int indexMe, String appId, String bcName, boolean isTemplateNode) {
        StringBuilder jsonStr = new StringBuilder();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        String id = "AWS_NODE_BC_ID_" + index + indexMe;
        String pid = appId.replace('.', '_');
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(bcName);
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("appname:'").append(app.getName()).append("',");
        jsonStr.append("type:'BMCategory',");
        if (!isTemplateNode) {
            jsonStr.append("nocheck:true,");
            jsonStr.append("menu:true,");
        } else {
            jsonStr.append("menu:false,");
        }
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#xe728;");
        ifj.put("color", (Object)"#2bbb8f");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false,");
        jsonStr.append("open:false,");
        jsonStr.append("pid:'" + pid + "'");
        jsonStr.append('}');
        return jsonStr.toString();
    }

    private String replaceJQUERYKey(String value) {
        return value;
    }

    private String getCategoryJsonByAppId(String appId, String categoryName) {
        StringBuilder jsonStr = new StringBuilder();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        String id = "AWS_NODE_BC_BO_" + this.replaceJQUERYKey(app.getName()) + "_" + this.replaceJQUERYKey(categoryName);
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id.replaceAll(" ", ""));
        jsonStr.append("',name:'");
        jsonStr.append(categoryName);
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("appname:'").append(app.getName()).append("',");
        jsonStr.append("type:'BMCategory',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#xe728;");
        ifj.put("color", (Object)"#2bbb8f");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append('}');
        return jsonStr.toString();
    }

    private String getBizModelAppsJson(int index, AppContext appContext, boolean isTemplateNode) {
        File icon;
        String id = appContext.getId().replace('.', '_');
        StringBuilder jsonStr = new StringBuilder();
        String text = appContext.getName();
        appContext.getRuntimeState();
        jsonStr.append('{');
        if (PlatformXMetaModelHelper.isTemplateApp(appContext.getId())) {
            text = "<span style=\"color:#FE0707\" title=\"" + I18nRes.findValue("_bpm.platform", "\u6a21\u7248") + "\">" + text + "</span>";
            jsonStr.append("title:\"" + I18nRes.findValue("_bpm.platform", "\u6a21\u7248") + "\",");
        } else if ("STOPPED".equals(appContext.getRuntimeState())) {
            text = "<span style=\"color:#999\" title=\"\u5df2\u6682\u505c\">" + text + "</span>";
            jsonStr.append("title:\"\u5df2\u6682\u505c").append("\",");
        } else if ("READY".equals(appContext.getRuntimeState())) {
            text = "<span style=\"color:#999\" title=\"\u5df2\u5c31\u7eea\">" + text + "</span>";
            jsonStr.append("title:\"\u5df2\u5c31\u7eea").append("\",");
        }
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(text);
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appContext.getId()).append("',");
        jsonStr.append("appname:'").append(appContext.getName()).append("',");
        jsonStr.append("type:'BMApps',");
        if (!isTemplateNode) {
            jsonStr.append("nocheck:true,");
        }
        if ((icon = new File(appContext.getIcon16FilePath())).exists()) {
            jsonStr.append("icon:'" + AppsAPIManager.getInstance().getIcon16URL(appContext.getId(), this.getContext()) + "',");
        } else {
            jsonStr.append("iconCls:'treeBMApps',");
        }
        jsonStr.append("leaf:false,");
        jsonStr.append("title:").append("'").append(appContext.getId()).append("',");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'root'");
        jsonStr.append(",menu:false");
        jsonStr.append('}');
        return jsonStr.toString();
    }

    private String getBizModelPDCategoryJson(String prefix, int index, String appId, String categoryname) {
        List pddwAll = ProcessDefCache.getInstance().getListOfCategory(appId, categoryname);
        ArrayList<ProcessDefinition> groupsAll = new ArrayList<ProcessDefinition>();
        for (ProcessDefinition pd : pddwAll) {
            if (pd.getEngineType() != 0) continue;
            groupsAll.add(pd);
        }
        ArrayList<ProcessDefinition> groups = new ArrayList<ProcessDefinition>();
        for (ProcessDefinition pd : groupsAll) {
            if (pd == null || pd.getEngineType() != 0 || !ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)pd, (String)super.getContext().getUID())) continue;
            groups.add(pd);
        }
        if (groups.size() == 0) {
            return "";
        }
        StringBuilder jsonStr = new StringBuilder();
        String id = "AWS_NODE_WC_WF_" + prefix + "_" + index;
        String pid = "AWS_NODE_BC_ID_" + prefix;
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(I18nRes.findValue("_bpm.platform", "\u6d41\u7a0b\u6a21\u578b"));
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("category:'").append(categoryname).append("',");
        jsonStr.append("type:'BMPDCategory',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#58981;");
        ifj.put("color", (Object)"#73abec");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}').append(',');
        return jsonStr.toString();
    }

    private String getBizModelFormCategoryJson(String prefix, int index, String appId, String categoryname) {
        List formListAll = FormCache.getInstance().getListByCategoryName(appId, categoryname);
        ArrayList<FormModel> formList = new ArrayList<FormModel>();
        String uid = super.getContext().getUID();
        for (FormModel fm : formListAll) {
            if (fm == null || !fm.isAdministrator(uid)) continue;
            fm.setTitle(I18nMetadataUtil.findValue(appId, "FORM_NAME_", fm.getId(), this.getContext().getLanguage(), fm.getTitle()));
            formList.add(fm);
        }
        if (formList.size() == 0) {
            return "";
        }
        StringBuilder jsonStr = new StringBuilder();
        String id = "AWS_NODE_FC_FM_" + prefix + "_" + index;
        String pid = "AWS_NODE_BC_ID_" + prefix;
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(I18nRes.findValue("_bpm.platform", "\u8868\u5355\u6a21\u578b"));
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("category:'").append(categoryname).append("',");
        jsonStr.append("type:'BMFormCategory',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#xe706;");
        ifj.put("color", (Object)"#57c6bc");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}').append(',');
        return jsonStr.toString();
    }

    private String getBizModelBOCategoryJson(String prefix, int index, String appId, String categoryname) {
        List boListAll = BOCache.getInstance().getListByCategoryName(appId, categoryname);
        ArrayList<BOModel> boList = new ArrayList<BOModel>();
        for (BOModel bm : boListAll) {
            if (!bm.isAdministrator(this.getContext().getUID())) continue;
            boList.add(bm);
        }
        if (boList.size() == 0) {
            return "";
        }
        StringBuilder jsonStr = new StringBuilder();
        String id = "AWS_NODE_BC_BO_" + prefix + "_" + index;
        String pid = "AWS_NODE_BC_ID_" + prefix;
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(I18nRes.findValue("_bpm.platform", "\u5b58\u50a8\u6a21\u578b"));
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("category:'").append(categoryname).append("',");
        jsonStr.append("type:'BMBOCategory',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#58898;");
        ifj.put("color", (Object)"#f5bd5e");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}').append(',');
        return jsonStr.toString();
    }

    private String getBizModelDataWindowJson(String prefix, int index, String appId, String categoryname) {
        List list = DWCache.getInstance().getListByAppAndCategoryName(appId, categoryname);
        int count = 0;
        String _me = this.getContext().getUID();
        for (DWModel dw : list) {
            if (!dw.isAdministrator(_me)) continue;
            if (++count > 0) break;
            boolean dwFileExsit = true;
            ProcessDefinition processDef = null;
            if (dw.getDwType() == 2) continue;
            List processDefList = ProcessDefCache.getInstance().getListOfGroupId(appId, dw.getProcessGroupId());
            if (processDefList != null && processDefList.size() == 0) {
                AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                AppsLogger.warn((AppContext)app, (String)(String.valueOf(I18nRes.findValue("_bpm.platform", "\u6570\u636e\u7a97\u53e3\u6a21\u578b")) + "\uff1a" + dw.getProcessGroupId() + I18nRes.findValue("_bpm.platform", "\u5bf9\u5e94\u7684\u6d41\u7a0b\u5df2\u4e22\u5931") + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u5982\u679c\u9700\u8981\u6062\u590d\u8be5\u6570\u636e\u7a97\u53e3\u6a21\u578b,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458") + "\u3002"));
                continue;
            }
            ProcessDefCache.getInstance().sortByCreateTime(processDefList);
            processDef = (ProcessDefinition)processDefList.get(0);
        }
        if (count == 0) {
            return "";
        }
        StringBuilder jsonStr = new StringBuilder();
        String id = "AWS_NODE_UC_UV_" + prefix + "_" + index;
        String pid = "AWS_NODE_BC_ID_" + prefix;
        jsonStr.append('{');
        jsonStr.append("id:'");
        jsonStr.append(id);
        jsonStr.append("',name:'");
        jsonStr.append(I18nRes.findValue("_bpm.platform", "\u6570\u636e\u7a97\u53e3"));
        jsonStr.append("',");
        jsonStr.append("appid:'").append(appId).append("',");
        jsonStr.append("category:'").append(categoryname).append("',");
        jsonStr.append("type:'BMDWCategory',");
        JSONObject ifj = new JSONObject();
        ifj.put("code", (Object)"&#59804;");
        ifj.put("color", (Object)"#5bc376");
        jsonStr.append("iconFont:" + ifj + ",");
        jsonStr.append("leaf:false,");
        jsonStr.append("draggable:false");
        jsonStr.append(",open:false");
        jsonStr.append(",pid:'" + pid + "'");
        jsonStr.append(",menu:false");
        jsonStr.append('}').append(',');
        return jsonStr.toString();
    }

    public String getAppList() {
        ResponseObject ro = ResponseObject.newOkResponse();
        List<AppContext> apps = ModelRepositoryWeb.getVisibleInstalledApps(super.getContext().getUID());
        JSONArray array = new JSONArray();
        JSONObject empty = new JSONObject();
        empty.put("id", (Object)"");
        empty.put("text", (Object)"");
        empty.put("imgs", (Object)"");
        array.add((Object)empty);
        for (AppContext appContext : apps) {
            if (!appContext.getRuntimeState().equals("ACTIVE")) continue;
            JSONObject json = new JSONObject();
            String img = AMCUtil.getAppIconNoClass(appContext.getId());
            json.put("label", (Object)appContext.getName());
            json.put("value", (Object)appContext.getId());
            json.put("id", (Object)appContext.getId());
            json.put("imgs", (Object)img);
            json.put("text", (Object)appContext.getName());
            array.add((Object)json);
        }
        ro.setData(array);
        return ro.toString();
    }

    public String getCategoryByAppid(String appid) {
        ResponseObject ro = ResponseObject.newOkResponse();
        Collection<String> cs = this.getCategorysByApp(appid);
        String jsonStr = "[";
        for (String c : cs) {
            jsonStr = String.valueOf(jsonStr) + "'" + c + "'";
            jsonStr = String.valueOf(jsonStr) + ",";
        }
        if (jsonStr.endsWith(",")) {
            jsonStr = jsonStr.substring(0, jsonStr.length() - 1);
        }
        jsonStr = String.valueOf(jsonStr) + "]";
        ro.setData(JSONArray.parseArray((String)jsonStr));
        return ro.toString();
    }

    private boolean isAppCategoryVisible(String appId, String category, String uid) {
        if (this.isHideNoChild()) {
            Map processList = ProcessDefCache.getInstance().getListByApp(appId);
            for (ProcessDefinition model : processList.values()) {
                if (!category.equals(model.getCategoryName()) || !ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)model, (String)uid)) continue;
                return true;
            }
            Map bos = BOCache.getInstance().getListByApp(appId);
            for (BOModel model : bos.values()) {
                if (!category.equals(model.getCategoryName()) || !model.isAdministrator(uid)) continue;
                return true;
            }
            Map forms = FormCache.getInstance().getListByApp(appId);
            for (FormModel model : forms.values()) {
                if (!category.equals(model.getCategoryName()) || !model.isAdministrator(uid)) continue;
                return true;
            }
            Map dws = DWCache.getInstance().getListByApp(appId);
            for (DWModel model : dws.values()) {
                if (!category.equals(model.getCategoryName()) || !model.isAdministrator(uid)) continue;
                return true;
            }
            List dicts = Xml2DictUtil.getList((String)appId, (boolean)true);
            dicts.addAll(Xml2DictUtil.getList((String)appId, (boolean)false));
            int i = 0;
            while (i < dicts.size()) {
                DictModel model = (DictModel)dicts.get(i);
                if (category.equals(model.getCategoryName()) && model.isAdministrator(uid)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean isAppVisible(AppContext appContext, String uid) {
        return this.isAppVisible(appContext, uid, null);
    }

    private boolean isAppVisible(AppContext appContext, String uid, String type) {
        if ("OFFLINE".equals(appContext.getRuntimeState())) {
            return false;
        }
        if (!appContext.isCategoryVisible()) {
            return false;
        }
        String appId = appContext.getId();
        if (this.isHideNoChild()) {
            if (UtilString.isEmpty(type) || type.equals("process")) {
                Map processList = ProcessDefCache.getInstance().getListByApp(appId);
                for (ProcessDefinition model : processList.values()) {
                    if (!ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)model, (String)uid)) continue;
                    return true;
                }
            }
            if (UtilString.isEmpty(type) || type.equals("BO")) {
                Map bos = BOCache.getInstance().getListByApp(appId);
                for (ProcessDefinition model : bos.values()) {
                    if (!model.isAdministrator(uid)) continue;
                    return true;
                }
            }
            if (UtilString.isEmpty(type) || type.equals("form")) {
                Map forms = FormCache.getInstance().getListByApp(appId);
                for (ProcessDefinition model : forms.values()) {
                    if (!model.isAdministrator(uid)) continue;
                    return true;
                }
            }
            if (UtilString.isEmpty(type) || type.equals("DW")) {
                Map dws = DWCache.getInstance().getListByApp(appId);
                for (ProcessDefinition model : dws.values()) {
                    if (!model.isAdministrator(uid)) continue;
                    return true;
                }
            }
            if (UtilString.isEmpty(type) || type.equals("dict")) {
                List dicts = Xml2DictUtil.getList((String)appId, (boolean)true);
                dicts.addAll(Xml2DictUtil.getList((String)appId, (boolean)false));
                int i = 0;
                while (i < dicts.size()) {
                    DictModel model = (DictModel)dicts.get(i);
                    if (model.isAdministrator(uid)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isHideNoChild() {
        return this.hideNoChild;
    }

    private void setHideNoChild(boolean hideNoChild) {
        this.hideNoChild = hideNoChild;
    }

    private String getBizType() {
        return this.bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
        if (this.isTemplate()) {
            this.setHideNoChild(true);
        }
    }

    private boolean isTemplateHasField(BOItemModel boItemModel) {
        BOModel bo = (BOModel)BOCache.getInstance().getModel(this.getBoDefId());
        List items = bo.getBoItems();
        if (items != null) {
            for (BOItemModel item : items) {
                if (!item.getName().equals(boItemModel.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String getBoDefId() {
        return this.boDefId;
    }

    public void setBoDefId(String boDefId) {
        this.boDefId = boDefId;
    }

    private boolean isTemplate() {
        return TYPE_TEMPLATE.equals(this.getBizType());
    }

    public String getFormProcessList(UserContext me, String formDefId, String appId) {
        boolean isTemplateScene = TYPE_TEMPLATE.equals(this.getBizType());
        ResponseObject rs = ResponseObject.newErrResponse();
        AppContext oldApp = AppsAPIManager.getInstance().getAppContext(appId);
        List apps = new ArrayList();
        apps = AppsAPIManager.getInstance().queryDependenciesIncludeSelfAndSort(oldApp);
        AppsAPIManager.getInstance().sortAppByName(apps);
        JSONArray proArr = new JSONArray();
        ArrayList<String> proIdList = new ArrayList<String>();
        String _me = me.getUID();
        for (AppContext appContext : apps) {
            if (!this.isAppVisible(appContext, _me) || !GradeSecurityUtil.isSuperMaster(_me) && !isTemplateScene && !this.hasManageModel(appContext.getId(), _me)) continue;
            Map listByApp = ProcessDefCache.getInstance().getListByApp(appContext.getId());
            Map groups = ProcessDefCache.getInstance().getGroups(appContext.getId());
            for (ProcessDefinition processDefinition : listByApp.values()) {
                Map tasks = processDefinition.getTasks();
                for (ActivityModel activityModel : tasks.values()) {
                    if (!(activityModel instanceof UserTaskModel)) continue;
                    UserTaskModel userTaskModel = (UserTaskModel)activityModel;
                    List formSets = userTaskModel.getFormSets();
                    for (FormSetModel formSet : formSets) {
                        String proId;
                        if (!formDefId.equals(formSet.getFormId()) || proIdList.contains(proId = processDefinition.getId())) continue;
                        JSONObject obj = new JSONObject();
                        String proGroupId = processDefinition.getProcessGroupId();
                        String processGroupName = (String)groups.get(proGroupId);
                        String type = processDefinition.getTrackDiagramType();
                        String imgSpan = "<span class='save-process'></span>";
                        String name = ProcessDefVersionUtil.getProcessNameOfVersion((ProcessDefinition)processDefinition);
                        if ("2".equals(type)) {
                            DWModel dw = (DWModel)DWCache.getInstance().getModel(processDefinition.getProcessGroupId());
                            if (!UtilString.isEmpty(dw)) {
                                name = dw.getTitle().getLabel();
                            }
                            imgSpan = "<span class='save-dw'></span>";
                        }
                        String showName = String.valueOf(appContext.getName()) + " " + processGroupName + "/" + name;
                        proIdList.add(proId);
                        obj.put("appId", (Object)processDefinition.getAppId());
                        obj.put("processId", (Object)proId);
                        obj.put("processName", (Object)showName);
                        obj.put("imgSpan", (Object)imgSpan);
                        proArr.add((Object)obj);
                    }
                }
            }
        }
        rs.ok();
        rs.put("proArr", proArr);
        return rs.toString();
    }
}

