/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.repository;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.dao.BODaoFactory;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bo.design.search.BOSearch;
import com.actionsoft.bpms.bo.design.util.BOUtil;
import com.actionsoft.bpms.bo.design.web.BOBaseDataTabWeb;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessDefUtil;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessDefVersionUtil;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessSearch;
import com.actionsoft.bpms.bpmn.engine.model.def.ActivityModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.def.UserTaskModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ext.FormSetModel;
import com.actionsoft.bpms.bpmn.modeler.util.CopyBPMNFile;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.dictionary.model.DictModel;
import com.actionsoft.bpms.commons.dictionary.search.DictionarySearch;
import com.actionsoft.bpms.commons.dictionary.util.Xml2DictUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlFormTemplate;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelBean;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelHelper;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationFunction;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.commons.xmetadata.XDaoUtil;
import com.actionsoft.bpms.dw.design.cache.DWCache;
import com.actionsoft.bpms.dw.design.dao.AWSDWDaoFactory;
import com.actionsoft.bpms.dw.design.model.DWModel;
import com.actionsoft.bpms.dw.design.search.DWSearch;
import com.actionsoft.bpms.dw.design.util.DataWindowUtil;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.form.design.dao.FormDaoFactory;
import com.actionsoft.bpms.form.design.model.FormItemModel;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.form.design.search.FormSearch;
import com.actionsoft.bpms.form.design.util.FormDesignUtil;
import com.actionsoft.bpms.form.design.util.FormTemplateUtil;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSQuotaException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelRepositoryWeb {
    private UserContext _me;

    public ModelRepositoryWeb(UserContext userContext) {
        this._me = userContext;
    }

    public ModelRepositoryWeb() {
    }

    public static List<AppContext> getVisibleInstalledApps(String uid) {
        return AMCAPIManager.getVisibleInstalledApps(uid);
    }

    public static List<AppContext> getVisibleInstalledDevAndManagementApps(String uid) {
        return AMCAPIManager.getVisibleInstalledDevAndManagementApps(uid);
    }

    public String copyModel(String appId, String modelType, String modelId, Map extendParams) {
        ResponseObject ro = ResponseObject.newOkResponse();
        if (modelType.toUpperCase().equals("BO")) {
            return this.copyBOModel(modelId, extendParams);
        }
        if (modelType.toUpperCase().equals("FM")) {
            return this.copyFormModel(modelId, extendParams);
        }
        if (modelType.toUpperCase().equals("DW")) {
            return this.copyDWModel(modelId, extendParams);
        }
        ro.err();
        ro.msg(I18nRes.findValue("_bpm.platform", "\u590d\u5236\u6a21\u578b\u65f6\u63d0\u4f9b\u7684\u6a21\u578b\u7c7b\u578b\u53c2\u6570\u9519\u8bef"));
        return ro.toString();
    }

    public String getCopyModelPage(String modelType, String modelId, String category, String appid) {
        ResponseObject ro = ResponseObject.newErrResponse();
        ro.err();
        StringBuilder html = new StringBuilder();
        if (modelType.equals("BMForm")) {
            FormModel model = (FormModel)FormCache.getInstance().getModel(modelId);
            html.append("<table class='awsui-ux'>");
            html.append("<tbody>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u6e90\u6a21\u578b") + "</td><td>" + model.getTitle().replace("<", "&lt;").replace("<", "&gt;") + "</td></tr>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u8868\u5355\u540d\u79f0") + "</td><td><span class='required'><input id ='reportTitle' name='reportTitle' class='txt' type='text'></span></td></tr>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u5206\u7c7b") + "</td><td>" + this.getSelectGroupName(model.getCategoryName(), appid) + "</td></tr>");
            html.append("</tbody>");
            html.append("</table>");
        } else if (modelType.equals("BMBO")) {
            BOModel model = (BOModel)BOCache.getInstance().getModel(modelId);
            String lable = "";
            String entityExitValue = "";
            String length = "";
            String tablePrefix = AppsAPIManager.getInstance().getAppContext(appid).getTablePrefix();
            if (model.getEntityType().equals("TABLE")) {
                lable = I18nRes.findValue("_bpm.platform", "\u8868\u540d\u79f0");
                entityExitValue = "BO_" + tablePrefix + "_";
                length = "2";
            } else {
                lable = I18nRes.findValue("_bpm.platform", "\u89c6\u56fe\u540d\u79f0");
                entityExitValue = "VIEW_" + tablePrefix + "_";
                length = "4";
            }
            html.append("<table class='awsui-ux'>");
            html.append("<tbody>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u6e90\u6a21\u578b") + "</td><td class=''>" + model.getName() + "</td></tr>");
            html.append("<tr><td class='awsui-ux-title'>" + lable + "</td><td><input name='entityExit' id='entityExit' class='awsui-textbox' type='text' value='" + entityExitValue + "' readonly=\"readonly\"></td><td><span class='required'><input name='entityName' id='entityName' class='awsui-textbox' type='text' size='20' maxlength='20'></span></td></tr>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u6807\u9898") + "</td><td colspan=2><span class='required'><input id='entityTitle' name='entityTitle' class='awsui-textbox' type='text' size='35' maxlength='100'></span></td></tr>");
            html.append("<tr><td class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u5206\u7c7b") + "</td><td colspan=2>" + this.getSelectGroupName(model.getCategoryName(), appid) + "</td></tr>");
            html.append("</tbody>");
            html.append("</table>");
            html.append("<input type='hidden' name='boType' value='" + model.getEntityType() + "'/>");
        } else if (!modelType.equals("BMRP")) {
            ro.msg(I18nRes.findValue("_bpm.platform", "\u7cfb\u7edf\u8bfb\u53d6\u590d\u5236\u6a21\u578b\u7684\u9875\u9762\u65f6\u63d0\u4f9b\u7684\u6a21\u578b\u7c7b\u578b\u53c2\u6570\u9519\u8bef"));
            return ro.toString();
        }
        ro.ok();
        ro.msg(html.toString());
        return ro.toString();
    }

    private String getSelectGroupName(String currentcategory, String appid) {
        StringBuilder selectGroupName = new StringBuilder();
        selectGroupName.append("<select id='newGroupName' name='newGroupName' class='awsui-select' style='width:316px;'>");
        ArrayList cs = AppsAPIManager.getInstance().getCategorys(appid);
        for (String c : cs) {
            selectGroupName.append("<option value='" + c + "'" + (currentcategory.equals(c) ? " selected" : "") + ">" + c + "</option>");
        }
        selectGroupName.append("</select>");
        return selectGroupName.toString();
    }

    public String getAWSBizModelPortal(String createNewModelByAppId) {
        if (!Quota.isDeveloperService()) {
            throw new AWSQuotaException(I18nRes.findValue("_bpm.platform", "\u8bb8\u53ef\u672a\u6388\u6743\u8be5\u529f\u80fd"));
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this._me.getSessionId());
        macroLibraries.put("createNewModelByAppId", createNewModelByAppId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.bm.portal.htm", macroLibraries);
    }

    public String getAWSBizModelNavigation(String createNewModelByAppId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this._me.getSessionId());
        macroLibraries.put("createNewModelByAppId", createNewModelByAppId);
        macroLibraries.put("wizardOptionJs", FormDesignUtil.getWizardOptionsString((String)""));
        macroLibraries.put("formCount", 0);
        macroLibraries.put("mastFormItemId", 0);
        macroLibraries.put("subJson", "[]");
        macroLibraries.put("class", "class=\"awsui-wizard-content-item\"");
        macroLibraries.put("isAdmin", String.valueOf(GradeSecurityUtil.isSuperMaster(this._me.getUID()) || GradeSecurityUtil.isSystemMaster(this._me.getUID())));
        macroLibraries.put("hashStepName", "");
        macroLibraries.put("formDefId", "");
        macroLibraries.put("BoTypeGroupSelect", "[]");
        macroLibraries.put("formWizard", HtmlPageTemplate.merge("_bpm.platform", "console.m.form.createform.wizard.htm", macroLibraries));
        String subAdminRole = SDK.getAppAPI().getProperty("com.actionsoft.apps.addons.processdeftpl", "subAdminRole");
        String subAdminPower = "";
        if (!UtilString.isEmpty(subAdminRole) && RoleCache.confirmRole((String)this._me.getUID(), (String)subAdminRole)) {
            subAdminPower = "true";
        }
        macroLibraries.put("subAdminPower", subAdminPower);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.bm.navigation.htm", macroLibraries);
    }

    public String setHigheLight(String str, String query) {
        int index = str.toUpperCase().indexOf(query);
        int len = query.length();
        if (index > -1) {
            str = String.valueOf(str.substring(0, index)) + "<span class='awsui-search-highlight'>" + str.substring(index, len + index) + "</span>" + str.substring(len + index, str.length());
        }
        return str;
    }

    public String getSearchModelDataToJSON(String appId, String query, int limit, int currentPage) {
        DictModel dictModel;
        JSONObject dwJson;
        JSONObject node;
        BOItemModel model;
        Map.Entry entry;
        JSONObject node2;
        int start = (currentPage - 1) * limit;
        query = query.toUpperCase();
        JSONObject result = new JSONObject();
        JSONArray data = new JSONArray();
        String sid = this._me.getSessionId();
        String prefix = "000000000000000";
        HashMap maps = new HashMap();
        int resultSize = 0;
        String cls = "";
        BOSearch.getSearchBOResult((String)query, maps, (String)this._me.getUID());
        Iterator iterator = maps.entrySet().iterator();
        while (iterator.hasNext()) {
            JSONObject boJson = new JSONObject();
            String type = "";
            Map.Entry entry2 = iterator.next();
            BOModel model2 = (BOModel)entry2.getValue();
            cls = model2.getEntityType().equals("VIEW") && model2.getViewType().equals("BOVIEW") ? "BMBOVBOView" : (model2.getEntityType().equals("VIEW") && model2.getViewType().equals("COMMON") ? "BMBOVCommon" : "BMBO");
            type = model2.getEntityType().equals("TABLE") ? "<i class='awsui-iconfont' style='color:#f5bd5e;font-size: 16px;vertical-align: middle;'>&#58898;</i>" + I18nRes.findValue("_bpm.platform", "\u5b58\u50a8") : (model2.getEntityType().equals("STRUCTURE") ? "<i class='awsui-iconfont' style='color:#9cc153;font-size: 16px;vertical-align: middle;'>&#59177;</i>" + I18nRes.findValue("_bpm.platform", "\u7ed3\u6784") : "<i class='awsui-iconfont' style='color:#f48552;font-size: 16px;vertical-align: middle;'>&#xe7cc;</i>" + I18nRes.findValue("_bpm.platform", "\u89c6\u56fe"));
            boJson.put("type", (Object)type);
            boJson.put("name", (Object)(String.valueOf(this.setHigheLight(model2.getTitle(), query)) + "&nbsp;(" + this.setHigheLight(model2.getName(), query) + ")"));
            node2 = new JSONObject();
            if (model2.getEntityType().equals("VIEW") && model2.getViewType().equals("BOVIEW")) {
                node2.put("iconCls", (Object)"treeBMBOVBOView");
                node2.put("iconClsName", (Object)"treeBMBOVBOView");
            } else if (model2.getEntityType().equals("VIEW") && model2.getViewType().equals("COMMON")) {
                node2.put("iconCls", (Object)"treeBMBOVCommon");
                node2.put("iconClsName", (Object)"treeBMBOVCommon");
            } else if (model2.getEntityType().equals("STRUCTURE")) {
                node2.put("iconCls", (Object)"treeBMBOStructure");
                node2.put("iconClsName", (Object)"treeBMBOStructure");
            } else {
                node2.put("iconCls", (Object)"treeBMBO");
                node2.put("iconClsName", (Object)"treeBMBO");
            }
            node2.put("category", (Object)model2.getCategoryName());
            node2.put("id", (Object)(String.valueOf(prefix) + model2.getId()));
            node2.put("baseId", (Object)model2.getId());
            node2.put("type", (Object)"BMBO");
            node2.put("name", (Object)model2.getTitle());
            node2.put("appid", (Object)model2.getAppId());
            boJson.put("params", (Object)node2);
            boJson.put("path", (Object)(String.valueOf(SDK.getAppAPI().getAppContext(model2.getAppId()).getName()) + " > " + model2.getCategoryName() + " > " + I18nRes.findValue("_bpm.platform", "\u5b58\u50a8\u6a21\u578b")));
            data.add((Object)boJson);
        }
        resultSize += maps.size();
        maps.clear();
        BOSearch.getSearchBOItemResult((String)query, maps, (String)this._me.getUID());
        iterator = maps.entrySet().iterator();
        while (iterator.hasNext()) {
            JSONObject boItemJson = new JSONObject();
            entry = iterator.next();
            model = (BOItemModel)entry.getValue();
            BOModel metaModel = (BOModel)BOCache.getInstance().getModel(model.getBoModelId());
            if (metaModel == null) continue;
            boItemJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#f6c77b;font-size: 16px;vertical-align: middle;'>&#59254;</i>" + I18nRes.findValue("_bpm.platform", "\u5b57\u6bb5")));
            boItemJson.put("name", (Object)(String.valueOf(this.setHigheLight(model.getName(), query)) + "[" + this.setHigheLight(model.getTitle(), query) + "]"));
            node2 = new JSONObject();
            if (metaModel.getEntityType().equals("VIEW") && metaModel.getViewType().equals("BOVIEW")) {
                node2.put("iconCls", (Object)"treeBMBOVBOView");
                node2.put("iconClsName", (Object)"treeBMBOVBOView");
            } else if (metaModel.getEntityType().equals("VIEW") && metaModel.getViewType().equals("COMMON")) {
                node2.put("iconCls", (Object)"treeBMBOVCommon");
                node2.put("iconClsName", (Object)"treeBMBOVCommon");
            } else if (metaModel.getEntityType().equals("STRUCTURE")) {
                node2.put("iconCls", (Object)"treeBMBOStructure");
                node2.put("iconClsName", (Object)"treeBMBOStructure");
            } else {
                node2.put("iconCls", (Object)"treeBMBO");
                node2.put("iconClsName", (Object)"treeBMBO");
            }
            node2.put("category", (Object)metaModel.getCategoryName());
            node2.put("id", (Object)(String.valueOf(prefix) + metaModel.getId()));
            node2.put("baseId", (Object)metaModel.getId());
            node2.put("type", (Object)"BMBO");
            node2.put("name", (Object)metaModel.getTitle());
            node2.put("appid", (Object)metaModel.getAppId());
            boItemJson.put("params", (Object)node2);
            boItemJson.put("path", (Object)(String.valueOf(SDK.getAppAPI().getAppContext(metaModel.getAppId()).getName()) + " > " + metaModel.getCategoryName() + " > " + I18nRes.findValue("_bpm.platform", "\u5b58\u50a8\u6a21\u578b") + " > " + metaModel.getTitle()));
            data.add((Object)boItemJson);
        }
        resultSize += maps.size();
        maps.clear();
        FormSearch.getSearchResult((String)query, maps, (String)this._me.getUID());
        Iterator its = maps.entrySet().iterator();
        while (its.hasNext()) {
            JSONObject formJson = new JSONObject();
            entry = its.next();
            model = (FormModel)entry.getValue();
            formJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#57c6bc;font-size: 16px;vertical-align: middle;'>&#xe706;</i>" + I18nRes.findValue("_bpm.platform", "\u8868\u5355")));
            formJson.put("name", (Object)this.setHigheLight(model.getTitle(), query));
            node = new JSONObject();
            node.put("category", (Object)model.getCategoryName());
            node.put("id", (Object)(String.valueOf(prefix) + model.getId()));
            node.put("baseId", (Object)model.getId());
            node.put("type", (Object)"BMForm");
            node.put("name", (Object)model.getTitle());
            node.put("appid", (Object)model.getAppId());
            formJson.put("params", (Object)node);
            formJson.put("path", (Object)(String.valueOf(SDK.getAppAPI().getAppContext(model.getAppId()).getName()) + " > " + model.getCategoryName()));
            data.add((Object)formJson);
        }
        resultSize += maps.size();
        maps.clear();
        ProcessSearch.getSearchProcessDefResult((String)query, maps, (String)this._me.getUID());
        its = maps.entrySet().iterator();
        while (its.hasNext()) {
            JSONObject processJson = new JSONObject();
            entry = its.next();
            model = (ProcessDefinition)entry.getValue();
            if (model.getEngineType() == 1) continue;
            processJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#73abec;font-size: 16px;vertical-align: middle;'>&#58981;</i>" + I18nRes.findValue("_bpm.platform", "\u6d41\u7a0b")));
            processJson.put("name", (Object)this.setHigheLight(ProcessDefVersionUtil.getProcessNameOfVersion((ProcessDefinition)model), query));
            node = new JSONObject();
            node.put("capdId", (Object)this.getGroupId((ProcessDefinition)model));
            node.put("category", (Object)model.getCategoryName());
            node.put("id", (Object)(String.valueOf(prefix) + model.getId()));
            node.put("baseId", (Object)model.getId());
            node.put("type", (Object)"BMPD");
            node.put("name", (Object)ProcessDefVersionUtil.getProcessNameOfVersion((ProcessDefinition)model));
            node.put("appid", (Object)model.getAppId());
            processJson.put("params", (Object)node);
            processJson.put("path", (Object)(String.valueOf(SDK.getAppAPI().getAppContext(model.getAppId()).getName()) + " > " + model.getCategoryName() + " > " + I18nRes.findValue("_bpm.platform", "\u6d41\u7a0b\u6a21\u578b")));
            data.add((Object)processJson);
        }
        resultSize += maps.size();
        maps.clear();
        resultSize += maps.size();
        maps.clear();
        DWSearch.getSearchResult((String)query, maps, (String)this._me.getUID());
        for (Object defId : maps.keySet()) {
            DWModel dwModel = (DWModel)maps.get(defId);
            if (dwModel == null) continue;
            dwJson = new JSONObject();
            dwJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#5bc376;font-size: 16px;vertical-align: middle;'>&#59804;</i>" + I18nRes.findValue("_bpm.platform", "\u89c6\u56fe")));
            dwJson.put("name", (Object)this.setHigheLight(dwModel.getTitle().getLabel(), query));
            node = new JSONObject();
            ProcessDefinition processDef = null;
            if (dwModel.getDwType() != 2) {
                List processDefList = ProcessDefCache.getInstance().getListOfGroupId(dwModel.getAppId(), dwModel.getProcessGroupId());
                if (processDefList != null && processDefList.size() == 0) {
                    AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                    AppsLogger.warn((AppContext)app, (String)(String.valueOf(I18nRes.findValue("_bpm.platform", "\u6570\u636e\u7a97\u53e3\u6a21\u578b")) + "\uff1a" + dwModel.getProcessGroupId() + I18nRes.findValue("_bpm.platform", "\u5bf9\u5e94\u7684\u6d41\u7a0b\u5df2\u4e22\u5931\u5982\u679c\u9700\u8981\u6062\u590d\u8be5\u6570\u636e\u7a97\u53e3\u6a21\u578b\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002") + "\u3002"));
                } else {
                    ProcessDefCache.getInstance().sortByCreateTime(processDefList);
                    processDef = (ProcessDefinition)processDefList.get(0);
                }
            }
            node.put("processGroupId", (Object)dwModel.getProcessGroupId());
            node.put("category", (Object)dwModel.getCategoryName());
            node.put("id", (Object)(String.valueOf(prefix) + dwModel.getId()));
            node.put("baseId", (Object)(processDef == null ? dwModel.getId() : processDef.getId()));
            node.put("type", (Object)"DWDetailed");
            node.put("name", (Object)dwModel.getTitle().getLabel());
            node.put("appid", (Object)dwModel.getAppId());
            dwJson.put("params", (Object)node);
            dwJson.put("path", (Object)(String.valueOf(SDK.getAppAPI().getAppContext(dwModel.getAppId()).getName()) + " > " + dwModel.getCategoryName()));
            data.add((Object)dwJson);
        }
        resultSize += maps.size();
        maps.clear();
        DictionarySearch.getSearchDictionaryResult((String)query, maps, (String)this._me.getUID(), (boolean)true);
        for (Object app : maps.keySet()) {
            dictModel = (DictModel)maps.get(app);
            dwJson = new JSONObject();
            dwJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#fb9a66;font-size: 16px;vertical-align: middle;'>&#xe7dc;</i>" + I18nRes.findValue("_bpm.platform", "\u5b57\u5178")));
            dwJson.put("name", (Object)this.setHigheLight(dictModel.getTitle(), query));
            node = new JSONObject();
            node.put("isDic", (Object)true);
            node.put("xmlName", (Object)dictModel.getName());
            node.put("id", (Object)("XD_" + dictModel.getId()));
            node.put("baseId", (Object)dictModel.getId());
            node.put("type", (Object)"BMDICXD");
            node.put("name", (Object)dictModel.getTitle());
            node.put("appid", (Object)dictModel.getAppId());
            node.put("category", (Object)dictModel.getCategoryName());
            dwJson.put("params", (Object)node);
            String tmpAppId = app.toString().substring(0, app.toString().lastIndexOf("_"));
            AppContext appContext = SDK.getAppAPI().getAppContext(tmpAppId);
            String appName = "App" + I18nRes.findValue("_bpm.platform", "\u4e0d\u5b58\u5728");
            if (appContext != null) {
                appName = appContext.getName();
            }
            dwJson.put("path", (Object)(String.valueOf(appName) + " > " + dictModel.getCategoryName() + " > " + I18nRes.findValue("_bpm.platform", "\u5b57\u5178\u6a21\u578b")));
            data.add((Object)dwJson);
        }
        resultSize += maps.size();
        maps.clear();
        DictionarySearch.getSearchDictionaryResult((String)query, maps, (String)this._me.getUID(), (boolean)false);
        for (Object app : maps.keySet()) {
            dictModel = (DictModel)maps.get(app);
            dwJson = new JSONObject();
            dwJson.put("type", (Object)("<i class='awsui-iconfont' style='color:#f87b79;font-size: 16px;vertical-align: middle;'>&#59063;</i>" + I18nRes.findValue("_bpm.platform", "\u5b57\u5178")));
            dwJson.put("name", (Object)this.setHigheLight(dictModel.getTitle(), query));
            node = new JSONObject();
            node.put("isDic", (Object)false);
            node.put("xmlName", (Object)dictModel.getName());
            node.put("id", (Object)("CD_" + dictModel.getId()));
            node.put("baseId", (Object)dictModel.getId());
            node.put("type", (Object)"BMDICCD");
            node.put("name", (Object)dictModel.getTitle());
            node.put("appid", (Object)dictModel.getAppId());
            node.put("category", (Object)dictModel.getCategoryName());
            dwJson.put("params", (Object)node);
            String appStr = app.toString();
            String appName = SDK.getAppAPI().getAppContext(appStr.substring(0, appStr.lastIndexOf("_"))).getName();
            dwJson.put("path", (Object)(String.valueOf(appName) + " > " + dictModel.getCategoryName() + " > " + I18nRes.findValue("_bpm.platform", "\u5b57\u5178\u6a21\u578b")));
            data.add((Object)dwJson);
        }
        resultSize += maps.size();
        maps.clear();
        JSONArray pageData = new JSONArray();
        int i = start;
        while (i < start + limit) {
            if (i > data.size() - 1) break;
            pageData.add(data.get(i));
            ++i;
        }
        result.put("totalRecords", (Object)data.size());
        result.put("curPage", (Object)currentPage);
        result.put("data", (Object)pageData);
        return result.toString();
    }

    private String getGroupId(ProcessDefinition processDef) {
        MD5 md5 = new MD5();
        StringBuilder id = new StringBuilder();
        id.append(processDef.getProcessGroupId()).append("_");
        id.append(processDef.getCategoryName().replaceAll(" ", "").replaceAll("\\.", "_").replaceAll("-", "_")).append("_");
        id.append(processDef.getProcessGroupName().replaceAll(" ", "").replaceAll("\\.", "_").replaceAll("-", "_"));
        return md5.toDigest(id.toString());
    }

    public String getTemplatePage(String boDefId, String templateType) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        List h = BOCache.getInstance().getBOItemList(boModel);
        StringBuilder mapList = new StringBuilder();
        if (h != null) {
            for (BOItemModel refModel : h) {
                mapList.append("|" + refModel.getName() + "|");
            }
        }
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this._me.getSessionId());
        macroLibraries.put("boDefId", boDefId);
        macroLibraries.put("templateType", templateType);
        macroLibraries.put("mapList", mapList.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.template.page.htm", macroLibraries);
    }

    public String getColumnExtPage(String boDefId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this._me.getSessionId());
        macroLibraries.put("boDefId", boDefId);
        String props = boModel.getItemProps();
        if (UtilString.isEmpty(props)) {
            props = "[]";
        }
        macroLibraries.put("columnExt", props);
        return HtmlPageTemplate.merge("_bpm.platform", "console.m.column.ext.page.htm", macroLibraries);
    }

    public String saveColumnExt(String boDefId, String colExt) {
        ResponseObject ro = ResponseObject.newOkResponse();
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        BOModel tmp = new BOModel();
        tmp.setModel(boModel);
        tmp.setItemProps(colExt);
        BODaoFactory.createBO().storeBO(tmp);
        return ro.toString();
    }

    private String copyFormModel(String modelId, Map extendParams) {
        ResponseObject ro = ResponseObject.newErrResponse();
        FormModel originalModel = (FormModel)FormCache.getInstance().getModel(modelId);
        FormModel model = FormDesignUtil.cloneFormModel((FormModel)originalModel);
        model.setId(XDaoUtil.uuid());
        if (extendParams != null && extendParams.size() > 0) {
            List items;
            if (extendParams.containsKey("REPORT_TITLE")) {
                model.setTitle(extendParams.get("REPORT_TITLE").toString());
            }
            if (extendParams.containsKey("GROUP_NAME")) {
                model.setCategoryName(extendParams.get("GROUP_NAME").toString());
            }
            if (extendParams.containsKey("APPID")) {
                model.setAppId(extendParams.get("APPID").toString());
            }
            if (extendParams.containsKey("MANAGED")) {
                boolean managed = false;
                if ("true".equals(extendParams.get("MANAGED").toString())) {
                    managed = true;
                }
                model.setManagedNoCheck(managed);
            }
            if ((items = model.getFormItems()) != null) {
                String html = "";
                for (FormItemModel model2 : items) {
                    List<String> fs;
                    model2.setId(XDaoUtil.uuid());
                    model2.setFormId(model.getId());
                    JSONObject templeteObj = JSONArray.parseObject((String)model2.getTemplateFile());
                    String originalFormName = UtilJson.optString(templeteObj, "pc");
                    String modelName = String.valueOf(model.getCategoryName()) + "-" + model.getTitle() + ".htm";
                    if (!model2.isGrid() && (fs = HtmlFormTemplate.getTemplateFileNames(model.getAppId())) != null) {
                        for (String fn : fs) {
                            if (!fn.equals(modelName)) continue;
                            ro.err();
                            ro.msg(String.valueOf(I18nRes.findValue("_bpm.platform", "\u8868\u5355\u540d\u79f0")) + " [" + model.getTitle() + "] " + I18nRes.findValue("_bpm.platform", "\u5df2\u7ecf\u5b58\u5728\u8bf7\u91cd\u65b0\u547d\u540d"));
                            return ro.toString();
                        }
                    }
                    JSONObject templateFile = new JSONObject();
                    String newFormName = String.valueOf(model.getCategoryName()) + "-" + model.getTitle() + ".htm";
                    if (model2.isGrid()) {
                        newFormName = String.valueOf(model.getCategoryName()) + "-" + model.getTitle() + "-" + model2.getTitle() + ".htm";
                    }
                    if (UtilString.isNotEmpty(originalFormName) && !UtilString.isEmpty(html = FormTemplateUtil.getHtmlFile((String)model.getAppId(), (String)originalFormName))) {
                        html = html.replaceAll(originalModel.getTitle(), model.getTitle());
                        FormTemplateUtil.saveHtmlFile((String)model.getAppId(), (String)html, (String)newFormName);
                        templateFile.put("pc", (Object)newFormName);
                        templateFile.put("tablet", (Object)newFormName);
                    }
                    String originalFormName2 = UtilJson.optString(templeteObj, "mobile");
                    String newFormName2 = String.valueOf(model.getCategoryName()) + "-" + model.getTitle() + "_m.htm";
                    if (model2.isGrid()) {
                        newFormName2 = String.valueOf(model.getCategoryName()) + "-" + model.getTitle() + "-" + model2.getTitle() + "_m.htm";
                    }
                    if (UtilString.isNotEmpty(originalFormName2) && !UtilString.isEmpty(html = FormTemplateUtil.getHtmlFile((String)model.getAppId(), (String)originalFormName2))) {
                        html = html.replaceAll(originalModel.getTitle(), model.getTitle());
                        FormTemplateUtil.saveHtmlFile((String)model.getAppId(), (String)html, (String)newFormName2);
                        templateFile.put("mobile", (Object)newFormName2);
                    }
                    model2.setTitle(model.getTitle());
                    if (templateFile.size() > 0) {
                        model2.setTemplateFile(templateFile.toString());
                    }
                    HtmlPageTemplate.loadInstancesByApp(model.getAppId());
                }
            }
        }
        model.setUpdateTime(UtilDate.datetimeFormat(new Date()));
        model.setCreateTime(UtilDate.datetimeFormat(new Date()));
        FormDaoFactory.createForm().storeNoCheck(model);
        if (extendParams.containsKey("APPID") && extendParams.containsKey("PRODEFIDS")) {
            this.updatePorcessForm(extendParams.get("PRODEFIDS").toString(), model, modelId);
        }
        ro.ok();
        ro.msg(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f"));
        return ro.toString();
    }

    public void updatePorcessForm(String appIdProDefIds, FormModel newmodel, String oldFormDefId) {
        if (!UtilString.isEmpty(appIdProDefIds)) {
            List<String> arrs = Arrays.asList(appIdProDefIds.split(","));
            for (String str : arrs) {
                String[] arr = str.split("\\|");
                if (arr.length != 2) continue;
                HashMap attrMap = new HashMap();
                ArrayList usertasks = new ArrayList();
                attrMap.put("userTasks", usertasks);
                HashMap<String, Object> usertask = new HashMap<String, Object>();
                usertasks.add(usertask);
                Map tasks = ((ProcessDefinition)ProcessDefCache.getInstance().getModel(arr[1])).getTasks();
                block1: for (ActivityModel activityModel : tasks.values()) {
                    if (!(activityModel instanceof UserTaskModel)) continue;
                    UserTaskModel userTaskModel = (UserTaskModel)activityModel;
                    List formSets = userTaskModel.getFormSets();
                    usertask.put("id", userTaskModel.getId());
                    for (FormSetModel formSet : formSets) {
                        if (!oldFormDefId.equals(formSet.getFormId())) continue;
                        String operatingAuthorization = userTaskModel.getOperatingAuthorization();
                        if (!UtilString.isEmpty(operatingAuthorization)) {
                            JSONArray arrop = JSONArray.parseArray((String)operatingAuthorization);
                            JSONArray newOpera = new JSONArray();
                            int m = 0;
                            while (m < arrop.size()) {
                                JSONObject objItem = arrop.getJSONObject(m);
                                String bindFormId = objItem.getString("mainFormID");
                                if (bindFormId.equals(oldFormDefId)) {
                                    JSONObject paramObj = objItem.getJSONObject(bindFormId);
                                    JSONObject newObjItem = new JSONObject();
                                    newObjItem.put("mainFormID", (Object)newmodel.getId());
                                    newObjItem.put(newmodel.getId(), (Object)paramObj);
                                    newOpera.add((Object)newObjItem);
                                } else {
                                    newOpera.add((Object)objItem);
                                }
                                ++m;
                            }
                            usertask.put("operatingAuthorization", newOpera.toString());
                            userTaskModel.setOperatingAuthorization(newOpera.toString());
                        }
                        ArrayList forms = new ArrayList();
                        usertask.put("forms", forms);
                        HashMap<String, String> form = new HashMap<String, String>();
                        forms.add(form);
                        form.put("id", formSet.getId());
                        form.put("formId", newmodel.getId());
                        ProcessDefUtil.updateProcessDefinition((String)arr[0], (String)arr[1], attrMap);
                        continue block1;
                    }
                }
            }
        }
    }

    private String copyBOModel(String modelId, Map extendParams) {
        BOModel tmp;
        ResponseObject ro = ResponseObject.newErrResponse();
        BOModel originalModel = (BOModel)BOCache.getInstance().getModel(modelId);
        BOModel model = BOUtil.cloneBOModel((BOModel)originalModel);
        model.setId(XDaoUtil.uuid());
        model.setCreateTime(UtilDate.datetimeFormat(new Date()));
        model.setUpdateTime(UtilDate.datetimeFormat(new Date()));
        if (extendParams != null && extendParams.size() > 0) {
            if (extendParams.containsKey("ENTITY_NAME")) {
                model.setName(extendParams.get("ENTITY_NAME").toString());
            }
            if (extendParams.containsKey("ENTITY_TITLE")) {
                model.setTitle(extendParams.get("ENTITY_TITLE").toString());
            }
            if (extendParams.containsKey("GROUP_NAME")) {
                model.setCategoryName(extendParams.get("GROUP_NAME").toString());
            }
            if (extendParams.containsKey("BOTYPE")) {
                model.setEntityType(extendParams.get("BOTYPE").toString());
            }
            if (extendParams.containsKey("APPID")) {
                model.setAppId(extendParams.get("APPID").toString());
            }
            if (extendParams.containsKey("MANAGED")) {
                boolean managed = false;
                if ("true".equals(extendParams.get("MANAGED").toString())) {
                    managed = true;
                }
                model.setManagedNoCheck(managed);
            }
        }
        if (model.getName().equals(I18nRes.findValue("_bpm.platform", "\u7cfb\u7edf\u9ed8\u8ba4"))) {
            model.setName(Long.toString(System.currentTimeMillis()));
        }
        String tablePrefix = AppsAPIManager.getInstance().getAppContext(model.getAppId()).getTablePrefix();
        if (model.getEntityType().equals("TABLE")) {
            model.setName("BO_" + tablePrefix + "_" + model.getName());
        }
        if (model.getEntityType().equals("VIEW")) {
            model.setName("VIEW_" + tablePrefix + "_" + model.getName());
        }
        if ((tmp = BOCache.getInstance().getModelByEntityName(model.getName().toUpperCase())) != null) {
            ro.err();
            ro.msg(String.valueOf(I18nRes.findValue("_bpm.platform", "\u5b58\u50a8\u6a21\u578b")) + " [" + model.getName() + "] " + I18nRes.findValue("_bpm.platform", "\u5df2\u7ecf\u5b58\u5728\u8bf7\u91cd\u65b0\u547d\u540d"));
            return ro.toString();
        }
        try {
            List items = model.getBoItems();
            if (items != null) {
                for (BOItemModel itemModel : items) {
                    itemModel.setId(XDaoUtil.uuid());
                    itemModel.setBoModelId(model.getId());
                }
            }
            if (model.getEntityType().equals("VIEW")) {
                BOBaseDataTabWeb web = new BOBaseDataTabWeb(this._me);
                web.createBO(model);
            } else {
                BODaoFactory.createBO((BOModel)model).create(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BODaoFactory.createBO().remove(model.getId());
            ro.err();
            ro.msg(e.getMessage());
            return ro.toString();
        }
        ro.ok();
        ro.msg(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f"));
        return ro.toString();
    }

    private String copyDWModel(String modelId, Map extendParams) {
        ResponseObject ro = ResponseObject.newErrResponse();
        DWModel model = DataWindowUtil.copyDWModel((UserContext)this._me, (String)modelId);
        String appId = "";
        String dwTitle = "";
        String catogaryName = "";
        String managedStr = "false";
        if (extendParams.containsKey("DW_TITLE")) {
            dwTitle = extendParams.get("DW_TITLE").toString();
            model.getTitle().setLabel(dwTitle);
        }
        if (extendParams.containsKey("CATEGORY_NAME")) {
            catogaryName = extendParams.get("CATEGORY_NAME").toString();
            model.setCategoryName(catogaryName);
        }
        if (extendParams.containsKey("APPID")) {
            appId = extendParams.get("APPID").toString();
            model.setAppId(appId);
        }
        if (extendParams.containsKey("MANAGED")) {
            boolean managed = false;
            managedStr = extendParams.get("MANAGED").toString();
            if ("true".equals(managedStr)) {
                managed = true;
            }
            model.setManagedNoCheck(managed);
        }
        if (model.getDwType() == 1) {
            String proGroupId = this.copyProcessDef(appId, extendParams.get("PROCESSDEFID").toString(), dwTitle, "", dwTitle, catogaryName, managedStr);
            model.setProcessGroupId(proGroupId);
        } else {
            model.setProcessGroupId(UUIDGener.getObjectId());
        }
        model.setProcessGroupName(dwTitle);
        AWSDWDaoFactory.createAwsDw().store2(model);
        if (extendParams.containsKey("NAVIDS")) {
            this.updateDwNavFun(extendParams.get("NAVIDS").toString(), model.getAppId(), model.getProcessGroupId(), model.getProcessGroupName());
        }
        ro.ok();
        ro.msg(I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f"));
        return ro.toString();
    }

    public void updateDwNavFun(String navIds, String appId, String proGroupId, String groupName) {
        List<String> navIdList = Arrays.asList(navIds.split(","));
        NavigationFunction dao = new NavigationFunction();
        for (String navid : navIdList) {
            NavigationFunctionModelImpl model = (NavigationFunctionModelImpl)dao.queryById(navid.trim());
            if (model == null) continue;
            String linkurl = "./w?sid=@sid&cmd=CLIENT_DW_PORTAL&processGroupId=" + proGroupId + "&appId=" + appId;
            model.setFunctionName(groupName);
            model.setAppId(appId);
            model.setLinkUrl(linkurl);
            try {
                dao.update(model);
                NavigationFunctionCache.updateModel(model);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AWSException(e);
            }
        }
    }

    public String copyProcessDef(String appId, String sourceProcessDefId, String newFlowName, String newProcessGroupId, String newGroupName, String categoryName, String managed) {
        CopyBPMNFile cp = new CopyBPMNFile();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processName", newFlowName);
        params.put("processGroupId", UtilString.isEmpty(newProcessGroupId) ? UUIDGener.getObjectId() : newProcessGroupId);
        params.put("processGroupName", newGroupName);
        params.put("appId", appId);
        if (!UtilString.isEmpty(categoryName)) {
            params.put("categoryName", categoryName);
        }
        if (!UtilString.isEmpty(managed)) {
            params.put("isManaged", managed);
        }
        params.put("versionStatus", String.valueOf(0));
        params.put("isClosed", String.valueOf(false));
        String newProcessDefId = "";
        String proGroupId = "";
        try {
            newProcessDefId = cp.copyBpmnFile(sourceProcessDefId, params);
            ProcessDefinition newProcessDefinition = (ProcessDefinition)ProcessDefCache.getInstance().getModel(newProcessDefId);
            proGroupId = newProcessDefinition.getProcessGroupId();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return proGroupId;
    }

    private String getHTMLCode(FormModel formModel) {
        StringBuilder html = new StringBuilder();
        String img = "../apps/_bpm.platform/img/model/form.gif";
        html.append("<fieldset class='form_fieldset'>\n<legend><div class='form'");
        html.append(" title='").append(formModel.getTitle()).append("'");
        html.append(">\n");
        html.append("<div class='form_inner'>");
        html.append(formModel.getTitle());
        html.append("</div></div></legend>\n");
        List tmpSheets = FormCache.getInstance().getFormItemList(formModel.getId());
        int j = 0;
        while (j < tmpSheets.size()) {
            BOModel boModel;
            FormItemModel formItemModel = (FormItemModel)tmpSheets.get(j);
            if (formItemModel != null && (boModel = (BOModel)BOCache.getInstance().getModel(formItemModel.getBoModelId())) != null) {
                html.append("<div class='bo'>");
                html.append("<div class='bo_inner' title='").append(boModel.getTitle()).append("'>");
                html.append(boModel.getTitle());
                html.append("</div></div>\n");
            }
            ++j;
        }
        html.append("</fieldset>\n");
        return html.toString();
    }

    private String getSIDFlag() {
        String sid = "<input type=hidden name=sid value=" + this._me.getSessionId() + ">\n";
        return sid;
    }

    public String validateFieldType(String boDefId, String boItemId) {
        ResponseObject object = ResponseObject.newOkResponse();
        BOModel model = (BOModel)BOCache.getInstance().getModel(boDefId);
        String boItemTile = "";
        for (BOItemModel itemsModel : model.getBoItems()) {
            if (!itemsModel.getId().equals(boItemId)) continue;
            boItemTile = itemsModel.getName();
        }
        int i = DBSql.getInt("SELECT COUNT('" + boItemTile + "') as cnt FROM " + model.getName(), "cnt");
        if (i > 0) {
            object = ResponseObject.newErrResponse();
            object.msg(I18nRes.findValue("_bpm.platform", "\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u6570\u636e\u4e0d\u80fd\u66f4\u6362\u7c7b\u578b"));
        }
        return object.toString();
    }

    public String batchLicense(String type, String modelId, String target, String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String[] ids = modelId.split(" ");
        if (type.equals("process")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ProcessDefinition process = (ProcessDefinition)ProcessDefCache.getInstance().getModel(id);
                if (process != null) {
                    PlatformXMetaModelHelper.addAdministrator(process, target);
                }
                ++n2;
            }
        } else if (type.equals("bo")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                BOModel bo = (BOModel)BOCache.getInstance().getModel(id);
                if (bo != null) {
                    PlatformXMetaModelHelper.addAdministrator((PlatformXMetaModelBean)bo, target);
                }
                ++n3;
            }
        } else if (type.equals("form")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n4 = 0;
            while (n4 < n) {
                String id = stringArray[n4];
                FormModel form = (FormModel)FormCache.getInstance().getModel(id);
                if (form != null) {
                    PlatformXMetaModelHelper.addAdministrator((PlatformXMetaModelBean)form, target);
                }
                ++n4;
            }
        } else if (type.equals("dw")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n5 = 0;
            while (n5 < n) {
                String id = stringArray[n5];
                DWModel dw = (DWModel)DWCache.getInstance().getModel(id);
                if (dw != null) {
                    PlatformXMetaModelHelper.addAdministrator((PlatformXMetaModelBean)dw, target);
                }
                ++n5;
            }
        } else if (type.equals("dict")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n6 = 0;
            while (n6 < n) {
                boolean isdic;
                String[] temp;
                String fileName;
                DictModel dict;
                String id = stringArray[n6];
                if (id.contains(":") && (dict = Xml2DictUtil.getModel((String)appId, (String)(fileName = (temp = id.split(":"))[0]), (boolean)(isdic = temp[1].equals("true")))) != null) {
                    PlatformXMetaModelHelper.addAdministrator(dict, appId, fileName, isdic, target);
                }
                ++n6;
            }
        }
        ro.ok(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
        return ro.toString();
    }

    public String transfer(String _me, String type, String modelId, String target, String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String[] ids = modelId.split(" ");
        if (type.equals("process")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                ProcessDefinition process = (ProcessDefinition)ProcessDefCache.getInstance().getModel(id);
                if (process != null) {
                    PlatformXMetaModelHelper.transfer(_me, process, target);
                }
                ++n2;
            }
        } else if (type.equals("bo")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n3 = 0;
            while (n3 < n) {
                String id = stringArray[n3];
                BOModel bo = (BOModel)BOCache.getInstance().getModel(id);
                if (bo != null) {
                    PlatformXMetaModelHelper.transfer(_me, (PlatformXMetaModelBean)bo, target);
                }
                ++n3;
            }
        } else if (type.equals("form")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n4 = 0;
            while (n4 < n) {
                String id = stringArray[n4];
                FormModel form = (FormModel)FormCache.getInstance().getModel(id);
                if (form != null) {
                    PlatformXMetaModelHelper.transfer(_me, (PlatformXMetaModelBean)form, target);
                }
                ++n4;
            }
        } else if (type.equals("dw")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n5 = 0;
            while (n5 < n) {
                String id = stringArray[n5];
                DWModel dw = (DWModel)DWCache.getInstance().getModel(id);
                if (dw != null) {
                    PlatformXMetaModelHelper.transfer(_me, (PlatformXMetaModelBean)dw, target);
                }
                ++n5;
            }
        } else if (type.equals("dict")) {
            String[] stringArray = ids;
            int n = ids.length;
            int n6 = 0;
            while (n6 < n) {
                boolean isdic;
                String[] temp;
                String fileName;
                DictModel dict;
                String id = stringArray[n6];
                if (id.contains(":") && (dict = Xml2DictUtil.getModel((String)appId, (String)(fileName = (temp = id.split(":"))[0]), (boolean)(isdic = temp[1].equals("true")))) != null) {
                    PlatformXMetaModelHelper.transfer(_me, dict, appId, fileName, isdic, target);
                }
                ++n6;
            }
        }
        ro.ok(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
        return ro.toString();
    }

    public String updateCategory(String appId, String category, String newCategoryName) {
        String fileName;
        JSONObject json;
        String uid = this._me.getUID();
        ResponseObject ro = ResponseObject.newOkResponse();
        List pddwAll = ProcessDefCache.getInstance().getListOfCategory(appId, category);
        for (ProcessDefinition p : pddwAll) {
            if (!ProcessDefUtil.isProcessDefAdminitrator((ProcessDefinition)p, (String)uid)) continue;
            HashMap map = new HashMap();
            map.put("categoryName", newCategoryName);
            ProcessDefUtil.updateProcessDefinition((String)appId, (String)p.getId(), (Map)map);
            p.setCategoryName(newCategoryName);
        }
        List formListAll = FormCache.getInstance().getListByCategoryName(appId, category);
        for (FormModel fm : formListAll) {
            if (!fm.isAdministrator(uid)) continue;
            PlatformXMetaModelHelper.migrateCatetory((PlatformXMetaModelBean)fm, newCategoryName);
        }
        List boListAll = BOCache.getInstance().getListByCategoryName(appId, category);
        for (BOModel bm : boListAll) {
            if (!bm.isAdministrator(uid)) continue;
            PlatformXMetaModelHelper.migrateCatetory((PlatformXMetaModelBean)bm, newCategoryName);
        }
        List dwList = DWCache.getInstance().getListByAppAndCategoryName(appId, category);
        for (DWModel dw : dwList) {
            if (!dw.isAdministrator(uid)) continue;
            PlatformXMetaModelHelper.migrateCatetory((PlatformXMetaModelBean)dw, newCategoryName);
        }
        List dictList = Xml2DictUtil.getList((String)appId, (boolean)true, (String)category, (String)this._me.getUID());
        for (DictModel dict : dictList) {
            if (!dict.isAdministrator(uid)) continue;
            json = new JSONObject();
            fileName = dict.getName();
            json.put("categoryName", (Object)newCategoryName);
            try {
                Xml2DictUtil.setXmlProperty((String)appId, (String)fileName, (boolean)true, (JSONObject)json);
            }
            catch (Exception e) {
                ro.err(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u5931\u8d25"));
            }
        }
        dictList = Xml2DictUtil.getList((String)appId, (boolean)false, (String)category, (String)this._me.getUID());
        for (DictModel dict : dictList) {
            if (!dict.isAdministrator(uid)) continue;
            json = new JSONObject();
            fileName = dict.getName();
            json.put("categoryName", (Object)newCategoryName);
            try {
                Xml2DictUtil.setXmlProperty((String)appId, (String)fileName, (boolean)false, (JSONObject)json);
            }
            catch (Exception e) {
                ro.err(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u5931\u8d25"));
            }
        }
        ro.ok(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
        return ro.toString();
    }

    public String moveCategory(String appId, String category, String newCategoryName) {
        ResponseObject ro = ResponseObject.newOkResponse();
        return this.updateCategory(appId, category, newCategoryName);
    }
}

