/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.schedule.ClassLoaderProvider;
import com.actionsoft.bpms.schedule.IJob;
import com.actionsoft.bpms.schedule.ITrigger;
import com.actionsoft.bpms.schedule.IdGenerator;
import com.actionsoft.bpms.schedule.JobAdapter;
import com.actionsoft.bpms.schedule.JobConnectionProvider;
import com.actionsoft.bpms.schedule.LoggingJobHistoryPlugin;
import com.actionsoft.bpms.schedule.LoggingListener;
import com.actionsoft.bpms.schedule.LoggingTriggerHistoryPlugin;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.schedule.system.SYS_HttpExecute;
import com.actionsoft.bpms.schedule.system.SYS_NativeCallExecute;
import com.actionsoft.bpms.schedule.system.SYS_SQLExecute;
import com.actionsoft.bpms.schedule.system.SYS_WSExecute;
import com.actionsoft.bpms.schedule.util.JobGroup;
import com.actionsoft.bpms.schedule.util.JobGroupFactory;
import com.actionsoft.bpms.server.Console;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.ThreadMgr;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.impl.jdbcjobstore.MSSQLDelegate;
import org.quartz.impl.jdbcjobstore.PostgreSQLDelegate;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.simpl.SimpleThreadPool;

public class AWSScheduleEngine {
    public static final String TABLE_PREFIX = "QRTZ_";
    public static final String AWS_SCHEDULE_USER_PARAM = "aws_schedule_user_param";
    public static final String P_SCHEDULE = "aws.schedule";
    public static final String AWS_SCHEDULE_MODEL_ID = "aws_schedule_model_id";
    public static final String AWS_SCHEDULE_CTX_APP = "g_ctx_app";
    public static final String AWS_SCHEDULE_CTX_JOB = "g_ctx_job";
    public static final String AWS_JOB_ID = "aws_job_id";
    public static final String AWS_JOB_GROUP = "aws_job_group";
    public static final String AWS_SCHEDULE_GROUP_ID = "aws_schedule_group_id";
    private static Scheduler scheduler = null;
    private static AWSScheduleEngine engine = new AWSScheduleEngine();

    private AWSScheduleEngine() {
    }

    public static AWSScheduleEngine getInstance() {
        return engine;
    }

    private static void startScheduler() throws SchedulerException {
        Properties props;
        block21: {
            props = new Properties();
            props.put("org.quartz.scheduler.skipUpdateCheck", (Object)true);
            props.put("org.quartz.scheduler.instanceName", "Platform Scheduler");
            props.put("org.quartz.plugin.jobHistory.class", LoggingJobHistoryPlugin.class.getName());
            props.put("org.quartz.plugin.triggHistory.class", LoggingTriggerHistoryPlugin.class.getName());
            props.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            props.put("org.quartz.threadPool.threadCount", Integer.toString(AWSServerConf.getJobsThreadCount()));
            props.put("org.quartz.threadPool.threadPriority", Integer.toString(5));
            props.put("org.quartz.scheduler.instanceIdGenerator.class", IdGenerator.class.getName());
            props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", (Object)false);
            props.put("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", (Object)true);
            props.put("org.quartz.scheduler.classLoadHelper.class", ClassLoaderProvider.class.getName());
            if (AWSServerConf.isInformix()) {
                props.put("org.quartz.jobStore.tablePrefix", "q");
            } else {
                props.put("org.quartz.jobStore.tablePrefix", TABLE_PREFIX);
            }
            props.put("org.quartz.jobStore.dataSource", TABLE_PREFIX);
            props.put("org.quartz.jobStore.misfireThreshold", "60000");
            if (AWSServerConf.isSQLServer() || AWSServerConf.isSybase()) {
                props.put("org.quartz.jobStore.driverDelegateClass", MSSQLDelegate.class.getName());
            } else if (AWSServerConf.isPostgreSQL()) {
                props.put("org.quartz.jobStore.driverDelegateClass", PostgreSQLDelegate.class.getName());
            } else {
                props.put("org.quartz.jobStore.driverDelegateClass", StdJDBCDelegate.class.getName());
            }
            props.put("org.quartz.dataSource.QRTZ_.connectionProvider.class", JobConnectionProvider.class.getName());
            props.put("org.quartz.jobStore.class", JobStoreTX.class.getName());
            props.put("org.quartz.jobStore.isClustered", Boolean.toString(ClusterAPI.isCluster()));
            props.put("org.quartz.scheduler.instanceId", "AUTO");
            File ps = new File("./conf/quartz.properties");
            if (ps.exists()) {
                Properties diy = new Properties();
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(ps);
                        diy.load(is);
                        props.putAll((Map<?, ?>)diy);
                    }
                    catch (Exception e) {
                        ConsolePrinter.err("\u52a0\u8f7dconf/quartz.properties\u51fa\u9519");
                        e.printStackTrace();
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        scheduler = new StdSchedulerFactory(props).getScheduler();
        scheduler.getListenerManager().addSchedulerListener((SchedulerListener)new LoggingListener());
    }

    public Trigger getTrigger(String id, String group) {
        try {
            return scheduler.getTrigger(TriggerKey.triggerKey((String)id, (String)group));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return null;
        }
    }

    private static void throwTranslateException(Exception ex) {
        throw new AWSException(ex);
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public void start() {
        System.out.println("\u4fe1\u606f: [" + UtilDate.datetimeFormat(new Date()) + "]\u51c6\u5907\u542f\u52a8\u8c03\u5ea6\u670d\u52a1");
        try {
            DBSql.getString("select JOB_NAME from QRTZ_JOB_DETAILS", "JOB_NAME");
            AWSScheduleEngine.startScheduler();
        }
        catch (Throwable e) {
            ConsolePrinter.err("\u8c03\u5ea6\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u5e73\u53f0\u5c06\u9000\u51fa\uff0c\u8bf7\u68c0\u67e5QRTZ_\u8868\u662f\u5426\u5b58\u5728\uff0c\u9519\u8bef\uff1a" + e);
            e.printStackTrace();
            System.exit(Console._exitCode);
        }
        ThreadMgr.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.start();
                    System.out.println("\u4fe1\u606f: [" + UtilDate.datetimeFormat(new Date()) + "]\u8c03\u5ea6\u670d\u52a1\u5df2\u542f\u52a8");
                }
                catch (Throwable e) {
                    ConsolePrinter.err("\u8c03\u5ea6\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u5e73\u53f0\u5c06\u9000\u51fa\uff0c\u9519\u8bef\uff1a" + e);
                    e.printStackTrace();
                    System.exit(Console._exitCode);
                }
            }
        });
    }

    public Date rescheduleJob(String jobId, String jobGroup, Trigger newTrigger) {
        try {
            return scheduler.rescheduleJob(TriggerKey.triggerKey((String)jobId, (String)jobGroup), newTrigger);
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return null;
        }
    }

    public void schedule(String jobId, String jobGroup, Date startTime, Date endTime, int repeatCount, int seconds, Class<? extends IJob> jobClass, Map<String, Object> context) {
        Trigger t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(repeatCount).withIntervalInSeconds(seconds)).withIdentity(AWSScheduleEngine.triggerKey(jobId, jobGroup)).startAt(startTime).endAt(endTime).build();
        this.initContext(t, jobId, jobGroup, context);
        JobDetail jd = JobBuilder.newJob(jobClass).withIdentity(jobId, jobGroup).build();
        this.schedule(jd, t);
    }

    private static TriggerKey triggerKey(String name, String group) {
        return TriggerKey.triggerKey((String)name, (String)group);
    }

    public void schedule(String jobId, String jobGroup, Date startTime, Date endTime, String cron, Class<? extends IJob> jobClass, Map<String, Object> context, TimeZone timeZone) {
        CronTrigger t = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(AWSScheduleEngine.triggerKey(jobId, jobGroup)).startAt(startTime).endAt(endTime).build();
        this.initContext((Trigger)t, jobId, jobGroup, context);
        JobDetail jd = JobBuilder.newJob(jobClass).withIdentity(jobId, jobGroup).build();
        this.schedule(jd, (Trigger)t);
    }

    public void schedule(JobDetail jd, Trigger t) {
        try {
            scheduler.scheduleJob(jd, t);
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void pauseJob(String jobId, String jobGroup) {
        try {
            scheduler.pauseJob(JobKey.jobKey((String)jobId, (String)jobGroup));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void pauseJobGroup(String jobGroup) {
        try {
            String[] gs = this.getJobNames(jobGroup);
            if (gs != null && gs.length > 0) {
                scheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)jobGroup));
            }
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void resumeJob(String jobId, String jobGroup) {
        try {
            scheduler.resumeJob(JobKey.jobKey((String)jobId, (String)jobGroup));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void resumeJobGroup(String jobGroup) {
        try {
            String[] gs = this.getJobNames(jobGroup);
            if (gs != null && gs.length > 0) {
                scheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)jobGroup));
            }
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void initContext(Trigger t, String jobId, String jobGroup, Map<String, Object> context) {
        if (context != null) {
            t.getJobDataMap().putAll(context);
        }
        t.getJobDataMap().put(AWS_JOB_ID, jobId);
        t.getJobDataMap().put(AWS_JOB_GROUP, jobGroup);
    }

    public boolean deleteJob(AWSScheduleModel scheduleModel) {
        return this.deleteJob(scheduleModel.getId(), scheduleModel.getGroup());
    }

    public boolean deleteJob(String scheduleId) {
        AWSScheduleModel model = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        return this.deleteJob(model);
    }

    public boolean deleteJob(String name, String group) {
        try {
            return scheduler.deleteJob(JobKey.jobKey((String)name, (String)group));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return false;
        }
    }

    public void schedule(String scheduleId) {
        AWSScheduleModel model = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        this.schedule(model);
    }

    public void schedule(AWSScheduleModel scheduleModel) {
        if (scheduleModel.isDisabled()) {
            return;
        }
        JobDetail job = this.buildJob(scheduleModel);
        try {
            Trigger t = AWSScheduleEngine.parseTrigger(scheduleModel);
            Trigger tr = scheduler.getTrigger(TriggerKey.triggerKey((String)t.getKey().getName(), (String)t.getKey().getGroup()));
            if (tr == null) {
                scheduler.scheduleJob(job, t);
            }
        }
        catch (Exception e) {
            AWSScheduleEngine.throwTranslateException(e);
        }
    }

    public String[] getJobNames(String jobGroup) {
        try {
            ArrayList<String> s = new ArrayList<String>();
            Set set = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)jobGroup));
            if (!UtilString.isEmpty(set)) {
                for (JobKey key : set) {
                    s.add(key.getName());
                }
            }
            return s.toArray(new String[0]);
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return null;
        }
    }

    public void pause(AWSScheduleModel scheduleModel) {
        try {
            scheduler.pauseJob(JobKey.jobKey((String)scheduleModel.getId(), (String)scheduleModel.getGroup()));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public void updateJob(AWSScheduleModel scheduleModel) {
        JobDetail job = this.buildJob(scheduleModel);
        try {
            scheduler.addJob(job, true);
        }
        catch (Exception e) {
            AWSScheduleEngine.throwTranslateException(e);
        }
    }

    private JobDetail buildJob(AWSScheduleModel scheduleModel) {
        JobDetail job = JobBuilder.newJob(AWSScheduleEngine.parseJobImpl(scheduleModel)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        job.getJobDataMap().put(AWS_SCHEDULE_MODEL_ID, scheduleModel.getId());
        job.getJobDataMap().put(AWS_SCHEDULE_CTX_APP, scheduleModel.getAppId());
        job.getJobDataMap().put(AWS_SCHEDULE_CTX_JOB, scheduleModel.getClassz());
        if (!UtilString.isEmpty(scheduleModel.getUserParam())) {
            job.getJobDataMap().put(AWS_SCHEDULE_USER_PARAM, scheduleModel.getUserParam());
        }
        return job;
    }

    public void updateTrigger(AWSScheduleModel scheduleModel) {
        try {
            Trigger dupeT = scheduler.getTrigger(TriggerKey.triggerKey((String)AWSScheduleEngine.triggerName(scheduleModel), (String)scheduleModel.getGroup()));
            if (dupeT != null) {
                scheduler.rescheduleJob(TriggerKey.triggerKey((String)scheduleModel.getId(), (String)scheduleModel.getGroup()), AWSScheduleEngine.parseTrigger(scheduleModel));
            } else {
                scheduler.scheduleJob(dupeT);
            }
        }
        catch (Exception e) {
            AWSScheduleEngine.throwTranslateException(e);
        }
    }

    public boolean exist(AWSScheduleModel scheduleModel) {
        try {
            JobKey jk = JobKey.jobKey((String)scheduleModel.getId(), (String)scheduleModel.getGroup());
            return scheduler.checkExists(jk);
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return false;
        }
    }

    public boolean interrupt(AWSScheduleModel scheduleModel) {
        try {
            return scheduler.interrupt(JobKey.jobKey((String)scheduleModel.getId(), (String)scheduleModel.getGroup()));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return false;
        }
    }

    public void resum(AWSScheduleModel scheduleModel) {
        try {
            scheduler.resumeJob(JobKey.jobKey((String)scheduleModel.getId(), (String)scheduleModel.getGroup()));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
    }

    public Trigger.TriggerState getTriggerState(String jobId, String group) {
        try {
            return scheduler.getTriggerState(TriggerKey.triggerKey((String)jobId, (String)group));
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return null;
        }
    }

    public void clear() {
        Set names;
        List groups = null;
        try {
            groups = scheduler.getTriggerGroupNames();
            if (!UtilString.isEmpty(groups)) {
                int i = 0;
                while (i < groups.size()) {
                    names = scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)((String)groups.get(i))));
                    if (!UtilString.isEmpty(names)) {
                        scheduler.unscheduleJobs(new ArrayList(names));
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            groups = scheduler.getJobGroupNames();
            if (!UtilString.isEmpty(groups)) {
                int i = 0;
                while (i < groups.size()) {
                    names = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)((String)groups.get(i))));
                    if (!UtilString.isEmpty(names)) {
                        scheduler.deleteJobs(new ArrayList(names));
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Class<? extends Job> parseJobImpl(AWSScheduleModel scheduleModel) {
        JobGroup jp = JobGroupFactory.getJobGroup(scheduleModel.getGroup());
        if ("http".equals(jp.getJobType())) {
            return SYS_HttpExecute.class;
        }
        if ("NativeCall".equals(jp.getJobType())) {
            return SYS_NativeCallExecute.class;
        }
        if ("webservice".equals(jp.getJobType())) {
            return SYS_WSExecute.class;
        }
        if ("SQL".equals(jp.getJobType())) {
            return SYS_SQLExecute.class;
        }
        if (scheduleModel.isConcurrent()) {
            return StatefulJobAdapter.class;
        }
        try {
            DisallowConcurrentExecution dc;
            Object obj = ClassReflect.getInstance(scheduleModel.getClassz(), null, null, scheduleModel.getAppId());
            if (obj instanceof Job && (dc = obj.getClass().getAnnotation(DisallowConcurrentExecution.class)) != null) {
                return StatefulJobAdapter.class;
            }
        }
        catch (Exception e) {
            throw new AWSException("Job\u521d\u59cb\u5316\u51fa\u9519", e);
        }
        return JobAdapter.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean interruptable(AWSScheduleModel scheduleModel) {
        try {
            Job job;
            JobDetail jobDetail;
            List jobs = scheduler.getCurrentlyExecutingJobs();
            Iterator iterator = jobs.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                JobExecutionContext jec = (JobExecutionContext)iterator.next();
                jobDetail = jec.getJobDetail();
                job = jec.getJobInstance();
            } while (!jobDetail.getKey().getName().equals(AWSScheduleEngine.jobName(scheduleModel)) || !jobDetail.getKey().getGroup().equals(scheduleModel.getGroup()) || !(job instanceof InterruptableJob));
            return true;
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
        }
        return false;
    }

    public List<JobExecutionContext> getCurrentlyExecutingJobs() {
        try {
            return scheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            AWSScheduleEngine.throwTranslateException((Exception)((Object)e));
            return null;
        }
    }

    public static boolean isValideScheduleModel(AWSScheduleModel scheduleModel) {
        try {
            AWSScheduleEngine.parseTrigger(scheduleModel);
            AppContext appContext = AppsAPIManager.getInstance().getAppContext(scheduleModel.getAppId());
            ClassReflect.getInstance(scheduleModel.getClassz(), null, null, appContext);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isScheduleModelOutDay(AWSScheduleModel scheduleModel) {
        try {
            Date last;
            Trigger t = AWSScheduleEngine.parseTrigger(scheduleModel);
            if (t != null && (last = t.getFinalFireTime()) != null && !last.before(new Date())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String jobName(AWSScheduleModel scheduleModel) {
        return scheduleModel.getId();
    }

    public static String triggerName(AWSScheduleModel scheduleModel) {
        return scheduleModel.getId();
    }

    public static Trigger parseTrigger(AWSScheduleModel scheduleModel) throws Exception {
        Trigger t = null;
        String[] rule = scheduleModel.getTriggerRule().split(":");
        if ("0".equals(rule[0])) {
            String cron = "0 " + rule[2] + " " + rule[1] + " ? * *";
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("1".equals(rule[0])) {
            String cron = "0 " + rule[3] + " " + rule[2] + " ? * " + rule[1];
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("2".equals(rule[0])) {
            String cron = "0 " + rule[3] + " " + rule[2] + " " + rule[1] + " * ?";
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("3".equals(rule[0])) {
            String monthsOfSession = rule[1].equals("1") ? "1,4,7,10" : (rule[1].equals("2") ? "2,5,8,11" : "3,6,9,12");
            String cron = "0 " + rule[4] + " " + rule[3] + " " + rule[2] + " " + monthsOfSession + " ? *";
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("4".equals(rule[0])) {
            String cron = "0 " + rule[4] + " " + rule[3] + " " + rule[2] + " " + rule[1] + " ? *";
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("5".equals(rule[0])) {
            String cron = rule[1];
            t = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("6".equals(rule[0])) {
            String repeatCount = rule[2];
            String repeatInterval = rule[1];
            t = repeatCount.equals("0") ? TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build() : TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.parseInt(repeatInterval)).withRepeatCount(Integer.parseInt(repeatCount))).withIdentity(scheduleModel.getId(), scheduleModel.getGroup()).build();
        } else if ("7".equals(rule[0])) {
            Object obj = ClassReflect.getInstance(rule[1], null, null, scheduleModel.getAppId());
            if (obj instanceof ITrigger) {
                t = ((ITrigger)obj).getTrigger(scheduleModel.getId(), scheduleModel.getGroup());
            } else {
                throw new IllegalArgumentException("\u89e6\u53d1\u5668\u7c7b\uff1a[" + rule[1] + "]\u9700\u8981\u662f" + Trigger.class.getName() + "\u7684\u5b50\u7c7b");
            }
        }
        return t;
    }

    public void exit() {
        try {
            if (scheduler != null) {
                int size = 0;
                if (scheduler.getCurrentlyExecutingJobs() != null) {
                    size = scheduler.getCurrentlyExecutingJobs().size();
                }
                ConsolePrinter.info("Stopping schedule job, Active(" + size + ")...");
                scheduler.shutdown(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @PersistJobDataAfterExecution
    @DisallowConcurrentExecution
    public static class StatefulJobAdapter
    extends JobAdapter {
    }
}

