/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.PushMetricDataCollector;
import com.actionsoft.bpms.schedule.AWSScheduleEngine;
import com.actionsoft.bpms.schedule.IJob;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.server.monitor.ThreadMonit;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class JobAdapter
implements Job {
    private static Logger logger = LogAPI.getLogger(JobAdapter.class);
    private static Set<String> errtip = new HashSet<String>();
    private static ConcurrentMap<String, ConcurrentMap<Thread, Object>> TT = new ConcurrentHashMap<String, ConcurrentMap<Thread, Object>>();

    private String getIndex(String id, int type) {
        return String.valueOf(id) + "_" + type;
    }

    public static void interrupt(String appId) {
        ConcurrentMap ts = (ConcurrentMap)TT.get(appId);
        if (ts == null) {
            return;
        }
        for (Map.Entry o : ts.entrySet()) {
            if (o.getValue() instanceof InterruptableJob) {
                try {
                    ((InterruptableJob)o.getValue()).interrupt();
                }
                catch (UnableToInterruptJobException unableToInterruptJobException) {}
                continue;
            }
            ((Thread)o.getKey()).interrupt();
        }
        int i = 0;
        while (i++ < 20) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (ts.isEmpty()) break;
        }
        Collection c = ts.values();
        if (!c.isEmpty()) {
            ArrayList<String> cz = new ArrayList<String>();
            for (Object v : c) {
                cz.add(v.getClass().getName());
            }
            try {
                for (Map.Entry entry : ts.entrySet()) {
                    try {
                        Field f = ThreadMonit.class.getDeclaredField("TLIST");
                        f.setAccessible(true);
                        Map m = (Map)f.get(null);
                        m.remove(((Thread)entry.getKey()).getId());
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                    ((Thread)entry.getKey()).stop();
                }
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
            AppsLogger.warn((AppContext)SDK.getAppAPI().getAppContext(appId), (String)("\u5e94\u7528\u6682\u505c\uff0c\u4f46\u8c03\u5ea6\u4efb\u52a1\u4e2d\u65ad\u540e\u4f9d\u7136\u7ee7\u7eed\u6267\u884c\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62\uff1a" + UtilString.join(cz, ",")));
        }
    }

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        AppContext appContext;
        String clazz;
        String resourceInfo;
        String id;
        Object obj;
        String appId;
        String tn;
        block17: {
            block16: {
                tn = Thread.currentThread().getName();
                JobDataMap data = ctx.getJobDetail().getJobDataMap();
                appId = null;
                obj = null;
                try {
                    id = data.getString("aws_schedule_model_id");
                    AWSScheduleModel scheduleModel = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(id);
                    Thread.currentThread().setName("job worker-" + id + (scheduleModel == null ? "" : "," + scheduleModel.getClassz().substring(scheduleModel.getClassz().lastIndexOf(46) + 1)));
                    resourceInfo = null;
                    clazz = null;
                    if (scheduleModel == null) {
                        String index = this.getIndex(id, 0);
                        if (!errtip.contains(index)) {
                            errtip.add(index);
                            logger.warn("\u8c03\u5ea6\u4efb\u52a1[" + id + "]\u6a21\u578b\u4e0d\u5b58\u5728");
                        }
                        appId = data.getString("g_ctx_app");
                        clazz = data.getString("g_ctx_job");
                    } else {
                        appId = scheduleModel.getAppId();
                        clazz = scheduleModel.getClassz();
                        resourceInfo = String.valueOf(scheduleModel.getName()) + "->" + clazz;
                    }
                    appContext = AppsAPIManager.getInstance().getAppContext(appId);
                    if (appContext != null) break block16;
                    logger.error("\u8c03\u5ea6\u4efb\u52a1[" + resourceInfo + "]\u7684app:" + appId + "\u4e0d\u5b58\u5728");
                    AWSScheduleEngine.getInstance().deleteJob(id, "DEFAULT");
                    this.removeExecInfo(appId, obj);
                    Thread.currentThread().setName(tn);
                    return;
                }
                catch (Throwable throwable) {
                    this.removeExecInfo(appId, obj);
                    Thread.currentThread().setName(tn);
                    throw throwable;
                }
            }
            if (SDK.getAppAPI().isActive(appContext)) break block17;
            logger.warn("\u8c03\u5ea6\u4efb\u52a1[" + resourceInfo + "]\u6240\u5728app:" + appContext + "\u672a\u542f\u52a8");
            this.removeExecInfo(appId, obj);
            Thread.currentThread().setName(tn);
            return;
        }
        SLATimeCollectionContext sla = PushMetricDataCollector.getInstance().begin();
        try {
            obj = ClassReflect.getInstance(clazz, null, null, appContext);
            if (obj instanceof Job) {
                this.addTrackInfo(id, clazz);
                this.addExecInfo(appId, obj);
                ((Job)obj).execute(ctx);
                PushMetricDataCollector.getInstance().collection(sla, "JOB.execute", appId, id, resourceInfo, null);
            } else if (obj instanceof IJob) {
                this.addTrackInfo(id, clazz);
                this.addExecInfo(appId, obj);
                ((IJob)obj).execute(ctx);
                PushMetricDataCollector.getInstance().collection(sla, "JOB.execute", appId, id, resourceInfo, null);
            } else {
                String index = this.getIndex(id, 1);
                if (!errtip.contains(index)) {
                    throw new Exception("\u8c03\u5ea6\u4efb\u52a1[" + resourceInfo + "]\u7684\u5b9e\u73b0\u63a5\u53e3\u4e0d\u6b63\u786e");
                }
            }
        }
        catch (ClassNotFoundException e) {
            String index = this.getIndex(id, 2);
            if (!errtip.contains(index)) {
                logger.error("\u8c03\u5ea6\u4efb\u52a1[" + resourceInfo + "] class not find");
            }
        }
        catch (Exception e) {
            PushMetricDataCollector.getInstance().collection(sla, "JOB.failing", appId, id, resourceInfo, e);
            e.printStackTrace(System.err);
            throw new JobExecutionException((Throwable)e);
        }
        this.removeExecInfo(appId, obj);
        Thread.currentThread().setName(tn);
    }

    private void removeExecInfo(String appId, Object obj) {
        ConcurrentMap ts;
        ThreadMonit.end();
        if (appId != null && (ts = (ConcurrentMap)TT.get(appId)) != null) {
            ts.remove(Thread.currentThread());
        }
    }

    private void addTrackInfo(String id, String clazz) {
        ThreadMonit.start((int)2, (Object[])new Object[]{id, clazz});
    }

    private void addExecInfo(String appId, Object obj) {
        if (appId != null) {
            ConcurrentMap ts = (ConcurrentMap)TT.get(appId);
            if (ts == null) {
                TT.putIfAbsent(appId, new ConcurrentHashMap());
                ts = (ConcurrentMap)TT.get(appId);
            }
            ts.put(Thread.currentThread(), obj);
        }
    }
}

