/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule;

import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.schedule.JobsUtil;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.exception.ExceptionUtil;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;

public class LoggingJobHistoryPlugin
implements SchedulerPlugin,
JobListener {
    private String name;

    public void initialize(String pname, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.name = pname;
        scheduler.getListenerManager().addJobListener((JobListener)this, (Matcher)EverythingMatcher.allJobs());
    }

    public void start() {
    }

    public void shutdown() {
    }

    public String getName() {
        return this.name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (jobException != null) {
            String errMsg = ExceptionUtil.getMessage((Throwable)jobException);
            LogModel lg = new LogModel();
            lg.setLogChannel("APP");
            lg.setLogCatalog("job");
            lg.setLogObj(JobsUtil.getJobLogObject(context));
            lg.setOp("exec");
            lg.setOpLevel(9);
            lg.setOpInfo(errMsg);
            Auditor.log(lg);
        } else {
            LogModel lg = new LogModel();
            lg.setLogChannel("APP");
            lg.setLogCatalog("job");
            lg.setLogObj(JobsUtil.getJobLogObject(context));
            lg.setOp("exec");
            StringBuilder sb = new StringBuilder();
            sb.append("runtime:" + context.getJobRunTime());
            if (context.getNextFireTime() != null) {
                sb.append(",nextfire:" + UtilDate.datetimeFormat(context.getNextFireTime()));
            }
            if (context.getResult() != null) {
                sb.append(",result:" + context.getResult());
            }
            lg.setOpInfo(sb.toString());
            Auditor.log(lg);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        LogModel lg = new LogModel();
        lg.setLogChannel("APP");
        lg.setLogCatalog("job");
        lg.setLogObj(JobsUtil.getJobLogObject(context));
        lg.setOp("veto");
        Auditor.log(lg);
    }
}

