/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule;

import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.schedule.JobsUtil;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import org.quartz.JobExecutionContext;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;

public class LoggingTriggerHistoryPlugin
implements SchedulerPlugin,
TriggerListener {
    private String name;

    public void initialize(String pname, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.name = pname;
        scheduler.getListenerManager().addTriggerListener((TriggerListener)this, (Matcher)EverythingMatcher.allTriggers());
    }

    public void start() {
    }

    public void shutdown() {
    }

    public String getName() {
        return this.name;
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
    }

    public void triggerMisfired(Trigger trigger) {
        LogModel lg = new LogModel();
        lg.setLogChannel("APP");
        lg.setLogCatalog("job");
        lg.setLogObj(JobsUtil.getJobLogObject(trigger));
        lg.setOp("misfire");
        lg.setOpLevel(7);
        Auditor.log(lg);
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        AWSScheduleModel scheduleModel;
        String id = (String)context.getMergedJobDataMap().get((Object)"aws_schedule_model_id");
        if (!UtilString.isEmpty(id) && (scheduleModel = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(id)) != null && ("webservice".equals(scheduleModel.getGroup()) || "http".equals(scheduleModel.getGroup()))) {
            JSONObject jo = JSONObject.parseObject((String)scheduleModel.getUserParam());
            String startCondition = SDK.getRuleAPI().executeAtScript(jo.getString("startCondition"));
            return !UtilString.isEmpty(startCondition) && !Boolean.parseBoolean(startCondition);
        }
        return false;
    }
}

