/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.cache;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.bo.design.cache.XModelCacheAbst;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.schedule.AWSScheduleEngine;
import com.actionsoft.bpms.schedule.dao.AWSScheduleDaoFactory;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.exception.AWSEngineException;
import java.util.Map;

public class AWSScheduleCache
extends XModelCacheAbst<AWSScheduleModel> {
    public AWSScheduleCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static final AWSScheduleCache getInstance() {
        return (AWSScheduleCache)((Object)CacheManager.getCache(AWSScheduleCache.class.getName()));
    }

    protected Map<String, AWSScheduleModel> loadOfApp(AppContext app) {
        return AWSScheduleDaoFactory.creatAWSSchedule().getInstanceByApp(app.getId());
    }

    public void scheduleInstIfNot(String appId) {
        Map s = this.getListByApp(appId);
        boolean checked = false;
        for (AWSScheduleModel scheduleModel : s.values()) {
            if (!checked) {
                checked = true;
                if (AWSScheduleEngine.getInstance().exist(scheduleModel)) break;
            }
            try {
                AWSScheduleEngine.getInstance().schedule(scheduleModel);
            }
            catch (Exception e) {
                throw new AWSEngineException("\u914d\u7f6e\u5b9a\u65f6\u4efb\u52a1[" + scheduleModel + "]\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u5668\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528", e, AWSEngineException.ENGINE_JOB);
            }
        }
    }

    public void unscheduleInst(String appId) {
        Map s = this.getListByApp(appId);
        for (AWSScheduleModel scheduleModel : s.values()) {
            try {
                AWSScheduleEngine.getInstance().deleteJob(scheduleModel);
            }
            catch (Exception e) {
                throw new AWSEngineException("\u5378\u8f7d\u5b9a\u65f6\u4efb\u52a1[" + scheduleModel + "]\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u5668\u53ef\u80fd\u8fd8\u5728\u6267\u884c", e, AWSEngineException.ENGINE_JOB);
            }
        }
    }
}

