/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.dao;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.mvc.dao.XDaoObject;
import com.actionsoft.bpms.commons.xmetadata.XDaoUtil;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import java.util.Date;
import java.util.Map;

public class AWSSchedule
extends XDaoObject {
    public AWSSchedule() {
        super("repository/job");
    }

    public int create(AWSScheduleModel model) {
        model.setCreateTime(UtilDate.datetimeFormat(new Date()));
        return this.store(model);
    }

    public int store(AWSScheduleModel model) {
        String appId = model.getAppId();
        if ("".equals(appId)) {
            throw new IllegalArgumentException("<I18N#\u8be5\u64cd\u4f5c\u4e0d\u6210\u529f\uff0c\u539f\u56e0\uff1a\u7f3a\u5c11\u5e94\u7528ID>");
        }
        if ("DEFAULT".equals(model.getGroup()) && !UtilString.isEmpty(model.getClassz())) {
            Map list = AWSScheduleCache.getInstance().getList();
            for (Map vs : list.values()) {
                for (AWSScheduleModel m : vs.values()) {
                    boolean exist;
                    boolean bl = exist = "DEFAULT".equals(m.getGroup()) && m.getClassz().equals(model.getClassz()) && !model.getAppId().equals(m.getAppId());
                    if (!exist || !UtilString.isEmpty(model.getId()) && m.getId().equals(model.getId())) continue;
                    throw new AWSIllegalArgumentException("\u4e0d\u5141\u8bb8[" + model.getClassz() + "]\u6ce8\u518c\u5230\u4e0d\u540c\u7684App\u4e0b\uff0c\u5df2\u53d1\u73b0\uff1a" + m.getId() + "," + m.getAppId());
                }
            }
        }
        if ("".equals(model.getId())) {
            model.setId(XDaoUtil.uuid());
        }
        try {
            model.setUpdateTime(UtilDate.datetimeFormat(new Date()));
            this.saveModel(appId, model, AWSScheduleModel.class);
            AWSScheduleModel scheduleModel = this.getInstance(appId, model.getId());
            scheduleModel.setAppId(appId);
            AWSScheduleCache.getInstance().putModel(scheduleModel);
        }
        catch (AWSDataAccessException e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public int remove(String id) {
        AWSScheduleModel sm = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(id);
        if (sm != null) {
            super.remove(sm.getAppId(), sm.getId());
            AWSScheduleCache.getInstance().removeModel(id);
            Auditor.log("model", "delete", String.valueOf(sm.getId()) + "/" + sm.getName(), "\u5220\u9664\u5b9a\u65f6\u4efb\u52a1");
        }
        return 1;
    }

    public AWSScheduleModel getInstance(String appId, String id) {
        AWSScheduleModel awsScheduleModel = this.loadModel(appId, id, AWSScheduleModel.class);
        awsScheduleModel.setAppId(appId);
        return awsScheduleModel;
    }

    public Map<String, AWSScheduleModel> getInstanceByApp(String appId) {
        return this.loadAllByAppId(appId, AWSScheduleModel.class);
    }

    public Map<String, AWSScheduleModel> getInstanceByApp(AppContext app) {
        return this.loadAllByAppId(app, AWSScheduleModel.class);
    }
}

