/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.system;

import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.log.auditing.model.AuditConfModel;
import com.actionsoft.bpms.commons.log.auditing.model.PurgeModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataPurgeJob
implements Job {
    public static final String FIELDTYPE_LONG = "long";
    public static final String FIELDTYPE_DATE = "date";
    private static final Logger log = LogAPI.getLogger(DataPurgeJob.class);

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        AuditConfModel conf = Auditor.getLgConf();
        if (conf == null) {
            return;
        }
        List<PurgeModel> purges = conf.getPurges();
        for (PurgeModel purge : purges) {
            if ("SYS_AUDIT_LOG".equals(purge.getTable()) && HighSecurity.isON()) continue;
            String t = purge.getTable();
            String fn = purge.getField();
            int expire = purge.getExpire();
            Date deleteBefore = this.getDate(expire);
            String sql = "delete from " + t + " where " + fn + " < ?";
            try {
                DBSql.update(sql, new Object[]{FIELDTYPE_LONG.equals(purge.getFieldtype()) ? Long.valueOf(deleteBefore.getTime()) : deleteBefore});
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5ba1\u8ba1\u6e05\u7406\u51fa\u9519\uff1a" + purge.getTable(), (Throwable)e);
            }
        }
    }

    private Date getDate(int expire) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(5, 1);
        c.set(2, c.get(2) - expire);
        return c.getTime();
    }
}

