/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.system;

import com.actionsoft.bpms.cc.Adapter;
import com.actionsoft.bpms.schedule.IJob;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.SQLException;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SYS_SQLExecute
implements IJob {
    @Override
    public void execute(JobExecutionContext jobexecutioncontext) throws JobExecutionException {
        JobDataMap ctx = jobexecutioncontext.getJobDetail().getJobDataMap();
        AWSScheduleModel scheduleModel = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(ctx.getString("aws_schedule_model_id"));
        if (scheduleModel != null && "SQL".equals(scheduleModel.getGroup())) {
            String cz = scheduleModel.getUserParam();
            JSONObject jo = JSONObject.parseObject((String)cz);
            String jdbc = jo.getString("ccjdbc");
            JSONArray sqls = jo.getJSONArray("sqlExc");
            Connection conn = null;
            Adapter.DB db = null;
            boolean local = "_local".equals(jdbc);
            boolean isTransaction = jo.getBoolean("isTransaction");
            if (local) {
                conn = DBSql.open();
            } else {
                try {
                    db = Adapter.DB.binding((String)jdbc);
                    conn = db.open();
                }
                catch (Exception e) {
                    throw new JobExecutionException((Throwable)e);
                }
            }
            try {
                try {
                    if (isTransaction) {
                        conn.setAutoCommit(false);
                    }
                    int i = 0;
                    while (i < sqls.size()) {
                        String sql = SDK.getRuleAPI().executeAtScript(sqls.getJSONObject(i).getString("sql"));
                        DBSql.update(conn, sql);
                        ++i;
                    }
                    if (isTransaction) {
                        conn.commit();
                    }
                }
                catch (Exception e) {
                    if (isTransaction) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            throw new JobExecutionException((Throwable)e1);
                        }
                    }
                    throw new JobExecutionException((Throwable)e);
                }
            }
            finally {
                if (local) {
                    DBSql.close(conn);
                } else {
                    Adapter.DB.close((Connection)conn);
                }
            }
        }
    }
}

