/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.util;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.managed.ManagedWeb;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelBean;
import com.actionsoft.bpms.repository.ModelRepositoryWeb;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JobGroup {
    protected static final String ICON = "ctxIcon";

    public abstract String getJobType();

    public abstract String getGroupName();

    public String getIconCls() {
        return ICON;
    }

    public abstract String getPage(UserContext var1, AWSScheduleModel var2);

    protected String htmlEncode(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    protected String getTriggerWeb() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("quarterDiv", this.getQuarterDiv());
        macroLibraries.put("yearDiv", this.getYearDiv());
        macroLibraries.put("hourDiv", this.getHourDiv());
        return HtmlPageTemplate.merge("_bpm.platform", "console.i.job.trigger.htm", macroLibraries);
    }

    protected String getYearDiv() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table  class='awsui-ux' style='padding:0px;'><tr>");
        sb.append("<td><select name=\"monthOfYear\" class='awsui-select awsui-select-nofit' style='width:75px;' id = \"monthOfYear\">");
        sb.append((CharSequence)this.getOptions(1, 12));
        sb.append("</select>\u6708&nbsp;&nbsp;<select class='awsui-select awsui-select-nofit' name=\"dayOfYear\" style='width:75px;' id = \"dayOfYear\">");
        sb.append((CharSequence)this.getOptions(1, 31));
        sb.append("</select>\u65e5</td></tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    protected String getHourDiv() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='awsui-ux' style='padding:0px;'><tr>");
        sb.append("<td ><select name=\"hour\" class='awsui-select awsui-select-nofit' id = \"hour\">");
        sb.append((CharSequence)this.getOptions(0, 23));
        sb.append("</select>\u65f6&nbsp;&nbsp;<select name=\"minute\" class='awsui-select awsui-select-nofit' id = \"minute\">");
        sb.append((CharSequence)this.getOptions(0, 59));
        sb.append("</select>\u5206");
        sb.append("<input type=\"hidden\" name=\"second\" id = \"second\" value=\"0\">");
        sb.append("</td></tr>");
        sb.append("</table>");
        return sb.toString();
    }

    protected String getQuarterDiv() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='awsui-ux' style='padding:0px;width:75px;'>\n");
        sb.append("\t<tr>\n");
        sb.append("\t <td>\n");
        sb.append("\t\t<select name=\"monthOfSession\" class='awsui-select awsui-select-nofit' id = \"monthOfSession\">\n");
        sb.append("\t\t\t<option value=\"1\" selected=\"selected\">1</option>\n");
        sb.append("\t\t\t<option value=\"2\">2</option>\n");
        sb.append("\t\t\t<option value=\"3\">3</option>\n");
        sb.append("\t\t</select>\u6708&nbsp;&nbsp;");
        sb.append("<select name=\"dayOfSession\" class='awsui-select awsui-select-nofit' id = \"dayOfSession\">\n");
        sb.append((CharSequence)this.getOptions(1, 31));
        sb.append("\t\t</select>\u65e5\n");
        sb.append("\t </td>\n");
        sb.append(" </tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    private StringBuilder getOptions(int start, int last) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= last) {
            if (i == 1) {
                sb.append("\t\t<option value=\"1\" selected=\"selected\">1</option>\n");
            } else {
                sb.append("\t\t<option value=\"" + i + "\">" + i + "</option>\n");
            }
            ++i;
        }
        return sb;
    }

    protected String getAppsId(AWSScheduleModel scheduleModel, UserContext _me) {
        boolean edit = scheduleModel.getId() == null || "".equals(scheduleModel.getId());
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t<select class='awsui-select' name=\"appId\" id = \"appId\"" + (edit ? "" : " disabled") + ">\n");
        sb.append("<option value=''>\u8bf7\u9009\u62e9</option>");
        List<AppContext> apps = ModelRepositoryWeb.getVisibleInstalledApps(_me.getUID());
        for (AppContext appContext : apps) {
            sb.append("\t<option value=\"" + appContext.getId() + "\" " + (appContext.getId().equals(scheduleModel.getAppId()) ? "selected" : "") + ">" + appContext.getName() + "</option>\n");
        }
        sb.append("</select>");
        return sb.toString();
    }

    protected String formateCZ(String label, String value) {
        String s = "<td class='awsui-ux-title'>{0}</td><td id = 'td_cz' >{1}</td>";
        return MessageFormat.format(s, label, value);
    }

    protected void setManagedInfo(AWSScheduleModel model, Map<String, Object> macroLibraries) {
        macroLibraries.put("managedInfo", new ManagedWeb(DispatcherRequest.getUserContext()).getManagedWebHtml((PlatformXMetaModelBean)model));
    }
}

