/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.util;

import com.actionsoft.bpms.schedule.util.DefaultGroup;
import com.actionsoft.bpms.schedule.util.HttpGroup;
import com.actionsoft.bpms.schedule.util.JobGroup;
import com.actionsoft.bpms.schedule.util.NativeCallGroup;
import com.actionsoft.bpms.schedule.util.SQLGroup;
import com.actionsoft.bpms.schedule.util.WebServiceGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobGroupFactory {
    private static List<JobGroup> _jobGroup = null;
    private static Map<String, JobGroup> _mapJobGroup = null;

    static {
        _jobGroup = new ArrayList<JobGroup>();
        _jobGroup.add(new DefaultGroup());
        _jobGroup.add(new SQLGroup());
        _jobGroup.add(new WebServiceGroup());
        _jobGroup.add(new NativeCallGroup());
        _jobGroup.add(new HttpGroup());
        _mapJobGroup = new HashMap<String, JobGroup>(_jobGroup.size());
        for (JobGroup group : _jobGroup) {
            _mapJobGroup.put(group.getJobType(), group);
        }
    }

    public static int order(String jobType) {
        JobGroup jp = JobGroupFactory.getJobGroup(jobType);
        int i = 0;
        while (i < _jobGroup.size()) {
            if (_jobGroup.get(i) == jp) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static List getSupportGroup() {
        return Collections.unmodifiableList(_jobGroup);
    }

    public static JobGroup getJobGroup(String jobType) {
        return _mapJobGroup.get(jobType);
    }
}

