/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.util;

import com.actionsoft.bpms.cc.CCUtil;
import com.actionsoft.bpms.cc.cache.CCCache;
import com.actionsoft.bpms.cc.model.CCModel;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.schedule.util.JobGroup;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class SQLGroup
extends JobGroup {
    public static final String JDBC_CONNECTION = "ccjdbc";
    public static final String JDBC_SQL = "sqlExc";
    public static final String JDBC_ISTRANSCATION = "isTransaction";
    public static final String JDBC_CONNECTION_LOCAL = "_local";

    @Override
    public String getGroupName() {
        return "DB Job";
    }

    @Override
    public String getJobType() {
        return "SQL";
    }

    private String getccjdbc(String jdbc, String uid) {
        StringBuilder sb = new StringBuilder();
        sb.append("<select value = '" + jdbc + "' class='awsui-select'  id = \"" + JDBC_CONNECTION + "\" name = \"" + JDBC_CONNECTION + "\">");
        if (jdbc == null || "".equals(jdbc)) {
            sb.append("<option value=''>\u8bf7\u9009\u62e9...</option>");
            sb.append("<option value='_local'>\u5f53\u524dBPM\u6570\u636e\u6e90</option>");
            sb.append("<optgroup label=\"CC\u6570\u636e\u6e90\">");
            Map h = CCCache.getInstance().getListByType("jdbc", uid);
            int i = 0;
            while (i < h.size()) {
                CCModel cp = (CCModel)h.get(i);
                sb.append("<option value='" + cp.getId() + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
                ++i;
            }
        } else if (jdbc.equals(JDBC_CONNECTION_LOCAL)) {
            sb.append("<option value='_local'>\u5f53\u524dBPM\u6570\u636e\u6e90</option>");
            sb.append("<optgroup label=\"CC\u6570\u636e\u6e90\">");
            Map h = CCCache.getInstance().getListByType("jdbc");
            int i = 0;
            while (i < h.size()) {
                CCModel cp = (CCModel)h.get(i);
                sb.append("<option value='" + cp.getId() + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
                ++i;
            }
        } else {
            CCModel cp = (CCModel)CCCache.getInstance().getModel(jdbc);
            if (cp != null) {
                sb.append("<option value='" + jdbc + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
            } else {
                sb.append("<option value=''>\u8bf7\u9009\u62e9...</option>");
            }
            sb.append("<option value='_local'>\u5f53\u524dBPM\u6570\u636e\u6e90</option>");
            sb.append("<optgroup label=\"CC\u6570\u636e\u6e90\">");
            Map h = CCCache.getInstance().getListByType("jdbc");
            int i = 0;
            while (i < h.size()) {
                cp = (CCModel)h.get(i);
                if (!cp.getId().equals(jdbc)) {
                    sb.append("<option value='" + cp.getId() + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
                }
                ++i;
            }
        }
        sb.append("</select>");
        return sb.toString();
    }

    @Override
    public String getPage(UserContext me, AWSScheduleModel scheduleModel) {
        String title = "\u5b9a\u65f6\u4efb\u52a1\u7f16\u8f91";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("title", title);
        macroLibraries.put("planId", scheduleModel.getId());
        macroLibraries.put("name", this.htmlEncode(scheduleModel.getName()));
        macroLibraries.put("desc", this.htmlEncode(scheduleModel.getDesc()));
        String cz = scheduleModel.getUserParam();
        if (UtilString.isEmpty(cz)) {
            macroLibraries.put(JDBC_CONNECTION, this.getccjdbc("", me.getUID()));
            macroLibraries.put("recoredData", "[]");
            macroLibraries.put("classz", "");
            macroLibraries.put(JDBC_ISTRANSCATION, "<input type = 'checkbox' class='awsui-checkbox' name = 'isTransaction' id = 'isTransaction'>");
        } else {
            JSONObject jo = JSONObject.parseObject((String)cz);
            macroLibraries.put(JDBC_CONNECTION, this.getccjdbc(jo.getString(JDBC_CONNECTION), me.getUID()));
            macroLibraries.put("recoredData", jo.getJSONArray(JDBC_SQL));
            macroLibraries.put(JDBC_ISTRANSCATION, "<input type = 'checkbox' class='awsui-checkbox' name = 'isTransaction' id = 'isTransaction' " + (jo.containsKey((Object)JDBC_ISTRANSCATION) && jo.getBoolean(JDBC_ISTRANSCATION) != false ? "checked" : "") + ">");
            macroLibraries.put("classz", this.htmlEncode(scheduleModel.getClassz()));
        }
        macroLibraries.put("userParam", this.htmlEncode(scheduleModel.getUserParam()));
        macroLibraries.put("triggerRule", UtilString.isEmpty(scheduleModel.getId()) ? "[]" : JSONArray.parseArray((String)JSON.toJSONString((Object)scheduleModel.getTriggerRule().split(":"))).toString());
        macroLibraries.put("planId", scheduleModel.getId());
        macroLibraries.put("sid", me.getSessionId());
        macroLibraries.put("isSystem", scheduleModel.isSystem() ? "1" : "0");
        macroLibraries.put("isDisabled", scheduleModel.isDisabled() ? "1" : "0");
        macroLibraries.put("trigger", this.getTriggerWeb());
        macroLibraries.put("appId", scheduleModel.getAppId());
        macroLibraries.put("jobGroup", this.getJobType());
        this.setManagedInfo(scheduleModel, macroLibraries);
        return HtmlPageTemplate.merge("_bpm.platform", "console.i.job.sql.page.htm", macroLibraries);
    }
}

