/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.util;

import com.actionsoft.bpms.cc.CCUtil;
import com.actionsoft.bpms.cc.cache.CCCache;
import com.actionsoft.bpms.cc.model.CCModel;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.schedule.util.JobGroup;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class WebServiceGroup
extends JobGroup {
    public static final String WS_UUID = "wsUuid";

    @Override
    public String getGroupName() {
        return "WebService Job";
    }

    @Override
    public String getJobType() {
        return "webservice";
    }

    private String getWSDef(String uuid, String uid) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span class=\"required\"><select id = \"wsUuid\"  class='awsui-select' value = '" + uuid + "' name = \"wsUuid\">");
        if (uuid == null || "".equals(uuid)) {
            sb.append("<option value=''>\u8bf7\u9009\u62e9...</option>");
        } else {
            CCModel cp = (CCModel)CCCache.getInstance().getModel(uuid);
            if (cp != null) {
                sb.append("<option value='" + uuid + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
            } else {
                sb.append("<option value=''>\u8bf7\u9009\u62e9...</option>");
            }
        }
        Map h = CCCache.getInstance().getListByType("ws", uid);
        int i = 0;
        while (i < h.size()) {
            CCModel cp = (CCModel)h.get(i);
            if ("".equals(uuid)) {
                sb.append("<option value='" + cp.getId() + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
            } else if (!cp.getId().equals(uuid)) {
                sb.append("<option value='" + cp.getId() + "'>" + CCUtil.getName((CCModel)cp) + "</option>");
            }
            ++i;
        }
        sb.append("</select></span>");
        return sb.toString();
    }

    @Override
    public String getPage(UserContext me, AWSScheduleModel scheduleModel) {
        String title = "\u5b9a\u65f6\u4efb\u52a1\u7f16\u8f91";
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("title", title);
        macroLibraries.put("appId", scheduleModel.getAppId());
        macroLibraries.put("name", this.htmlEncode(scheduleModel.getName()));
        macroLibraries.put("desc", this.htmlEncode(scheduleModel.getDesc()));
        JSONObject jo = new JSONObject();
        try {
            String s = scheduleModel.getUserParam();
            jo = JSONObject.parseObject((String)s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        macroLibraries.put(WS_UUID, this.formateCZ("CC SOAP", this.getWSDef(UtilJson.optString(jo, "id"), me.getUID())));
        macroLibraries.put("startCondition", this.htmlEncode(UtilJson.optString(jo, "startCondition")));
        macroLibraries.put("reqArgs", Html.escape(UtilJson.optString(jo, "reqArgs")));
        macroLibraries.put("userParam", this.htmlEncode(scheduleModel.getUserParam()));
        macroLibraries.put("classz", this.htmlEncode(scheduleModel.getClassz()));
        macroLibraries.put("triggerRule", UtilString.isEmpty(scheduleModel.getId()) ? "[]" : JSONArray.parseArray((String)JSON.toJSONString((Object)scheduleModel.getTriggerRule().split(":"))).toString());
        macroLibraries.put("planId", scheduleModel.getId());
        macroLibraries.put("sid", me.getSessionId());
        macroLibraries.put("isSystem", scheduleModel.isSystem() ? "1" : "0");
        macroLibraries.put("isDisabled", scheduleModel.isDisabled() ? "1" : "0");
        macroLibraries.put("trigger", this.getTriggerWeb());
        macroLibraries.put("jobGroup", this.getJobType());
        this.setManagedInfo(scheduleModel, macroLibraries);
        return HtmlPageTemplate.merge("_bpm.platform", "console.i.job.ws.page.htm", macroLibraries);
    }
}

