/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.schedule.web;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.managed.ManagedControl;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bpmn.engine.JobAPIManager;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.log.auditing.constant.AuditConst;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelBean;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.schedule.AWSScheduleEngine;
import com.actionsoft.bpms.schedule.ITrigger;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.dao.AWSScheduleDaoFactory;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.schedule.util.JobGroup;
import com.actionsoft.bpms.schedule.util.JobGroupFactory;
import com.actionsoft.bpms.schedule.util.Pager;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.Trigger;

public class ScheduleDesignWeb
extends ActionWeb {
    public ScheduleDesignWeb(UserContext me) {
        super(me);
    }

    private static String getJOBIoc(String group) {
        if (group == null) {
            return "";
        }
        String ioc = "";
        if (group.equals("DEFAULT")) {
            ioc = "&#58978;";
        } else if (group.equals("http")) {
            ioc = "&#xe9e7;";
        } else if (group.equals("NativeCall")) {
            ioc = "&#58978;";
        } else if (group.equals("SQL")) {
            ioc = "&#58898;";
        } else if (group.equals("webservice")) {
            ioc = "&#58899;";
        }
        return ioc;
    }

    private static String getFrequency(AWSScheduleModel scheduleModel) {
        String[] r = scheduleModel.getTriggerRule().split(":");
        StringBuilder sb = new StringBuilder();
        switch (Integer.parseInt(r[0])) {
            case 0: {
                sb.append("\u5929\u8ba1\u5212(" + r[1] + ":" + r[2] + ")");
                break;
            }
            case 1: {
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                m.put(1, "\u65e5");
                m.put(2, "\u4e00");
                m.put(3, "\u4e8c");
                m.put(4, "\u4e09");
                m.put(5, "\u56db");
                m.put(6, "\u4e94");
                m.put(7, "\u516d");
                String[] ss = r[1].split(",");
                ArrayList<String> s1 = new ArrayList<String>();
                String[] stringArray = ss;
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    int w = Integer.parseInt(str);
                    s1.add((String)m.get(w));
                    ++n2;
                }
                sb.append("\u5468\u8ba1\u5212(\u5468" + UtilString.join(s1, ",") + "\uff0c" + r[2] + ":" + r[3] + ")");
                break;
            }
            case 2: {
                sb.append("\u6708\u8ba1\u5212(" + r[1] + "\u53f7 " + r[2] + ":" + r[3] + ")");
                break;
            }
            case 3: {
                sb.append("\u5b63\u8ba1\u5212(\u7b2c" + r[1] + "\u6708\u7b2c" + r[2] + "\u5929 " + r[3] + ":" + r[4] + ")");
                break;
            }
            case 4: {
                sb.append("\u5e74\u8ba1\u5212(\u7b2c" + r[1] + "\u6708\u7b2c" + r[2] + "\u5929 " + r[3] + ":" + r[4] + ")");
                break;
            }
            case 5: {
                sb.append("CRON(" + r[1] + ")");
                break;
            }
            case 6: {
                if (r[2].equals("0")) {
                    sb.append("\u6267\u884c\u4e00\u6b21");
                    break;
                }
                sb.append(String.valueOf(r[2].equals("-1") ? "\u65e0\u9650" : "\u91cd\u590d" + r[2]) + "\u6b21\uff0c\u95f4\u9694" + r[1] + "\u79d2");
                break;
            }
            case 7: {
                sb.append("\u89e6\u53d1\u5668(" + r[1] + ")");
                break;
            }
        }
        return sb.toString();
    }

    public static String getTriggerStatus(String jobId, String group) {
        Trigger.TriggerState s = AWSScheduleEngine.getInstance().getTriggerState(jobId, group);
        String str = "-";
        if (s == Trigger.TriggerState.BLOCKED) {
            str = "\u963b\u585e";
        } else if (s == Trigger.TriggerState.COMPLETE) {
            str = "\u7ed3\u675f";
        } else if (s == Trigger.TriggerState.ERROR) {
            str = "\u9519\u8bef";
        } else if (s == Trigger.TriggerState.NONE) {
            str = "\u65e0\u8c03\u5ea6";
        } else if (s == Trigger.TriggerState.NORMAL) {
            str = "\u8fd0\u884c";
        } else if (s == Trigger.TriggerState.PAUSED) {
            str = "\u6682\u505c";
        }
        return str;
    }

    public static String getInfo(LogModel logModel, SimpleDateFormat df) {
        if (logModel.getOp().equals("exec") && logModel.getOpLevel() != 9) {
            String[] ss;
            String infoStr = logModel.getOpInfo();
            if (UtilJson.mayBeJSON(infoStr)) {
                JSONObject info = JSONObject.parseObject((String)infoStr);
                StringBuilder sb = new StringBuilder();
                if (info.containsKey((Object)"firetime")) {
                    if (sb.length() > 0) {
                        sb.append("\uff0c");
                    }
                    sb.append("\u89e6\u53d1\u65f6\u95f4\uff1a" + df.format(new Date(info.getLongValue("firetime"))));
                }
                if (info.containsKey((Object)"endtime")) {
                    if (sb.length() > 0) {
                        sb.append("\uff0c");
                    }
                    sb.append("\u7ed3\u675f\u65f6\u95f4\uff1a" + df.format(new Date(info.getLongValue("endtime"))));
                }
                if (info.containsKey((Object)"runtime")) {
                    if (sb.length() > 0) {
                        sb.append("\uff0c");
                    }
                    sb.append("\u7528\u65f6\uff1a" + UtilJson.optString(info, "runtime") + "\u6beb\u79d2");
                }
                if (info.containsKey((Object)"nextfire")) {
                    if (sb.length() > 0) {
                        sb.append("\uff0c");
                    }
                    sb.append("\u4e0b\u6b21\u89e6\u53d1\uff1a" + df.format(new Date(info.getLongValue("nextfire"))));
                }
                if (info.containsKey((Object)"result")) {
                    if (sb.length() > 0) {
                        sb.append("\uff0c");
                    }
                    sb.append("\u7528\u6237\u6570\u636e\uff1a" + UtilJson.optString(info, "result"));
                }
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder();
            String[] stringArray = ss = infoStr.split(",");
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.contains("runtime")) {
                    sb.append("\u7528\u65f6\uff1a" + s.split(":")[1] + "\u6beb\u79d2" + ",");
                } else if (s.contains("nextfire")) {
                    sb.append("\u4e0b\u6b21\u89e6\u53d1\uff1a" + s.substring(s.indexOf(" ") + 1) + ",");
                }
                ++n2;
            }
            return sb.substring(0, sb.length() - 1);
        }
        return logModel.getOpInfo();
    }

    private Set<String> getAuthAppIds(String uid, boolean dev) {
        HashSet<String> set = new HashSet<String>();
        List<AppContext> list = AMCAPIManager.getVisibleInstalledDevAndManagementApps(this.getContext().getUID());
        for (AppContext app : list) {
            set.add(app.getId());
        }
        return set;
    }

    public String getSchedulesAsJson(int curPage, int pageSize, String appId, String jobType, String jobName) {
        HashMap<String, Map> jobList;
        ResponseObject response = ResponseObject.newOkResponse();
        if (!UtilString.isEmpty(appId)) {
            jobList = new HashMap<String, Map>();
            jobList.put(appId, AWSScheduleCache.getInstance().getListByApp(appId));
        } else {
            jobList = AWSScheduleCache.getInstance().getList();
        }
        ArrayList<AWSScheduleModel> scheduleModels = new ArrayList<AWSScheduleModel>();
        Set<String> set = this.getAuthAppIds(this.getContext().getUID(), false);
        for (String tempAppId : jobList.keySet()) {
            Map appJobList = (Map)jobList.get(tempAppId);
            for (String jobId : appJobList.keySet()) {
                AWSScheduleModel scheduleModel = (AWSScheduleModel)appJobList.get(jobId);
                if (!UtilString.isEmpty(jobType) && !jobType.equals(scheduleModel.getGroup()) || !UtilString.isEmpty(jobName) && !scheduleModel.getName().toLowerCase().contains(jobName.toLowerCase()) && !scheduleModel.getId().contains(jobName) && !scheduleModel.getClassz().toLowerCase().contains(jobName.toLowerCase()) || !set.contains(tempAppId)) continue;
                scheduleModels.add(scheduleModel);
            }
        }
        Collections.sort(scheduleModels, new Comparator<AWSScheduleModel>(){

            @Override
            public int compare(AWSScheduleModel o1, AWSScheduleModel o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int result = o2.getCreateDate().compareTo(o1.getCreateDate());
                if (result == 0) {
                    return (o2.isSystem() ? 1 : 0) - (o1.isSystem() ? 1 : 0);
                }
                return result;
            }
        });
        Pager pager = new Pager(curPage, pageSize, scheduleModels.size());
        JSONArray jobJA = new JSONArray();
        int i = pager.getStart_size() - 1 >= 0 ? pager.getStart_size() - 1 : 0;
        while (i < pager.getEnd_size()) {
            AWSScheduleModel scheduleModel = (AWSScheduleModel)scheduleModels.get(i);
            JSONObject jobJO = new JSONObject();
            jobJO.put("id", (Object)scheduleModel.getId());
            String groupName = "";
            JobGroup group = JobGroupFactory.getJobGroup(scheduleModel.getGroup());
            if (group != null) {
                groupName = group.getGroupName();
            } else {
                System.err.println("\u5b9a\u65f6\u5668" + scheduleModel.getAppId() + "/" + scheduleModel.getId() + "\u7684\u5c5e\u6027\u53ef\u80fd\u4e0d\u6b63\u786e\uff0cgroup=" + scheduleModel.getGroup());
            }
            jobJO.put("group", (Object)groupName);
            jobJO.put("name", (Object)Html.escape(scheduleModel.getName()));
            jobJO.put("status", (Object)ScheduleDesignWeb.getTriggerStatus(scheduleModel.getId(), scheduleModel.getGroup()));
            jobJO.put("ioc", (Object)ScheduleDesignWeb.getJOBIoc(group == null ? null : group.getJobType()));
            jobJO.put("isSystem", (Object)scheduleModel.isSystem());
            jobJO.put("edit", (Object)this.getEdit(scheduleModel));
            jobJO.put("statusManager", (Object)this.getStatus(scheduleModel));
            jobJO.put("frequency", (Object)ScheduleDesignWeb.getFrequency(scheduleModel));
            UserModel u = UserCache.getModel((String)scheduleModel.getCreateUser());
            jobJO.put("createUser", (Object)(u == null ? scheduleModel.getCreateUser() : u.getUserName()));
            jobJO.put("createDate", (Object)UtilDate.dateFormat(scheduleModel.getCreateDate()));
            jobJO.put("desc", (Object)Html.escape(scheduleModel.getDesc().length() > 195 ? String.valueOf(scheduleModel.getDesc().substring(0, 195)) + "..." : scheduleModel.getDesc()));
            jobJO.put("appId", (Object)scheduleModel.getAppId());
            String appName = "";
            AppContext appContext = AppsAPIManager.getInstance().getAppContext(scheduleModel.getAppId());
            if (appContext != null) {
                appName = appContext.getName();
            }
            jobJO.put("appName", (Object)appName);
            jobJA.add((Object)jobJO);
            ++i;
        }
        JSONObject pagedData = new JSONObject();
        pagedData.put("totalRecords", (Object)scheduleModels.size());
        pagedData.put("data", (Object)jobJA);
        pagedData.put("pager", (Object)pager);
        response.setData(pagedData);
        return response.toString();
    }

    private Trigger.TriggerState getTriggerState(AWSScheduleModel scheduleModel) {
        return AWSScheduleEngine.getInstance().getTriggerState(scheduleModel.getId(), scheduleModel.getGroup());
    }

    private String getStatus(AWSScheduleModel scheduleModel) {
        Trigger.TriggerState s = this.getTriggerState(scheduleModel);
        boolean outOfDay = AWSScheduleEngine.isScheduleModelOutDay(scheduleModel);
        if (!this.isStartRunOnceModel(scheduleModel) && !outOfDay && AWSScheduleEngine.isValideScheduleModel(scheduleModel) && s != Trigger.TriggerState.NONE) {
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (!outOfDay) {
            if (s == Trigger.TriggerState.NONE) {
                actions.add("<a href = '#' class='' onclick = 'schedule(\"" + scheduleModel.getId() + "\",1);return false;'><span title= '\u672a\u8c03\u5ea6\uff0c\u70b9\u51fb\u542f\u52a8\u4efb\u52a1'><i class='awsui-iconfont' style='font-size:16px;color:#c8a202;'>&#59204;</i></span></a>");
            } else if (s != Trigger.TriggerState.COMPLETE) {
                if (s == Trigger.TriggerState.BLOCKED) {
                    actions.add("<a href = '#' class='' onclick = 'pause(\"" + scheduleModel.getId() + "\",1);return false;' title= '\u963b\u585e\u72b6\u6001'><span><i class='awsui-iconfont' style='font-size:16px;color:#8c8c8c;'>&#58905;</i></span></a>");
                } else if (s == Trigger.TriggerState.ERROR) {
                    actions.add("<a href = '#' class='' onclick = 'pause(\"" + scheduleModel.getId() + "\",1);return false;' title= '\u51fa\u9519\u72b6\u6001'><span><i class='awsui-iconfont' style='font-size:16px;color:#f3a327;'>&#58941;</i></span></a>");
                } else {
                    if (s == Trigger.TriggerState.PAUSED) {
                        actions.add("<a href = '#' class='' onclick = 'pause(\"" + scheduleModel.getId() + "\",1);return false;'><span title= '\u6682\u505c\u72b6\u6001\uff0c\u70b9\u51fb\u8fd0\u884c'><i class='awsui-iconfont' style='font-size:16px;color:#ffbd53;'>&#xe783;</i></span></a>");
                    }
                    if (s == Trigger.TriggerState.NORMAL) {
                        actions.add("<a href = '#'  class='' onclick = 'pause(\"" + scheduleModel.getId() + "\",0);return false;'><span title = '\u8fd0\u884c\u72b6\u6001\uff0c\u70b9\u51fb\u6682\u505c'><i class='awsui-iconfont' style='font-size:16px;color:#48c521;'>&#xe768;</i></span></a>");
                    }
                }
            }
        }
        if (!scheduleModel.isDisabled() && AWSScheduleEngine.getInstance().interruptable(scheduleModel)) {
            actions.add("<a href = '#' class='' style='color:#2c96ea' onclick = 'interrupt(\"" + scheduleModel.getId() + "\");return false;'><img src = '../apps/_bpm.platform/img/model/admin.gif' awsui-qtip = '\u8fd0\u884c\u72b6\u6001\uff0c\u70b9\u51fb\u6267\u884c\u4e2d\u65ad'></a>");
        }
        actions.add("<a href='#' onclick=openLogDialog(\"" + scheduleModel.getId() + "\")><span title='\u67e5\u770b\u65e5\u5fd7'><i class='awsui-iconfont' style='font-size:16px;color:#49c521;'>&#59183;</i></span></a>");
        String isVisibility = "style='visibility: hidden;'";
        if (AMCAPIManager.isXModelAccess(scheduleModel, this.getContext().getUID())) {
            isVisibility = "";
            actions.add("<span class='separator'>\uff5c</span>");
        }
        String tip = "title='\u672a\u9501\u5b9a'";
        if (scheduleModel.isSystem()) {
            tip = "title='\u9501\u5b9a\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u548c\u5220\u9664'";
        }
        String iconfont = scheduleModel.isSystem() ? "&#xe7b3;" : "&#xe7bc;";
        actions.add("<a " + isVisibility + " href = '#' onclick = 'setSystem(\"" + scheduleModel.getId() + "\",\"" + (scheduleModel.isSystem() ? "0" : "1") + "\");return false;'><span " + tip + " ><i class='awsui-iconfont' style='font-size:16px;color:#49c521;'>" + iconfont + "</i></span></a>");
        String evt = Html.toHtmlJSEvent("onclick", "btnRemoveHandle", new Object[]{scheduleModel.getName(), scheduleModel.getId(), scheduleModel.isSystem()});
        actions.add("<a href='#'  " + (!scheduleModel.isSystem() ? "" : "style='visibility: hidden;'") + evt + "><span title='\u5220\u9664' ><i class='awsui-iconfont' style='font-size:16px;color:#49c521;'>&#58918;</i></span></a>");
        return StringUtils.join(actions, (String)"&nbsp;&nbsp;");
    }

    public String checkClass(String input, String appId, String type) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            Class<?> inputClass = ClassReflect.forName(input, appId);
            if (type.equals("job")) {
                if (!Job.class.isAssignableFrom(inputClass)) {
                    ro.warn("\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u7c7b[" + input + "]\u9700\u8981\u662f" + Job.class.getName() + "\u7684\u5b50\u7c7b");
                }
            } else if (type.equals("trigger") && !ITrigger.class.isAssignableFrom(inputClass)) {
                ro.warn("\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u7c7b\uff1a[" + input + "]\u9700\u8981\u662f" + Trigger.class.getName() + "\u7684\u5b50\u7c7b");
            }
        }
        catch (ClassNotFoundException e) {
            ro.warn("\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u7c7b\uff1a[" + input + "]\u4e0d\u5b58\u5728");
        }
        return ro.toString();
    }

    private String getEdit(AWSScheduleModel scheduleModel) {
        StringBuilder str = new StringBuilder();
        String evt = Html.toHtmlJSEvent("onclick", "addSchedule", new Object[]{scheduleModel.getId(), scheduleModel.getGroup(), scheduleModel.isDisabled(), scheduleModel.getName()});
        str.append("<a href = '#' style='font-size:24px;vertical-align: middle;' " + evt + " title='" + scheduleModel.getName() + "'>" + scheduleModel.getName() + "</a>");
        return str.toString();
    }

    private boolean isStartRunOnceModel(AWSScheduleModel scheduleModel) {
        String[] rule = scheduleModel.getTriggerRule().split(":");
        return "6".equals(rule[0]) && rule[2].equals("0");
    }

    public String getScheduleLogsAsJson(String schedule) {
        ResponseObject response = ResponseObject.newOkResponse();
        AWSScheduleModel sm = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(schedule);
        List h = JobAPIManager.getInstance().getJobLogs(sm.getId(), sm.getGroup(), 0, 120);
        JSONArray ja = new JSONArray();
        GregorianCalendar c = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        for (LogModel logModel : h) {
            JSONObject jo = new JSONObject();
            jo.put("type", (Object)AuditConst.getOpI18N(logModel.getOp()));
            jo.put("rdate", (Object)UtilDate.datetimeFormat(logModel.getOpTime()));
            c.setTime(logModel.getOpTime());
            jo.put("day", (Object)Integer.toString(c.get(5)));
            jo.put("status", (Object)logModel.getOpLevel());
            jo.put("info", (Object)ScheduleDesignWeb.getInfo(logModel, df));
            ja.add((Object)jo);
        }
        JSONObject result = new JSONObject();
        result.put("success:true", (Object)true);
        result.put("root", (Object)ja);
        response.setData(result);
        return response.toString();
    }

    public String schedule(String scheduleId, String isSchedule) {
        ResponseObject response = ResponseObject.newOkResponse();
        AWSScheduleModel m = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        if (isSchedule.equals("1")) {
            try {
                if (m.isDisabled()) {
                    response.msg("\u4efb\u52a1\u88ab\u505c\u7528\uff0c\u4e0d\u80fd\u542f\u52a8");
                    return response.toString();
                }
                response.msg("\u542f\u52a8\u6210\u529f");
                AWSScheduleEngine.getInstance().schedule(m);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.msg("\u4efb\u52a1\uff1a[" + m.getName() + "]\u542f\u52a8\u5931\u8d25\\n\u539f\u56e0\uff1a" + e.getMessage());
                response.err();
                return response.toString();
            }
        }
        try {
            AWSScheduleEngine.getInstance().deleteJob(m);
            response.msg("\u505c\u6b62\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.msg("\u4efb\u52a1\uff1a[" + m.getName() + "_" + m.getId() + "]\u505c\u6b62\u5931\u8d25\\n\u539f\u56e0\uff1a" + e.getMessage());
            response.err();
            return response.toString();
        }
        return response.toString();
    }

    public String setSystem(String scheduleId, String beSystem) {
        ResponseObject response = ResponseObject.newErrResponse();
        AWSScheduleModel m = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        if (!AMCAPIManager.isXModelAccess(m, this.getContext().getUID())) {
            response.err("\u6ca1\u6709\u6743\u9650");
        } else {
            m.setSystem("1".equals(beSystem));
            AWSScheduleDaoFactory.creatAWSSchedule().store(m);
            response.ok("\u8bbe\u7f6e\u6210\u529f");
        }
        return response.toString();
    }

    public String pauseSchedule(String scheduleId, String isSchedule) {
        ResponseObject response = ResponseObject.newErrResponse();
        AWSScheduleModel m = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        try {
            if (isSchedule.equals("1")) {
                AWSScheduleEngine.getInstance().resum(m);
            } else {
                AWSScheduleEngine.getInstance().pause(m);
            }
            response.ok("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.err("\u64cd\u4f5c\u5931\u8d25[" + e.getMessage() + "]");
        }
        return response.toString();
    }

    public String interruptSchedule(String scheduleId) {
        ResponseObject response = ResponseObject.newErrResponse();
        AWSScheduleModel m = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(scheduleId);
        boolean sucess = false;
        try {
            sucess = AWSScheduleEngine.getInstance().interrupt(m);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.msg("\u4efb\u52a1\uff1a[" + m.getName() + "_" + m.getId() + "]\u4e2d\u65ad\u5f02\u5e38\\n\u539f\u56e0\uff1a" + e.getMessage());
            return response.toString();
        }
        if (sucess) {
            response.ok();
            response.msg("\u6210\u529f\u8fd0\u884c\u4e2d\u65ad");
        } else {
            response.msg("\u4efb\u52a1\u5b9e\u4f8b\u53ef\u80fd\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        return response.toString();
    }

    public String getList(String optType, String appId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        List l = JobGroupFactory.getSupportGroup();
        JSONObject jo = new JSONObject();
        int j = 0;
        while (j < l.size()) {
            jo.put(((JobGroup)l.get(j)).getGroupName(), (Object)j);
            ++j;
        }
        macroLibraries.put("indexObj", jo.toString());
        macroLibraries.put("sid", this.getContext().getSessionId());
        Set<String> tmp = this.getAuthAppIds(this.getContext().getUID(), true);
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        AppsAPIManager.getInstance().sortAppByName(appContexts);
        StringBuilder sb = new StringBuilder();
        sb.append("<option selected='selected' value='' >\u8bf7\u9009\u62e9APP</option>");
        for (AppContext appContext : appContexts) {
            if (!appContext.getRuntimeState().equals("ACTIVE") || !tmp.contains(appContext.getId())) continue;
            sb.append("<option value='" + appContext.getId() + "'>" + appContext.getName() + "</option>");
        }
        macroLibraries.put("appOptions", sb.toString());
        macroLibraries.put("optType", Html.encodeForJavaScript(optType));
        macroLibraries.put("targetAppId", Html.encodeForJavaScript(appId));
        return HtmlPageTemplate.merge("_bpm.platform", "console.i.job.list.htm", macroLibraries);
    }

    public String checkSys(String id) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AWSScheduleModel model = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(id);
        ro.put("status", model != null && model.isSystem());
        return ro.toString();
    }

    public String getAppList(String appName) {
        List<AppContext> appContexts = AMCAPIManager.getDevApps(super.getContext().getUID());
        AppsAPIManager.getInstance().sortAppByName(appContexts);
        JSONArray appNames = new JSONArray();
        JSONObject empty = new JSONObject();
        empty.put("id", (Object)"");
        empty.put("text", (Object)"");
        empty.put("imgs", (Object)"");
        appNames.add((Object)empty);
        for (AppContext appContext : appContexts) {
            if (!appContext.getRuntimeState().equals("ACTIVE")) continue;
            JSONObject jsObject = new JSONObject();
            String img = AMCUtil.getAppIconNoClass(appContext.getId());
            jsObject.put("label", (Object)appContext.getName());
            jsObject.put("value", (Object)appContext.getId());
            jsObject.put("id", (Object)appContext.getId());
            jsObject.put("imgs", (Object)img);
            jsObject.put("text", (Object)appContext.getName());
            appNames.add((Object)jsObject);
        }
        return appNames.toString();
    }

    public String getLogList(String taskID) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("schedules", taskID);
        AWSScheduleModel model = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(taskID);
        macroLibraries.put("sid", this.getContext().getSessionId());
        String title = model.getName();
        macroLibraries.put("title", title);
        return HtmlPageTemplate.merge("_bpm.platform", "console.i.job.log.htm", macroLibraries);
    }

    public String deleteSchedules(String id) {
        ResponseObject response = ResponseObject.newOkResponse();
        AWSScheduleModel xModel = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(id);
        if (xModel == null) {
            response.msg("\u6a21\u578b\u4e0d\u5b58\u5728\uff0cid=" + id);
        } else if (!AMCAPIManager.isXModelAccess(xModel, this.getContext().getUID())) {
            response.warn("\u6ca1\u6709\u6743\u9650");
        } else {
            AWSScheduleEngine.getInstance().deleteJob(id);
            AWSScheduleDaoFactory.creatAWSSchedule().remove(id);
            response.msg("\u5220\u9664\u6210\u529f");
        }
        return response.toString();
    }

    public String getSchedulePage(AWSScheduleModel scheduleModel) {
        if (!UtilString.isEmpty(scheduleModel.getId()) && !AMCAPIManager.isDevelopApp(scheduleModel.getAppId(), this.getContext().getUID())) {
            throw new AWSForbiddenException("\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        }
        return JobGroupFactory.getJobGroup(scheduleModel.getGroup()).getPage(this.getContext(), scheduleModel);
    }

    public String saveSchedule(RequestParams params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        boolean isCreate = UtilString.isEmpty(params.get("planId"));
        AWSScheduleModel model = this.saveModel(params);
        if (isCreate) {
            ro.put("type", "create");
            ro.put("planId", model.getId());
        } else {
            ro.put("type", "save");
            ro.put("planId", model.getId());
        }
        ro.msg("\u4fdd\u5b58\u6210\u529f");
        return ro.toString();
    }

    private AWSScheduleModel saveModel(RequestParams params) {
        AWSScheduleModel model = null;
        String planId = params.get("planId");
        boolean isCreate = UtilString.isEmpty(planId);
        if (isCreate) {
            model = new AWSScheduleModel();
        } else {
            model = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(planId);
            ManagedControl.getInstance().interceptor((PlatformXMetaModelBean)model);
        }
        model.setSystem("1".equals(params.get("isSystem")));
        model.setDisabled("1".equals(params.get("isDisabled")));
        model.setGroup(params.get("jobGroup"));
        model.setName(params.get("name"));
        String cz = params.get("classz");
        model.setAppId(params.get("appId"));
        model.setManaged(params.get("managed").equalsIgnoreCase("on"));
        if (AppsAPIManager.getInstance().getAppContext(model.getAppId()) == null) {
            throw new AWSIllegalArgumentException("appId\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u53ef\u80fd\u6ca1\u6709\u8f93\u5165\u6b63\u786e\u7684\u5e94\u7528\u540d\u79f0");
        }
        model.setClassz(cz);
        model.setStateful(params.getBoolean("isStateful"));
        model.setConcurrent(params.getBoolean("concurrent"));
        model.setUserParam(params.get("userParam"));
        String desc = params.get("desc");
        model.setDesc(desc);
        String triggerRule = params.get("triggerRule");
        model.setTriggerRule(triggerRule);
        if (isCreate) {
            model.setCreateUser(this.getContext().getUID());
            model.setCreateDate(new Date());
        }
        if (isCreate) {
            AWSScheduleDaoFactory.creatAWSSchedule().create(model);
        } else {
            AWSScheduleDaoFactory.creatAWSSchedule().store(model);
        }
        return model;
    }

    public String applySchedule(RequestParams params) {
        boolean isCreate = UtilString.isEmpty(params.get("planId"));
        AWSScheduleModel m = this.saveModel(params);
        ResponseObject ro = ResponseObject.newOkResponse();
        if (!isCreate) {
            AWSScheduleEngine.getInstance().deleteJob(m);
        }
        if (!m.isDisabled()) {
            AWSScheduleEngine.getInstance().schedule(m);
            ro.ok("\u5e94\u7528\u6210\u529f");
        } else {
            ro.warn("\u5e94\u7528\u65b0\u8bbe\u7f6e\u4e0d\u6210\u529f\uff0c\u539f\u56e0\uff1a\u5b9a\u65f6\u4efb\u52a1\u88ab\u7981\u7528");
        }
        if (isCreate) {
            ro.put("type", "applyCreate");
        } else {
            ro.put("type", "apply");
        }
        ro.put("planId", m.getId());
        return ro.toString();
    }
}

