/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server;

import com.actionsoft.bpms.server.IniSystem;
import com.actionsoft.bpms.server.ShutdownAWSServer;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.framework.io.Exchange;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.serialization.ClassResolvers;
import io.netty.handler.codec.serialization.ObjectDecoder;
import io.netty.handler.codec.serialization.ObjectEncoder;
import java.util.HashMap;
import java.util.Properties;

@Controller
public class ShutdownServer {
    @Mapping(value="CONSOLE_SHELL_SERVICE_SHUTDOWN", session=false, noSessionReason="\u672c\u5730shutdown\u811a\u672c\u5173\u95edAWS\u670d\u52a1", noSessionEvaluate="\u8be5\u547d\u4ee4\u8981\u6c42\u63d0\u4f9b\u7279\u5f81\u4fe1\u606f\uff0c\u5df2\u505a\u5b89\u5168\u5904\u7406")
    public String callASLP(String securityCode) {
        if (this.shutdown(securityCode)) {
            return "1";
        }
        return "0";
    }

    private boolean shutdown(String securityCode) {
        String licence = new UtilFile("license.dat").readStrUTF8();
        if (licence == null) {
            licence = "no_license";
        }
        if (!licence.equals(securityCode)) {
            return false;
        }
        ShutdownAWSServer.infoDown("\u63a5\u6536\u5230\u5173\u95edAWS\u670d\u52a1\u7684\u811a\u672c\u6307\u4ee4");
        return true;
    }

    private void shutdown() throws Exception {
        Properties properties = System.getProperties();
        System.out.println("Using AWS_HOME: " + properties.getProperty("user.dir"));
        System.out.println("Using JAVA_HOME:" + properties.getProperty("java.home"));
        IniSystem.initEngine();
        String licence = new UtilFile("license.dat").readStrUTF8();
        if (licence == null) {
            licence = "no_license";
        }
        try {
            Exchange msg = new Exchange();
            msg.setClientIp("localhost");
            msg.setCmd("CONSOLE_SHELL_SERVICE_SHUTDOWN");
            msg.setResponseType("JD");
            msg.setSecurityKey(AWSPortalConf.getSecurityCode());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("l", licence);
            parameters.put("securityCode", licence);
            msg.setParameters(parameters);
            ShutdownServer.sendNio("localhost", AWSServerConf.getMainServerPort(), msg);
            System.out.println("Send Signal Success");
        }
        catch (Exception e) {
            System.out.println("Shutdown Error");
            System.out.println(e.getMessage());
        }
    }

    private static void sendNio(String host, int port, Exchange message) throws Exception {
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)workerGroup);
            b.channel(NioSocketChannel.class);
            b.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("frameDecoder", (ChannelHandler)new ObjectDecoder(0xA00000, ClassResolvers.cacheDisabled((ClassLoader)Exchange.class.getClassLoader())));
                    pipeline.addLast("frameEncoder", (ChannelHandler)new ObjectEncoder());
                }
            });
            ChannelFuture f = b.connect(host, port).sync();
            f.channel().writeAndFlush((Object)message);
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        new ShutdownServer().shutdown();
        System.exit(0);
    }
}

