/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.conf.portal;

import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.RequestContext;
import com.actionsoft.bpms.server.ShutdownAWSServer;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.LanguageModel;
import com.actionsoft.bpms.server.conf.portal.MobilePortalConfig;
import com.actionsoft.bpms.util.UtilString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class AWSPortalConf {
    protected static boolean isInit = false;
    private static long lastModified;
    public static String SSO_NTLM;
    public static String SSO_CAS;
    private static String location;
    private static String url;
    private static String mobileUrl;
    private static String securityLoginAdapter;
    private static int securityFailLockedTimes;
    private static long securityUnlockTime;
    private static String securityPwdDefault;
    private static int securityMinPwdLength;
    private static int securityMaxPwdLength;
    private static int securityPwdCycle;
    private static boolean securityPwdComplexity;
    private static boolean securityPwdChange;
    private static String securityCode;
    private static String requiredUserInfo;
    private static String ssoProvider;
    private static String ssoKeystore;
    private static String ssoKeyPwd;
    private static String ssoJndiCC;
    private static List<LanguageModel> language;
    private static Map<String, String> properties;
    private static MobilePortalConfig mobilePortalConfig;

    static {
        SSO_NTLM = "NTLM";
        SSO_CAS = "CAS";
        properties = new HashMap<String, String>();
        mobilePortalConfig = new MobilePortalConfig();
        AWSPortalConf.readXML();
    }

    public static Boolean isInit() {
        return isInit;
    }

    protected static void readXML() {
        if (AWSPortalConf.isInit().booleanValue()) {
            return;
        }
        isInit = true;
        File xmlFile = new File("conf/aws-portal.xml");
        if (!xmlFile.exists()) {
            ShutdownAWSServer.errDown("Not find[conf/aws-portal.xml]");
        }
        AWSPortalConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        try {
            Document doc = DocumentFactory.getInstance().createDocument();
            doc = saxreader.read(xmlFile);
            Element root = doc.getRootElement();
            String location = root.attributeValue("location");
            String url = root.attributeValue("url");
            String mobileUrl = root.attributeValue("mobileUrl");
            AWSPortalConf.setLocation(location);
            AWSPortalConf.setUrl(url);
            AWSPortalConf.setMobileUrl(mobileUrl);
            Iterator iter = root.elementIterator();
            while (iter.hasNext()) {
                Iterator iter2;
                Element element = (Element)iter.next();
                if (element == null) continue;
                if (element.getName().equals("security")) {
                    String loginAdapter = element.attributeValue("loginAdapter");
                    String failLockedTimes = element.attributeValue("failLockedTimes");
                    String unlockTime = element.attributeValue("unlockTime");
                    String pwdDefault = element.attributeValue("pwdDefault");
                    String minPwdLength = element.attributeValue("minPwdLength");
                    String maxPwdLength = element.attributeValue("maxPwdLength");
                    String pwdCycle = element.attributeValue("pwdCycle");
                    String pwdComplexity = element.attributeValue("pwdComplexity");
                    String pwdChange = element.attributeValue("pwdChange");
                    String code = element.attributeValue("code");
                    String requiredUserInfo = element.attributeValue("requiredUserInfo");
                    AWSPortalConf.setSecurityLoginAdapter(loginAdapter);
                    AWSPortalConf.setSecurityPwdDefault(pwdDefault);
                    AWSPortalConf.setSecurityCode(code);
                    AWSPortalConf.setRequiredUserInfo(requiredUserInfo);
                    try {
                        if (failLockedTimes != null) {
                            AWSPortalConf.setSecurityFailLockedTimes(Integer.valueOf(failLockedTimes));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (unlockTime != null) {
                            AWSPortalConf.setSecurityUnlockTime(Long.valueOf(unlockTime));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (minPwdLength != null) {
                            AWSPortalConf.setSecurityMinPwdLength(Integer.valueOf(minPwdLength));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (maxPwdLength != null) {
                            AWSPortalConf.setSecurityMaxPwdLength(Integer.valueOf(maxPwdLength));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (pwdCycle != null) {
                            AWSPortalConf.setSecurityPwdCycle(Integer.valueOf(pwdCycle));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (pwdComplexity != null) {
                            AWSPortalConf.setSecurityPwdComplexity(Boolean.valueOf(pwdComplexity));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (pwdChange == null) continue;
                        AWSPortalConf.setSecurityPwdChange(Boolean.valueOf(pwdChange));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (element.getName().equals("sso")) {
                    String provider = element.attributeValue("provider");
                    String keystore = element.attributeValue("keystore");
                    String keyPwd = element.attributeValue("keyPwd");
                    String jndiCC = element.attributeValue("jndiCC");
                    AWSPortalConf.setSsoProvider(provider);
                    AWSPortalConf.setSsoKeystore(keystore);
                    AWSPortalConf.setSsoKeyPwd(keyPwd);
                    AWSPortalConf.setSsoJndiCC(jndiCC);
                    continue;
                }
                if (element.getName().equals("properties")) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    iter2 = element.elementIterator();
                    while (iter2.hasNext()) {
                        Element property = (Element)iter2.next();
                        String name = property.attributeValue("name");
                        String value = property.getTextTrim();
                        properties.put(name.trim().toUpperCase(), value);
                    }
                    AWSPortalConf.setProperties(properties);
                    continue;
                }
                if (element.getName().equals("language")) {
                    ArrayList<LanguageModel> languages = new ArrayList<LanguageModel>();
                    iter2 = element.elementIterator();
                    while (iter2.hasNext()) {
                        Element layout = (Element)iter2.next();
                        String title = layout.attributeValue("title");
                        String name = layout.attributeValue("name");
                        String def = layout.attributeValue("default");
                        boolean isDef = false;
                        if (!UtilString.isEmpty(def) && def.equalsIgnoreCase("true")) {
                            isDef = true;
                        }
                        languages.add(new LanguageModel(name, title, isDef));
                    }
                    AWSPortalConf.setLanguages(languages);
                    continue;
                }
                if (!element.getName().equals("mobilePortal")) continue;
                String enabled = element.attributeValue("enabled");
                String mdmEnabled = element.attributeValue("mdmEnabled");
                String bannerUrl = element.attributeValue("bannerUrl");
                String bannerLink = element.attributeValue("bannerLink");
                String padBackground = element.attributeValue("padBackground");
                String phoneBackground = element.attributeValue("phoneBackground");
                String iOSMDMPermPwd = element.attributeValue("iOSMDMPermPwd");
                String appleId = element.attributeValue("appleId");
                String apnsCreate = element.attributeValue("apnsCreate");
                String userUnregister = element.attributeValue("userUnregister");
                String multiDevice = element.attributeValue("multiDevice");
                mobilePortalConfig.setEnabled(enabled != null && enabled.length() > 0 ? Boolean.valueOf(enabled) : false);
                mobilePortalConfig.setBannerUrl(bannerUrl);
                mobilePortalConfig.setiOSMDMPermPwd(iOSMDMPermPwd);
                mobilePortalConfig.setPadBackground(padBackground);
                mobilePortalConfig.setPhoneBackground(phoneBackground);
                mobilePortalConfig.setAppleId(appleId);
                mobilePortalConfig.setApnsCreate(apnsCreate != null && apnsCreate.length() > 0 ? Boolean.valueOf(apnsCreate) : false);
                mobilePortalConfig.setBannerLink(bannerLink);
                mobilePortalConfig.setMdmEnabled(mdmEnabled != null && mdmEnabled.length() > 0 ? Boolean.valueOf(mdmEnabled) : true);
                mobilePortalConfig.setUserUnregister(userUnregister != null && userUnregister.length() > 0 ? Boolean.valueOf(userUnregister) : true);
                mobilePortalConfig.setMultiDevice(multiDevice != null && multiDevice.length() > 0 ? Boolean.valueOf(multiDevice) : true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ShutdownAWSServer.errDown("Parser [conf/aws-portal.xml] error! [" + e.getMessage() + "]");
        }
    }

    public static String getLocation() {
        if (location == null || location.trim().length() == 0) {
            location = "../webserver/webapps/portal/";
        }
        return location;
    }

    protected static void setLocation(String location) {
        AWSPortalConf.location = location;
    }

    public static String getUrl() {
        UserContext userContext;
        RequestContext resuestContext = DispatcherRequest.getContext();
        if (resuestContext != null && (userContext = resuestContext.getUserContext()) != null && (userContext.isMobileClient() || userContext.isTabletClient())) {
            return AWSPortalConf.getMobileUrl();
        }
        if (url == null || url.trim().length() == 0) {
            url = "http://localhost:8088/portal";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    protected static void setUrl(String url) {
        AWSPortalConf.url = url;
    }

    public static String getMobileUrl() {
        if (mobileUrl == null || mobileUrl.trim().length() == 0) {
            mobileUrl = url;
        }
        if (mobileUrl.endsWith("/")) {
            mobileUrl = mobileUrl.substring(0, mobileUrl.length());
        }
        return mobileUrl;
    }

    protected static void setMobileUrl(String sslUrl) {
        mobileUrl = sslUrl;
    }

    public static String getSecurityLoginAdapter() {
        if (securityLoginAdapter == null || securityLoginAdapter.trim().length() == 0) {
            securityLoginAdapter = "com.actionsoft.bpms.commons.login.LoginImpl";
        }
        return securityLoginAdapter;
    }

    protected static void setSecurityLoginAdapter(String securityLoginAdapter) {
        AWSPortalConf.securityLoginAdapter = securityLoginAdapter;
    }

    public static int getSecurityFailLockedTimes() {
        return securityFailLockedTimes;
    }

    protected static void setSecurityFailLockedTimes(int securityFailLockedTimes) {
        AWSPortalConf.securityFailLockedTimes = securityFailLockedTimes;
    }

    public static long getSecurityUnlockTime() {
        if (securityUnlockTime == 0L) {
            securityUnlockTime = 600000L;
        }
        return securityUnlockTime;
    }

    protected static void setSecurityUnlockTime(long securityUnlockTime) {
        AWSPortalConf.securityUnlockTime = securityUnlockTime;
    }

    public static String getSecurityPwdDefault() {
        if (securityPwdDefault == null || securityPwdDefault.trim().length() == 0) {
            securityPwdDefault = "123456";
        }
        return securityPwdDefault;
    }

    protected static void setSecurityPwdDefault(String securityPwdDefault) {
        AWSPortalConf.securityPwdDefault = securityPwdDefault;
    }

    public static int getSecurityMinPwdLength() {
        return securityMinPwdLength;
    }

    protected static void setSecurityMinPwdLength(int securityMinPwdLength) {
        AWSPortalConf.securityMinPwdLength = securityMinPwdLength;
    }

    public static int getSecurityMaxPwdLength() {
        if (securityMaxPwdLength <= 0 || securityMaxPwdLength > 32) {
            securityMaxPwdLength = 32;
        }
        return securityMaxPwdLength;
    }

    protected static void setSecurityMaxPwdLength(int securityMaxPwdLength) {
        AWSPortalConf.securityMaxPwdLength = securityMaxPwdLength;
    }

    public static int getSecurityPwdCycle() {
        return securityPwdCycle;
    }

    protected static void setSecurityPwdCycle(int securityPwdCycle) {
        AWSPortalConf.securityPwdCycle = securityPwdCycle;
    }

    public static boolean isSecurityPwdComplexity() {
        return securityPwdComplexity;
    }

    protected static void setSecurityPwdComplexity(boolean securityPwdComplexity) {
        AWSPortalConf.securityPwdComplexity = securityPwdComplexity;
    }

    public static boolean isSecurityPwdChange() {
        return securityPwdChange;
    }

    protected static void setSecurityPwdChange(boolean securityPwdChange) {
        AWSPortalConf.securityPwdChange = securityPwdChange;
    }

    public static String getSecurityCode() {
        if (securityCode == null || securityCode.trim().length() == 0) {
            securityCode = "AH{%C1%F5%BD%F0%D6%F9}";
        }
        return securityCode;
    }

    protected static void setSecurityCode(String securityCode) {
        AWSPortalConf.securityCode = securityCode;
    }

    public static String getRequiredUserInfo() {
        if (requiredUserInfo == null || requiredUserInfo.trim().length() == 0) {
            requiredUserInfo = "";
        }
        return requiredUserInfo;
    }

    protected static void setRequiredUserInfo(String requiredUserInfo) {
        AWSPortalConf.requiredUserInfo = requiredUserInfo;
    }

    public static String getSsoProvider() {
        return ssoProvider;
    }

    protected static void setSsoProvider(String ssoProvider) {
        AWSPortalConf.ssoProvider = ssoProvider;
    }

    public static String getSsoKeystore() {
        return ssoKeystore;
    }

    protected static void setSsoKeystore(String ssoKeystore) {
        AWSPortalConf.ssoKeystore = ssoKeystore;
    }

    public static String getSsoKeyPwd() {
        return ssoKeyPwd;
    }

    protected static void setSsoKeyPwd(String ssoKeyPwd) {
        AWSPortalConf.ssoKeyPwd = ssoKeyPwd;
    }

    public static String getSsoJndiCC() {
        return ssoJndiCC;
    }

    protected static void setSsoJndiCC(String ssoJndiCC) {
        AWSPortalConf.ssoJndiCC = ssoJndiCC;
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String str = properties.get((name = name.trim()).toUpperCase());
        if (str == null) {
            str = "";
        }
        return str;
    }

    protected static void setProperties(Map<String, String> properties) {
        AWSPortalConf.properties = properties;
    }

    protected static void setProperty(String name, String value) {
        properties.put(name.trim().toUpperCase(), value);
    }

    public static List<LanguageModel> getLanguages() {
        if (language == null) {
            language = new ArrayList<LanguageModel>();
            language.add(new LanguageModel("cn", "\u4e2d\u6587\u7b80\u4f53", true));
        }
        return language;
    }

    public static String getDefaultLanguage() {
        List<LanguageModel> languages = AWSPortalConf.getLanguages();
        for (LanguageModel m : languages) {
            if (!m.isDefault()) continue;
            return m.getName();
        }
        return "cn";
    }

    public static String getDefaultLanguageTitle() {
        List<LanguageModel> languages = AWSPortalConf.getLanguages();
        for (LanguageModel m : languages) {
            if (!m.isDefault()) continue;
            return m.getTitle();
        }
        return "cn";
    }

    protected static void setLanguages(List<LanguageModel> language) {
        AWSPortalConf.language = language;
    }

    public static boolean isNTLM() {
        return SSO_NTLM.equalsIgnoreCase(ssoProvider);
    }

    public static boolean isCAS() {
        return SSO_CAS.equalsIgnoreCase(ssoProvider);
    }

    protected static long getLastModified() {
        return lastModified;
    }

    protected static void setLastModified(long lastModified) {
        AWSPortalConf.lastModified = lastModified;
    }

    public static MobilePortalConfig getMobilePortalConfig() {
        return mobilePortalConfig;
    }

    public static void main(String[] args) {
        System.out.println(AWSPortalConf.getSsoProvider());
    }
}

