/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.conf.portal;

import com.actionsoft.bpms.server.conf.portal.PortalXMLScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class PortalXML {
    private static PortalXML config = new PortalXML();

    private PortalXML() {
    }

    public static final PortalXML getInstance() {
        return config;
    }

    public final void saveProperty(File appConfigFile, Map<String, String> values) throws Exception {
        Document doc = this.getDocument(appConfigFile);
        for (String key : values.keySet()) {
            Element node = this.getElement(doc, key);
            if (node == null) continue;
            node.setText(values.get(key));
        }
        this.saveXML(doc, appConfigFile);
        new PortalXMLScanner().scan();
    }

    private final Document getDocument(File configFile) throws Exception {
        SAXReader saxreader = new SAXReader();
        Document doc = DocumentFactory.getInstance().createDocument();
        doc = saxreader.read(configFile);
        return doc;
    }

    private final Element getElement(Document doc, String name) throws Exception {
        Element propertiesNode;
        List propertyList;
        Element portalNode;
        List propertiesList;
        List portalList = doc.selectNodes("portal");
        if (portalList.size() > 0 && (propertiesList = (portalNode = (Element)portalList.get(0)).selectNodes("properties")).size() > 0 && (propertyList = (propertiesNode = (Element)propertiesList.get(0)).selectNodes("property")).size() > 0) {
            int i = 0;
            while (i < propertyList.size()) {
                Element propertyNode = (Element)propertyList.get(i);
                Attribute attrName = propertyNode.attribute("name");
                if (attrName.getText().equals(name)) {
                    return propertyNode;
                }
                ++i;
            }
        }
        return null;
    }

    public void saveXML(Document doc, File configFile) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(4);
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(configFile), format);
        writer.write(doc);
        writer.close();
    }
}

