/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.conf.server;

import com.actionsoft.bpms.server.ShutdownAWSServer;
import com.actionsoft.bpms.util.Passwd;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSIllegalArgumentException;
import java.io.File;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class AWSServerConf {
    protected static boolean isInit = false;
    private static long lastModified;
    public static String DB_PROVIDER_ORACLE;
    public static String DB_PROVIDER_SQLSERVER;
    public static String DB_PROVIDER_MYSQL;
    public static String DB_PROVIDER_DB2;
    public static String DB_PROVIDER_SYBASE;
    public static String DB_PROVIDER_DM;
    public static String DB_PROVIDER_OSCAR;
    private static String DB_PROVIDER_ST;
    public static String DB_PROVIDER_INFORMIX;
    private static String DB_PROVIDER_GBASE;
    public static String DB_PROVIDER_POSTGRESQL;
    public static String DEF_UNICAST_PORT;
    private static String instanceName;
    private static String ip;
    private static String version;
    private static boolean paasCloud;
    private static String paasCloudAPIId;
    private static boolean clusterService;
    private static String clusterGroup;
    private static String clusterMulticastAddr;
    private static String clusterMulticastPort;
    private static long clusterFrequency;
    private static long clusterDropTime;
    private static boolean multicastEnabled;
    private static String unicastHosts;
    private static String unicastPort;
    private static int mainServerPort;
    private static int mainServerMaxClient;
    private static long mainServerConnectionTimeout;
    private static boolean mainServerShell;
    private static long mainServerSessionTimeout;
    private static long mainServerSessionIdleTime;
    private static int fileServerPort;
    private static long fileServerConnectionTimeout;
    private static boolean debugSql;
    private static boolean debugCmd;
    private static boolean debugTemplatePage;
    private static boolean debugCache;
    private static String databaseProvider;
    private static String databaseDriver;
    private static String databaseUrl;
    private static String username;
    private static String password;
    private static int initialSize;
    private static int maxActive;
    private static String databaseExtendConfig;
    private static Map<String, String> properties;
    private static int jobsThreadCount;
    public static final String IP = "aws.ip";
    public static final String INSTANCE = "aws.inst";
    public static final String PORT_AWS = "aws.business.port";
    public static final String PORT_FILE = "aws.file.port";
    private static final String MULTICAST_ADDR = "228.0.0.4";
    private static final String MULTICAST_PORT = "45564";
    private static final String UNICAST_PORT = "unicast.port";
    private static final String DROPTIME = "3000";
    private static final String FRE = "500";

    static {
        DB_PROVIDER_ORACLE = "oracle";
        DB_PROVIDER_SQLSERVER = "sqlserver";
        DB_PROVIDER_MYSQL = "mysql";
        DB_PROVIDER_DB2 = "db2";
        DB_PROVIDER_SYBASE = "sybase";
        DB_PROVIDER_DM = "dm";
        DB_PROVIDER_OSCAR = "oscar";
        DB_PROVIDER_ST = "st";
        DB_PROVIDER_INFORMIX = "informix";
        DB_PROVIDER_GBASE = "gbase";
        DB_PROVIDER_POSTGRESQL = "postgresql";
        DEF_UNICAST_PORT = "'4000";
        multicastEnabled = true;
        properties = new HashMap<String, String>();
        AWSServerConf.readXML();
    }

    public static boolean isInit() {
        return isInit;
    }

    protected static void readXML() {
        if (AWSServerConf.isInit()) {
            return;
        }
        isInit = true;
        File xmlFile = new File("conf/server.xml");
        if (!xmlFile.exists()) {
            ShutdownAWSServer.errDown("\u65e0\u6cd5\u542f\u52a8AWS\u670d\u52a1\uff0c\u539f\u56e0\u662f[" + System.getProperties().getProperty("user.dir") + "]\u76ee\u5f55\u4e0b\u8bfb\u627e\u4e0d\u5230/conf/server.xml\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u5c06\u542f\u52a8\u8def\u5f84\u8bbe\u7f6e\u4e3aAWS\u5b89\u88c5\u76ee\u5f55");
        }
        AWSServerConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        try {
            Document doc = DocumentFactory.getInstance().createDocument();
            doc = saxreader.read(xmlFile);
            Element root = doc.getRootElement();
            String ip = root.attributeValue("ip");
            String instanceName = root.attributeValue("instanceName");
            String version = root.attributeValue("version");
            String paasCloudAPIId = root.attributeValue("paasCloudAPIId");
            AWSServerConf.setIp(ip);
            AWSServerConf.setInstanceName(instanceName);
            AWSServerConf.setVersion(version);
            AWSServerConf.setPaaSCloudAPIId(paasCloudAPIId);
            String paasCloud = root.attributeValue("paasCloud");
            try {
                if (paasCloud != null) {
                    AWSServerConf.setPaaSCloud(Boolean.valueOf(paasCloud));
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            Iterator iter = root.elementIterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                if (element == null) continue;
                if (element.getName().equals("connector")) {
                    String port;
                    if (element.attributeValue("name").equals("mainServer")) {
                        port = element.attributeValue("port");
                        String maxClient = element.attributeValue("maxClient");
                        String connectionTimeout = element.attributeValue("connectionTimeout");
                        String shell = element.attributeValue("shell");
                        String sessionTimeout = element.attributeValue("sessionTimeout");
                        String sessionIdleTime = element.attributeValue("sessionIdleTime");
                        try {
                            if (port != null) {
                                AWSServerConf.setMainServerPort(Integer.valueOf(port));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (maxClient != null) {
                                AWSServerConf.setMainServerMaxClient(Integer.valueOf(maxClient));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (connectionTimeout != null) {
                                AWSServerConf.setMainServerConnectionTimeout(Long.valueOf(connectionTimeout));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (shell != null) {
                                AWSServerConf.setMainServerShell(Boolean.valueOf(shell));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (sessionTimeout != null) {
                                AWSServerConf.setMainServerSessionTimeout(Long.valueOf(sessionTimeout));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        try {
                            if (sessionIdleTime == null) continue;
                            AWSServerConf.setMainServerSessionIdleTime(Long.valueOf(sessionIdleTime));
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        continue;
                    }
                    if (!element.attributeValue("name").equals("fileServer")) continue;
                    port = element.attributeValue("port");
                    String connectionTimeout = element.attributeValue("connectionTimeout");
                    try {
                        if (port != null) {
                            AWSServerConf.setFileServerPort(Integer.valueOf(port));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (connectionTimeout == null) continue;
                        AWSServerConf.setFileServerConnectionTimeout(Long.valueOf(connectionTimeout));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (element.getName().equals("cluster")) {
                    String dropTime;
                    String frequency;
                    String multicastPort;
                    String unicastPort;
                    String unicastHosts;
                    String service = element.attributeValue("service");
                    String group = element.attributeValue("group");
                    String multicastEnabled = element.attributeValue("multicast.enabled");
                    if (!UtilString.isEmpty(multicastEnabled)) {
                        AWSServerConf.multicastEnabled = Boolean.parseBoolean(multicastEnabled);
                    }
                    AWSServerConf.unicastHosts = unicastHosts = element.attributeValue("unicast.hosts");
                    AWSServerConf.unicastPort = unicastPort = element.attributeValue(UNICAST_PORT);
                    String multicastAddr = element.attributeValue("multicastAddr");
                    if (UtilString.isEmpty(multicastAddr)) {
                        multicastAddr = MULTICAST_ADDR;
                    }
                    if (UtilString.isEmpty(multicastPort = element.attributeValue("multicastPort"))) {
                        multicastPort = MULTICAST_PORT;
                    }
                    if (UtilString.isEmpty(frequency = element.attributeValue("frequency"))) {
                        frequency = FRE;
                    }
                    if (UtilString.isEmpty(dropTime = element.attributeValue("dropTime"))) {
                        dropTime = DROPTIME;
                    }
                    try {
                        if (service != null) {
                            AWSServerConf.setClusterService(Boolean.valueOf(service));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    AWSServerConf.setClusterGroup(group);
                    AWSServerConf.setClusterMulticastAddr(multicastAddr);
                    AWSServerConf.setClusterMulticastPort(multicastPort);
                    try {
                        if (frequency != null) {
                            AWSServerConf.setClusterFrequency(Long.valueOf(frequency));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (dropTime == null) continue;
                        AWSServerConf.setClusterDropTime(Long.valueOf(dropTime));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (element.getName().equals("debug")) {
                    String sql = element.attributeValue("sql");
                    String cmd = element.attributeValue("cmd");
                    String info = element.attributeValue("info");
                    String templatePage = element.attributeValue("templatePage");
                    String cache = element.attributeValue("cache");
                    try {
                        if (sql != null) {
                            AWSServerConf.setDebugSql(Boolean.valueOf(sql));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (cmd != null) {
                            AWSServerConf.setDebugCmd(Boolean.valueOf(cmd));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (templatePage != null) {
                            AWSServerConf.setDebugTemplatePage(Boolean.valueOf(templatePage));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (cache == null) continue;
                        AWSServerConf.setDebugCache(Boolean.valueOf(cache));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (element.getName().equals("database")) {
                    String provider = element.attributeValue("provider");
                    String driver = element.attributeValue("driver");
                    String url = element.attributeValue("url");
                    String username = element.attributeValue("username");
                    String password = element.attributeValue("password");
                    String initialSize = element.attributeValue("initialSize");
                    String maxActive = element.attributeValue("maxActive");
                    String extendConfig = element.attributeValue("extendConfig");
                    password = Passwd.decrypt((String)password);
                    if (DB_PROVIDER_ST.equalsIgnoreCase(provider)) {
                        provider = DB_PROVIDER_OSCAR;
                    } else if (DB_PROVIDER_GBASE.equalsIgnoreCase(provider)) {
                        provider = DB_PROVIDER_INFORMIX;
                    }
                    AWSServerConf.setDatabaseProvider(provider);
                    AWSServerConf.setDatabaseDriver(driver);
                    AWSServerConf.setDatabaseUrl(url);
                    AWSServerConf.setDatabaseUsername(username);
                    AWSServerConf.setDatabasePassword(password);
                    AWSServerConf.setDatabaseExtendConfig(extendConfig);
                    try {
                        if (initialSize != null) {
                            AWSServerConf.setDatabaseInitialSize(Integer.valueOf(initialSize));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        if (maxActive == null) continue;
                        AWSServerConf.setDatabaseMaxActive(Integer.valueOf(maxActive));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (element.getName().equals("properties")) {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    Iterator iter2 = element.elementIterator();
                    while (iter2.hasNext()) {
                        Element property = (Element)iter2.next();
                        String name = property.attributeValue("name");
                        String value = property.getTextTrim();
                        properties.put(name.trim().toUpperCase(), value);
                    }
                    AWSServerConf.setProperties(properties);
                    continue;
                }
                if (!element.getName().equals("jobs")) continue;
                String threadCount = element.attributeValue("threadCount");
                try {
                    if (threadCount == null) continue;
                    AWSServerConf.setJobsThreadCount(Integer.parseInt(threadCount));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        catch (Exception e) {
            ShutdownAWSServer.errDown("Parser [conf/server.xml] error! [" + e.toString() + "]");
        }
    }

    public static String getInstanceName() {
        String v = AWSServerConf.getClusterParam(INSTANCE);
        if (!UtilString.isEmpty(v)) {
            return v;
        }
        if (instanceName == null || instanceName.trim().length() == 0) {
            instanceName = "s1";
            try {
                String ip = AWSServerConf.getClusterIp();
                if (!UtilString.isEmpty(ip)) {
                    instanceName = "s" + ip.substring(ip.lastIndexOf(46) + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        instanceName = instanceName.trim();
        return instanceName;
    }

    protected static void setInstanceName(String instanceName) {
        if (instanceName != null && instanceName.length() > 90) {
            throw new AWSIllegalArgumentException("instanceName", "FORMAT", "server.xml\u4e2dinstanceName\u4e0d\u80fd\u5927\u4e8e90\u4e2a\u5b57\u7b26");
        }
        AWSServerConf.instanceName = instanceName;
    }

    public static String getVersion() {
        if (version == null || version.trim().length() == 0) {
            version = "6.0";
        }
        version = version.trim();
        return version;
    }

    protected static void setVersion(String version) {
        AWSServerConf.version = version;
    }

    private static String getClusterIp() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            List<InterfaceAddress> list = ni.getInterfaceAddresses();
            for (InterfaceAddress ia : list) {
                InetAddress ad = ia.getAddress();
                if (!ad.getHostAddress().startsWith("192.168")) continue;
                return ad.getHostAddress();
            }
        }
        return null;
    }

    public static String getIp() {
        String v = AWSServerConf.getClusterParam(IP);
        if (!UtilString.isEmpty(v)) {
            return v.trim();
        }
        if (ip == null || ip.trim().length() == 0) {
            try {
                ip = AWSServerConf.getClusterIp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (UtilString.isEmpty(ip)) {
                ip = "localhost";
            }
        }
        ip = ip.trim();
        return ip;
    }

    protected static void setIp(String ip) {
        AWSServerConf.ip = ip;
    }

    public static boolean isPaaSCloud() {
        return paasCloud;
    }

    protected static void setPaaSCloud(boolean paasCloud) {
        AWSServerConf.paasCloud = paasCloud;
    }

    public static String getPaaSCloudAPIId() {
        return paasCloudAPIId;
    }

    protected static void setPaaSCloudAPIId(String paasCloudAPIId) {
        AWSServerConf.paasCloudAPIId = paasCloudAPIId;
    }

    public static int getMainServerPort() {
        String v = AWSServerConf.getClusterParam(PORT_AWS);
        if (!UtilString.isEmpty(v)) {
            return Integer.parseInt(v.trim());
        }
        if (mainServerPort == 0) {
            mainServerPort = 10008;
        }
        return mainServerPort;
    }

    public static String getUnicastPort() {
        String v = AWSServerConf.getClusterParam(UNICAST_PORT);
        if (!UtilString.isEmpty(v)) {
            return v.trim();
        }
        return unicastPort;
    }

    protected static void setMainServerPort(int mainServerPort) {
        AWSServerConf.mainServerPort = mainServerPort;
    }

    public static int getMainServerMaxClient() {
        if (mainServerMaxClient == 0) {
            mainServerMaxClient = 500;
        }
        return mainServerMaxClient;
    }

    protected static void setMainServerMaxClient(int mainServerMaxClient) {
        AWSServerConf.mainServerMaxClient = mainServerMaxClient;
    }

    public static long getMainServerConnectionTimeout() {
        if (mainServerConnectionTimeout == 0L) {
            mainServerConnectionTimeout = 1200000L;
        }
        return mainServerConnectionTimeout;
    }

    protected static void setMainServerConnectionTimeout(long mainServerConnectionTimeout) {
        AWSServerConf.mainServerConnectionTimeout = mainServerConnectionTimeout;
    }

    public static boolean isMainServerShell() {
        return mainServerShell;
    }

    protected static void setMainServerShell(boolean mainServerShell) {
        AWSServerConf.mainServerShell = mainServerShell;
    }

    public static long getMainServerSessionTimeout() {
        if (mainServerSessionTimeout == 0L) {
            mainServerSessionTimeout = 120L;
        }
        return mainServerSessionTimeout;
    }

    protected static void setMainServerSessionTimeout(long mainServerSessionTimeout) {
        AWSServerConf.mainServerSessionTimeout = mainServerSessionTimeout / 60L / 1000L;
    }

    public static long getMainServerSessionIdleTime() {
        if (mainServerSessionIdleTime == 0L) {
            mainServerSessionIdleTime = 1200000L;
        }
        return mainServerSessionIdleTime;
    }

    protected static void setMainServerSessionIdleTime(long mainServerSessionIdleTime) {
        AWSServerConf.mainServerSessionIdleTime = mainServerSessionIdleTime;
    }

    public static boolean isClusterService() {
        return clusterService;
    }

    protected static void setClusterService(boolean service) {
        clusterService = service;
    }

    public static String getClusterGroup() {
        return clusterGroup;
    }

    protected static void setClusterGroup(String clusterGroup) {
        AWSServerConf.clusterGroup = clusterGroup;
    }

    public static String getClusterMulticastAddr() {
        return clusterMulticastAddr;
    }

    protected static void setClusterMulticastAddr(String multicastAddr) {
        clusterMulticastAddr = multicastAddr;
    }

    public static boolean isMulticastEnabled() {
        return multicastEnabled;
    }

    public static String getUnicastHosts() {
        return unicastHosts;
    }

    public static String getClusterMulticastPort() {
        return clusterMulticastPort;
    }

    protected static void setClusterMulticastPort(String clusterMulticastPort) {
        AWSServerConf.clusterMulticastPort = clusterMulticastPort;
    }

    public static long getClusterFrequency() {
        return clusterFrequency;
    }

    protected static void setClusterFrequency(long clusterFrequency) {
        AWSServerConf.clusterFrequency = clusterFrequency;
    }

    public static long getClusterDropTime() {
        return clusterDropTime;
    }

    protected static void setClusterDropTime(long dropTime) {
        clusterDropTime = dropTime;
    }

    public static int getFileServerPort() {
        String v = AWSServerConf.getClusterParam(PORT_FILE);
        if (!UtilString.isEmpty(v)) {
            return Integer.parseInt(v.trim());
        }
        if (fileServerPort == 0) {
            fileServerPort = 10007;
        }
        return fileServerPort;
    }

    protected static void setFileServerPort(int fileServerPort) {
        AWSServerConf.fileServerPort = fileServerPort;
    }

    public static long getFileServerConnectionTimeout() {
        if (fileServerConnectionTimeout == 0L) {
            fileServerConnectionTimeout = 2400000L;
        }
        return fileServerConnectionTimeout;
    }

    protected static void setFileServerConnectionTimeout(long fileServerConnectionTimeout) {
        AWSServerConf.fileServerConnectionTimeout = fileServerConnectionTimeout;
    }

    public static boolean isDebugSql() {
        return debugSql;
    }

    protected static void setDebugSql(boolean debugSql) {
        AWSServerConf.debugSql = debugSql;
    }

    public static boolean isDebugCmd() {
        return debugCmd;
    }

    protected static void setDebugCmd(boolean debugCmd) {
        AWSServerConf.debugCmd = debugCmd;
    }

    public static boolean isDebugCache() {
        return debugCache;
    }

    protected static void setDebugCache(boolean debugCache) {
        AWSServerConf.debugCache = debugCache;
    }

    public static boolean isDebugTemplatePage() {
        return debugTemplatePage;
    }

    protected static void setDebugTemplatePage(boolean debugTemplatePage) {
        AWSServerConf.debugTemplatePage = debugTemplatePage;
    }

    public static String getDatabaseProvider() {
        if (databaseProvider == null || databaseProvider.equals("")) {
            databaseProvider = "mysql";
        }
        databaseProvider = databaseProvider.toLowerCase();
        return databaseProvider;
    }

    protected static void setDatabaseProvider(String databaseProvider) {
        AWSServerConf.databaseProvider = databaseProvider;
    }

    public static String getDatabaseDriver() {
        if (databaseDriver == null) {
            databaseDriver = "";
        }
        databaseDriver = databaseDriver.trim();
        return databaseDriver;
    }

    protected static void setDatabaseDriver(String databaseDriver) {
        AWSServerConf.databaseDriver = databaseDriver;
    }

    public static String getDatabaseUrl() {
        if (databaseUrl == null) {
            databaseUrl = "";
        }
        databaseUrl = databaseUrl.trim();
        return databaseUrl;
    }

    protected static void setDatabaseUrl(String databaseUrl) {
        AWSServerConf.databaseUrl = databaseUrl;
    }

    public static String getDatabaseUsername() {
        if (username == null) {
            username = "";
        }
        username = username.trim();
        return username;
    }

    protected static void setDatabaseUsername(String username) {
        AWSServerConf.username = username;
    }

    public static String getDatabasePassword() {
        if (password == null) {
            password = "";
        }
        password = password.trim();
        return password;
    }

    protected static void setDatabasePassword(String password) {
        AWSServerConf.password = password;
    }

    public static int getDatabaseInitialSize() {
        if (initialSize <= 0) {
            initialSize = 50;
        }
        return initialSize;
    }

    protected static void setDatabaseInitialSize(int initialSize) {
        AWSServerConf.initialSize = initialSize;
    }

    public static int getDatabaseMaxActive() {
        if (maxActive < 0) {
            maxActive = 300;
        }
        return maxActive;
    }

    protected static void setDatabaseMaxActive(int maxActive) {
        AWSServerConf.maxActive = maxActive;
    }

    public static String getDatabaseExtendConfig() {
        if (databaseExtendConfig == null || databaseExtendConfig.equals("")) {
            databaseExtendConfig = "conf/db_pool.properties";
        }
        databaseExtendConfig = databaseExtendConfig.trim();
        return databaseExtendConfig;
    }

    protected static void setDatabaseExtendConfig(String databaseExtendConfig) {
        AWSServerConf.databaseExtendConfig = databaseExtendConfig;
    }

    public static String getLongPollingCmd() {
        String cmds = AWSServerConf.getProperty("long.polling.cmd");
        if (cmds == null) {
            cmds = "";
        }
        cmds = cmds.trim();
        return cmds;
    }

    public static int getJobsThreadCount() {
        if (jobsThreadCount == 0) {
            jobsThreadCount = 5;
        }
        return jobsThreadCount;
    }

    protected static void setJobsThreadCount(int jobsThreadCount) {
        AWSServerConf.jobsThreadCount = jobsThreadCount;
    }

    public static Map<String, String> getProperties() {
        return properties;
    }

    public static String getProperty(String name) {
        String v;
        if (name == null) {
            return null;
        }
        if ("dc.path".equals(name) && !UtilString.isEmpty(v = AWSServerConf.getClusterParam(name))) {
            return v;
        }
        String str = properties.get((name = name.trim()).toUpperCase());
        if (str == null) {
            str = "";
        }
        return str;
    }

    protected static void setProperties(Map<String, String> properties) {
        AWSServerConf.properties = properties;
    }

    protected static void setProperty(String name, String value) {
        properties.put(name.trim().toUpperCase(), value);
    }

    public static int getDefaultPageLineSize() {
        return 18;
    }

    public static boolean isOracle() {
        return DB_PROVIDER_ORACLE.equalsIgnoreCase(databaseProvider) || AWSServerConf.isDM();
    }

    public static boolean isSQLServer() {
        return DB_PROVIDER_SQLSERVER.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isMySQL() {
        return DB_PROVIDER_MYSQL.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isDB2() {
        return DB_PROVIDER_DB2.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isSybase() {
        return DB_PROVIDER_SYBASE.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isDM() {
        return DB_PROVIDER_DM.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isOscar() {
        return DB_PROVIDER_OSCAR.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isInformix() {
        return "informix".equalsIgnoreCase(databaseProvider);
    }

    public static boolean isPostgreSQL() {
        return DB_PROVIDER_POSTGRESQL.equalsIgnoreCase(databaseProvider);
    }

    public static boolean isWindowsOS() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isLinuxOS() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static boolean isUnixOS() {
        return SystemUtils.IS_OS_UNIX;
    }

    protected static long getLastModified() {
        return lastModified;
    }

    protected static void setLastModified(long lastModified) {
        AWSServerConf.lastModified = lastModified;
    }

    public static void main(String[] args) throws SocketException {
        System.out.println(AWSServerConf.getInstanceName());
    }

    private static String getClusterParam(String key) {
        String s = System.getProperty(key);
        return s;
    }
}

