/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.conf.sla;

import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollector;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.conf.sla.ResourceMetric;
import com.actionsoft.bpms.server.conf.sla.ResourceMetricImpl;
import com.actionsoft.bpms.server.conf.sla.SLAAlarm;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class AWSSLAConf {
    private static long lastModified;
    private static boolean service;
    private static int pullCollectionInterval;
    private static Map<String, ResourceMetric> metrics;
    private static List<ResourceMetric> sortMetrics;
    private static List<SLAAlarm> alarms;
    private static File xmlFile;

    static {
        xmlFile = new File("conf/aws-sla.xml");
        AWSSLAConf.readXML();
    }

    public static Boolean isInit() {
        return false;
    }

    public static void addOrUpdateAlarmXML(boolean add, String name, String level, String when, String condition, String continuous, String value, String happen, String scope, String service) throws DocumentException, IOException {
        AWSSLAConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        Document doc = saxreader.read(xmlFile);
        Element root = doc.getRootElement();
        if (add) {
            Element el = root.element("alarms");
            Element ele = el.addElement("alarm");
            ele.addAttribute("name", name);
            ele.addAttribute("service", service);
            ele.addAttribute("level", level);
            ele.addAttribute("when", when);
            ele.addAttribute("condition", condition);
            ele.addAttribute("continuous", continuous);
            ele.addAttribute("value", value);
            ele.addAttribute("happen", happen);
            ele.addAttribute("scope", scope);
        } else {
            Element childElement = (Element)root.selectSingleNode("//alarm[@name='" + name + "']");
            childElement.addAttribute("service", service);
            childElement.addAttribute("level", level);
            childElement.addAttribute("when", when);
            childElement.addAttribute("condition", condition);
            childElement.addAttribute("value", value);
            childElement.addAttribute("continuous", continuous);
            childElement.addAttribute("happen", happen);
            childElement.addAttribute("scope", scope);
        }
        AWSSLAConf.writeXML(doc);
    }

    public static void setSLAService(boolean on) throws DocumentException, IOException {
        AWSSLAConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        Document doc = saxreader.read(xmlFile);
        Element root = doc.getRootElement();
        root.addAttribute("service", Boolean.toString(on));
        AWSSLAConf.writeXML(doc);
    }

    public static void setAlarmService(String name, boolean on) throws DocumentException, IOException {
        AWSSLAConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        Document doc = saxreader.read(xmlFile);
        Element root = doc.getRootElement();
        Element e = (Element)root.selectSingleNode("//alarm[@name='" + name + "']");
        e.addAttribute("service", Boolean.toString(on));
        AWSSLAConf.writeXML(doc);
    }

    public static void removeAlerm(String name) throws DocumentException, IOException {
        AWSSLAConf.setLastModified(xmlFile.lastModified());
        SAXReader saxreader = new SAXReader();
        Document doc = saxreader.read(xmlFile);
        Element root = doc.getRootElement();
        Element e = (Element)root.selectSingleNode("//alarm[@name='" + name + "']");
        e.detach();
        AWSSLAConf.writeXML(doc);
    }

    protected static void writeXML(Document doc) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8"), format);
        writer.write(doc);
        writer.close();
        AWSSLAConf.readXML();
    }

    protected static synchronized void readXML() {
        block17: {
            File xmlFile = new File("conf/aws-sla.xml");
            AWSSLAConf.setLastModified(xmlFile.lastModified());
            SAXReader saxreader = new SAXReader();
            try {
                List alarmNodes;
                List resourceNodes;
                Document doc = DocumentFactory.getInstance().createDocument();
                doc = saxreader.read(xmlFile);
                Element root = doc.getRootElement();
                String service = root.attributeValue("service");
                String pullCollectionInterval = root.attributeValue("pullCollectionInterval");
                if (!UtilString.isEmpty(service)) {
                    AWSSLAConf.setService(service.equalsIgnoreCase("true"));
                }
                if (!UtilString.isEmpty(pullCollectionInterval)) {
                    try {
                        AWSSLAConf.setPullCollectionInterval(Integer.valueOf(pullCollectionInterval));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!UtilString.isEmpty(resourceNodes = root.selectNodes("//resource"))) {
                    HashMap<String, ResourceMetric> metrics = new HashMap<String, ResourceMetric>();
                    ArrayList<ResourceMetric> metrics2 = new ArrayList<ResourceMetric>();
                    for (Object o : resourceNodes) {
                        Element element = (Element)o;
                        String resourceName = element.attributeValue("name");
                        Iterator iter2 = element.elementIterator();
                        while (iter2.hasNext()) {
                            ResourceMetricImpl metric = new ResourceMetricImpl();
                            Element subElement = (Element)iter2.next();
                            metric.setType(subElement.attributeValue("type"));
                            metric.setName(subElement.attributeValue("name"));
                            metric.setQualityTrend(subElement.attributeValue("qualityTrend"));
                            metric.setUnit(subElement.attributeValue("unit"));
                            metric.setCollectionPolicy(subElement.attributeValue("collectionPolicy"));
                            metric.setResourceName(resourceName);
                            String clazz = subElement.attributeValue("clazz");
                            if (!UtilString.isEmpty(clazz)) {
                                clazz = clazz.trim();
                                Constructor cons = null;
                                try {
                                    Class[] parameterTypes = new Class[]{};
                                    cons = ClassReflect.getConstructor(clazz, parameterTypes);
                                    Object obj = cons.newInstance(new Object[0]);
                                    metric.setCollector((SLACollector)obj);
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.err);
                                }
                            }
                            metrics.put(metric.getId(), metric);
                            metrics2.add(metric);
                        }
                    }
                    AWSSLAConf.setMetrics(metrics);
                    sortMetrics = metrics2;
                }
                if (UtilString.isEmpty(alarmNodes = root.selectNodes("//alarms/alarm"))) break block17;
                ArrayList<SLAAlarm> alarms = new ArrayList<SLAAlarm>();
                for (Object o : alarmNodes) {
                    String continuous;
                    Element subElement = (Element)o;
                    SLAAlarm alarm = new SLAAlarm();
                    String alarmServie = subElement.attributeValue("service");
                    if (!UtilString.isEmpty(alarmServie) && alarmServie.equalsIgnoreCase("true")) {
                        alarm.setService(true);
                    }
                    if (!UtilString.isEmpty(continuous = subElement.attributeValue("continuous"))) {
                        try {
                            alarm.setContinuous(Integer.valueOf(continuous));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    alarm.setLevel(subElement.attributeValue("level"));
                    alarm.setWhen(subElement.attributeValue("when"));
                    alarm.setName(subElement.attributeValue("name"));
                    alarm.setValue(subElement.attributeValue("value"));
                    alarm.setCondition(subElement.attributeValue("condition"));
                    alarm.setHappen(subElement.attributeValue("happen"));
                    alarm.setScope(subElement.attributeValue("scope"));
                    alarms.add(alarm);
                }
                AWSSLAConf.setAlarms(alarms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int getPullCollectionInterval() {
        if (pullCollectionInterval == 0) {
            pullCollectionInterval = 60;
        }
        return pullCollectionInterval;
    }

    public static void setPullCollectionInterval(int pullCollectionInterval) {
        AWSSLAConf.pullCollectionInterval = pullCollectionInterval;
    }

    public static boolean isService() {
        return service && Quota.isSLAService();
    }

    public static void setService(boolean service) {
        AWSSLAConf.service = service;
    }

    public static Map<String, ResourceMetric> getMetrics() {
        if (metrics == null) {
            metrics = new HashMap<String, ResourceMetric>();
        }
        return metrics;
    }

    public static void setMetrics(Map<String, ResourceMetric> metrics) {
        AWSSLAConf.metrics = metrics;
    }

    public static List<ResourceMetric> getMetricsOfSort() {
        if (sortMetrics == null) {
            sortMetrics = new ArrayList<ResourceMetric>();
        }
        return sortMetrics;
    }

    public static List<SLAAlarm> getAlarms() {
        if (alarms == null) {
            alarms = new ArrayList<SLAAlarm>();
        }
        return alarms;
    }

    public static void setAlarms(List<SLAAlarm> alarms) {
        AWSSLAConf.alarms = alarms;
    }

    protected static long getLastModified() {
        return lastModified;
    }

    protected static void setLastModified(long lastModified) {
        AWSSLAConf.lastModified = lastModified;
    }
}

