/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs;

import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.commons.formfile.FormFileUtil;
import com.actionsoft.bpms.commons.formfile.dao.FormFileDao;
import com.actionsoft.bpms.commons.formfile.model.delegate.FormFile;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.fs.dc.DCMessage;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.server.fs.dc.cloud.CloudDCProfileManager;
import com.actionsoft.bpms.server.fs.file.dao.FileDao;
import com.actionsoft.bpms.server.fs.file.model.FileModel;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.bpms.util.UtilURL;
import com.actionsoft.exception.AWSException;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.io.FileUtil;
import jodd.util.StringUtil;

public final class DCContext {
    private UserContext session;
    private String appId;
    private String repositoryName;
    private String groupValue;
    private String fileValue;
    private String fileName;
    private String extParam = "";
    private Map<String, Object> extParams = new HashMap<String, Object>();
    private String fileNameShow;
    private String securityFileName;
    private DCPluginProfile dcProfile;
    private DCMessage message;
    private String contentTokenId;
    private boolean isCloud = false;
    private boolean isPush = false;
    private String cloudId = "";
    private String cloudAppId = "";
    private String cloudInfo = "";
    private String sysFilesId = "";
    private static String STATIC_SID = "ck";

    public DCContext(UserContext session, DCPluginProfile dcProfile, String appId, String groupValue, String fileValue, String fileName) {
        this.setSession(session);
        this.setAppId(appId);
        this.setDCProfile(dcProfile);
        this.setGroupValue(groupValue);
        this.setFileValue(fileValue);
        this.setFileName(fileName);
        if (!DCUtil.isIgnoreRepositoryName(this)) {
            this.initCloudParam();
        }
    }

    public DCContext(UserContext session, DCPluginProfile dcProfile, String appId, String groupValue, String fileValue, String fileName, String extParam) {
        this.setSession(session);
        this.setAppId(appId);
        this.setDCProfile(dcProfile);
        this.setGroupValue(groupValue);
        this.setFileValue(fileValue);
        this.setFileName(fileName);
        this.setExtParam(extParam);
        if (UtilJson.mayBeJSON(extParam)) {
            this.setExtParams((Map<String, Object>)JSONObject.parseObject((String)extParam));
        }
        if (!DCUtil.isIgnoreRepositoryName(this)) {
            this.initCloudParam();
        }
    }

    public DCContext(UserContext session, DCPluginProfile dcProfile, String appId, String groupValue, String fileValue) {
        this.setSession(session);
        this.setAppId(appId);
        this.setDCProfile(dcProfile);
        this.setGroupValue(groupValue);
        this.setFileValue(fileValue);
    }

    public DCContext(UserContext session, DCPluginProfile dcProfile, String groupValue, String fileValue) {
        this(session, dcProfile, dcProfile.getAppContext().getId(), groupValue, fileValue);
    }

    public static DCContext fromJson(String str) {
        if (UtilString.isEmpty(str)) {
            return null;
        }
        JSONObject json = JSONObject.parseObject((String)str);
        String appId = json.getString("appId");
        String repositoryName = json.getString("repositoryName");
        String groupValue = json.getString("groupValue");
        String fileValue = json.getString("fileValue");
        String fileName = json.getString("fileName");
        DCContext dcContext = new DCContext(null, DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
        return dcContext;
    }

    public boolean isCloud() {
        return this.isCloud;
    }

    public void setCloud(boolean cloud) {
        this.isCloud = cloud;
    }

    public boolean isPush() {
        return this.isPush;
    }

    public void setPush(boolean push) {
        this.isPush = push;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getCloudAppId() {
        return this.cloudAppId;
    }

    public void setCloudAppId(String cloudAppId) {
        this.cloudAppId = cloudAppId;
    }

    public String getCloudInfo() {
        return this.cloudInfo;
    }

    public void setCloudInfo(String cloudInfo) {
        this.cloudInfo = cloudInfo;
    }

    public String getSysFilesId() {
        return this.sysFilesId;
    }

    public void setSysFilesId(String sysFilesId) {
        this.sysFilesId = sysFilesId;
    }

    private void initCloudParam() {
        FileDao fileDao;
        List<FileModel> fileList;
        int size = CloudDCProfileManager.getProfileList().size();
        if (size > 0 && (fileList = (fileDao = new FileDao()).getFileList("GROUPVALUE = ? AND FILEVALUE = ? AND REPOSITORYNAME = ? AND FILENAME = ?", this.groupValue, this.fileValue, this.repositoryName, this.fileName)) != null && fileList.size() > 0) {
            FileModel fileModel = fileList.get(0);
            this.isCloud = fileModel.isCloud();
            this.isPush = fileModel.isPush();
            this.cloudId = fileModel.getCloudId();
            this.cloudAppId = fileModel.getCloudAppId();
            this.cloudInfo = fileModel.getCloudInfo();
            this.sysFilesId = fileModel.getId();
        }
    }

    public DCMessage getDCMessage() {
        return this.message;
    }

    public void setDCMessage(DCMessage message) {
        this.message = message;
    }

    public void setDCMessage(String type, String msg) {
        if (msg == null || msg == null) {
            this.message = null;
        } else {
            DCMessage message = new DCMessage();
            message.setType(type);
            message.setMessage(msg);
            this.message = message;
        }
    }

    public String getContentTokenId() {
        return this.contentTokenId;
    }

    public void setContentTokenId(String contentTokenId) {
        this.contentTokenId = contentTokenId;
    }

    public String getDownloadURL() {
        if (this.isCloud && !this.repositoryName.equals("!form-ui-file-")) {
            CloudDCPluginProfile profile;
            String downLoadUrl = "";
            if (UtilString.isNotEmpty(this.cloudId) && UtilString.isNotEmpty(this.cloudAppId) && (profile = CloudDCProfileManager.getDCProfile(this.cloudAppId, this.cloudId)) != null) {
                AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(profile.getClazzName(), this.cloudAppId, this.cloudId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("cloudInfo", this.cloudInfo);
                params.put("uid", this.session == null ? "" : this.session.getUID());
                params.put("DCContext", this);
                downLoadUrl = cloudFile.getDownloadURL(params);
            }
            return downLoadUrl;
        }
        StringBuilder sb = new StringBuilder();
        if (UtilString.isEmpty(this.contentTokenId)) {
            sb.append("./df?groupValue=");
            sb.append(UtilURL.URLEncode(this.groupValue));
            sb.append("&fileValue=");
            sb.append(UtilURL.URLEncode(this.fileValue));
            sb.append("&sid=");
            if (this.session != null) {
                boolean hideSession = this.isHideSid();
                if (hideSession) {
                    sb.append(STATIC_SID);
                } else {
                    sb.append(UtilURL.URLEncode(this.session.getSessionId()));
                }
            }
            sb.append("&repositoryName=");
            sb.append(UtilURL.URLEncode(this.repositoryName));
            sb.append("&appId=");
            sb.append(UtilURL.URLEncode(this.appId));
            sb.append("&attachment=true");
            if (this.getFileNameShow() != null && !"".equals(this.getFileNameShow())) {
                sb.append("&fileNameShow=" + UtilURL.URLEncode(this.getFileNameShow()));
            }
            sb.append("&fileName=");
            sb.append(UtilURL.URLEncode(this.fileName));
            sb.append("&lastModified=");
            sb.append(this.getFileLastModified());
        } else {
            sb.append("./df?contentTokenId=");
            sb.append(UtilURL.URLEncode(this.contentTokenId));
            sb.append("&repositoryName=");
            sb.append(UtilURL.URLEncode(this.repositoryName));
            sb.append("&appId=");
            sb.append(UtilURL.URLEncode(this.appId));
            sb.append("&attachment=true");
            if (this.getFileNameShow() != null && !"".equals(this.getFileNameShow())) {
                sb.append("&fileNameShow=" + UtilURL.URLEncode(this.getFileNameShow()));
            }
            sb.append("&fileName=");
            sb.append(UtilURL.URLEncode(this.fileName));
            sb.append("&lastModified=");
            sb.append(this.getFileLastModified());
        }
        return sb.toString();
    }

    private boolean isHideSid() {
        return SDK.getAppAPI().getPropertyBooleanValue("_bpm.platform", "isHideSession", false);
    }

    public String getStremURL() {
        if (this.isCloud) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("./df?groupValue=");
        sb.append(UtilURL.URLEncode(this.groupValue));
        sb.append("&fileValue=");
        sb.append(UtilURL.URLEncode(this.fileValue));
        sb.append("&sid=");
        if (this.session != null) {
            boolean hideSession = this.isHideSid();
            if (hideSession) {
                sb.append(STATIC_SID);
            } else {
                sb.append(UtilURL.URLEncode(this.session.getSessionId()));
            }
        }
        sb.append("&repositoryName=");
        sb.append(UtilURL.URLEncode(this.repositoryName));
        sb.append("&appId=");
        sb.append(UtilURL.URLEncode(this.appId));
        sb.append("&attachment=true");
        if (this.getFileNameShow() != null && !"".equals(this.getFileNameShow())) {
            sb.append("&fileNameShow=" + UtilURL.URLEncode(this.getFileNameShow()));
        }
        sb.append("&fileName=");
        sb.append(UtilURL.URLEncode(this.fileName));
        return sb.toString();
    }

    public boolean existFile() {
        if (this.isCloud) {
            CloudDCPluginProfile profile;
            String downLoadUrl = "";
            if (UtilString.isNotEmpty(this.cloudId) && UtilString.isNotEmpty(this.cloudAppId) && (profile = CloudDCProfileManager.getDCProfile(this.cloudAppId, this.cloudId)) != null) {
                AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(profile.getClazzName(), this.cloudAppId, this.cloudId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("cloudInfo", this.cloudInfo);
                params.put("uid", this.session == null ? "" : this.session.getUID());
                params.put("DCContext", this);
                downLoadUrl = cloudFile.getDownloadURL(params);
                if (StringUtil.isNotEmpty((CharSequence)downLoadUrl)) {
                    return true;
                }
            }
            return false;
        }
        if (UtilString.isEmpty(this.getFileName())) {
            return false;
        }
        String realPath = String.valueOf(this.getPath()) + this.getFileName();
        boolean isHighSecurityStorage = false;
        if (this.getRepositoryName().equals("!form-ui-file-")) {
            FormFileDao ffd = new FormFileDao();
            FormFile ff = (FormFile)ffd.queryById(this.getGroupValue());
            if (ff != null) {
                isHighSecurityStorage = FormFileUtil.getInstance().isEncrypt(ff.getBoItemName(), ff.getBoName());
            }
        } else {
            isHighSecurityStorage = this.getRepositoryName().equals("!form-comment-file-") ? true : DCUtil.isHighSecurityStorage(this.getRepositoryName());
        }
        boolean isEncrypt = false;
        if (this.extParams.containsKey("boItemName") && this.extParams.containsKey("boDefId")) {
            String boItemName = (String)this.extParams.get("boItemName");
            String boDefId = (String)this.extParams.get("boDefId");
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
        }
        if (isHighSecurityStorage || isEncrypt) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(this.getFileName());
            realPath = String.valueOf(this.getPath()) + newFileName;
            File file = new File(realPath);
            if (!file.exists()) {
                newFileName = this.getFileNameOfHistory(this.getFileName());
                realPath = String.valueOf(this.getPath()) + newFileName;
                File file_old = new File(realPath);
                return file_old.exists();
            }
        }
        File file = new File(realPath);
        return file.exists();
    }

    public String getFileNameOfHistory(String fileName) {
        String historyFileName = "";
        String tmpFileName = fileName;
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        try {
            historyFileName = String.valueOf(new String(Base64.encode(AES.encrypt((byte[])tmpFileName.toString().getBytes(), (String)"awsfile")))) + fileSuffix;
            if (historyFileName.indexOf("/") != -1) {
                historyFileName = new UtilString(historyFileName).replace("/", "!");
            }
        }
        catch (Exception e) {
            historyFileName = tmpFileName;
        }
        return historyFileName;
    }

    public long getFileLastModified() {
        File file;
        if (UtilString.isEmpty(this.getFileName())) {
            return -1L;
        }
        String realPath = String.valueOf(this.getPath()) + this.getFileName();
        boolean isHighSecurityStorage = DCUtil.isHighSecurityStorage(this.getRepositoryName());
        if (isHighSecurityStorage) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(this.getFileName());
            realPath = String.valueOf(this.getPath()) + newFileName;
            File file2 = new File(realPath);
            if (!file2.exists()) {
                newFileName = this.getFileNameOfHistory(this.getFileName());
                realPath = String.valueOf(this.getPath()) + newFileName;
                File file_old = new File(realPath);
                if (file_old.exists()) {
                    return file_old.lastModified();
                }
            }
        }
        if (!(file = new File(realPath)).exists() && !isHighSecurityStorage) {
            String newFileName = DCUtil.encryptFileName(this.getFileName());
            realPath = String.valueOf(this.getPath()) + newFileName;
            file = new File(realPath);
            if (file.exists()) {
                return file.lastModified();
            }
        }
        return file.lastModified();
    }

    public boolean delete() {
        boolean isHighSecurityStorage;
        if (this.isCloud) {
            CloudDCPluginProfile profile;
            if (this.isPush && UtilString.isNotEmpty(this.cloudId) && UtilString.isNotEmpty(this.cloudAppId) && (profile = CloudDCProfileManager.getDCProfile(this.cloudAppId, this.cloudId)) != null) {
                AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(profile.getClazzName(), this.cloudAppId, this.cloudId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("cloudInfo", this.cloudInfo);
                if (this.session != null) {
                    params.put("uid", this.session.getUID());
                }
                cloudFile.deleteCloudFile(params);
            }
            FileDao fileDao = new FileDao();
            return fileDao.delete(this.sysFilesId);
        }
        String realPath = String.valueOf(this.getPath()) + this.getFileName();
        boolean isEncrypt = false;
        if (this.extParams.containsKey("boItemName") && this.extParams.containsKey("boDefId")) {
            String boItemName = (String)this.extParams.get("boItemName");
            String boDefId = (String)this.extParams.get("boDefId");
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boModel.getName());
        }
        if ((isHighSecurityStorage = DCUtil.isHighSecurityStorage(this.getRepositoryName())) || isEncrypt) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(this.getFileName());
            realPath = String.valueOf(this.getPath()) + newFileName;
        }
        try {
            File dest = new File(realPath);
            if (!dest.exists()) {
                String filename = this.getFileNameOfHistory(this.getFileName());
                realPath = String.valueOf(this.getPath()) + filename;
                dest = new File(realPath);
            }
            boolean d = dest.delete();
            File parent = dest.getParentFile();
            while (parent.delete()) {
                parent = parent.getParentFile();
            }
            return d;
        }
        catch (Exception e) {
            throw new AWSException("DC[" + this.getPath() + "]\u6587\u4ef6\u5220\u9664\u9519\u8bef", e);
        }
    }

    public void deleteByGroup() {
        String file = this.getGroupPath();
        try {
            FileUtil.delete((String)file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteByGroupName(FilenameFilter ff) {
        String file = this.getGroupPath();
        File[] fs = new File(file).listFiles(ff);
        if (fs != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    FileUtil.delete((File)f);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    public String getFilePath() {
        return String.valueOf(this.getPath()) + this.getFileName();
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupPath());
        if (DCUtil.isBigStorage(this.repositoryName)) {
            String fDeep;
            block5: {
                fDeep = "0";
                try {
                    fDeep = Integer.toString(this.getDeepNum(Integer.parseInt(this.getFileValue())));
                }
                catch (Exception ex) {
                    if (this.getFileValue().length() < 3) break block5;
                    fDeep = this.getFileValue().substring(this.getFileValue().length() - 3);
                }
            }
            if (UtilString.isNotEmpty(this.getFileValue())) {
                sb.append(fDeep).append("/");
                sb.append("").append(this.fileValue).append("/");
            }
        } else {
            sb.append("").append(this.fileValue).append("/");
        }
        return sb.toString();
    }

    private String getGroupPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(AWSServerConf.getProperty("dc.path")).append(this.appId).append("/").append(this.repositoryName).append("/");
        if (DCUtil.isBigStorage(this.repositoryName)) {
            String gDeep;
            block4: {
                gDeep = "0";
                try {
                    gDeep = Integer.toString(this.getDeepNum(Integer.parseInt(this.getGroupValue())));
                }
                catch (Exception ex) {
                    if (this.getGroupValue().length() < 3) break block4;
                    gDeep = this.getGroupValue().substring(this.getGroupValue().length() - 3);
                }
            }
            sb.append(gDeep).append("/");
            sb.append("").append(this.groupValue).append("/");
        } else {
            sb.append("").append(this.groupValue).append("/");
        }
        return sb.toString();
    }

    private int getDeepNum(int num) {
        int d = num / 10000 + 1;
        return d;
    }

    public String getSecurityFileName() {
        return this.securityFileName;
    }

    public void setSecurityFileName(String securityFileName) {
        this.securityFileName = securityFileName;
    }

    public DCPluginProfile getDCProfile() {
        return this.dcProfile;
    }

    public final void setDCProfile(DCPluginProfile dcProfile) {
        this.dcProfile = dcProfile;
        if (dcProfile == null) {
            this.setRepositoryName(null);
        } else {
            this.setRepositoryName(dcProfile.getRepositoryName());
        }
    }

    public UserContext getSession() {
        return this.session;
    }

    public final void setSession(UserContext session) {
        this.session = session;
    }

    public String getAppId() {
        return this.appId;
    }

    protected final void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private final void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getGroupValue() {
        if (this.groupValue == null) {
            this.groupValue = "null";
        }
        return this.groupValue;
    }

    protected final void setGroupValue(String groupValue) {
        this.groupValue = groupValue;
    }

    public String getFileValue() {
        if (this.fileValue == null) {
            this.fileValue = "null";
        }
        return this.fileValue;
    }

    protected final void setFileValue(String fileValue) {
        this.fileValue = fileValue;
    }

    public String getFileName() {
        if (!UtilString.isEmpty(this.fileName) && this.fileName.length() > 255) {
            throw new AWSException("\u6587\u4ef6\u540d\u603b\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7255\u4e2a\u5b57\u7b26");
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (!UtilString.isEmpty(fileName) && fileName.length() > 255) {
            throw new AWSException("\u6587\u4ef6\u540d\u603b\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7255\u4e2a\u5b57\u7b26");
        }
        this.fileName = fileName;
    }

    public String getFileNameShow() {
        return this.fileNameShow;
    }

    public void setFileNameShow(String fileNameShow) {
        this.fileNameShow = fileNameShow;
    }

    public String getExtParam() {
        return this.extParam;
    }

    public Map<String, Object> getExtParams() {
        return this.extParams;
    }

    public void setExtParam(String extParam) {
        this.extParam = extParam;
    }

    public void setExtParams(Map<String, Object> extParams) {
        this.extParams = extParams;
    }

    public String toJson() {
        JSONObject json = new JSONObject();
        json.put("appId", (Object)this.appId);
        json.put("repositoryName", (Object)this.dcProfile.getRepositoryName());
        json.put("groupValue", (Object)this.groupValue);
        json.put("fileValue", (Object)this.fileValue);
        json.put("fileName", (Object)this.fileName);
        return json.toString();
    }
}

