/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs;

import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.Debug;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.push.CmdFilePush;
import com.actionsoft.bpms.commons.security.logging.AuditLogger;
import com.actionsoft.bpms.server.HandlerExceptionResolver;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.file.ReadDCFile;
import com.actionsoft.bpms.server.fs.file.WriteDCFile;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import java.io.DataInputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DispatcherFileStream {
    public static final String CHARSET = "UTF-8";
    private Socket _clientSocket;
    private String _myCmdLine = null;
    private String _socketCmd = new String();

    public DispatcherFileStream(Socket receivedSocket) {
        this._clientSocket = receivedSocket;
    }

    public void executeCommand() {
        block83: {
            UserContext me = null;
            DataInputStream in = null;
            OutputStreamWriter myOut = null;
            List<String> myCmdArray = null;
            int success = 0;
            String clientIP = this._clientSocket.getLocalAddress().getHostAddress();
            String sid = "";
            String responseType = "JD";
            try {
                try {
                    in = new DataInputStream(this._clientSocket.getInputStream());
                    myOut = new OutputStreamWriter(this._clientSocket.getOutputStream(), CHARSET);
                    this._myCmdLine = in.readUTF();
                    UtilString myStr = new UtilString(this._myCmdLine);
                    myCmdArray = myStr.split(" ");
                    this._socketCmd = myCmdArray.get(1).toString();
                    String s1 = myCmdArray.get(0).toString();
                    clientIP = s1.substring(s1.lastIndexOf("}") + 1);
                    String contentTokenId = "";
                    if (!myCmdArray.get(0).toString().equals(String.valueOf(AWSPortalConf.getSecurityCode()) + clientIP)) {
                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u7f51\u7edc\u5b89\u5168\u914d\u7f6e\u68c0\u67e5\u672a\u901a\u8fc7"), "401", new String[0]));
                    } else {
                        contentTokenId = myStr.matchValue("_contentTokenId[", "]contentTokenId_");
                        if (!UtilString.isEmpty(contentTokenId) && contentTokenId.equals("null")) {
                            contentTokenId = "";
                        }
                        if (!UtilString.isEmpty(contentTokenId)) {
                            success = 1;
                        } else {
                            sid = myCmdArray.get(2).toString();
                            if (sid.equals("")) {
                                myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u6ca1\u6709\u7528\u6237\u4f1a\u8bdd"), "400", new String[0]));
                            } else {
                                try {
                                    me = UserContext.fromSessionId((String)sid, (String)clientIP);
                                    int r = me.validateSession();
                                    if (r == 10) {
                                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u7528\u6237\u4e0d\u5b58\u5728"), "401", new String[0]));
                                        success = -1;
                                    } else if (r == 9) {
                                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u7528\u6237\u4f1a\u8bdd\u4e0d\u5b58\u5728\u6216\u5df2\u8d85\u65f6\u65e0\u6548\u8bf7\u91cd\u65b0\u767b\u5f55"), "401", new String[0]));
                                        success = -1;
                                    } else if (r == 8) {
                                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u5728\u6821\u9a8c\u7528\u6237\u4f1a\u8bdd\u65f6\u53d1\u751f\u5185\u90e8\u9519\u8bef"), "401", new String[0]));
                                        success = -1;
                                    } else if (r == 7) {
                                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u7528\u6237\u4f1a\u8bdd\u5df2\u8d85\u65f6\u8bf7\u91cd\u65b0\u767b\u5f55"), "401", new String[0]));
                                        success = -1;
                                    } else {
                                        success = 1;
                                    }
                                }
                                catch (Exception e) {
                                    myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveThrowable((Throwable)e));
                                }
                            }
                        }
                    }
                    if (success != true) break block83;
                    if (this._socketCmd.equals("CLIENT_FILE_UP")) {
                        Debug.cmd2access((String)"[UPFILE ACCESS]");
                        String groupValue = myStr.matchValue("_groupValue[", "]groupValue_");
                        String fileValue = myStr.matchValue("_fileValue[", "]fileValue_");
                        String fileName = myStr.matchValue("_fileName[", "]fileName_");
                        String repositoryName = myStr.matchValue("_repositoryName[", "]repositoryName_");
                        String appId = myStr.matchValue("_appId[", "]appId_");
                        String extParam = myStr.matchValue("_extParam[", "]extParam_");
                        HashMap<String, String> errorMap = new HashMap<String, String>();
                        boolean validate = true;
                        if (groupValue == null || groupValue.trim().length() == 0) {
                            validate = false;
                            errorMap.put("error", "groupValue " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a"));
                        } else if (fileValue == null || fileValue.trim().length() == 0) {
                            validate = false;
                            errorMap.put("error", "fileValue " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a"));
                        } else if (fileName == null || fileName.trim().length() == 0) {
                            validate = false;
                            errorMap.put("error", "fileName " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a"));
                        } else if (appId == null || appId.trim().length() == 0) {
                            validate = false;
                            errorMap.put("error", "appId " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a"));
                        } else if (repositoryName == null || repositoryName.trim().length() == 0) {
                            validate = false;
                            errorMap.put("error", "repositoryName " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a"));
                        }
                        if (validate) {
                            try {
                                if (sid.indexOf("_") > 0) {
                                    Thread.currentThread().setName("UPFILE--" + me.getUID() + "--" + fileName + "--" + clientIP + "--" + me.getLanguage());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                            if (DCUtil.isDangerFileName(fileName) || DCUtil.isDangerFileName(groupValue) || DCUtil.isDangerFileName(fileValue) || DCUtil.isDangerFileName(fileName, true)) {
                                myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("warning", null, I18nRes.findValue("_bpm.platform", "\u5df2\u88ab\u8bb0\u5f55\u4e3a\u6f5c\u5728\u653b\u51fb\u6027\u7684\u5b89\u5168\u4e8b\u4ef6\u8bf7\u786e\u8ba4\u9644\u4ef6\u540d\u7684\u5408\u6cd5\u6027"), "403", new String[0]));
                                AuditLogger.logFile(null, fileName, "warning", false, false);
                            } else {
                                DCPluginProfile dcProfile = DCProfileManager.getDCProfile(appId, repositoryName);
                                DCContext dcContext = new DCContext(me, dcProfile, appId, groupValue, fileValue, fileName, extParam);
                                if (dcProfile != null) {
                                    SLATimeCollectionContext slaCtx = CmdFilePush.getInstance().begin();
                                    boolean isStore = WriteDCFile.getInstance().write(in, dcContext);
                                    if (isStore) {
                                        CmdFilePush.getInstance().end(slaCtx, true, dcContext);
                                    } else if (dcContext.getDCMessage() == null) {
                                        dcContext.setDCMessage("error", I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u4e0a\u4f20\u5931\u8d25\u53ef\u80fd\u65e0\u6cd5\u8fde\u63a5\u4e0a\u4e91\u7aef\u8bf7\u68c0\u67e5\u914d\u7f6e"));
                                    }
                                    AuditLogger.logFile(dcContext, fileName, dcContext.getPath(), isStore, true);
                                } else {
                                    System.err.println(String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u672a\u5b9a\u4e49\u7c7b\u578b\u7684\u6587\u4ef6\u4e0a\u4f20\u5904\u7406\u8bf7\u6c42\u4e0a\u4f20\u88ab\u62d2\u7edd")) + ".repositoryName=[" + repositoryName + "]");
                                    dcContext.setDCMessage("warning", String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u672a\u5b9a\u4e49\u7c7b\u578b\u7684\u6587\u4ef6\u4e0a\u4f20\u5904\u7406\u8bf7\u6c42\u4e0a\u4f20\u88ab\u62d2\u7edd")) + ".repositoryName=[" + repositoryName + "]");
                                    AuditLogger.logFile(dcContext, fileName, dcContext.getPath(), false, true);
                                }
                                myOut.write(dcContext.getDCMessage().toJson());
                            }
                            break block83;
                        }
                        String error = !UtilString.isEmpty(((String)errorMap.get("error")).toString()) ? ((String)errorMap.get("error")).toString() : "";
                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u4e0d\u6b63\u5e38\u7684\u8bbf\u95ee\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574")) + ": " + error, "400", new String[0]));
                        AuditLogger.logFile(null, fileName, "warning", false, true);
                        break block83;
                    }
                    if (!this._socketCmd.equals("CLIENT_FILE_DOWN")) break block83;
                    Debug.cmd2access((String)"[DOWNFILE ACCESS]");
                    String groupValue = myStr.matchValue("_groupValue[", "]groupValue_");
                    String fileValue = myStr.matchValue("_fileValue[", "]fileValue_");
                    String fileName = myStr.matchValue("_fileName[", "]fileName_");
                    String repositoryName = myStr.matchValue("_repositoryName[", "]repositoryName_");
                    String appId = myStr.matchValue("_appId[", "]appId_");
                    String range = myStr.matchValue("_range[", "]range_");
                    HashMap<String, String> errorMap = new HashMap<String, String>();
                    boolean validate = true;
                    if (groupValue == null || groupValue.trim().length() == 0) {
                        validate = false;
                        errorMap.put("error", I18nRes.findValue("_bpm.portal", me.getLanguage(), "groupValue " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a")));
                    } else if (fileValue == null || fileValue.trim().length() == 0) {
                        validate = false;
                        errorMap.put("error", I18nRes.findValue("_bpm.portal", me.getLanguage(), "fileValue " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a")));
                    } else if (fileName == null || fileName.trim().length() == 0) {
                        validate = false;
                        errorMap.put("error", I18nRes.findValue("_bpm.portal", me.getLanguage(), "fileName" + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a")));
                    } else if (appId == null || appId.trim().length() == 0) {
                        validate = false;
                        errorMap.put("error", I18nRes.findValue("_bpm.portal", me.getLanguage(), "appId " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a")));
                    } else if (repositoryName == null || repositoryName.trim().length() == 0) {
                        validate = false;
                        errorMap.put("error", I18nRes.findValue("_bpm.portal", me.getLanguage(), "repositoryName " + I18nRes.findValue("_bpm.platform", "\u4e3a\u7a7a")));
                    }
                    Range r = new Range(0L, -1L);
                    if (!UtilString.isEmpty(range)) {
                        r = this.parseRange(range);
                    }
                    if (validate) {
                        try {
                            Thread.currentThread().setName("DOWNFILE--" + me.getUID() + "--" + fileName + "--" + clientIP);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                        if (fileName.indexOf("AWS-ONLINE-OFFICE-PREFIX") > -1) {
                            fileName = fileName.substring("AWS-ONLINE-OFFICE-PREFIX".length());
                        }
                        if (DCUtil.isDangerFileName(fileName) || DCUtil.isDangerFileName(groupValue) || DCUtil.isDangerFileName(fileValue) || DCUtil.isDangerFileName(fileName, true)) {
                            myOut.write("{type:'warning',message:'" + I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u5df2\u88ab\u8bb0\u5f55\u4e3a\u6f5c\u5728\u653b\u51fb\u6027\u7684\u5b89\u5168\u4e8b\u4ef6\u8bf7\u786e\u8ba4\u9644\u4ef6\u540d\u7684\u5408\u6cd5\u6027") + "'}");
                            AuditLogger.logFile(null, fileName, "warning", false, false);
                        } else {
                            DCPluginProfile dcProfile = DCProfileManager.getDCProfile(appId, repositoryName);
                            DCContext dcContext = new DCContext(me, dcProfile, appId, groupValue, fileValue, fileName);
                            if (dcProfile != null) {
                                dcContext.setContentTokenId(contentTokenId);
                                SLATimeCollectionContext slaCtx = CmdFilePush.getInstance().begin();
                                boolean isRead = ReadDCFile.getInstance().read(this._clientSocket, dcContext, r.start, r.length);
                                if (isRead) {
                                    CmdFilePush.getInstance().end(slaCtx, false, dcContext);
                                }
                                AuditLogger.logFile(dcContext, fileName, dcContext.getPath(), isRead, false);
                                if (!isRead) {
                                    myOut.write(dcContext.getDCMessage().toJson());
                                }
                            } else {
                                System.err.println(String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u672a\u5b9a\u4e49\u7c7b\u578b\u7684\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u8bf7\u6c42\u4e0b\u8f7d\u88ab\u62d2\u7edd")) + ".repositoryName=[" + repositoryName + "]");
                                dcContext.setDCMessage("warning", String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u672a\u5b9a\u4e49\u7c7b\u578b\u7684\u6587\u4ef6\u4e0b\u8f7d\u5904\u7406\u8bf7\u6c42\u4e0b\u8f7d\u88ab\u62d2\u7edd")) + ".repositoryName=[" + repositoryName + "]");
                                AuditLogger.logFile(dcContext, fileName, dcContext.getPath(), false, false);
                                myOut.write(dcContext.getDCMessage().toJson());
                            }
                        }
                        break block83;
                    }
                    String error = !UtilString.isEmpty(((String)errorMap.get("error")).toString()) ? ((String)errorMap.get("error")).toString() : "";
                    myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveMessage("error", null, String.valueOf(I18nRes.findValue("_bpm.platform", me.getLanguage(), "\u4e0d\u6b63\u5e38\u7684\u8bbf\u95ee\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574")) + ": " + error, "400", new String[0]));
                    AuditLogger.logFile(null, fileName, "warning", false, false);
                }
                catch (Throwable e) {
                    try {
                        myOut.write(HandlerExceptionResolver.getInstance((String)responseType).resolveThrowable(e));
                    }
                    catch (Exception eee) {
                        eee.printStackTrace(System.err);
                    }
                    try {
                        myOut.flush();
                        myOut.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace(System.err);
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace(System.err);
                    }
                    try {
                        this._clientSocket.close();
                    }
                    catch (Exception e4) {
                        e4.printStackTrace(System.err);
                    }
                }
            }
            finally {
                try {
                    myOut.flush();
                    myOut.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                try {
                    this._clientSocket.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private Range parseRange(String range) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String[] stringArray = range.substring(6).split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            long start = DispatcherFileStream.sublong(part, 0, part.indexOf("-"));
            long end = DispatcherFileStream.sublong(part, part.indexOf("-") + 1, part.length());
            long length = 0L;
            if (start == -1L) {
                start = 0L;
            } else {
                length = end == -1L ? -1L : end - start + 1L;
            }
            ranges.add(new Range(start, length));
            ++n2;
        }
        return (Range)ranges.get(0);
    }

    protected class Range {
        long start;
        long length;

        public Range(long start, long length) {
            this.start = start;
            this.length = length;
        }
    }
}

