/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.bpms.bpmn.engine.event.impl.ValueHandler;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.server.fs.dc.cloud.CloudDCProfileManager;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.exception.AWSException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;

public class FileProcessorEvent {
    private static FileProcessorEvent fileProcessorEvent = new FileProcessorEvent();

    private FileProcessorEvent() {
    }

    public static final FileProcessorEvent getInstance() {
        return fileProcessorEvent;
    }

    public final boolean handleUploadReadyEvent(Map<String, Object> param, String listener) {
        Boolean r = this.handleBooleanCloudFileEvent(param, "uploadReady");
        if (r != null) {
            return r;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleFileProcessorUploadReadyEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            if (!(o instanceof FileProcessorListener)) {
                throw new AWSException("EventHandler[handleFileProcessorUploadReadyEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
            }
            FileProcessorListener event = (FileProcessorListener)o;
            return event.uploadReady(param);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    private AppContext getListenerContext(Map<String, Object> param) {
        DCContext dc = (DCContext)param.get("DCContext");
        return dc.getDCProfile().getAppContext();
    }

    public final void handleUploadBeforeEncryptEvent(Map<String, Object> param, String listener) {
        if (this.handleVoidCloudFileEvent(param, "uploadBeforeEncrypt")) {
            return;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleFileProcessorUploadBeforeEncryptEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            if (!(o instanceof FileProcessorListener)) {
                throw new AWSException("EventHandler[handleFileProcessorUploadBeforeEncryptEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
            }
            FileProcessorListener event = (FileProcessorListener)o;
            event.uploadBeforeEncrypt(param);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public final void handleUploadSuccessEvent(Map<String, Object> param, String listener) {
        if (this.handleVoidCloudFileEvent(param, "uploadSuccess")) {
            return;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleFileProcessorUploadSuccessEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            if (!(o instanceof FileProcessorListener)) {
                throw new AWSException("EventHandler[handleFileProcessorUploadSuccessEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
            }
            FileProcessorListener event = (FileProcessorListener)o;
            event.uploadSuccess(param);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public final void handleUploadErrorEvent(Map<String, Object> param, String listener) {
        if (this.handleVoidCloudFileEvent(param, "uploadError")) {
            return;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleFileProcessorUploadErrorEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            if (!(o instanceof FileProcessorListener)) {
                throw new AWSException("EventHandler[handleFileProcessorUploadErrorEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
            }
            FileProcessorListener event = (FileProcessorListener)o;
            event.uploadError(param);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public final boolean handleDownloadValidateEvent(Map<String, Object> param, String listener) {
        Boolean r = this.handleBooleanCloudFileEvent(param, "downloadValidate");
        if (r != null) {
            return r;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleFileProcessorDownloadValidateEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            if (!(o instanceof FileProcessorListener)) {
                throw new AWSException("EventHandler[handleFileProcessorDownloadValidateEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
            }
            FileProcessorListener event = (FileProcessorListener)o;
            return event.downloadValidate(param);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public final InputStream handleDownloadContentEvent(Map<String, Object> param, String listener) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        param.put("PathMD5", MD5.toDigestUTF8(context.getPath()));
        param.put("cloudInfo", context.getCloudInfo());
        CloudDCPluginProfile cloudDCProfileAllScope = CloudDCProfileManager.getCloudDCProfileAllScope();
        if (cloudDCProfileAllScope != null && !context.getRepositoryName().equals("tmp")) {
            AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(cloudDCProfileAllScope.getClazzName(), cloudDCProfileAllScope.getAppContext().getId(), cloudDCProfileAllScope.getCloudId());
            InputStream downloadContent = this.reflectInputStream(cloudFile.getClass().getName(), param, cloudDCProfileAllScope.getAppContext());
            if (downloadContent != null) {
                return downloadContent;
            }
        } else {
            AbstractCloudFileProcessor cloudFile;
            InputStream downloadContent;
            CloudDCPluginProfile cloudDCProfileAppScope = CloudDCProfileManager.getCloudDCProfileAppScope(context.getAppId());
            if (cloudDCProfileAppScope != null && !context.getRepositoryName().equals("tmp") && (downloadContent = this.reflectInputStream((cloudFile = CloudDCProfileManager.getCloudFileObject(cloudDCProfileAppScope.getClazzName(), cloudDCProfileAppScope.getAppContext().getId(), cloudDCProfileAppScope.getCloudId())).getClass().getName(), param, cloudDCProfileAppScope.getAppContext())) != null) {
                return downloadContent;
            }
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleDownloadContentEvent");
        Object o = handler.getBeans(listener, this.getListenerContext(param));
        if (!(o instanceof FileProcessorListener)) {
            throw new AWSException("EventHandler[handleDownloadContentEvent]\u6267\u884c\u7684[" + listener + "]\u5fc5\u987b\u5b9e\u73b0FileProcessorListener\u63a5\u53e3");
        }
        FileProcessorListener event = (FileProcessorListener)o;
        return event.downloadContent(param);
    }

    private final InputStream reflectInputStream(String className, Map<String, Object> param, AppContext appContext) {
        try {
            Constructor _cons = null;
            Class[] parameterTypes = new Class[]{};
            _cons = ClassReflect.getConstructor(className, parameterTypes, appContext);
            if (_cons != null) {
                Object[] paras = new Object[]{};
                Object o = _cons.newInstance(paras);
                Method method = AbstractCloudFileProcessor.class.getMethod("downloadContent", Map.class);
                Object r = method.invoke(o, param);
                if (r != null && r instanceof InputStream) {
                    return (InputStream)r;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final void handleDownloadCompleteEvent(Map<String, Object> param, String listener) {
        if (this.handleVoidCloudFileEvent(param, "downloadComplete")) {
            return;
        }
        ValueHandler handler = new ValueHandler();
        handler.setEventName("handleDownloadCompleteEvent");
        try {
            Object o = handler.getBeans(listener, this.getListenerContext(param));
            FileProcessorListener event = (FileProcessorListener)o;
            event.downloadComplete(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final Boolean handleBooleanCloudFileEvent(Map<String, Object> param, String methodName) {
        DCContext context = (DCContext)param.get("DCContext");
        param.put("PathMD5", MD5.toDigestUTF8(context.getPath()));
        CloudDCPluginProfile cloudDCProfileAllScope = CloudDCProfileManager.getCloudDCProfileAllScope();
        if (cloudDCProfileAllScope != null && !context.getRepositoryName().equals("tmp")) {
            return this.fireBooleanEvent(param, cloudDCProfileAllScope, methodName);
        }
        CloudDCPluginProfile cloudDCProfileAppScope = CloudDCProfileManager.getCloudDCProfileAppScope(context.getAppId());
        if (cloudDCProfileAppScope != null && !context.getRepositoryName().equals("tmp")) {
            return this.fireBooleanEvent(param, cloudDCProfileAppScope, methodName);
        }
        return null;
    }

    private Boolean fireBooleanEvent(Map<String, Object> param, CloudDCPluginProfile cloudDCProfile, String methodName) {
        DCContext context = (DCContext)param.get("DCContext");
        String repositoryName = context.getRepositoryName();
        InputStream data = null;
        if ((repositoryName.equals("!form-ui-file-") || repositoryName.equals("!form-comment-file-")) && param.containsKey("data")) {
            InputStream in = (InputStream)param.get("data");
            data = DCUtil.cloneInputStream(in);
            param.put("data", data);
        }
        AbstractCloudFileProcessor cloudFileProcessor = CloudDCProfileManager.getCloudFileObject(cloudDCProfile.getClazzName(), cloudDCProfile.getAppContext().getId(), cloudDCProfile.getCloudId());
        try {
            Constructor _cons = null;
            Class[] parameterTypes = new Class[]{};
            _cons = ClassReflect.getConstructor(cloudFileProcessor.getClass().getName(), parameterTypes, cloudDCProfile.getAppContext());
            if (_cons != null) {
                Object[] paras = new Object[]{};
                Object o = _cons.newInstance(paras);
                Method method = AbstractCloudFileProcessor.class.getMethod(methodName, Map.class);
                Object r = method.invoke(o, param);
                if (r != null && r instanceof Boolean) {
                    Boolean bl = (Boolean)r;
                    return bl;
                }
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private final boolean handleVoidCloudFileEvent(Map<String, Object> param, String methodName) {
        Boolean aBoolean;
        CloudDCPluginProfile cloudDCProfileAppScope;
        Boolean aBoolean2;
        DCContext context = (DCContext)param.get("DCContext");
        param.put("PathMD5", MD5.toDigestUTF8(context.getPath()));
        Object in = null;
        CloudDCPluginProfile cloudDCProfileAllScope = CloudDCProfileManager.getCloudDCProfileAllScope();
        return cloudDCProfileAllScope != null && !context.getRepositoryName().equals("tmp") ? (aBoolean2 = this.reflectBoolean(param, cloudDCProfileAllScope, methodName)) != null && aBoolean2 != false : (cloudDCProfileAppScope = CloudDCProfileManager.getCloudDCProfileAppScope(context.getAppId())) != null && !context.getRepositoryName().equals("tmp") && (aBoolean = this.reflectBoolean(param, cloudDCProfileAppScope, methodName)) != null && aBoolean != false;
    }

    private Boolean reflectBoolean(Map<String, Object> param, CloudDCPluginProfile cloudDCProfile, String methodName) {
        AbstractCloudFileProcessor cloudFileProcessor = CloudDCProfileManager.getCloudFileObject(cloudDCProfile.getClazzName(), cloudDCProfile.getAppContext().getId(), cloudDCProfile.getCloudId());
        try {
            Constructor _cons = null;
            Class[] parameterTypes = new Class[]{};
            _cons = ClassReflect.getConstructor(cloudFileProcessor.getClass().getName(), parameterTypes, cloudDCProfile.getAppContext());
            if (_cons != null) {
                Object[] paras = new Object[]{};
                Object o = _cons.newInstance(paras);
                Method method = AbstractCloudFileProcessor.class.getMethod(methodName, Map.class);
                Object r = method.invoke(o, param);
                if (r != null && r instanceof Boolean) {
                    return (Boolean)r;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

