/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.dc;

import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import java.util.HashMap;
import java.util.Map;

public class DCMessage {
    public static final String OK = "ok";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    private String type = "ok";
    private String message;
    private Map<String, Object> attrs = new HashMap<String, Object>();

    public String getType() {
        if (this.type == null) {
            this.type = OK;
        }
        return this.type;
    }

    public Object addAttr(String key, Object v) {
        return this.attrs.put(key, v);
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public Object removeAttr(String key) {
        return this.attrs.remove(key);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        ResponseObject ro = this.type.equals(OK) ? ResponseObject.newOkResponse().ok(this.message) : (this.type.equals(WARNING) ? ResponseObject.newWarnResponse().warn(this.message) : ResponseObject.newErrResponse().err(this.message));
        if (this.attrs.size() > 0) {
            ro.put("attrs", this.attrs);
        }
        return ro.toString();
    }
}

