/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.dc;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorEvent;
import com.actionsoft.bpms.server.fs.dc.DCMessage;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.server.fs.dc.cloud.CloudDCProfileManager;
import com.actionsoft.bpms.server.fs.file.DCFileQueue;
import com.actionsoft.bpms.server.fs.file.ReadDCFile;
import com.actionsoft.bpms.server.fs.file.WriteDCFile;
import com.actionsoft.bpms.server.fs.file.dao.FileDao;
import com.actionsoft.bpms.server.fs.file.model.FileModel;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.io.FileUtil;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.IOUtils;

public final class DCUtil {
    private static DCUtil util = new DCUtil();

    public static DCUtil getInstance() {
        return util;
    }

    public static String genRepositoryName(String name, boolean deepFile, boolean encrypt, boolean RWBytes) {
        StringBuilder sb = new StringBuilder();
        if (encrypt) {
            sb.append("-");
        }
        if (RWBytes) {
            sb.append("!");
        }
        sb.append(name);
        if (deepFile) {
            sb.append("-");
        }
        return name;
    }

    public static boolean isDiyContent(String repositoryName) {
        return repositoryName != null && repositoryName.indexOf("!") == 0;
    }

    public static boolean handlerWriteDCDefault(InputStream in, DCContext context, Map<String, Object> param) {
        String watchFileObj = String.valueOf(context.getPath()) + context.getFileName();
        DCFileQueue.addWatch(watchFileObj, Thread.currentThread().getName());
        String outFile = watchFileObj;
        if (DCUtil.isHighSecurityStorage(context.getRepositoryName())) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(context.getFileName());
            context.setSecurityFileName(newFileName);
            outFile = String.valueOf(context.getPath()) + newFileName;
        }
        FileOutputStream fos = null;
        boolean fosIsClose = false;
        try {
            CloudDCPluginProfile cloudDCProfileAllScope = CloudDCProfileManager.getCloudDCProfileAllScope();
            if (cloudDCProfileAllScope != null && !DCUtil.isIgnoreRepositoryName(context)) {
                boolean bl = DCUtil.writeCloud(param, cloudDCProfileAllScope);
                return bl;
            }
            CloudDCPluginProfile cloudDCProfileAppScope = CloudDCProfileManager.getCloudDCProfileAppScope(context.getAppId());
            if (cloudDCProfileAppScope != null && !DCUtil.isIgnoreRepositoryName(context)) {
                boolean bl = DCUtil.writeCloud(param, cloudDCProfileAppScope);
                return bl;
            }
            File file = new File(context.getPath());
            if (!file.exists()) {
                FileUtil.mkdirs((File)file);
            }
            fos = new FileOutputStream(outFile);
            UtilIO.copy(in, fos);
            fos.close();
            fosIsClose = true;
            if (DCUtil.isHighSecurityStorage(context.getRepositoryName())) {
                FileProcessorEvent.getInstance().handleUploadBeforeEncryptEvent(param, context.getDCProfile().getClazzName());
                DCUtil.getInstance();
                DCUtil.encryptFile(context);
            }
            if (context.getDCMessage() == null) {
                context.setDCMessage("ok", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5df2\u63a5\u6536\u5b8c\u6bd5"));
            }
            FileProcessorEvent.getInstance().handleUploadSuccessEvent(param, context.getDCProfile().getClazzName());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.platform", I18nRes.getUserLanguage(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25")) + "," + I18nRes.findValue("_bpm.platform", I18nRes.getUserLanguage(), "\u539f\u56e0\u662f") + "[" + e.getMessage() + "]");
            FileProcessorEvent.getInstance().handleUploadErrorEvent(param, context.getDCProfile().getClazzName());
            return false;
        }
        finally {
            try {
                if (fos != null && !fosIsClose) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DCFileQueue.removeWatch(watchFileObj);
        }
    }

    private static boolean writeCloud(Map<String, Object> param, CloudDCPluginProfile cloudDCProfile) {
        DCContext dcContext = (DCContext)param.get("DCContext");
        if (DCUtil.isHighSecurityStorage(dcContext.getRepositoryName())) {
            FileProcessorEvent.getInstance().handleUploadBeforeEncryptEvent(param, dcContext.getDCProfile().getClazzName());
        }
        DCMessage oldMessage = dcContext.getDCMessage();
        String showName = dcContext.getFileNameShow();
        String pathMD5 = MD5.toDigestUTF8(dcContext.getPath());
        param.put("PathMD5", pathMD5);
        param.put("fileName", dcContext.getFileName());
        InputStream data = null;
        if (param.containsKey("data")) {
            InputStream in = (InputStream)param.get("data");
            data = DCUtil.cloneInputStream(in);
            param.put("data", data);
        }
        try {
            ResponseObject ro;
            AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(cloudDCProfile.getClazzName(), cloudDCProfile.getAppContext().getId(), cloudDCProfile.getCloudId());
            String s = cloudFile.pushCloudFile(param);
            if (StringUtil.isNotEmpty((CharSequence)s) && (ro = ResponseObject.parse(s)) != null) {
                if (ro.isOk()) {
                    if (ro.getData() != null) {
                        JSONObject result = (JSONObject)ro.getData();
                        String cloudInfo = result.getString("cloudInfo");
                        long fileSize = result.getLong("fileSize");
                        String sysFileId = DCUtil.writeSysFile(dcContext, dcContext.getAppId(), fileSize, cloudDCProfile.getCloudId(), cloudDCProfile.getAppContext().getId(), cloudInfo);
                        dcContext.setCloud(true);
                        dcContext.setPush(true);
                        dcContext.setCloudAppId(cloudDCProfile.getAppContext().getId());
                        dcContext.setCloudId(cloudDCProfile.getCloudId());
                        dcContext.setCloudInfo(cloudInfo);
                        dcContext.setSysFilesId(sysFileId);
                        param.put("DCContext", dcContext);
                        param.put("fileSize", fileSize);
                    }
                    FileProcessorEvent.getInstance().handleUploadSuccessEvent(param, dcContext.getDCProfile().getClazzName());
                    return true;
                }
                dcContext.setDCMessage("error", ro.getMsg());
                return false;
            }
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean isIgnoreRepositoryName(DCContext context) {
        List<String> strings;
        String repositoryName = context.getRepositoryName();
        if (repositoryName.equals("!appresource")) {
            return true;
        }
        if (repositoryName.equals("tmp")) {
            return true;
        }
        if (context.getFileName().equals("_CONTENT") || context.getFileName().equals("_TRACK")) {
            return true;
        }
        if (repositoryName.equals("mobileportal")) {
            return true;
        }
        if (repositoryName.equals("-processbo-")) {
            return true;
        }
        if (repositoryName.equals("processvar-")) {
            return true;
        }
        if (repositoryName.equals("cc")) {
            return true;
        }
        if (repositoryName.equals("!iweboffice-")) {
            return true;
        }
        if (repositoryName.equals("!iwebpdf-")) {
            return true;
        }
        if (repositoryName.equals("-cachet-")) {
            return true;
        }
        if (repositoryName.equals("testCase")) {
            return true;
        }
        if (repositoryName.equals("testCaseTmp")) {
            return true;
        }
        if (repositoryName.equals("report")) {
            return true;
        }
        if (repositoryName.equals("-_transfer_onlinedoc-")) {
            return true;
        }
        if (repositoryName.equals("wpsOATemplate")) {
            return true;
        }
        String extParam = context.getExtParam();
        if ("wpsOA".equals(extParam)) {
            return true;
        }
        String ignoreRepositoryNames = SDK.getAppAPI().getProperty("_bpm.platform", "ignoreRepositoryNames");
        return UtilString.isNotEmpty(ignoreRepositoryNames) && !UtilString.isEmpty(strings = new UtilString(ignoreRepositoryNames).split(",")) && strings.contains(repositoryName);
    }

    public static boolean isHighSecurityStorage(String repositoryName) {
        return repositoryName != null && repositoryName.startsWith("-");
    }

    public static boolean isBigStorage(String repositoryName) {
        return repositoryName != null && repositoryName.endsWith("-");
    }

    public static String getSecurityKey(String path) {
        path = new UtilString(path).replace("\\", "/");
        String dir = path.substring(0, path.lastIndexOf("/"));
        Object pbeKey = null;
        return dir.substring(dir.lastIndexOf("/") + 1);
    }

    public static String encryptFileName(String fileName, String charsetName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        String newFileName = "";
        String tmpFileName = fileName;
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (fileName.length() <= 50) {
            try {
                newFileName = String.valueOf(new String(Base64.encode(AES.encrypt((byte[])tmpFileName.getBytes(charsetName), (String)"awsfile")), "charset")) + fileSuffix;
                if (newFileName.indexOf("/") != -1) {
                    newFileName = new UtilString(newFileName).replace("/", "!");
                }
            }
            catch (Exception e) {
                newFileName = fileName;
            }
        } else {
            String key = new MD5().toDigest(fileName, "utf-8");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ID", key);
            param.put("V", fileName);
            String id = DBSql.getString("SELECT ID FROM SYS_MD5_VALUE WHERE ID=:ID", "ID", param);
            if (UtilString.isEmpty(id)) {
                DBSql.update(DBSql.getInsertStatement("SYS_MD5_VALUE", param), param);
            }
            newFileName = String.valueOf(key) + fileSuffix;
        }
        return newFileName;
    }

    public static String encryptFileName(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        String newFileName = "";
        String tmpFileName = fileName;
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (fileName.length() <= 50) {
            try {
                newFileName = String.valueOf(new String(Base64.encode(AES.encrypt((byte[])tmpFileName.toString().getBytes(), (String)"awsfile")))) + fileSuffix;
                if (newFileName.indexOf("/") != -1) {
                    newFileName = new UtilString(newFileName).replace("/", "!");
                }
            }
            catch (Exception e) {
                newFileName = fileName;
            }
        } else {
            String key = new MD5().toDigest(fileName, "utf-8");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ID", key);
            param.put("V", fileName);
            String id = DBSql.getString("SELECT ID FROM SYS_MD5_VALUE WHERE ID=:ID", "ID", param);
            if (UtilString.isEmpty(id)) {
                DBSql.update(DBSql.getInsertStatement("SYS_MD5_VALUE", param), param);
            }
            newFileName = String.valueOf(key) + fileSuffix;
        }
        return newFileName;
    }

    public static String decryptFileName(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        String newFileName = "";
        String tmpFileName = "";
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (fileName.length() <= 50) {
            if (tmpFileName.indexOf("!") != -1) {
                tmpFileName = new UtilString(tmpFileName).replace("!", "/");
            }
            try {
                newFileName = String.valueOf(new String(AES.decrypt((byte[])Base64.decode(tmpFileName.getBytes()), (String)"awsfile"))) + fileSuffix;
            }
            catch (Exception e) {
                newFileName = fileName;
            }
        } else {
            String key = new MD5().toDigest(fileName, "utf-8");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ID", key);
            String v = DBSql.getString("SELECT V FROM SYS_MD5_VALUE WHERE ID=:ID", "V", param);
            if (!UtilString.isEmpty(v)) {
                newFileName = v;
            } else {
                throw new AWSObjectNotFindException(String.valueOf(I18nRes.findValue("_bpm.platform", "\u957f\u6587\u4ef6\u540d\u5bf9\u5e94\u7684\u5b57\u5178")) + "[" + key + "]" + I18nRes.findValue("_bpm.platform", "\u7684\u503c\u6ca1\u6709\u627e\u5230"));
            }
        }
        return newFileName;
    }

    public static InputStream decryptFile(DCContext context) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(context.getAppId());
        if (app == null) {
            context.getDCMessage().setType("warning");
            context.getDCMessage().setMessage(String.valueOf(I18nRes.findValue("_bpm.platform", "\u65e0\u6548\u7684AppId")) + "[" + context.getAppId() + "]");
            return null;
        }
        if (context.isCloud()) {
            CloudDCPluginProfile profile;
            String cloudId = context.getCloudId();
            String cloudAppId = context.getCloudAppId();
            if (UtilString.isNotEmpty(cloudId) && UtilString.isNotEmpty(cloudAppId) && (profile = CloudDCProfileManager.getDCProfile(cloudAppId, cloudId)) != null) {
                AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(profile.getClazzName(), cloudAppId, cloudId);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("DCContext", context);
                params.put("uid", context.getSession().getUID());
                if (DCUtil.isDiyContent(context.getRepositoryName())) {
                    return cloudFile.downloadCloudFile(params);
                }
                return cloudFile.downloadContent(params);
            }
        }
        String realPath = "";
        boolean isHighSecurityStorage = DCUtil.isHighSecurityStorage(context.getRepositoryName());
        if (isHighSecurityStorage) {
            DCUtil.getInstance();
            String newFileName = DCUtil.encryptFileName(context.getFileName());
            context.setSecurityFileName(newFileName);
            realPath = String.valueOf(context.getPath()) + newFileName;
            File file = new File(realPath);
            if (!file.exists()) {
                String fileName;
                String tmpFileName = fileName = context.getFileName();
                String fileSuffix = "";
                if (fileName.lastIndexOf(".") > -1) {
                    tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
                    fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
                }
                try {
                    newFileName = String.valueOf(new String(Base64.encode(AES.encrypt((byte[])tmpFileName.toString().getBytes(), (String)"awsfile")))) + fileSuffix;
                    if (newFileName.indexOf("/") != -1) {
                        newFileName = new UtilString(newFileName).replace("/", "!");
                    }
                    context.setSecurityFileName(newFileName);
                }
                catch (Exception e) {
                    newFileName = fileName;
                }
            }
        }
        realPath = String.valueOf(context.getPath()) + context.getSecurityFileName();
        FileInputStream in = null;
        try {
            in = new FileInputStream(realPath);
            int len = in.available();
            if (len > 0) {
                byte[] buf = new byte[len];
                in.read(buf, 0, len);
                buf = AES.decrypt((byte[])buf, (String)DCUtil.getSecurityKey(realPath));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
                return byteArrayInputStream;
            }
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u4e0d\u53ef\u8bfb"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        {
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    context.setDCMessage("ok", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5df2\u8bfb\u53d6\u5b8c\u6bd5"));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        {
            context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.platform", "\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef")) + "[" + e.getMessage() + "]");
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                in = null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static int encryptFile(DCContext context) {
        int fileSize;
        block18: {
            String path = String.valueOf(context.getPath()) + context.getSecurityFileName();
            String password = DCUtil.getSecurityKey(path);
            fileSize = 0;
            FileOutputStream out = null;
            FileInputStream in = null;
            File inFile = new File(path);
            File outFile = new File(String.valueOf(path) + ".enc");
            try {
                try {
                    int len;
                    in = new FileInputStream(inFile);
                    out = new FileOutputStream(outFile);
                    fileSize = len = in.available();
                    if (len > 0) {
                        AES.encrypt((InputStream)in, (OutputStream)out, (String)password);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    try {
                        in.close();
                        in = null;
                        out.close();
                        out = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inFile.delete();
                    try {
                        UtilFile.copyFile(outFile, inFile);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    outFile.delete();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    in = null;
                    out.close();
                    out = null;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                inFile.delete();
                try {
                    UtilFile.copyFile(outFile, inFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                outFile.delete();
                throw throwable;
            }
            try {
                in.close();
                in = null;
                out.close();
                out = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            inFile.delete();
            try {
                UtilFile.copyFile(outFile, inFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            outFile.delete();
        }
        return fileSize / 1024;
    }

    public static DCContext createTempFileContext(String appId, String fileSuffix) {
        return DCUtil.createTempFileContext(appId, null, null, fileSuffix);
    }

    public static DCContext createTempFileContext(String appId, String groupValue, String fileValue, String fileSuffix) {
        if (appId == null || appId.trim().length() == 0) {
            return null;
        }
        if (AppsAPIManager.getInstance().getAppContext(appId) == null) {
            return null;
        }
        if (groupValue == null || groupValue.equals("")) {
            groupValue = "Normal";
        }
        if (fileValue == null || fileValue.equals("")) {
            fileValue = "Normal";
        }
        if (fileSuffix == null) {
            fileSuffix = "";
        }
        if (fileSuffix.length() > 0) {
            fileSuffix = "." + fileSuffix;
        }
        String fileName = String.valueOf(System.currentTimeMillis()) + fileSuffix;
        DCContext context = new DCContext(null, DCProfileManager.getDCProfile(appId, "tmp"), appId, groupValue, fileValue, fileName);
        File file = new File(context.getPath());
        if (!file.exists()) {
            file.mkdirs();
        }
        return context;
    }

    public static boolean copyDCFile(DCContext sourceContext, DCContext targetContext) {
        InputStream sourceFileByte = ReadDCFile.getInstance().read(sourceContext);
        if (targetContext.getFileName() == null || targetContext.getFileName().equals("")) {
            targetContext.setFileName(sourceContext.getFileName());
        }
        try {
            boolean bl = WriteDCFile.getInstance().write(sourceFileByte, targetContext);
            return bl;
        }
        finally {
            try {
                sourceFileByte.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDangerFileName(String fileName) {
        return DCUtil.isDangerFileName(fileName, false);
    }

    public static boolean isDangerFileName(String fileName, boolean checkSuffix) {
        if (fileName == null) {
            return false;
        }
        if (checkSuffix) {
            String s;
            int n;
            int n2;
            String[] stringArray;
            boolean safe;
            String[] ss;
            String whitelist = SDK.getAppAPI().getProperty("_bpm.platform", "file.whitelist.suffix");
            String blacklist = SDK.getAppAPI().getProperty("_bpm.platform", "file.blacklist.suffix");
            if (!UtilString.isEmpty(whitelist)) {
                ss = whitelist.split("\\|");
                if (fileName.lastIndexOf(46) != -1) {
                    safe = false;
                    stringArray = ss;
                    n2 = ss.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        if (fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase(s)) {
                            safe = true;
                            break;
                        }
                        ++n;
                    }
                    if (!safe) {
                        return true;
                    }
                }
            }
            if (!UtilString.isEmpty(blacklist)) {
                ss = blacklist.split("\\|");
                if (fileName.lastIndexOf(46) != -1) {
                    safe = true;
                    stringArray = ss;
                    n2 = ss.length;
                    n = 0;
                    while (n < n2) {
                        s = stringArray[n];
                        if (fileName.substring(fileName.lastIndexOf(46) + 1).equalsIgnoreCase(s)) {
                            safe = false;
                            break;
                        }
                        ++n;
                    }
                    if (!safe) {
                        return true;
                    }
                }
            }
        }
        return fileName.contains("../") || fileName.contains("..%2F") || fileName.contains("..\\") || fileName.contains("..%5C");
    }

    public static String getMobileDownloadUrl(DCContext dcContext) {
        String downloadUrl = dcContext.getDownloadURL();
        if ((downloadUrl = downloadUrl.substring(1, downloadUrl.length())).startsWith("/df")) {
            downloadUrl = String.valueOf(SDK.getConfAPI().getMobileUrl()) + "/r" + downloadUrl;
        } else if (downloadUrl.startsWith("./")) {
            downloadUrl = downloadUrl.substring(1, downloadUrl.length());
            downloadUrl = String.valueOf(SDK.getConfAPI().getMobileUrl()) + downloadUrl;
        }
        return downloadUrl;
    }

    public static String encryptFileName_history(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        String newFileName = "";
        String tmpFileName = fileName;
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        try {
            newFileName = String.valueOf(new String(Base64.encode(AES.encrypt((byte[])tmpFileName.toString().getBytes(), (String)"awsfile")))) + fileSuffix;
            if (newFileName.indexOf("/") != -1) {
                newFileName = new UtilString(newFileName).replace("/", "!");
            }
        }
        catch (Exception e) {
            newFileName = fileName;
        }
        return newFileName;
    }

    public static String decryptFileName_history(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        String newFileName = "";
        String tmpFileName = "";
        String fileSuffix = "";
        if (fileName.lastIndexOf(".") > -1) {
            tmpFileName = fileName.substring(0, fileName.lastIndexOf("."));
            fileSuffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (tmpFileName.indexOf("!") != -1) {
            tmpFileName = new UtilString(tmpFileName).replace("!", "/");
        }
        System.out.println(tmpFileName);
        try {
            newFileName = String.valueOf(new String(AES.decrypt((byte[])Base64.decode(tmpFileName.getBytes()), (String)"awsfile"))) + fileSuffix;
        }
        catch (Exception e) {
            newFileName = fileName;
        }
        return newFileName;
    }

    public static String writeSysFile(DCContext context, String appId, long fileSize, String cloudId, String cloudAppId, String cloudInfo) {
        FileDao fileDao = new FileDao();
        String id = UUIDGener.getUUID();
        FileModel fileModel = new FileModel();
        fileModel.setId(id);
        fileModel.setFileSize(String.valueOf(fileSize));
        fileModel.setFileName(context.getFileName());
        fileModel.setCloudInfo(cloudInfo);
        fileModel.setCloud(true);
        fileModel.setPush(true);
        fileModel.setCloudId(cloudId);
        fileModel.setCloudAppId(cloudAppId);
        if (context.getSession() != null) {
            fileModel.setCreateUser(context.getSession().getUID());
        }
        fileModel.setGroupValue(context.getGroupValue());
        fileModel.setFileValue(context.getFileValue());
        fileModel.setRepositoryName(context.getRepositoryName());
        fileModel.setAppId(appId);
        fileDao.insert(fileModel);
        return id;
    }

    public static InputStream cloneInputStream(InputStream in) {
        ByteArrayInputStream data = null;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            data = new ByteArrayInputStream(baos.toByteArray());
            in.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return data;
    }

    public static ResponseObject downloadPackage(UserContext me, List<DCContext> dcList, String zipFilePath, String zipFileName, String repositoryName) throws Exception {
        File targetFileDir = new File(zipFilePath);
        if (!targetFileDir.exists()) {
            targetFileDir.mkdirs();
        }
        try {
            for (DCContext dcContext : dcList) {
                InputStream is = null;
                OutputStream out = null;
                try {
                    try {
                        File targetFile = new File(String.valueOf(zipFilePath) + dcContext.getFileName());
                        if (!targetFile.exists()) {
                            targetFile.createNewFile();
                        }
                        out = new FileOutputStream(targetFile);
                        is = ReadDCFile.getInstance().read(dcContext);
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            is.close();
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            DCPluginProfile dcProfile = DCProfileManager.getDCProfile("_bpm.platform", repositoryName);
            DCContext zipDcContext = new DCContext(me, dcProfile, "_bpm.platform", "zip", "rp", zipFileName);
            UtilFile.zipCompress(zipFilePath, new File(zipDcContext.getFilePath()));
            String downloadURL = zipDcContext.getDownloadURL();
            return ResponseObject.newOkResponse(downloadURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse(e.getMessage());
        }
    }
}

