/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.dc.cloud;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSClassLoaderException;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.sdk.local.SDK;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class CloudDCProfileManager {
    private static List<CloudDCPluginProfile> _list = new ArrayList<CloudDCPluginProfile>();

    public static CloudDCPluginProfile getDCProfile(String appId, String cloudId) {
        CloudDCPluginProfile profile = null;
        for (CloudDCPluginProfile dc : _list) {
            if (!dc.getAppContext().getId().equals(appId) || !dc.getCloudId().equals(cloudId)) continue;
            profile = dc;
            return profile;
        }
        if (profile == null) {
            for (CloudDCPluginProfile dc : _list) {
                if (!dc.getCloudId().equals(cloudId) || !dc.isCommon()) continue;
                profile = dc;
                return profile;
            }
        }
        return profile;
    }

    public static boolean registerPlugin(AppContext app, CloudDCPluginProfile plugin) {
        if (plugin.isSupportPush()) {
            for (CloudDCPluginProfile obj : _list) {
                if (!obj.isSupportPush()) continue;
                if (UtilString.isEmpty(plugin.getScope()) && UtilString.isEmpty(obj.getScope())) {
                    AppsLogger.err((AppContext)app, (String)("\u6ce8\u518cCloudDC\u6587\u4ef6\u5904\u7406\u5668[" + plugin.getCloudId() + "]\u51b2\u7a81\uff0c\u539f\u56e0\u662f\u5168\u5c40\u4e91\u5b58\u50a8\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u5df2\u88ab[" + obj.getAppContext().getName() + "]\u58f0\u660e"));
                    return false;
                }
                if (UtilString.isNotEmpty(plugin.getScope()) && obj.getScope().equals(plugin.getScope())) {
                    AppsLogger.err((AppContext)app, (String)("\u6ce8\u518cCloudDC\u6587\u4ef6\u5904\u7406\u5668[" + plugin.getCloudId() + "]\u51b2\u7a81\uff0c\u539f\u56e0\u662f\u8be5\u4e91\u5b58\u50a8\u53ea\u80fd\u6709\u4e00\u4e2a\uff0c\u5df2\u88ab[" + obj.getAppContext().getName() + "]\u58f0\u660e"));
                    return false;
                }
                if (!obj.getCloudId().equals(plugin.getCloudId()) || !obj.isCommon() && !plugin.isCommon()) continue;
                AppsLogger.err((AppContext)app, (String)("\u6ce8\u518cCloudDC\u6587\u4ef6\u5904\u7406\u5668[" + plugin.getCloudId() + "]\u51b2\u7a81\uff0c\u539f\u56e0\u662f\u8be5\u5b58\u50a8\u540d\u79f0\u5df2\u88ab[" + obj.getAppContext().getName() + "]\u58f0\u660e"));
                return false;
            }
        }
        _list.add(plugin);
        return true;
    }

    public static boolean destoryPlugin(AppContext app, CloudDCPluginProfile plugin) {
        ArrayList<CloudDCPluginProfile> new_list = new ArrayList<CloudDCPluginProfile>();
        for (CloudDCPluginProfile obj : _list) {
            if (plugin.getAppContext().getId().equals(obj.getAppContext().getId()) && plugin.getClazzName().equals(obj.getClazzName())) continue;
            new_list.add(obj);
        }
        _list = new_list;
        return true;
    }

    public static CloudDCPluginProfile getCloudDCProfileAppScope(String scopeAppId) {
        List<CloudDCPluginProfile> profileList = CloudDCProfileManager.getProfileList();
        for (CloudDCPluginProfile cloudDCPluginProfile : profileList) {
            if (!scopeAppId.equals(cloudDCPluginProfile.getScope())) continue;
            return cloudDCPluginProfile;
        }
        return null;
    }

    public static CloudDCPluginProfile getCloudDCProfileAllScope() {
        List<CloudDCPluginProfile> profileList = CloudDCProfileManager.getProfileList();
        for (CloudDCPluginProfile cloudDCPluginProfile : profileList) {
            if (!UtilString.isEmpty(cloudDCPluginProfile.getScope()) || !cloudDCPluginProfile.isSupportPush()) continue;
            return cloudDCPluginProfile;
        }
        return null;
    }

    public static AbstractCloudFileProcessor getCloudFileObject(String clazzName, String appId, String cloudId) {
        if (UtilString.isEmpty(clazzName)) {
            throw new AWSIllegalArgumentException("\u4e91\u6587\u6863\u5b58\u50a8\u670d\u52a1", "EMPT");
        }
        CloudDCPluginProfile profile = CloudDCProfileManager.getDCProfile(appId, cloudId);
        if (profile == null) {
            throw new AWSForbiddenException("\u4e91\u6587\u6863\u5b58\u50a8\u670d\u52a1\u7c7b[" + clazzName + "]\u6ca1\u6709\u6ce8\u518c\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
        }
        if (!SDK.getAppAPI().isActive(profile.getAppContext().getId())) {
            throw new AWSForbiddenException("\u5e94\u7528[" + profile.getAppContext().getName() + "]\u5df2\u505c\u6b62\uff0c\u4e91\u6587\u6863\u5b58\u50a8\u670d\u52a1[" + profile.getName() + "]\u6682\u4e0d\u53ef\u7528");
        }
        Constructor cons = null;
        try {
            Class[] parameterTypes = new Class[]{};
            cons = ClassReflect.getConstructor(clazzName, parameterTypes, profile.getAppContext());
            Class<?> clazz = profile.getAppContext().getBindClassLoader().loadClass(clazzName);
            AbstractCloudFileProcessor obj = (AbstractCloudFileProcessor)cons.newInstance(new Object[0]);
            return obj;
        }
        catch (AWSException e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw e;
        }
        catch (Exception e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw new AWSClassLoaderException(e);
        }
    }

    public static List<CloudDCPluginProfile> getProfileList() {
        return _list;
    }

    public static List<CloudDCPluginProfile> getPullProfileList() {
        ArrayList<CloudDCPluginProfile> pullList = new ArrayList<CloudDCPluginProfile>();
        for (CloudDCPluginProfile profile : _list) {
            if (!profile.isSupportPull()) continue;
            pullList.add(profile);
        }
        return pullList;
    }

    public static List<CloudDCPluginProfile> getPushProfileList() {
        ArrayList<CloudDCPluginProfile> pushList = new ArrayList<CloudDCPluginProfile>();
        for (CloudDCPluginProfile profile : _list) {
            if (!profile.isSupportPush()) continue;
            pushList.add(profile);
        }
        return pushList;
    }
}

