/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.file;

import com.actionsoft.exception.AWSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RandomOutputStream
extends ByteArrayOutputStream {
    private OutputStream out;
    private long accessStart;
    private long length;
    private long currentLength = 0L;

    public RandomOutputStream(OutputStream out, long accessStart, long length) {
        this.out = out;
        this.accessStart = accessStart;
        this.length = length;
    }

    @Override
    public synchronized void write(int b) {
        ++this.currentLength;
        if (this.currentLength - 1L >= this.accessStart && this.currentLength <= this.accessStart + this.length) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                throw new AWSException(e);
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.currentLength += (long)len;
        if (this.currentLength - 1L >= this.accessStart) {
            long sub;
            int newOff = off;
            int newLen = len;
            if (this.length == -1L) {
                if (this.currentLength - (long)len < this.accessStart - 1L) {
                    sub = this.accessStart - (this.currentLength - (long)len);
                    newOff += (int)sub;
                    newLen -= (int)sub;
                }
            } else if (this.currentLength - 1L <= this.accessStart + this.length - 1L) {
                if (this.currentLength - (long)len < this.accessStart - 1L) {
                    sub = this.accessStart - (this.currentLength - (long)len);
                    newOff += (int)sub;
                    newLen -= (int)sub;
                }
            } else if (this.currentLength - (long)len <= this.accessStart + this.length - 1L) {
                sub = this.currentLength - 1L - (this.accessStart + this.length - 1L);
                newLen -= (int)sub;
                if (this.currentLength - (long)len < this.accessStart - 1L) {
                    sub = this.accessStart - (this.currentLength - (long)len);
                    newOff += (int)sub;
                    newLen -= (int)sub;
                }
            } else {
                newOff += len;
                newLen = 0;
            }
            try {
                this.out.write(b, newOff, newLen);
            }
            catch (IOException e) {
                throw new AWSException(e);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
    }

    @Override
    public synchronized void writeTo(OutputStream out) throws IOException {
        super.writeTo(out);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

