/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.file;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorEvent;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.server.fs.dc.cloud.CloudDCProfileManager;
import com.actionsoft.bpms.server.fs.file.DCFileQueue;
import com.actionsoft.bpms.server.fs.file.RandomOutputStream;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UtilIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class ReadDCFile {
    private static ReadDCFile readFile = new ReadDCFile();

    private ReadDCFile() {
    }

    public static ReadDCFile getInstance() {
        return readFile;
    }

    public boolean read(Socket out, DCContext context) {
        return this.read(out, context, 0L, -1L);
    }

    public boolean read(Socket out, DCContext context, long accessIndex, long length) {
        BufferedOutputStream bufferOut = null;
        try {
            bufferOut = new BufferedOutputStream(out.getOutputStream());
            return this.read(bufferOut, context, accessIndex, length);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            context.setDCMessage("error", "\u6587\u4ef6\u8bfb\u53d6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
            return false;
        }
    }

    public boolean read(OutputStream bufferOut, DCContext context) {
        return this.read(bufferOut, context, 0L, -1L);
    }

    public boolean read(OutputStream bufferOut, DCContext context, long accessIndex, long length) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DCContext", context);
        if (DCUtil.isDiyContent(context.getRepositoryName())) {
            InputStream is = null;
            try {
                is = FileProcessorEvent.getInstance().handleDownloadContentEvent(param, context.getDCProfile().getClazzName());
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", "\u51c6\u5907\u6587\u4ef6\uff1a\u5728\u5904\u7406\u4e0b\u8f7d\u5185\u5bb9\u4e8b\u4ef6\u65f6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
                return false;
            }
            if (is == null) {
                return false;
            }
            try {
                UtilIO.copy(is, new RandomOutputStream(bufferOut, accessIndex, length));
                bufferOut.flush();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", "\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
                return false;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FileProcessorEvent.getInstance().handleDownloadCompleteEvent(param, context.getDCProfile().getClazzName());
            }
        }
        if (!this.vaildateReadContext(context)) {
            return false;
        }
        boolean handleValue = FileProcessorEvent.getInstance().handleDownloadValidateEvent(param, context.getDCProfile().getClazzName());
        if (handleValue) {
            DCFileQueue.wait(context.getPath());
            String realPath = String.valueOf(context.getPath()) + context.getFileName();
            boolean isHighSecurityStorage = DCUtil.isHighSecurityStorage(context.getRepositoryName());
            if (isHighSecurityStorage) {
                DCUtil.getInstance();
                String newFileName = DCUtil.encryptFileName(context.getFileName());
                context.setSecurityFileName(newFileName);
                realPath = String.valueOf(context.getPath()) + newFileName;
            }
            InputStream in = null;
            Object bufferIn = null;
            try {
                in = this.readInputStream(param, realPath, bufferOut, accessIndex, length);
                return context.getDCMessage().getType().equals("ok");
                {
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                context.setDCMessage("error", "\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
                return false;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    in = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                FileProcessorEvent.getInstance().handleDownloadCompleteEvent(param, context.getDCProfile().getClazzName());
            }
        }
        if (context.getDCMessage() == null) {
            context.setDCMessage("warning", "\u7a0b\u5e8f\u4e0d\u5141\u8bb8\u4e0b\u8f7d\u8be5\u9644\u4ef6\uff0c\u4e0b\u8f7d\u88ab\u62d2\u7edd");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readInputStream(Map<String, Object> param, String realPath, OutputStream bufferOut, long accessIndex, long length) {
        byte[] buf;
        int len;
        InputStream in;
        boolean isHighSecurityStorage;
        block43: {
            DCContext context = (DCContext)param.get("DCContext");
            isHighSecurityStorage = DCUtil.isHighSecurityStorage(context.getRepositoryName());
            param.put("PathMD5", MD5.toDigestUTF8(context.getPath()));
            in = null;
            CloudDCPluginProfile cloudDCProfileAllScope = CloudDCProfileManager.getCloudDCProfileAllScope();
            if (cloudDCProfileAllScope != null && !DCUtil.isIgnoreRepositoryName(context) && context.isCloud()) {
                return this.readCloud(param, cloudDCProfileAllScope);
            }
            CloudDCPluginProfile cloudDCProfileAppScope = CloudDCProfileManager.getCloudDCProfileAppScope(context.getAppId());
            if (cloudDCProfileAppScope != null && !DCUtil.isIgnoreRepositoryName(context) && context.isCloud()) {
                return this.readCloud(param, cloudDCProfileAppScope);
            }
            if (!new File(realPath).exists() && isHighSecurityStorage) {
                String hisName = DCUtil.encryptFileName_history(context.getFileName());
                context.setSecurityFileName(hisName);
                realPath = String.valueOf(context.getPath()) + hisName;
                if (!new File(realPath).exists()) {
                    return null;
                }
            }
            try {
                in = new FileInputStream(realPath);
                len = in.available();
                if (len > 0) {
                    if (bufferOut != null) {
                        BufferedInputStream bufferIn = null;
                        bufferIn = new BufferedInputStream(in);
                        if (!isHighSecurityStorage) {
                            UtilIO.copy(bufferIn, new RandomOutputStream(bufferOut, accessIndex, length));
                        } else {
                            AES.decrypt((InputStream)bufferIn, (OutputStream)new RandomOutputStream(bufferOut, accessIndex, length), (String)DCUtil.getSecurityKey(realPath));
                        }
                        bufferOut.flush();
                        context.setDCMessage("ok", "\u6587\u4ef6\u5df2\u8bfb\u53d6\u5b8c\u6bd5");
                        return null;
                    }
                    buf = new byte[len];
                    break block43;
                }
                context.setDCMessage("warning", "\u6587\u4ef6\u4e0d\u53ef\u8bfb");
                return null;
            }
            catch (Exception e) {
                context.setDCMessage("warning", "\u6587\u4ef6\u4e0d\u53ef\u8bfb");
                e.printStackTrace();
                return null;
            }
        }
        try {
            in.read(buf, 0, len);
            if (isHighSecurityStorage) {
                buf = AES.decrypt((byte[])buf, (String)DCUtil.getSecurityKey(realPath));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            return byteArrayInputStream;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    System.err.println("\u5173\u95ed\u6587\u4ef6\u51fa\u9519\uff1a" + e);
                }
            }
        }
    }

    private InputStream readCloud(Map<String, Object> param, CloudDCPluginProfile cloudDCProfile) {
        AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(cloudDCProfile.getClazzName(), cloudDCProfile.getAppContext().getId(), cloudDCProfile.getCloudId());
        InputStream inputStream = cloudFile.downloadCloudFile(param);
        return inputStream;
    }

    public InputStream read(DCContext context) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DCContext", context);
        if (DCUtil.isDiyContent(context.getRepositoryName())) {
            try {
                return FileProcessorEvent.getInstance().handleDownloadContentEvent(param, context.getDCProfile().getClazzName());
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", "\u83b7\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
                return null;
            }
        }
        if (!this.vaildateReadContext(context)) {
            return null;
        }
        boolean handleValue = FileProcessorEvent.getInstance().handleDownloadValidateEvent(param, context.getDCProfile().getClazzName());
        if (handleValue) {
            DCFileQueue.wait(context.getPath());
            String realPath = String.valueOf(context.getPath()) + context.getFileName();
            boolean isHighSecurityStorage = DCUtil.isHighSecurityStorage(context.getRepositoryName());
            if (isHighSecurityStorage) {
                DCUtil.getInstance();
                String newFileName = DCUtil.encryptFileName(context.getFileName());
                context.setSecurityFileName(newFileName);
                realPath = String.valueOf(context.getPath()) + newFileName;
            }
            InputStream in = null;
            try {
                InputStream inputStream = in = this.readInputStream(param, realPath, null, 0L, 0L);
                return inputStream;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                context.setDCMessage("error", "\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef[" + e.getMessage() + "]");
                return null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    in = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                FileProcessorEvent.getInstance().handleDownloadCompleteEvent(param, context.getDCProfile().getClazzName());
            }
        }
        if (context.getDCMessage() == null) {
            context.setDCMessage("warning", "\u7a0b\u5e8f\u4e0d\u5141\u8bb8\u4e0b\u8f7d\u8be5\u9644\u4ef6\uff0c\u4e0b\u8f7d\u88ab\u62d2\u7edd");
        }
        return null;
    }

    private boolean vaildateReadContext(DCContext context) {
        if (context == null) {
            return false;
        }
        String appId = context.getAppId();
        if (appId == null || appId.equals("") || AppsAPIManager.getInstance().getAppContext(appId) == null) {
            context.setDCMessage("warning", "\u4e0d\u80fd\u8bc6\u522b\u7684AppId[" + appId + "]\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (context.getFileName() == null || context.getFileName().trim().equals("")) {
            context.setDCMessage("warning", "\u6587\u4ef6\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (context.getGroupValue() == null || context.getGroupValue().trim().equals("")) {
            context.setDCMessage("warning", "groupValue\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (context.getFileValue() == null || context.getFileValue().trim().equals("")) {
            context.setDCMessage("warning", "fileValue\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (context.getRepositoryName() == null || context.getRepositoryName().trim().equals("")) {
            context.setDCMessage("warning", "repositoryName\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (context.getDCProfile() == null) {
            context.setDCMessage("warning", "DCProfile\u6587\u4ef6\u5904\u7406\u5668\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (DCUtil.isDangerFileName(context.getFileName())) {
            context.setDCMessage("warning", "\u6587\u4ef6\u540d\u547d\u540d\u5b58\u5728\u5b89\u5168\u9690\u60a3\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        if (DCUtil.isDangerFileName(context.getRepositoryName())) {
            context.setDCMessage("warning", "RepositoryName\u547d\u540d\u5b58\u5728\u5b89\u5168\u9690\u60a3\uff0c\u8bfb\u6587\u4ef6\u88ab\u62d2\u7edd");
            return false;
        }
        return true;
    }
}

