/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.file;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorEvent;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.i18n.I18nRes;
import java.io.InputStream;
import java.util.HashMap;

public class WriteDCFile {
    private static WriteDCFile writeFile = new WriteDCFile();

    private WriteDCFile() {
    }

    public static WriteDCFile getInstance() {
        return writeFile;
    }

    public boolean write(InputStream in, DCContext context) {
        if (!this.vaildateWriteContext(context)) {
            return false;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("DCContext", context);
        param.put("data", in);
        if (DCUtil.isDiyContent(context.getRepositoryName())) {
            block9: {
                try {
                    boolean handleValue = FileProcessorEvent.getInstance().handleUploadReadyEvent(param, context.getDCProfile().getClazzName());
                    if (handleValue) break block9;
                    context = (DCContext)param.get("DCContext");
                    if (context.getDCMessage() == null) {
                        context.setDCMessage("warning", String.valueOf(I18nRes.findValue("_bpm.platform", "\u7a0b\u5e8f\u4e0d\u5141\u8bb8\u63a5\u6536\u8be5\u9644\u4ef6")) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u4e0a\u4f20\u88ab\u62d2\u7edd"));
                    }
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.platform", I18nRes.getUserLanguage(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25")) + "," + I18nRes.findValue("_bpm.platform", I18nRes.getUserLanguage(), "\u539f\u56e0\u662f") + "[" + e.getMessage() + "]");
                    return false;
                }
            }
            if (context.getDCMessage() == null) {
                context.setDCMessage("ok", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5df2\u63a5\u6536\u5b8c\u6bd5"));
            }
            FileProcessorEvent.getInstance().handleUploadSuccessEvent(param, context.getDCProfile().getClazzName());
            return true;
        }
        boolean handleValue = FileProcessorEvent.getInstance().handleUploadReadyEvent(param, context.getDCProfile().getClazzName());
        if (handleValue) {
            boolean result = DCUtil.handlerWriteDCDefault(in, context, param);
            return result;
        }
        if (context.getDCMessage() == null) {
            context.setDCMessage("warning", String.valueOf(I18nRes.findValue("_bpm.platform", "\u7a0b\u5e8f\u4e0d\u5141\u8bb8\u63a5\u6536\u8be5\u9644\u4ef6")) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u4e0a\u4f20\u88ab\u62d2\u7edd"));
        }
        return false;
    }

    private boolean vaildateWriteContext(DCContext context) {
        if (context == null) {
            return false;
        }
        String appId = context.getAppId();
        if (appId == null || appId.equals("") || AppsAPIManager.getInstance().getAppContext(appId) == null) {
            context.setDCMessage("warning", String.valueOf(I18nRes.findValue("_bpm.platform", "\u4e0d\u80fd\u8bc6\u522b\u7684AppId")) + "[" + appId + "]\uff0c" + I18nRes.findValue("_bpm.platform", "\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (context.getFileName() == null || context.getFileName().trim().equals("")) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (context.getGroupValue() == null || context.getGroupValue().trim().equals("")) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "groupValue\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (context.getFileValue() == null || context.getFileValue().trim().equals("")) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "fileValue\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (context.getRepositoryName() == null || context.getRepositoryName().trim().equals("")) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "repositoryName\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (context.getDCProfile() == null) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "DCProfile\u6587\u4ef6\u5904\u7406\u5668\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (DCUtil.isDangerFileName(context.getFileName())) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u540d\u547d\u540d\u5b58\u5728\u5b89\u5168\u9690\u60a3\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        if (DCUtil.isDangerFileName(context.getRepositoryName())) {
            context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "RepositoryName\u547d\u540d\u5b58\u5728\u5b89\u5168\u9690\u60a3\u5199\u6587\u4ef6\u88ab\u62d2\u7edd"));
            return false;
        }
        return true;
    }
}

