/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.file.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.server.fs.file.model.FileModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class FileDao
extends DaoObject<FileModel> {
    public static final String ENTITYNAME = "SYS_FILES";

    @Override
    public int insert(FileModel model) throws AWSDataAccessException {
        model.setId(UUIDGener.getUUID());
        if (model.getCreateDate() == null) {
            model.setCreateDate(new Timestamp(new Date().getTime()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ID", model.getId());
        params.put("APPID", model.getAppId());
        params.put("CLOUDAPPID", model.getCloudAppId());
        params.put("CLOUDID", model.getCloudId());
        params.put("CLOUDINFO", model.getCloudInfo());
        params.put("CREATEDATE", model.getCreateDate());
        params.put("CREATEUSER", model.getCreateUser());
        params.put("ISCLOUD", model.isCloud());
        params.put("ISPUSH", model.isPush());
        params.put("GROUPVALUE", model.getGroupValue());
        params.put("FILEVALUE", model.getFileValue());
        params.put("REPOSITORYNAME", model.getRepositoryName());
        params.put("FILENAME", model.getFileName());
        params.put("FILESIZE", model.getFileSize());
        String sql = DBSql.getInsertStatement(this.entityName(), params);
        try {
            return DBSql.update(sql, params);
        }
        catch (Exception e) {
            System.err.println(e);
            return 0;
        }
    }

    @Override
    public int update(FileModel model) throws AWSDataAccessException {
        throw new UnsupportedOperationException();
    }

    public List<FileModel> getFileList(String whereClause, Object ... params) {
        String sql = "SELECT * FROM " + this.entityName() + " WHERE " + whereClause + " ORDER BY CREATEDATE DESC";
        List<FileModel> list = DBSql.query(sql, new FileModelMapper(), params);
        return list;
    }

    public boolean delete(String id) {
        int r = super.delete(id);
        return r > 0;
    }

    @Override
    public String entityName() {
        return ENTITYNAME;
    }

    @Override
    public RowMapper<FileModel> rowMapper() {
        return new FileModelMapper();
    }

    private class FileModelMapper
    implements RowMapper<FileModel> {
        private FileModelMapper() {
        }

        public FileModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            FileModel file = new FileModel();
            file.setId(rs.getString("ID"));
            file.setAppId(rs.getString("APPID"));
            file.setCloud(rs.getBoolean("ISCLOUD"));
            file.setPush(rs.getBoolean("ISPUSH"));
            file.setCloudAppId(rs.getString("CLOUDAPPID"));
            file.setCloudId(rs.getString("CLOUDID"));
            file.setCloudInfo(rs.getString("CLOUDINFO"));
            file.setGroupValue(rs.getString("GROUPVALUE"));
            file.setFileValue(rs.getString("FILEVALUE"));
            file.setRepositoryName(rs.getString("REPOSITORYNAME"));
            file.setCreateUser(rs.getString("CREATEUSER"));
            file.setFileName(rs.getString("FILENAME"));
            file.setFileSize(rs.getString("FILESIZE"));
            file.setCreateDate(rs.getTimestamp("CREATEDATE"));
            return file;
        }
    }
}

