/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.cache.FastFiles;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class AppResourceFileProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    @Override
    public boolean uploadReady(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        if (context.getFileValue().equals("installApp") || context.getFileValue().equals("upgradeApp")) {
            InputStream data = (InputStream)param.get("data");
            if (!context.getFileName().endsWith(".app")) {
                context.getDCMessage();
                context.setDCMessage("error", "\u8bf7\u4e0a\u4f20\u4e00\u4e2a\u5408\u6cd5\u7684App\u6587\u4ef6");
                return false;
            }
            String doInstallAppPath = AppInstaller.getUploadPath();
            String targetFileName = String.valueOf(doInstallAppPath) + "/" + context.getFileName();
            UtilFile uf = new UtilFile(targetFileName);
            try {
                FileOutputStream fos = new FileOutputStream(uf);
                UtilIO.copy(data, fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", e.getMessage());
                return false;
            }
        }
        if (context.getFileValue().equals("FormDesigner")) {
            InputStream data = (InputStream)param.get("data");
            String formPath = "../apps/install/" + context.getAppId() + "/" + "template/form";
            String targetFileName = String.valueOf(formPath) + "/" + context.getFileName();
            UtilFile uf = new UtilFile(targetFileName);
            try {
                FileOutputStream fos = new FileOutputStream(uf);
                UtilIO.copy(data, fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", e.getMessage());
                return false;
            }
        }
        if (context.getFileValue().equals("ios") || context.getFileValue().equals("android")) {
            InputStream data = (InputStream)param.get("data");
            String formPath = "../apps/install/" + context.getAppId() + "/" + context.getGroupValue() + "/" + context.getFileValue();
            String targetFileName = String.valueOf(formPath) + "/" + context.getFileName();
            UtilFile uf = new UtilFile(targetFileName);
            try {
                FileOutputStream fos = new FileOutputStream(uf);
                UtilIO.copy(data, fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        List appProfiles;
        DCContext context = (DCContext)param.get("DCContext");
        AppContext app = AppsAPIManager.getInstance().getAppContext(context.getAppId());
        if (app == null) {
            context.setDCMessage("warning", "\u65e0\u6548\u7684AppId[" + context.getAppId() + "]");
            return null;
        }
        InputStream data = null;
        if (context.getGroupValue().equals("icon")) {
            String iconPath = null;
            if (context.getFileValue().equals("16")) {
                iconPath = app.getIcon16FilePath();
            } else if (context.getFileValue().equals("64")) {
                iconPath = app.getIcon64FilePath();
            } else if (context.getFileValue().equals("96")) {
                iconPath = app.getIcon96FilePath();
            } else if (context.getFileValue().equals("image")) {
                iconPath = app.getImageFilePath();
            }
            if (iconPath == null) {
                context.setDCMessage("warning", "\u4e0d\u53ef\u8bc6\u522b\u7684fileValue[" + context.getFileValue() + "]");
                return null;
            }
            byte[] bytes = FastFiles.getFile(iconPath);
            data = new ByteArrayInputStream(bytes);
        } else if (context.getGroupValue().equals("distFile")) {
            String distAppPath = "../apps/dist/" + app.getId() + ".app";
            if (!new File(distAppPath).exists()) {
                context.setDCMessage("warning", "\u6ca1\u6709\u53d1\u73b0\u6587\u4ef6[" + distAppPath + "]");
                return null;
            }
            UtilFile uf = new UtilFile(distAppPath);
            data = new FileInputStream(uf);
        } else if (context.getGroupValue().equals("bpmnimg")) {
            String imgPath = "../apps/install/" + app.getId() + "/" + "repository/process" + "/" + context.getFileValue() + "/" + context.getFileName();
            if (!new File(imgPath).exists()) {
                context.setDCMessage("warning", "\u6ca1\u6709\u53d1\u73b0\u6587\u4ef6[" + imgPath + "]");
                return null;
            }
            UtilFile uf = new UtilFile(imgPath);
            data = new FileInputStream(uf);
        } else if (context.getGroupValue().equals("mobileInstall") && (appProfiles = MobileAppsResource.getListByApp((String)app.getId())).size() > 0) {
            UtilFile uf = new UtilFile(((MobileAppProfile)appProfiles.get(0)).getResourceURI());
            data = new FileInputStream(uf);
        }
        if (data == null) {
            context.setDCMessage("error", "\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u672a\u8bfb\u53d6\u5230\u6570\u636e");
        }
        return data;
    }
}

