/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Map;

public final class FormGridImportProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    @Override
    public boolean uploadReady(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        InputStream data = (InputStream)param.get("data");
        String fileName = context.getFileName();
        if (fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsx")) {
            String newFileName = String.valueOf(UUIDGener.getUUID()) + fileName.substring(fileName.lastIndexOf("."), fileName.length());
            String newfilePath = context.getFilePath().replace(fileName, newFileName);
            String filePath = context.getFilePath().replace(context.getFileName(), "");
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            UtilFile uf = new UtilFile(newfilePath);
            try {
                FileOutputStream fos = new FileOutputStream(uf);
                UtilIO.copy(data, fos);
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                context.setDCMessage("error", e.getMessage());
                return false;
            }
            context.setDCMessage("ok", "");
            context.getDCMessage().addAttr("fileName", newFileName);
            context.getDCMessage().addAttr("originalFileName", fileName);
        } else {
            context.setDCMessage("error", "\u5bfc\u5165\u6587\u4ef6\u5fc5\u987b\u662fExcel\u6587\u4ef6");
        }
        return true;
    }
}

