/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Map;

public class FormLogoFileProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    @Override
    public boolean uploadReady(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        AppContext appContext = SDK.getAppAPI().getAppContext(context.getAppId());
        InputStream data = (InputStream)param.get("data");
        String targetFilePath = "../apps/" + appContext.getWarehouse() + "/" + appContext.getId() + "/formLogo/";
        String filePath = targetFilePath;
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String[] filenames = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".png");
            }
        });
        int tmp = filenames.length;
        String tmpName = "";
        tmpName = tmp < 10 ? "0" + tmp : String.valueOf(tmp);
        UtilFile target = new UtilFile(targetFilePath);
        target.mkdirs();
        String targetFileName = String.valueOf(target.getAbsolutePath()) + "/" + tmpName + ".png";
        UtilFile uf = new UtilFile(targetFileName);
        try {
            FileOutputStream fos = new FileOutputStream(uf);
            UtilIO.copy(data, fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getDCMessage().setType("error");
            context.getDCMessage().setMessage(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        FileInputStream data = null;
        DCContext context = (DCContext)param.get("DCContext");
        AppContext appContext = SDK.getAppAPI().getAppContext(context.getAppId());
        String filePath = "../apps/" + appContext.getWarehouse() + "/" + appContext.getId() + "/formLogo/" + context.getFileName();
        UtilFile uf = new UtilFile(filePath);
        data = new FileInputStream(uf);
        return data;
    }
}

