/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.dao.ProcessRuntimeDaoFactory;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.formfile.FormFileUtil;
import com.actionsoft.bpms.commons.formfile.dao.FormFileDao;
import com.actionsoft.bpms.commons.formfile.model.FormFileModel;
import com.actionsoft.bpms.commons.formfile.model.delegate.FormFile;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.form.engine.FormEngineHelper;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class FormUIFileProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    @Override
    public boolean uploadReady(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        if (context.getRepositoryName().equals("!form-ui-file-")) {
            String remark;
            String appId = context.getAppId();
            InputStream in = (InputStream)param.get("data");
            String configStr = context.getGroupValue();
            JSONObject config = null;
            if (configStr.contains("{")) {
                config = UtilString.isEmpty(configStr) ? new JSONObject() : JSONObject.parseObject((String)configStr);
            }
            String processInstId = config == null ? "" : config.getString("processInstId");
            String taskInstId = config == null ? "" : config.getString("taskInstId");
            String boId = config == null ? "" : config.getString("boId");
            String formFileId = config == null ? "" : config.getString("formFileId");
            String boDefId = config == null ? "" : config.getString("boDefId");
            String boItemName = config == null ? "" : config.getString("boItemName");
            String string = remark = config == null ? "" : config.getString("remark");
            boolean isWPSOA = config == null ? false : config.containsKey((Object)"isWPSOA") && config.getBooleanValue("isWPSOA");
            Boolean copyOnly = config == null ? Boolean.FALSE : config.getBoolean("matrixCopyOnly");
            boolean copyFileOnly = copyOnly == null ? false : copyOnly;
            BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
            boolean isCreate = false;
            if (isWPSOA) {
                FormFileDao dao = new FormFileDao();
                if (UtilString.isEmpty(formFileId)) {
                    isCreate = true;
                    formFileId = UUIDGener.getUUID();
                } else {
                    FormFile formFile = (FormFile)dao.queryById(formFileId);
                    if (formFile == null) {
                        isCreate = true;
                    }
                }
            } else if (UtilString.isEmpty(formFileId)) {
                isCreate = true;
                formFileId = UUIDGener.getUUID();
            }
            String groupValue = formFileId;
            if (copyFileOnly) {
                groupValue = config.getString("groupValue");
            }
            context = new DCContext(context.getSession(), DCProfileManager.getDCProfile(appId, "!form-ui-file-"), appId, groupValue, context.getFileValue(), context.getFileName(), context.getExtParam());
            return this.writeUIFile(context, appId, in, processInstId, taskInstId, boId, boItemName, boModel.getName(), formFileId, remark, isCreate, copyFileOnly);
        }
        return false;
    }

    @Override
    public void uploadSuccess(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        context.setDCMessage("ok", "");
        context.getDCMessage().addAttr("fileName", context.getFileName());
    }

    protected boolean writeUIFile(DCContext context, String appId, InputStream in, String processInstId, String taskInstId, String boId, String boItemName, String boName, String formFileId, String remark, boolean isCreate) {
        return this.writeUIFile(context, appId, in, processInstId, taskInstId, boId, boItemName, boName, formFileId, remark, isCreate, false);
    }

    protected boolean writeUIFile(DCContext context, String appId, InputStream in, String processInstId, String taskInstId, String boId, String boItemName, String boName, String formFileId, String remark, boolean isCreate, boolean copyFileOnly) {
        int fileSize = 0;
        String outFile = String.valueOf(context.getPath()) + context.getFileName();
        boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(boItemName, boName);
        String newFileName = context.getFileName();
        if (isEncrypt) {
            newFileName = DCUtil.encryptFileName(context.getFileName());
        }
        context.setSecurityFileName(newFileName);
        outFile = String.valueOf(context.getPath()) + newFileName;
        FileOutputStream fos = null;
        boolean fosIsClose = false;
        try {
            try {
                File file = new File(context.getPath());
                if (!file.exists()) {
                    file.mkdirs();
                }
                fos = new FileOutputStream(outFile);
                fileSize = UtilIO.copy(in, fos);
                fos.close();
                fosIsClose = true;
                if (isEncrypt) {
                    DCUtil.encryptFile(context);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.platform", I18nRes.getUserLanguage(), "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u539f\u56e0\u662f")) + "[" + e.getMessage() + "]");
                try {
                    if (fos != null && !fosIsClose) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (fos != null && !fosIsClose) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (copyFileOnly) {
            return true;
        }
        FormFileModel model = new FormFileModel();
        model.setId(formFileId);
        model.setAppId(appId);
        model.setBoId(boId);
        model.setBoName(boName);
        if (context.getSession() != null) {
            model.setCreateUser(context.getSession().getUID());
        }
        model.setCreateDate(new Timestamp(new Date().getTime()));
        model.setProcessInstId(processInstId);
        model.setBoItemName(boItemName);
        model.setTaskInstId(taskInstId);
        model.setFileName(context.getFileName());
        model.setFileSize(fileSize);
        model.setRemark(remark);
        FormFileDao dao = new FormFileDao();
        if (isCreate) {
            ProcessDefinition processDefinition;
            ProcessInstance processInst;
            if (HighSecurity.isON() && HighSecurity.isSecurityLevel() && (processInst = ProcessRuntimeDaoFactory.createProcessInstance().getInstance(processInstId)) != null && (processDefinition = (ProcessDefinition)ProcessDefCache.getInstance().getModel(processInst.getProcessDefId())).isSecurityLayer()) {
                String filename = context.getFileName();
                if (filename.contains("\u666e\u901a")) {
                    model.setSecurityLevel(0);
                } else if (filename.contains("\u79d8\u5bc6")) {
                    model.setSecurityLevel(1);
                } else if (filename.contains("\u673a\u5bc6")) {
                    model.setSecurityLevel(2);
                }
            }
            dao.insert(model);
        } else {
            dao.update(formFileId, remark);
        }
        this.auditLog(context, model, "upload");
        return true;
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        String formFileId = context.getGroupValue();
        FormFile formFileModel = (FormFile)new FormFileDao().queryById(formFileId);
        boolean isEncrypt = FormFileUtil.getInstance().isEncrypt(formFileModel.getBoItemName(), formFileModel.getBoName());
        AppContext app = AppsAPIManager.getInstance().getAppContext(context.getAppId());
        if (app == null) {
            context.getDCMessage().setType("warning");
            context.getDCMessage().setMessage(String.valueOf(I18nRes.findValue("_bpm.platform", "\u65e0\u6548\u7684AppId")) + "[" + context.getAppId() + "]");
            return null;
        }
        String newFileName = context.getFileName();
        if (isEncrypt) {
            newFileName = DCUtil.encryptFileName(context.getFileName());
        }
        context.setSecurityFileName(newFileName);
        InputStream in = null;
        if (!isEncrypt) {
            String realPath = String.valueOf(context.getPath()) + context.getSecurityFileName();
            try {
                in = new FileInputStream(realPath);
                int len = in.available();
                if (len > 0) {
                    byte[] buf = new byte[len];
                    in.read(buf, 0, len);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
                    this.auditLog(context, formFileModel, "download");
                    ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                    return byteArrayInputStream2;
                }
                context.setDCMessage("warning", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u4e0d\u53ef\u8bfb"));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            {
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        context.setDCMessage("ok", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5df2\u8bfb\u53d6\u5b8c\u6bd5"));
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
            {
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.platform", "\u8bfb\u53d6\u6587\u4ef6\u53d1\u751f\u9519\u8bef")) + "[" + e.getMessage() + "]");
                return null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    in = null;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        in = DCUtil.decryptFile(context);
        this.auditLog(context, formFileModel, "download");
        return in;
    }

    private void auditLog(DCContext context, FormFile formFileModel, String op) {
        FormEngineHelper.getInstance().operateAuditLog(context, formFileModel, op);
    }
}

