/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.bpms.commons.cache.FastFiles;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.model.impl.UserModelImpl;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.i18n.I18nRes;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;

public final class PhotoProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    private static final String[] images = new String[]{"png", "jpg", "jpeg", "gif"};
    private static final String tempSuffix = "_big";

    public static boolean isPhotoFile(String fn) {
        if (fn.indexOf(".") == -1) {
            return false;
        }
        fn = fn.toLowerCase();
        String[] stringArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String image = stringArray[n2];
            if (fn.endsWith("." + (image = image.toLowerCase()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getPhotoFileSuffix(String fn) {
        String suffix = fn.substring(fn.lastIndexOf("."));
        return suffix;
    }

    public static String getPhotoUrl(UserContext me, String uid) {
        DCContext dc = PhotoProcessor.getDCContext(me, uid);
        if (dc == null) {
            return "../commons/img/photo.png";
        }
        return String.valueOf(dc.getDownloadURL()) + "&lastModified=" + dc.getFileLastModified();
    }

    public static String getTmpPhotoUrl(UserContext me, String uid) {
        DCContext dc = PhotoProcessor.getTmpDCContext(me, uid);
        if (dc == null) {
            return "";
        }
        return dc.getDownloadURL();
    }

    public static DCContext getDCContext(UserContext me, String uid) {
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            return null;
        }
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", uid, user.getUniqueId(), "");
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.contains(String.valueOf(uid) + ".")) {
                return new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", uid, user.getUniqueId(), fileName);
            }
            ++n2;
        }
        return null;
    }

    public static DCContext getTmpDCContext(UserContext me, String uid) {
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            return null;
        }
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", uid, user.getUniqueId(), "");
        String tmpFileName = String.valueOf(uid) + tempSuffix;
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.contains(tmpFileName)) {
                return new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", uid, user.getUniqueId(), fileName);
            }
            ++n2;
        }
        return null;
    }

    public static DCContext getDCContextOutFile(UserContext me, String uid) {
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", uid, user.getUniqueId());
    }

    public static DCContext getTmpDCContextOutFile(UserContext me, String uid) {
        UserModel user = UserCache.getModel((String)uid);
        if (user == null) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile("_bpm.platform", "!photo-"), "_bpm.platform", String.valueOf(uid) + tempSuffix, user.getUniqueId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean uploadReady(Map<String, Object> param) {
        int height;
        int width;
        DCContext context;
        block70: {
            File file;
            int n;
            int n2;
            File[] fileArray;
            File folder;
            context = (DCContext)param.get("DCContext");
            String postfix = context.getFileName();
            if (!PhotoProcessor.isPhotoFile(postfix)) {
                context.setDCMessage("error", I18nRes.findValue("_bpm.portal", context.getSession().getLanguage(), "\u4e0d\u652f\u6301\u7684\u5934\u50cf\u56fe\u7247\u7c7b\u578b"));
                return false;
            }
            boolean fromMobile = false;
            if (context.getFileName().contains(String.valueOf(context.getGroupValue()) + "_" + context.getFileValue())) {
                fromMobile = true;
                folder = new File(context.getPath());
                if (!folder.exists()) {
                    folder.mkdirs();
                } else {
                    fileArray = folder.listFiles();
                    n2 = fileArray.length;
                    n = 0;
                    while (n < n2) {
                        file = fileArray[n];
                        file.delete();
                        ++n;
                    }
                }
                context.setFileName(String.valueOf(context.getGroupValue()) + PhotoProcessor.getPhotoFileSuffix(postfix));
            } else {
                folder = new File(context.getPath());
                if (!folder.exists()) {
                    folder.mkdirs();
                } else {
                    fileArray = folder.listFiles();
                    n2 = fileArray.length;
                    n = 0;
                    while (n < n2) {
                        file = fileArray[n];
                        if (file.getName().contains(String.valueOf(context.getGroupValue()) + tempSuffix)) {
                            file.delete();
                        }
                        ++n;
                    }
                }
                context.setFileName(String.valueOf(context.getGroupValue()) + tempSuffix + PhotoProcessor.getPhotoFileSuffix(postfix));
            }
            DataInputStream data = (DataInputStream)param.get("data");
            FilterOutputStream os = null;
            FastFiles.removeFile(String.valueOf(context.getPath()) + context.getFileName());
            File tempImage = new File(String.valueOf(context.getPath()) + context.getFileName());
            try {
                try {
                    os = new DataOutputStream(new FileOutputStream(tempImage));
                    UtilIO.copy(data, os);
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    context.setDCMessage("error", e.getMessage());
                    if (os == null) return false;
                    try {
                        os.close();
                        return false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
            width = 0;
            height = 0;
            try {
                block69: {
                    int orientation;
                    int degree;
                    BufferedImage bi = ImageIO.read(tempImage);
                    if (bi == null) {
                        context.setDCMessage("error", I18nRes.findValue("_bpm.portal", "\u8bfb\u53d6\u56fe\u50cf\u51fa\u9519!"));
                        return false;
                    }
                    width = bi.getWidth();
                    height = bi.getHeight();
                    if (width < 120 || height < 120) {
                        tempImage.delete();
                        context.setDCMessage("error", I18nRes.findValue("_bpm.portal", "\u5934\u50cf\u56fe\u7247\u5bbd\u548c\u9ad8\u4e0d\u80fd\u5c0f\u4e8e120\u50cf\u7d20"));
                        return false;
                    }
                    Metadata metadata = ImageMetadataReader.readMetadata((File)tempImage);
                    Directory exif = null;
                    Iterator iterator = metadata.getDirectoriesOfType(ExifIFD0Directory.class).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (exif != null) {
                                degree = 0;
                                orientation = 0;
                                try {
                                    orientation = exif.getInt(274);
                                }
                                catch (MetadataException e) {
                                    e.printStackTrace();
                                }
                                break;
                            }
                            break block69;
                        }
                        Directory directory = (Directory)iterator.next();
                        if (!directory.containsTag(274)) continue;
                        exif = directory;
                    }
                    switch (orientation) {
                        case 1: {
                            degree = 0;
                            break;
                        }
                        case 2: {
                            degree = 0;
                            break;
                        }
                        case 3: {
                            degree = 180;
                            break;
                        }
                        case 4: {
                            degree = 0;
                            break;
                        }
                        case 5: {
                            degree = 270;
                            break;
                        }
                        case 6: {
                            degree = 90;
                            break;
                        }
                        case 7: {
                            degree = 90;
                            break;
                        }
                        case 8: {
                            degree = 270;
                            break;
                        }
                        default: {
                            degree = 0;
                        }
                    }
                    if (degree != 0) {
                        BufferedImage img;
                        String format = PhotoProcessor.getPhotoFileSuffix(postfix).toUpperCase();
                        int type = bi.getColorModel().getTransparency();
                        if (degree == 180) {
                            img = new BufferedImage(width, height, type);
                            Graphics2D graphics2d = img.createGraphics();
                            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                            graphics2d.drawImage((Image)bi, 0, 0, null);
                            graphics2d.dispose();
                            ImageIO.write((RenderedImage)img, format, tempImage);
                        } else if (degree == 90 || degree == 270) {
                            width = bi.getHeight();
                            height = bi.getWidth();
                            img = new BufferedImage(width, height, type);
                            Graphics2D graphics2d = img.createGraphics();
                            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                            int x = 0;
                            int y = 0;
                            if (width > height) {
                                x = -(height - width) / 2;
                                y = (height - width) / 2;
                            } else {
                                y = -(width - height) / 2;
                                x = (width - height) / 2;
                            }
                            graphics2d.drawImage((Image)bi, x, y, null);
                            graphics2d.dispose();
                            ImageIO.write((RenderedImage)img, format, tempImage);
                        }
                    }
                }
                if (!fromMobile) break block70;
                FilterOutputStream bigOS = null;
                DataInputStream in = null;
                File bigImage = new File(String.valueOf(context.getPath()) + context.getGroupValue() + tempSuffix + PhotoProcessor.getPhotoFileSuffix(postfix));
                try {
                    try {
                        in = new DataInputStream(new FileInputStream(tempImage));
                        bigOS = new DataOutputStream(new FileOutputStream(bigImage));
                        UtilIO.copy(in, bigOS);
                        bigOS.close();
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        context.setDCMessage("error", e.getMessage());
                        if (bigOS != null) {
                            try {
                                bigOS.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (in == null) return false;
                        try {
                            in.close();
                            return false;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return false;
                    }
                }
                finally {
                    if (bigOS != null) {
                        try {
                            bigOS.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.portal", "\u56fe\u7247\u5904\u7406\u51fa\u9519")) + "\uff1a" + e.getMessage());
                return false;
            }
            catch (ImageProcessingException e1) {
                e1.printStackTrace();
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.portal", "\u56fe\u7247\u5904\u7406\u51fa\u9519")) + "\uff1a" + e1.getMessage());
                return false;
            }
        }
        context.setDCMessage("ok", "");
        context.getDCMessage().addAttr("fileName", context.getFileName());
        String url = String.valueOf(context.getDownloadURL()) + "&lastModified=" + context.getFileLastModified();
        context.getDCMessage().addAttr("url", url);
        context.getDCMessage().addAttr("width", width);
        context.getDCMessage().addAttr("height", height);
        return true;
    }

    @Override
    public void uploadSuccess(Map<String, Object> param) {
        String[] stringArray;
        DCContext context = (DCContext)param.get("DCContext");
        UserModel user = UserCache.getModel((String)context.getGroupValue());
        if (user == null) {
            return;
        }
        File dir = new File(context.getPath());
        if (dir != null && dir.exists() && (stringArray = dir.list()).length != 0) {
            String fileName = stringArray[0];
            File photoFile = new File(String.valueOf(dir.getPath()) + "/" + fileName);
            ((UserModelImpl)user).setPhotoLastModified(photoFile.lastModified());
        }
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        byte[] bytes = FastFiles.getFile(context.getFilePath());
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void downloadComplete(Map<String, Object> param) {
        super.downloadComplete(param);
    }
}

