/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.model.impl.UserModelImpl;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.i18n.I18nRes;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public final class PictureProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    private static final String[] images = new String[]{"png", "jpg", "jpeg", "gif"};
    private static final String tempSuffix = "_big";

    public static boolean isPhotoFile(String fn) {
        if (fn.indexOf(".") == -1) {
            return false;
        }
        fn = fn.toLowerCase();
        String[] stringArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String image = stringArray[n2];
            if (fn.endsWith("." + (image = image.toLowerCase()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getPhotoFileSuffix(String fn) {
        String suffix = fn.substring(fn.lastIndexOf("."));
        return suffix;
    }

    public static String getPictureUrl(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = PictureProcessor.getDCContext(me, appId, groupValue, fileValue, repositoryName, fileName);
        if (dc == null) {
            return "../commons/img/photo.png";
        }
        return dc.getDownloadURL();
    }

    public static String getTmpPictureUrl(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = PictureProcessor.getDCContext(me, appId, groupValue, fileValue, repositoryName, fileName);
        if (dc == null) {
            return "";
        }
        return dc.getDownloadURL();
    }

    public static DCContext getDCContext(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        return dc;
    }

    public static DCContext getTmpDCContext(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        return dc;
    }

    public static DCContext getDCContextOutFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
    }

    public static DCContext getTmpDCContextOutFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
    }

    @Override
    public boolean uploadReady(Map<String, Object> param) {
        int height;
        int width;
        String uuid;
        String fileName;
        DCContext context;
        block43: {
            BufferedImage bi;
            File tempImage;
            block42: {
                block41: {
                    context = (DCContext)param.get("DCContext");
                    fileName = context.getFileName();
                    context.setFileNameShow(fileName);
                    if (!PictureProcessor.isPhotoFile(fileName)) {
                        context.setDCMessage("error", I18nRes.findValue("_bpm.portal", context.getSession().getLanguage(), "\u4e0d\u652f\u6301\u7684\u5934\u50cf\u56fe\u7247\u7c7b\u578b"));
                        return false;
                    }
                    File folder = new File(context.getPath());
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    uuid = UUIDGener.getUUID();
                    context.setFileName(String.valueOf(uuid) + tempSuffix + PictureProcessor.getPhotoFileSuffix(fileName));
                    DataInputStream data = (DataInputStream)param.get("data");
                    FilterOutputStream os = null;
                    tempImage = new File(String.valueOf(context.getPath()) + context.getFileName());
                    try {
                        try {
                            os = new DataOutputStream(new FileOutputStream(tempImage));
                            UtilIO.copy(data, os);
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            context.setDCMessage("error", e.getMessage());
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return false;
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    width = 0;
                    height = 0;
                    bi = ImageIO.read(tempImage);
                    if (bi != null) break block41;
                    context.setDCMessage("error", I18nRes.findValue("_bpm.portal", "\u8bfb\u53d6\u56fe\u50cf\u51fa\u9519!"));
                    return false;
                }
                width = bi.getWidth();
                height = bi.getHeight();
                if (width >= 120 && height >= 120) break block42;
                tempImage.delete();
                context.setDCMessage("error", "\u5934\u50cf\u56fe\u7247\u5bbd\u548c\u9ad8\u4e0d\u80fd\u5c0f\u4e8e120\u50cf\u7d20");
                return false;
            }
            try {
                Metadata metadata = ImageMetadataReader.readMetadata((File)tempImage);
                Directory exif = null;
                for (Directory directory : metadata.getDirectoriesOfType(ExifIFD0Directory.class)) {
                    if (!directory.containsTag(274)) continue;
                    exif = directory;
                }
                if (exif == null) break block43;
                int degree = 0;
                int orientation = 0;
                try {
                    orientation = exif.getInt(274);
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                switch (orientation) {
                    case 1: {
                        degree = 0;
                        break;
                    }
                    case 2: {
                        degree = 0;
                        break;
                    }
                    case 3: {
                        degree = 180;
                        break;
                    }
                    case 4: {
                        degree = 0;
                        break;
                    }
                    case 5: {
                        degree = 270;
                        break;
                    }
                    case 6: {
                        degree = 90;
                        break;
                    }
                    case 7: {
                        degree = 90;
                        break;
                    }
                    case 8: {
                        degree = 270;
                        break;
                    }
                    default: {
                        degree = 0;
                    }
                }
                if (degree != 0) {
                    int type = bi.getColorModel().getTransparency();
                    if (degree == 180) {
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        graphics2d.drawImage((Image)bi, 0, 0, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                    } else if (degree == 90 || degree == 270) {
                        width = bi.getHeight();
                        height = bi.getWidth();
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        int x = 0;
                        int y = 0;
                        if (width > height) {
                            x = -(height - width) / 2;
                            y = (height - width) / 2;
                        } else {
                            y = -(width - height) / 2;
                            x = (width - height) / 2;
                        }
                        graphics2d.drawImage((Image)bi, x, y, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.portal", "\u56fe\u7247\u5904\u7406\u51fa\u9519")) + "\uff1a" + e.getMessage());
                return false;
            }
            catch (JpegProcessingException e1) {
                e1.printStackTrace();
            }
            catch (ImageProcessingException e1) {
                e1.printStackTrace();
                context.setDCMessage("error", String.valueOf(I18nRes.findValue("_bpm.portal", "\u56fe\u7247\u5904\u7406\u51fa\u9519")) + "\uff1a" + e1.getMessage());
                return false;
            }
        }
        context.setDCMessage("ok", "");
        context.getDCMessage().addAttr("fileName", context.getFileName());
        context.getDCMessage().addAttr("fileUUID", uuid);
        context.getDCMessage().addAttr("actFileName", fileName);
        context.getDCMessage().addAttr("url", context.getStremURL());
        context.getDCMessage().addAttr("width", width);
        context.getDCMessage().addAttr("height", height);
        return true;
    }

    @Override
    public void uploadSuccess(Map<String, Object> param) {
        String[] stringArray;
        DCContext context = (DCContext)param.get("DCContext");
        UserModel user = UserCache.getModel((String)context.getGroupValue());
        if (user == null) {
            return;
        }
        File dir = new File(context.getPath());
        if (dir != null && dir.exists() && (stringArray = dir.list()).length != 0) {
            String fileName = stringArray[0];
            File photoFile = new File(String.valueOf(dir.getPath()) + "/" + fileName);
            ((UserModelImpl)user).setPhotoLastModified(photoFile.lastModified());
        }
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        FileInputStream fis = new FileInputStream(context.getFilePath());
        return fis;
    }

    @Override
    public void downloadComplete(Map<String, Object> param) {
        super.downloadComplete(param);
    }
}

