/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.impl;

import com.actionsoft.bpms.server.DeveloperKey;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilIO;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;

public class TempFileProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    @Override
    public void uploadSuccess(Map<String, Object> param) {
        DCContext context = (DCContext)param.get("DCContext");
        String groupValue = context.getGroupValue();
        if (groupValue.equals("appicon")) {
            boolean flag = this.img(context);
            if (flag) {
                block29: {
                    String osFolderType = context.getFileValue();
                    File tempImage = new File(String.valueOf(context.getPath()) + context.getFileName());
                    int width = 0;
                    int height = 0;
                    context.setDCMessage("ok", "");
                    try {
                        BufferedImage bi = ImageIO.read(tempImage);
                        if (bi != null) {
                            width = bi.getWidth();
                            height = bi.getHeight();
                            context.getDCMessage().addAttr("width", width);
                            context.getDCMessage().addAttr("height", height);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (width == 96) {
                        context.setFileName("icon96_01.png");
                    } else if (width == 64) {
                        context.setFileName("icon64_01.png");
                    } else {
                        context.setFileName("icon16_01.png");
                    }
                    File iconImg = new File(String.valueOf(context.getPath()) + context.getFileName());
                    DataInputStream is = null;
                    FilterOutputStream os = null;
                    try {
                        try {
                            FileInputStream oo = new FileInputStream(tempImage);
                            is = new DataInputStream(oo);
                            os = new DataOutputStream(new FileOutputStream(iconImg));
                            UtilIO.copy(is, os);
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            context.setDCMessage("error", e.getMessage());
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                context.getDCMessage().addAttr("fileName", context.getFileName());
                String url = context.getDownloadURL();
                context.getDCMessage().addAttr("url", url);
            }
        } else if (groupValue.equals("developcer")) {
            String developerpath = "../apps/developer.csr";
            File sourceFile = new File(context.getFilePath());
            File targetFile = new File(developerpath);
            try {
                UtilFile.moveFile(sourceFile, targetFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DeveloperKey.reload();
            boolean isISVKey = DeveloperKey.isISVKey();
            if (isISVKey) {
                context.setDCMessage("ok", "");
                context.getDCMessage().addAttr("fileName", "developer.csr");
                context.getDCMessage().addAttr("developername", DeveloperKey.getDeveloperName());
                context.getDCMessage().addAttr("expirationDate", DeveloperKey.getExpirationDate());
                String url = context.getDownloadURL();
                context.getDCMessage().addAttr("url", url);
            } else {
                targetFile.delete();
            }
        }
    }

    public boolean img(DCContext context) {
        block27: {
            BufferedImage bi;
            int height;
            int width;
            File tempImage;
            block26: {
                block25: {
                    tempImage = new File(String.valueOf(context.getPath()) + context.getFileName());
                    width = 0;
                    height = 0;
                    bi = ImageIO.read(tempImage);
                    if (bi != null) break block25;
                    context.setDCMessage("error", "\u8bfb\u53d6\u56fe\u50cf\u51fa\u9519!");
                    return false;
                }
                width = bi.getWidth();
                height = bi.getHeight();
                if (width == 16 && height == 16 || width == 64 && height == 64 || width == 96 && height == 96) break block26;
                tempImage.delete();
                context.setDCMessage("error", "\u56fe\u7247\u5bbd\u548c\u9ad8\u4e0d\u7b26\u5408\u6761\u4ef6,\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return false;
            }
            try {
                Metadata metadata = ImageMetadataReader.readMetadata((File)tempImage);
                Directory exif = null;
                for (Directory directory : metadata.getDirectoriesOfType(ExifIFD0Directory.class)) {
                    if (!directory.containsTag(274)) continue;
                    exif = directory;
                }
                if (exif == null) break block27;
                int degree = 0;
                int orientation = 0;
                try {
                    orientation = exif.getInt(274);
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                switch (orientation) {
                    case 1: {
                        degree = 0;
                        break;
                    }
                    case 2: {
                        degree = 0;
                        break;
                    }
                    case 3: {
                        degree = 180;
                        break;
                    }
                    case 4: {
                        degree = 0;
                        break;
                    }
                    case 5: {
                        degree = 270;
                        break;
                    }
                    case 6: {
                        degree = 90;
                        break;
                    }
                    case 7: {
                        degree = 90;
                        break;
                    }
                    case 8: {
                        degree = 270;
                        break;
                    }
                    default: {
                        degree = 0;
                    }
                }
                if (degree != 0) {
                    int type = bi.getColorModel().getTransparency();
                    if (degree == 180) {
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        graphics2d.drawImage((Image)bi, 0, 0, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                    } else if (degree == 90 || degree == 270) {
                        width = bi.getHeight();
                        height = bi.getWidth();
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        int x = 0;
                        int y = 0;
                        if (width > height) {
                            x = -(height - width) / 2;
                            y = (height - width) / 2;
                        } else {
                            y = -(width - height) / 2;
                            x = (width - height) / 2;
                        }
                        graphics2d.drawImage((Image)bi, x, y, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.setDCMessage("error", "\u56fe\u7247\u5904\u7406\u51fa\u9519\uff1a" + e.getMessage());
                return false;
            }
            catch (JpegProcessingException e1) {
                e1.printStackTrace();
            }
            catch (ImageProcessingException e1) {
                e1.printStackTrace();
                context.setDCMessage("error", "\u56fe\u7247\u5904\u7406\u51fa\u9519\uff1a" + e1.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        FileInputStream webicon = new FileInputStream(context.getFilePath());
        return webicon;
    }
}

