/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.fs.web;

import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.commons.formfile.dao.FormFileDao;
import com.actionsoft.bpms.commons.formfile.model.FormFileModel;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.form.engine.FormEngineHelper;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorEvent;
import com.actionsoft.bpms.server.fs.dc.DCMessage;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.server.fs.dc.cloud.AbstractCloudFileProcessor;
import com.actionsoft.bpms.server.fs.dc.cloud.CloudDCProfileManager;
import com.actionsoft.bpms.server.fs.file.dao.FileDao;
import com.actionsoft.bpms.server.fs.file.model.FileModel;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jodd.util.StringUtil;

public class CloudFileWeb
extends ActionWeb {
    private UserContext _me;

    public CloudFileWeb(UserContext me) {
        this._me = me;
    }

    public static boolean isMobile(UserContext userContext) {
        return FormEngineHelper.getInstance().isMobileDevice(userContext);
    }

    public String getCloudDCPullHomePage(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boDefId, String boName, String boItemName, String boId, String processInstId, String taskInstId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", DispatcherRequest.getUserContext().getSessionId());
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        StringBuilder tabs = new StringBuilder();
        StringBuilder contents = new StringBuilder();
        JSONArray profiles = new JSONArray();
        List<CloudDCPluginProfile> profileList = CloudDCProfileManager.getPullProfileList();
        for (CloudDCPluginProfile profile : profileList) {
            JSONObject profileJ = new JSONObject();
            profileJ.put("appId", (Object)profile.getAppContext().getId());
            profileJ.put("cloudId", (Object)profile.getCloudId());
            profileJ.put("cloudName", (Object)profile.getName());
            profiles.add((Object)profileJ);
            tabs.append("<a cloudid=\"").append(profile.getCloudId()).append("\" cloudappid=\"").append(profile.getAppContext().getId()).append("\" tit=\"").append(profile.getCloudId()).append("\" >").append(profile.getName()).append("</a>");
            contents.append("<div tit=\"").append(profile.getCloudId()).append("\"  style=\"height:100%\">\n\t\t<iframe width=\"100%\" id=\"").append(profile.getCloudId()).append("\" name=\"").append(profile.getCloudId()).append("\" frameborder=\"0\" style=\"height:100%;\" src=\"\"></iframe>\n\t</div>");
        }
        macroLibraries.put("appId", appId);
        macroLibraries.put("groupValue", groupValue);
        macroLibraries.put("fileValue", fileValue);
        macroLibraries.put("repositoryName", repositoryName);
        macroLibraries.put("boItemName", boItemName);
        macroLibraries.put("boName", boName);
        macroLibraries.put("boId", boId);
        macroLibraries.put("processInstId", processInstId);
        macroLibraries.put("taskInstId", taskInstId);
        macroLibraries.put("boDefId", boDefId);
        macroLibraries.put("profiles", profiles);
        macroLibraries.put("tabs", tabs);
        macroLibraries.put("contents", contents);
        return HtmlPageTemplate.merge("_bpm.portal", "client.common.file.cloulddc.pull_home.htm", macroLibraries);
    }

    public String getCloudDCPullPage(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boDefId, String boName, String boItemName, String boId, String processInstId, String taskInstId, String cloudId, String cloudAppId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", DispatcherRequest.getUserContext().getSessionId());
        BOModel boModel = (BOModel)BOCache.getInstance().getModel(boDefId);
        String clazzName = "";
        CloudDCPluginProfile profile = CloudDCProfileManager.getDCProfile(cloudAppId, cloudId);
        clazzName = profile.getClazzName();
        AbstractCloudFileProcessor cloudFile = CloudDCProfileManager.getCloudFileObject(clazzName, cloudAppId, cloudId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", me.getUID());
        String fileHtml = cloudFile.getCloudFileHtml(param);
        macroLibraries.put("fileHtml", fileHtml);
        macroLibraries.put("cloudId", cloudId);
        macroLibraries.put("cloudAppId", cloudAppId);
        macroLibraries.put("appId", appId);
        macroLibraries.put("groupValue", JavascriptEscape.unescape(groupValue));
        macroLibraries.put("fileValue", fileValue);
        macroLibraries.put("repositoryName", repositoryName);
        macroLibraries.put("boItemName", boItemName);
        macroLibraries.put("boName", boName);
        macroLibraries.put("boId", boId);
        macroLibraries.put("processInstId", processInstId);
        macroLibraries.put("taskInstId", taskInstId);
        macroLibraries.put("boDefId", boDefId);
        return HtmlPageTemplate.merge("_bpm.portal", "client.common.file.cloulddc.pull.htm", macroLibraries);
    }

    public String saveCloudDC2UIFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boName, String boItemName, String boId, String processInstId, String taskInstId, String remark, boolean isCreate, String cloudId, String cloudAppId, String files, String boDefId) {
        ArrayList fileNames = new ArrayList();
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONArray datas = new JSONArray();
        if (UtilString.isNotEmpty(files)) {
            JSONArray fileArray = JSONArray.parseArray((String)files);
            for (Object o : fileArray) {
                FileDao fileDao = new FileDao();
                JSONObject file = (JSONObject)o;
                DCContext context = new DCContext(this.getContext(), DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, file.getString("fileName"));
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("DCContext", context);
                param.put("fileSize", file.getInteger("fileSize"));
                boolean handleValue = true;
                DCMessage oldMessage = null;
                String showName = "";
                if (!repositoryName.equals("!form-ui-file-")) {
                    handleValue = FileProcessorEvent.getInstance().handleUploadReadyEvent(param, context.getDCProfile().getClazzName());
                    oldMessage = context.getDCMessage();
                    showName = context.getFileNameShow();
                }
                if (!handleValue || repositoryName.equals("!form-ui-file-")) continue;
                String fileName = context.getFileName();
                List<FileModel> fileList = fileDao.getFileList("GROUPVALUE = ? AND FILEVALUE = ? AND REPOSITORYNAME = ? AND FILENAME = ?", groupValue, fileValue, repositoryName, fileName);
                if (fileList == null || fileList.size() == 0) {
                    String id = UUIDGener.getUUID();
                    FileModel fileModel = new FileModel();
                    fileModel.setId(id);
                    fileModel.setFileSize(file.getString("fileSize"));
                    fileModel.setFileName(fileName);
                    fileModel.setCloudInfo(file.getString("cloudInfo"));
                    fileModel.setCloud(true);
                    fileModel.setPush(false);
                    fileModel.setCloudId(file.getString("cloudId"));
                    fileModel.setCloudAppId(file.getString("cloudAppId"));
                    fileModel.setCreateUser(this.getContext().getUID());
                    fileModel.setGroupValue(groupValue);
                    fileModel.setFileValue(fileValue);
                    fileModel.setRepositoryName(repositoryName);
                    fileModel.setAppId(appId);
                    fileDao.insert(fileModel);
                }
                if (repositoryName.equals("!form-ui-file-")) {
                    isCreate = true;
                    String formFileId = UUIDGener.getUUID();
                    JSONObject cloudInfoJ = new JSONObject();
                    cloudInfoJ.put("cloudInfo", (Object)file.getString("cloudInfo"));
                    cloudInfoJ.put("cloudAppId", (Object)cloudAppId);
                    cloudInfoJ.put("cloudId", (Object)cloudId);
                    cloudInfoJ.put("isPush", (Object)false);
                    FormFileModel model = new FormFileModel();
                    model.setId(formFileId);
                    model.setAppId(appId);
                    model.setBoId(boId);
                    model.setBoName(boName);
                    model.setCreateUser(me.getUID());
                    model.setCreateDate(new Timestamp(new Date().getTime()));
                    model.setProcessInstId(processInstId);
                    model.setBoItemName(boItemName);
                    model.setTaskInstId(taskInstId);
                    model.setFileName(file.getString("fileName"));
                    model.setFileSize(Long.parseLong(file.getString("fileSize")));
                    model.setRemark(remark);
                    model.setCloudInfo(cloudInfoJ.toString());
                    FormFileDao dao = new FormFileDao();
                    if (isCreate) {
                        dao.insert(model);
                    } else {
                        dao.update(formFileId, remark);
                    }
                    try {
                        String auditObject = "\u9644\u4ef6\u540d\u79f0\uff1a" + model.getFileName();
                        String fileLevelText = "\u666e\u901a";
                        int fileLevel = model.getSecurityLevel();
                        if (fileLevel == 1) {
                            fileLevelText = "\u79d8\u5bc6";
                        } else if (fileLevel == 2) {
                            fileLevelText = "\u673a\u5bc6";
                        } else if (fileLevel == 3) {
                            fileLevelText = "\u7edd\u5bc6";
                        }
                        String auditInfo = "\u9644\u4ef6\u7ea7\u522b\uff1a" + fileLevelText + "\uff0c\u9644\u4ef6\u540d\u79f0\uff1a" + model.getFileName() + "\uff0c\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + model.getProcessInstId() + "\uff0c\u4efb\u52a1\u5b9e\u4f8b\uff1a" + model.getTaskInstId();
                        FormEngineHelper.getInstance().operateAuditLog("client", me, me.getUID(), "upload", auditObject, auditInfo, Level.INFO);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                context = new DCContext(this.getContext(), DCProfileManager.getDCProfile(appId, repositoryName), appId, groupValue, fileValue, fileName);
                if (oldMessage != null) {
                    context.setDCMessage(oldMessage);
                }
                if (StringUtil.isNotEmpty((CharSequence)showName)) {
                    context.setFileNameShow(showName);
                }
                param.put("DCContext", context);
                if (DCUtil.isHighSecurityStorage(context.getRepositoryName())) {
                    FileProcessorEvent.getInstance().handleUploadBeforeEncryptEvent(param, context.getDCProfile().getClazzName());
                }
                FileProcessorEvent.getInstance().handleUploadSuccessEvent(param, context.getDCProfile().getClazzName());
                JSONObject data = new JSONObject();
                data.put("data", (Object)context.getDCMessage());
                data.put("result", (Object)"ok");
                JSONObject result = new JSONObject();
                JSONObject f = new JSONObject();
                f.put("size", (Object)file.getString("fileSize"));
                f.put("name", (Object)file.getString("fileName"));
                String fileSuffix = file.getString("fileName").substring(file.getString("fileName").lastIndexOf("\\.") + 1);
                f.put("type", (Object)fileSuffix);
                result.put("data", (Object)data);
                result.put("files", (Object)f);
                datas.add((Object)result);
            }
        }
        ro.put("datas", datas);
        return ro.toString();
    }

    public String ifSupportCloudDC() {
        boolean ifSupportCloudDC = false;
        ResponseObject ro = ResponseObject.newOkResponse();
        List<CloudDCPluginProfile> profileList = CloudDCProfileManager.getPullProfileList();
        if (profileList.size() > 0) {
            ifSupportCloudDC = true;
        }
        ro.put("ifSupportCloudDC", ifSupportCloudDC);
        return ro.toString();
    }
}

