/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.shellcommand;

import com.actionsoft.apps.lifecycle.AppDist;
import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.AppServiceController;
import com.actionsoft.apps.lifecycle.AppUninstaller;
import com.actionsoft.apps.lifecycle.AppUpgrader;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.install.InstallDictPackage;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppDependencyHelper;
import com.actionsoft.apps.resource.AppsResource;
import com.actionsoft.bpms.server.apps.AppCmd;
import com.actionsoft.bpms.server.apps.AppController;
import com.actionsoft.bpms.server.apps.AppLoader;
import com.actionsoft.bpms.server.apps.AppsLoader;
import com.actionsoft.bpms.server.shellcommand.BaseCommand;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppCommand
implements BaseCommand {
    private AppContext getAppId(String str) {
        str = str.trim();
        AppContext context = AppsAPIManager.getInstance().getAppContext(str);
        if (context == null) {
            int count = 0;
            List list = AppsResource.getInstalledApps();
            for (AppContext app : list) {
                if (app.getId().indexOf(str) <= -1) continue;
                ++count;
                context = app;
            }
            if (count == 1) {
                return context;
            }
            if (count > 1) {
                System.out.println("\u540d\u79f0[" + str + "]\u88ab\u591a\u4e2aAppId\u6a21\u7cca\u547d\u4e2d\uff0c\u4e0d\u80fd\u81ea\u52a8\u8bc6\u522b!");
                return null;
            }
        }
        return context;
    }

    public boolean executeCommand(String cmd) {
        if (cmd.indexOf("start app") == 0) {
            String appId = cmd.substring(9).trim();
            if (appId.length() > 0) {
                AppContext context = this.getAppId(appId);
                if (context == null) {
                    System.out.println("Not find App[" + appId + "]");
                } else {
                    try {
                        context = AppsAPIManager.getInstance().start(context);
                        System.out.println("STATE=" + context.getRuntimeState());
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            } else {
                try {
                    AppServiceController.getInstance().start();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("stop app") == 0) {
            String appId = cmd.substring(8).trim();
            if (appId.length() > 0) {
                AppContext context = this.getAppId(appId);
                if (context == null) {
                    System.out.println("Not find App[" + appId + "]");
                } else {
                    try {
                        context = AppsAPIManager.getInstance().stop(context);
                        System.out.println("STATE=" + context.getRuntimeState());
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            } else {
                try {
                    AppServiceController.getInstance().stop();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("restart app") == 0) {
            String appId = cmd.substring(11).trim();
            if (appId.length() > 0) {
                AppContext context = this.getAppId(appId);
                if (context == null) {
                    System.out.println("Not find App[" + appId + "]");
                } else {
                    try {
                        context = AppServiceController.getInstance().restart(context);
                        System.out.println("STATE=" + context.getRuntimeState());
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            } else {
                try {
                    AppServiceController.getInstance().restart();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("install app") == 0) {
            String appIds = cmd.substring(11).trim();
            try {
                List<String> v = new UtilString(appIds).split(",");
                ArrayList<String> newApps = new ArrayList<String>();
                int i = 0;
                while (i < v.size()) {
                    String appId = v.get(i);
                    if (appId != null && appId.trim().length() > 0) {
                        newApps.add(appId.trim());
                    }
                    ++i;
                }
                Map installApp = AppInstaller.install(newApps);
                for (String appId : installApp.keySet()) {
                    if (AppsResource.getAppContext((String)appId) == null) continue;
                    AppsAPIManager.getInstance().start(AppsResource.getAppContext((String)appId));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return true;
        }
        if (cmd.indexOf("upgrade app") == 0) {
            String appIds = cmd.substring(11).trim();
            try {
                List<String> v = new UtilString(appIds).split(",");
                ArrayList<String> newApps = new ArrayList<String>();
                int i = 0;
                while (i < v.size()) {
                    String appId = v.get(i);
                    if (appId != null && appId.trim().length() > 0) {
                        newApps.add(appId.trim());
                    }
                    ++i;
                }
                Map upgradeApp = AppUpgrader.upgrade(newApps);
                for (String appId : upgradeApp.keySet()) {
                    AppsAPIManager.getInstance().start(AppsResource.getAppContext((String)appId));
                }
                AppServiceController.getInstance().start();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return true;
        }
        if (cmd.indexOf("uninstall app") == 0) {
            String appId = cmd.substring(13).trim();
            AppContext context = this.getAppId(appId);
            if (context == null) {
                System.out.println("Not find App[" + appId + "]");
            } else {
                try {
                    Map uninstallApp = AppUninstaller.uninstall((AppContext)context);
                    for (String app : uninstallApp.keySet()) {
                        System.out.println(String.valueOf(app) + "==>" + (String)uninstallApp.get(app));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("recovery app") == 0) {
            String appId = cmd.substring(13).trim();
            AppContext context = this.getAppId(appId);
            if (context == null) {
                System.out.println("Not find App[" + appId + "]");
            } else {
                try {
                    AppUninstaller.recovery((AppContext)context);
                    AppsAPIManager.getInstance().start(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("remove app") == 0) {
            String appId = cmd.substring(10).trim();
            AppContext context = this.getAppId(appId);
            if (context == null) {
                System.out.println("Not find App[" + appId + "]");
            } else {
                try {
                    AppUninstaller.physicalDelete((AppContext)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("dist app") == 0) {
            AppContext context;
            String appId = cmd.substring(8).trim();
            boolean isDistSource = false;
            if (cmd.endsWith(" src")) {
                appId = appId.substring(0, appId.length() - 4);
                isDistSource = true;
            }
            if ((context = this.getAppId(appId)) == null) {
                System.out.println("Not find App[" + appId + "]");
            } else {
                try {
                    String filePath = AppDist.makeApp((AppContext)context, (boolean)isDistSource);
                    System.out.println("\u53ef\u5206\u53d1\u7684app\u5b89\u88c5\u6587\u4ef6\u5df2\u5b8c\u6210:" + filePath);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            return true;
        }
        if (cmd.indexOf("tree app") == 0) {
            String appId = cmd.substring(8).trim();
            AppContext context = AppsAPIManager.getInstance().getAppContext(appId);
            if (context == null) {
                context = AppsResource.getAppContext((String)"_bpm.platform");
            }
            try {
                List list = AppDependencyHelper.queryAppsTree((AppContext)context);
                HashMap<String, String> props = new HashMap<String, String>();
                for (AppContext app : list) {
                    String prop = "";
                    if (app.getParentContext() != null) {
                        prop = (String)props.get(app.getParentContext().getId());
                        if (prop == null) {
                            prop = "  +--";
                            props.put(app.getId(), prop);
                        } else {
                            prop = "  " + prop + "--";
                            props.put(app.getId(), prop);
                        }
                    }
                    System.out.println(String.valueOf(prop) + app.getId() + "[" + app.getTablePrefix() + "]" + "(" + app.getVersion() + "_" + app.getRuntimeState() + ")" + app.getName());
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return true;
        }
        if (cmd.indexOf("initdict app") == 0) {
            String appId = cmd.substring("initdict app".length()).trim();
            AppContext context = AppsAPIManager.getInstance().getAppContext(appId);
            if (context == null) {
                context = AppsResource.getAppContext((String)"_bpm.platform");
            }
            try {
                new InstallDictPackage("\u5b89\u88c5\u5b57\u5178\u6587\u4ef6", false).execute(context, null, null, -1);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return true;
        }
        if (cmd.indexOf("list app") != -1) {
            try {
                String app = cmd.substring("list app".length(), cmd.length()).trim();
                List<AppContext> list = new ArrayList();
                if (app.length() > 0) {
                    List tmps = AppsAPIManager.getInstance().getInstalledApps();
                    for (AppContext appContext : tmps) {
                        if (appContext.getId().indexOf(app) == -1) continue;
                        list.add(appContext);
                    }
                } else {
                    list = AppsAPIManager.getInstance().getInstalledApps();
                }
                int i = 0;
                for (AppContext context : list) {
                    AppLoader appLoader;
                    System.out.println("=====================" + ++i + "=====================");
                    System.out.println("AppId=[" + context.getId() + "]");
                    System.out.println("AppName=[" + context.getName() + "]");
                    System.out.println("DeveloperName=[" + context.getDeveloperName() + "]");
                    System.out.println("TablePrefix=[" + context.getTablePrefix() + "]");
                    System.out.println("DeveloperUrl=[" + context.getDeveloperUrl() + "]");
                    System.out.println("State=[" + context.getRuntimeState() + "]");
                    System.out.println("InstallTime=[" + UtilDate.datetimeFormat(context.getInstallDate() == null ? new Date() : context.getInstallDate()) + "]");
                    System.out.println("StartTime=[" + UtilDate.datetimeFormat(context.getStartTime() == null ? new Date() : context.getStartTime()) + "]");
                    if (app.length() > 0 && (appLoader = AppsLoader.getInstance().getAppLoader(context.getId())) != null) {
                        Map cs = appLoader.getAppController();
                        JSONArray ja = new JSONArray();
                        for (Map.Entry entry : cs.entrySet()) {
                            JSONObject jo = new JSONObject();
                            jo.put("jar", (Object)((AppController)entry.getValue()).getArchiveName());
                            jo.put("controller", entry.getKey());
                            Map maps = ((AppController)entry.getValue()).getCmds();
                            ArrayList<String> cmds = new ArrayList<String>();
                            for (Map.Entry appCmd : maps.entrySet()) {
                                String args = AppCommand.getCmdArgsInfo((AppCmd)appCmd.getValue());
                                cmds.add(String.valueOf((String)appCmd.getKey()) + "[" + args + "]/" + ((AppCmd)appCmd.getValue()).getAccess());
                            }
                            jo.put("cmds", cmds);
                            ja.add((Object)jo);
                        }
                        System.out.println("Controllers=" + ja);
                    }
                    System.out.println("Notification=[" + context.getNotification().size() + "]");
                    if (context.getNotification().size() <= 0) continue;
                    int beanNum = 0;
                    for (AppLogMsg bean : context.getNotification()) {
                        System.out.println(String.valueOf(++beanNum) + ".[" + UtilDate.datetimeFormat(new Timestamp(bean.getTime())) + "][" + bean.getLevel() + "][" + bean.getMsg() + "]");
                    }
                }
                System.out.println("---------------------------------------------------------------");
                int ready = 0;
                int active = 0;
                int stopped = 0;
                int failed = 0;
                int uninstalled = AppsResource.getUninstalledApps().size();
                for (AppContext appContext : list) {
                    if (appContext.getRuntimeState().equals("ACTIVE")) {
                        ++active;
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("FAILED")) {
                        ++failed;
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("READY")) {
                        ++ready;
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("STOPPED")) {
                        ++stopped;
                        continue;
                    }
                    if (!appContext.getRuntimeState().equals("UNINSTALLED")) continue;
                    ++uninstalled;
                }
                System.out.println("READY(" + ready + "),ACTIVE(" + active + "),STOPPED(" + stopped + "),FAILED(" + failed + "),UNINSTALLED(" + uninstalled + ")");
                System.out.println("---------------------------------------------------------------");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return true;
        }
        return false;
    }

    private static String getCmdArgsInfo(AppCmd cmd) {
        try {
            Field[] fs = AppCmd.class.getDeclaredFields();
            Object[] metas = null;
            Field[] fieldArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getType().isArray()) {
                    field.setAccessible(true);
                    metas = (Object[])field.get(cmd);
                }
                ++n2;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (metas != null) {
                Object[] objectArray = metas;
                int n3 = metas.length;
                n = 0;
                while (n < n3) {
                    Object object = objectArray[n];
                    Method m = object.getClass().getMethod("getParameterName", null);
                    m.setAccessible(true);
                    list.add(m.invoke(object, new Object[0]));
                    ++n;
                }
            }
            return UtilString.join(list, ",");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    public static void main(String[] args) {
        String s = "list app";
        String s1 = "list app context";
        System.out.println(s1.substring(s.length(), s1.length()));
    }

    public String help() {
        StringBuilder help = new StringBuilder();
        help.append("[list app]\n").append("-----------------------------------\n").append("\u5217\u51fa\u5f53\u524d\u5e73\u53f0\u5168\u90e8App\u4fe1\u606f\n");
        help.append("[tree app]\n").append("-----------------------------------\n").append("\u6811\u5f62\u663e\u793aApp\u7684\u4f9d\u8d56\u5173\u7cfb\n");
        help.append("[start app %AppId%]\n").append("-----------------------------------\n").append("\u542f\u52a8\u5168\u90e8\u6216\u6307\u5b9a\u7684App\n");
        help.append("[stop app %AppId%]\n").append("-----------------------------------\n").append("\u6682\u505c\u5168\u90e8\u6216\u6307\u5b9a\u7684App\n");
        help.append("[restart app %AppId%]\n").append("-----------------------------------\n").append("\u91cd\u542f\u5168\u90e8\u6216\u6307\u5b9a\u7684App\n");
        help.append("[install app %.app%,%.app%..]\n").append("-----------------------------------\n").append("\u5b89\u88c5\u6307\u5b9a\u7684App\u6587\u4ef6\uff0c\u591a\u4e2a\u6587\u4ef6\u540d\u7528\u534a\u89d2\u9017\u53f7\u9694\u5f00\n");
        help.append("[upgrade app %.app%,%.app%..]\n").append("-----------------------------------\n").append("\u5347\u7ea7\u6307\u5b9a\u7684App\u6587\u4ef6\uff0c\u591a\u4e2a\u6587\u4ef6\u540d\u7528\u534a\u89d2\u9017\u53f7\u9694\u5f00\n");
        help.append("[initdict app %AppId%]\n").append("-----------------------------------\n").append("\u521d\u59cb\u5316App\u7684\u57fa\u7840\u5b57\u5178\u4fe1\u606f\n");
        help.append("[dist app %AppId%]\n").append("-----------------------------------\n").append("\u6253\u5305\u6210\u53ef\u5206\u53d1\u7684app\u5b89\u88c5\u6587\u4ef6\uff0c\u751f\u6210\u5230/apps/dist\u76ee\u5f55\u4e0b\n");
        help.append("[uninstall app %AppId%]\n").append("-----------------------------------\n").append("\u5378\u8f7d\u6307\u5b9a\u7684App\n");
        help.append("[recovery app %AppId%]\n").append("-----------------------------------\n").append("\u8fd8\u539f\u5378\u8f7d\u7684App\n");
        help.append("[remove app %AppId%]\n").append("-----------------------------------\n").append("\u7269\u7406\u5220\u9664\u5df2\u5378\u8f7d\u7684App\n");
        return help.toString();
    }
}

