/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.shellcommand;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.server.shellcommand.BaseCommand;
import com.actionsoft.bpms.util.UtilSerialize;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class InfoCommand
implements BaseCommand {
    public boolean executeCommand(String cmd) {
        if (cmd.indexOf("info class") != -1) {
            String className = cmd.substring(cmd.indexOf("info class") + "info class".length()).trim();
            List apps = AppsAPIManager.getInstance().getInstalledApps();
            HashMap<String, URL> list = new HashMap<String, URL>();
            for (AppContext appContext : apps) {
                ClassLoader loader = appContext.getBindClassLoader();
                if (loader == null) continue;
                try {
                    Class<?> cls = Class.forName(className, false, loader);
                    list.put(appContext.getId(), cls.getResource("/" + className.replace('.', '/') + ".class"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            System.out.println(UtilSerialize.toJSONString(list));
            return true;
        }
        return false;
    }

    public String help() {
        StringBuilder help = new StringBuilder();
        help.append("[info class %className%]\n").append("-----------------------------------\n").append("\u5217\u51fa\u5bb9\u5668\u4e2d\u6240\u6709\u7684\u7c7b\u5b9a\u4e49\n");
        return help.toString();
    }
}

