/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.server.webcommand;

import com.actionsoft.bpms.commons.at.web.ExpressionEditorLeftWeb;
import com.actionsoft.bpms.commons.at.web.ExpressionEditorMainWeb;
import com.actionsoft.bpms.commons.at.web.ExpressionEditorTopWeb;
import com.actionsoft.bpms.commons.at.web.ExpressionEditorWeb;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.repository.ModelRepositoryWeb;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.schedule.web.ScheduleDesignWeb;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.bind.annotation.Param;
import com.actionsoft.bpms.ui.helper.UserQuery;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.List;
import org.quartz.CronExpression;

@Controller
public class ToolsController {
    @Mapping(value="CONSOLE_M_AT_EDITOR_OPEN")
    public String getMainExpressionWeb(UserContext me, String target_value, String text_value) {
        ExpressionEditorMainWeb web = new ExpressionEditorMainWeb(me);
        return web.getMainWeb(target_value, text_value);
    }

    @Mapping(value="CONSOLE_M_AT_LEFT_TREE_OPEN")
    public String getLeftExpressionTree(UserContext me) {
        ExpressionEditorLeftWeb web = new ExpressionEditorLeftWeb(me);
        return web.getWeb();
    }

    @Mapping(value="CONSOLE_M_AT_TOP_OPEN")
    public String getTopExpressionWeb(UserContext me) {
        ExpressionEditorTopWeb web = new ExpressionEditorTopWeb(me);
        return web.getWeb();
    }

    @Mapping(value="CONSOLE_M_AT_RIGHT_EDITOR_OPEN")
    public String getRightExpressionWeb(UserContext me, RequestParams params) {
        ExpressionEditorWeb web = new ExpressionEditorWeb(me);
        String target = params.get("target");
        String target_value = params.get("target_value");
        return web.getWeb(target, target_value);
    }

    @Mapping(value="CLIENT_M_AT_EDITOR_UI")
    public String getExpressionUI(UserContext me) {
        ExpressionEditorWeb web = new ExpressionEditorWeb(me);
        return web.getUI();
    }

    @Mapping(value="CONSOLE_M_AT_EDITOR_TABLES")
    public String getBoTables(UserContext me, @Param(defaultValue="_bpm.platform") String appId) {
        ExpressionEditorWeb web = new ExpressionEditorWeb(me);
        return web.getBOJson(appId);
    }

    @Mapping(value="CONSOLE_M_AT_EDITOR_FIELDS")
    public String getBoFields(UserContext me, String boName) {
        ExpressionEditorWeb web = new ExpressionEditorWeb(me);
        return web.getBOFieldsByBoName(boName);
    }

    @Mapping(value="CLIENT_M_AT_EDITOR_EXPS")
    public String getExpJson(UserContext me) {
        ExpressionEditorWeb web = new ExpressionEditorWeb(me);
        return web.getExpJson();
    }

    @Mapping(value="CLIENT_LIEVE_SEARCH_ALL_USER")
    public String liveSearchOfAllUser(UserContext me, String term) {
        JSONArray userArray = new JSONArray();
        ORGAPI orgApi = SDK.getORGAPI();
        List users = orgApi.liveSearchUser(me.getUID(), term, 10);
        for (UserModel user : users) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUID());
            json.put("label", (Object)user.getUserName());
            json.put("value", (Object)user.getUID());
            userArray.add((Object)json);
        }
        return userArray.toString();
    }

    @Mapping(value="CLIENT_LIEVE_SEARCH_AT_SOMEONE")
    public String liveSearchOfAtSomeone(UserContext me, String term, int limit) {
        if (limit == 0) {
            limit = 9;
        }
        JSONArray userArray = new JSONArray();
        ORGAPI orgApi = SDK.getORGAPI();
        List users = orgApi.liveSearchUser(me.getUID(), term, limit);
        for (UserModel user : users) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUniqueId());
            json.put("uid", (Object)user.getUID());
            if (user.getUserNameAlias().equals(user.getUID())) {
                json.put("userName", (Object)(String.valueOf(user.getUserNameAlias()) + "<" + user.getUID() + ">"));
            } else {
                json.put("userName", (Object)user.getUserNameAlias());
            }
            userArray.add((Object)json);
        }
        return userArray.toString();
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_LIST")
    public String getSysSCheduleList(UserContext me, @Param(defaultValue="") String optType, String appId) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.getList(optType, appId);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_APPLIST")
    public String getSysSCheduleAppList(UserContext me, String appName) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.getAppList(appName);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_CHECKSYS")
    public String getCheckSys(UserContext me, String id) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.checkSys(id);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_JSON")
    public String getSchedulesAsJson(UserContext me, String curPage, String rPP, String jobType, String jobName, String appId) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.getSchedulesAsJson(Integer.parseInt(curPage), Integer.parseInt(rPP), appId, jobType, jobName);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_LOGJSON")
    public String getScheduleLogsAsJson(UserContext me, String schedules) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.getScheduleLogsAsJson(schedules);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_REMOVE")
    public String AWS_Sys_Schedule_Remove(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String task = params.get("tasks");
        return web.deleteSchedules(task);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_SCHEDULE")
    public String schedule(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String scheduleId = params.get("tasks");
        String isSchedule = params.get("isSchedule");
        return web.schedule(scheduleId, isSchedule);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_CRON_CHECK")
    public String checkCronException(UserContext me, String cron) throws ParseException {
        return String.valueOf(new CronExpression(cron));
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_SETSYSTEM")
    public String setScheduleSystem(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String scheduleId = params.get("tasks");
        String beSystem = params.get("beSystem");
        return web.setSystem(scheduleId, beSystem);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_PAUSE")
    public String pauseSchedule(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String scheduleId = params.get("tasks");
        String isSchedule = params.get("isPause");
        return web.pauseSchedule(scheduleId, isSchedule);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_INTERRUPT")
    public String interruptSchedule(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String scheduleId = params.get("tasks");
        return web.interruptSchedule(scheduleId);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_OPEN")
    public String getSchedulePage(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String planId = params.get("planId");
        String appId = params.get("appId");
        boolean isNew = "".equals(planId) || "0".equals(planId);
        AWSScheduleModel scheduleModel = null;
        if (isNew) {
            scheduleModel = new AWSScheduleModel();
            scheduleModel.setId("");
            String jobType = params.get("jobType");
            scheduleModel.setGroup(jobType);
            scheduleModel.setAppId(appId);
        } else {
            scheduleModel = (AWSScheduleModel)AWSScheduleCache.getInstance().getModel(planId);
        }
        return web.getSchedulePage(scheduleModel);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_APPLY")
    public String AWS_Sys_Schedule_Apply(UserContext me, RequestParams params) throws Exception {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.applySchedule(params);
    }

    @Mapping(value="CONSOLE_COMMON_CLASS_CHECK")
    public String checkClass(UserContext me, String input, String appId, String type) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        return web.checkClass(input, appId, type);
    }

    @Mapping(value="CONSOLE_I_JOB_SCHEDULE_VIWELOG")
    public String openScheduleViewLog(UserContext me, RequestParams params) {
        ScheduleDesignWeb web = new ScheduleDesignWeb(me);
        String ids = params.get("planId");
        String result = web.getLogList(ids);
        return result;
    }

    @Mapping(value="CONSOLE_COMMON_AJAX_CHECK_USER_QUERY")
    public String checkUser(UserContext me, RequestParams params) {
        String checkData = params.get("checkData");
        return UserQuery.checkUser((String)checkData);
    }

    @Mapping(value="CLIENT_COMMON_LIVESEARCH_DATA_JSON")
    public String LiveSearch_QueryData(UserContext me, RequestParams params) {
        String query = params.get("query");
        String param1 = params.get("param1");
        String param2 = params.get("param2");
        String param3 = params.get("param3");
        String opt = params.get("opt");
        UserQuery uq = new UserQuery(me, query, opt);
        return uq.getWeb(param1, param2, param3);
    }

    @Mapping(value="CONSOLE_COMMON_AT_JSON")
    public String getATCommandToJSON(UserContext me, RequestParams params) {
        ExpressionEditorLeftWeb web = new ExpressionEditorLeftWeb(me);
        String filter = params.get("filter");
        return web.getATCommandToJSON(filter);
    }

    @Mapping(value="CONSOLE_COMMON_AT_JSON_FIELD")
    public String getFieldsOfTable(UserContext me, RequestParams params) {
        ExpressionEditorLeftWeb web = new ExpressionEditorLeftWeb(me);
        String metaDataId = params.get("metaDataId");
        return web.getFieldsOfTable(metaDataId);
    }

    @Mapping(value="CONSOLE_M_LICENSE_BATCH")
    public String batchLicense(UserContext me, String type, String modelId, String target, String appId) {
        ModelRepositoryWeb web = new ModelRepositoryWeb(me);
        return web.batchLicense(type, modelId, target, appId);
    }

    @Mapping(value="CONSOLE_M_LICENSE_TRANSFER")
    public String transfer(UserContext me, String type, String modelId, String target, String appId) {
        ModelRepositoryWeb web = new ModelRepositoryWeb(me);
        return web.transfer(me.getUID(), type, modelId, target, appId);
    }
}

