/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.io.UnsupportedEncodingException;

public final class ChineseCahrToEnUtil {
    private static final int[] li_SecPosValue = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] lc_FirstLetter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "w", "x", "y", "z"};

    public static String getFirstFirstLetter(String str) {
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        String _str = ChineseCahrToEnUtil.getFirstLetter(str.substring(0, 1));
        return _str.toUpperCase();
    }

    public static String getFirstLetter(String chinese) {
        if (chinese == null || chinese.trim().length() == 0) {
            return "";
        }
        chinese = chinese.substring(0, 1);
        if ((chinese = ChineseCahrToEnUtil.conversionStr(chinese, "GB2312", "ISO8859-1")).length() > 1) {
            int li_SectorCode = chinese.charAt(0);
            int li_PositionCode = chinese.charAt(1);
            int li_SecPosCode = (li_SectorCode -= 160) * 100 + (li_PositionCode -= 160);
            if (li_SecPosCode > 1600 && li_SecPosCode < 5590) {
                int i = 0;
                while (i < 23) {
                    if (li_SecPosCode >= li_SecPosValue[i] && li_SecPosCode < li_SecPosValue[i + 1]) {
                        chinese = lc_FirstLetter[i];
                        break;
                    }
                    ++i;
                }
            } else {
                chinese = ChineseCahrToEnUtil.conversionStr(chinese, "ISO8859-1", "GB2312");
                chinese = chinese.substring(0, 1);
            }
        }
        return chinese.toUpperCase();
    }

    private static String conversionStr(String str, String charsetName, String toCharsetName) {
        try {
            str = new String(str.getBytes(charsetName), toCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("\u5b57\u7b26\u4e32\u7f16\u7801\u8f6c\u6362\u5f02\u5e38\uff1a" + ex.getMessage());
        }
        return str;
    }

    public static void main(String[] args) {
        ChineseCahrToEnUtil cte = new ChineseCahrToEnUtil();
        System.out.println("\u83b7\u53d6\u62fc\u97f3\u9996\u5b57\u6bcd\uff1a" + ChineseCahrToEnUtil.getFirstFirstLetter("\u5317\u4eac\u8054\u5e2d\u529e"));
    }
}

