/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.server.apps.AppClassLoader;
import com.actionsoft.bpms.util.ExecCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;

public class ClassReflect {
    public static URL getResource(Class<?> c) {
        return c.getResource("/" + c.getName().replace('.', '/') + ".class");
    }

    public static Object execInAppContext(AppContext appContext, ExecCallback callback) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(appContext.getBindClassLoader());
            Object object = callback.act();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static Class<?> forName(String className, String appId) throws ClassNotFoundException {
        AppContext appContext;
        ClassLoader cl = null;
        if (appId != null && !"".equals(appId) && (appContext = AppsAPIManager.getInstance().getAppContext(appId)) != null) {
            cl = appContext.getBindClassLoader();
        }
        return Class.forName(className, false, ClassReflect.getDefault(cl));
    }

    public static Object getInstance(String className, Class<?>[] parameterTypes, Object[] initargs) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ClassReflect.getInstance(className, parameterTypes, initargs, ClassReflect.getDefault(null));
    }

    public static Object getInstance(String className, Class<?>[] parameterTypes, Object[] initargs, String appId) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ClassReflect.getInstance(className, parameterTypes, initargs, AppsAPIManager.getInstance().getAppContext(appId));
    }

    public static Object getInstance(String className, Class<?>[] parameterTypes, Object[] initargs, AppContext appContext) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ClassReflect.getInstance(ClassReflect.getConstructor(className, (Class[])parameterTypes, ClassReflect.getDefault(appContext.getBindClassLoader())), initargs);
    }

    public static Constructor getConstructor(String className, Class[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        return ClassReflect.getConstructor(className, parameterTypes, ClassReflect.getDefault(null));
    }

    public static Constructor getConstructor(String className, Class[] parameterTypes, String appId) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        return ClassReflect.getConstructor(className, parameterTypes, AppsAPIManager.getInstance().getAppContext(appId));
    }

    public static Constructor getConstructor(String className, Class[] parameterTypes, AppContext appContext) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> reflectClass = Class.forName(className, true, ClassReflect.getDefault(appContext.getBindClassLoader()));
        Constructor<?> con = reflectClass.getConstructor(parameterTypes);
        return con;
    }

    private static <T> T getInstance(Constructor<T> cons, Object[] initargs) throws IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        T obj = cons.newInstance(initargs);
        return obj;
    }

    private static Constructor getConstructor(String className, Class[] parameterTypes, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> reflectClass = Class.forName(className, true, ClassReflect.getDefault(classLoader));
        Constructor<?> con = reflectClass.getConstructor(parameterTypes);
        return con;
    }

    private static Object getInstance(String className, Class<?>[] parameterTypes, Object[] initargs, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ClassReflect.getInstance(ClassReflect.getConstructor(className, (Class[])parameterTypes, ClassReflect.getDefault(classLoader)), initargs);
    }

    private static ClassLoader getDefault(ClassLoader now) {
        if (now != null) {
            return now;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static AppContext getAppContext(Class<?> c) {
        ClassLoader cl = c.getClassLoader();
        if (cl instanceof AppClassLoader) {
            return ((AppClassLoader)cl).getAppContext();
        }
        return null;
    }
}

