/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.commons.database.BatchPreparedStatementSetter;
import com.actionsoft.bpms.commons.database.ColumnRowMapRowMapper;
import com.actionsoft.bpms.commons.database.DBPoolsManager;
import com.actionsoft.bpms.commons.database.DBUtils;
import com.actionsoft.bpms.commons.database.JQueryParser;
import com.actionsoft.bpms.commons.database.ResultSetExtractor;
import com.actionsoft.bpms.commons.database.ResultSetHandler;
import com.actionsoft.bpms.commons.database.RowCallbackHandler;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.database.RowMapperResultSetExtractor;
import com.actionsoft.bpms.commons.database.SingleRowExtractor;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.push.LocalDatabasePush;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.Sequence;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class DBSql {
    public static final String SQLSERVER_ROWLOCK = "";
    public static final String SQLSERVER_NOLOCK = " WITH(NOLOCK) ";
    private static final ThreadLocal<Boolean> DoSlaLog = new ThreadLocal();

    public static int update(String sql) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        int r = 0;
        try {
            r = DBSql.update(conn, sql);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int update(Connection conn, String sql) throws AWSDataAccessException {
        int n;
        Statement stmt = null;
        sql = DBSql.decodeSQL(sql);
        if (conn == null) {
            LocalDatabasePush.getInstance().dbFailing("[\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql]" + sql, null);
            throw new AWSDataAccessException("\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql");
        }
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            stmt = DBSql.createStatement(conn);
            int r = stmt.executeUpdate(sql);
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
            n = r;
        }
        catch (SQLException e) {
            try {
                DBSql.throwTranslateException(sql, e, false, new Object[0]);
            }
            catch (Throwable throwable) {
                DBSql.close(stmt, null);
                throw throwable;
            }
            DBSql.close(stmt, null);
            return 0;
        }
        DBSql.close(stmt, null);
        return n;
    }

    public static int update(String sql, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        int r = 0;
        try {
            r = DBSql.update(conn, sql, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int update(Connection conn, String sql, Map<String, Object> paraMap) throws AWSDataAccessException {
        int n;
        PreparedStatement stmt = null;
        sql = DBSql.decodeSQL(sql);
        if (conn == null) {
            LocalDatabasePush.getInstance().dbFailing("[\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql]" + sql, null);
            throw new AWSDataAccessException("\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql");
        }
        String realSql = SQLSERVER_ROWLOCK;
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
            int r = stmt.executeUpdate();
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
            n = r;
        }
        catch (SQLException e) {
            try {
                realSql = DBSql.getRealSQL(stmt, sql);
                DBSql.throwTranslateException(UtilString.isEmpty(realSql) ? sql : realSql, e, false, paraMap);
            }
            catch (Throwable throwable) {
                DBSql.close(stmt, null);
                throw throwable;
            }
            DBSql.close(stmt, null);
            return 0;
        }
        DBSql.close(stmt, null);
        return n;
    }

    public static int update(String sql, Object[] args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        int r = 0;
        try {
            r = DBSql.update(conn, sql, args);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int update(Connection conn, String sql, Object[] args) throws AWSDataAccessException {
        int n;
        PreparedStatement stmt = null;
        sql = DBSql.decodeSQL(sql);
        if (conn == null) {
            LocalDatabasePush.getInstance().dbFailing("[\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql]" + sql, null);
            throw new AWSDataAccessException("\u6ca1\u6709\u53ef\u7528\u7684Connection\u6267\u884csql");
        }
        String realSql = SQLSERVER_ROWLOCK;
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            stmt = DBSql.createPreparedStatement(conn, sql, args);
            int r = stmt.executeUpdate();
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
            n = r;
        }
        catch (SQLException e) {
            try {
                realSql = DBSql.getRealSQL(stmt, sql);
                DBSql.throwTranslateException(UtilString.isEmpty(realSql) ? sql : realSql, e, false, args);
            }
            catch (Throwable throwable) {
                DBSql.close(stmt, null);
                throw throwable;
            }
            DBSql.close(stmt, null);
            return 0;
        }
        DBSql.close(stmt, null);
        return n;
    }

    public static int[] batch(String[] sqls) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            int[] nArray = DBSql.batch(conn, sqls);
            return nArray;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static int[] batch(Connection conn, String[] sql) throws AWSDataAccessException {
        Statement stmt = null;
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            stmt = conn.createStatement();
            int[] rowsAffected = new int[sql.length];
            if (DBUtils.supportsBatchUpdates((Connection)stmt.getConnection())) {
                String[] stringArray = sql;
                int n = sql.length;
                int n2 = 0;
                while (n2 < n) {
                    String sqlStmt = stringArray[n2];
                    stmt.addBatch(sqlStmt);
                    ++n2;
                }
                rowsAffected = stmt.executeBatch();
            } else {
                int i = 0;
                while (i < sql.length) {
                    if (!stmt.execute(sql[i])) {
                        rowsAffected[i] = stmt.getUpdateCount();
                    } else {
                        DBUtils.throwInvalidBatchSQL((String)sql[i]);
                    }
                    ++i;
                }
            }
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql.toString());
            int[] nArray = rowsAffected;
            return nArray;
        }
        catch (SQLException e) {
            DBSql.throwTranslateException(sql, e, new Object[0]);
            int[] nArray = new int[]{};
            return nArray;
        }
        finally {
            DBSql.close(null, stmt, null);
        }
    }

    public static int[] batch(String sql, BatchPreparedStatementSetter pss) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            int[] nArray = DBSql.batch(conn, sql, pss);
            return nArray;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static int[] batchUpdate(String sql, List<Map<String, ?>> batchValues) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            int[] nArray = DBSql.batchUpdate(conn, sql, batchValues);
            return nArray;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static int[] batchUpdate(Connection conn, String sql, final List<Map<String, ?>> batchValues) throws AWSDataAccessException {
        final JQueryParser jp = new JQueryParser(sql, batchValues.get(0));
        String sqlx = jp.getPreparedSql();
        final List ps = jp.getParaNames();
        return DBSql.batch(conn, sqlx, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                Map tmp = (Map)batchValues.get(paramInt);
                int len = ps.size();
                int j = 0;
                while (j < len) {
                    jp.setValue(pst, j + 1, j, tmp.get(ps.get(j)), ps);
                    ++j;
                }
            }

            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    public static int[] batch(Connection conn, String sql, BatchPreparedStatementSetter pss) throws AWSDataAccessException {
        int[] nArray;
        PreparedStatement stmt = null;
        int[] res = null;
        try {
            SLATimeCollectionContext ctx = null;
            boolean isSLA = false;
            if (sql.indexOf("SYS_SLA_DIM_M") == -1 && sql.indexOf("SYS_SLA_DIM_H") == -1 && sql.indexOf("SYS_SLA_DIM_D") == -1) {
                isSLA = true;
            }
            if (isSLA) {
                ctx = LocalDatabasePush.getInstance().begin();
            }
            stmt = conn.prepareStatement(sql);
            int batchSize = pss.getBatchSize();
            if (DBUtils.supportsBatchUpdates((Connection)conn)) {
                int i = 0;
                while (i < batchSize) {
                    pss.setValues(stmt, i);
                    stmt.addBatch();
                    ++i;
                }
                res = stmt.executeBatch();
            } else {
                ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                int i = 0;
                while (i < batchSize) {
                    pss.setValues(stmt, i);
                    rowsAffected.add(stmt.executeUpdate());
                    ++i;
                }
                int[] rowsAffectedArray = new int[rowsAffected.size()];
                int i2 = 0;
                while (i2 < rowsAffectedArray.length) {
                    rowsAffectedArray[i2] = (Integer)rowsAffected.get(i2);
                    ++i2;
                }
                res = rowsAffectedArray;
            }
            if (isSLA) {
                LocalDatabasePush.getInstance().sqlEnd(ctx, "[batch-sql][batchSize=" + batchSize + "]" + sql);
            }
            nArray = res;
        }
        catch (SQLException e) {
            int[] nArray2;
            try {
                if (e.getNextException() != null) {
                    System.err.println(e.getNextException());
                }
                DBSql.throwTranslateException(DBSql.getRealSQL(stmt, sql), e, false, new Object[0]);
                nArray2 = new int[]{};
            }
            catch (Throwable throwable) {
                DBSql.close(stmt, null);
                throw throwable;
            }
            DBSql.close(stmt, null);
            return nArray2;
        }
        DBSql.close(stmt, null);
        return nArray;
    }

    public static <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            List list = (List)DBSql.query(conn, sql, new RowMapperResultSetExtractor(rowMapper), args);
            return list;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> List<T> query(String sql, Map<String, Object> paraMap, RowMapper<T> rowMapper) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            List<T> list = DBSql.query(conn, sql, paraMap, rowMapper);
            return list;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static void query(String sql, RowCallbackHandler rch, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            DBSql.query(conn, sql, new RowCallbackHandlerResultSetExtractor(rch), args);
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> T query(String sql, ResultSetExtractor<T> rse, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            T t = DBSql.query(conn, sql, rse, args);
            return t;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> T query(String sql, Map<String, Object> paraMap, ResultSetExtractor<T> rse) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            T t = DBSql.query(conn, sql, paraMap, rse);
            return t;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> List<T> query(Connection conn, String sql, RowMapper<T> rowMapper, Object ... args) throws AWSDataAccessException {
        return (List)DBSql.query(conn, sql, new RowMapperResultSetExtractor(rowMapper), args);
    }

    public static <T> List<T> query(Connection conn, String sql, Map<String, Object> paraMap, RowMapper<T> rowMapper) throws AWSDataAccessException {
        return (List)DBSql.query(conn, sql, paraMap, new RowMapperResultSetExtractor(rowMapper));
    }

    public static void query(String sql, Map<String, Object> paraMap, RowCallbackHandler rch) throws AWSDataAccessException {
        DBSql.query(sql, paraMap, new RowCallbackHandlerResultSetExtractor(rch));
    }

    public static void query(Connection conn, String sql, RowCallbackHandler rch, Object ... args) throws AWSDataAccessException {
        DBSql.query(conn, sql, new RowCallbackHandlerResultSetExtractor(rch), args);
    }

    public static void query(String sql, ResultSetHandler rh, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            DBSql.query(conn, sql, rh, args);
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static void query(Connection conn, String sql, ResultSetHandler rh, Object ... args) throws AWSDataAccessException {
        DBSql.query(conn, sql, new HandlerResultSetExtractor(rh), args);
    }

    public static <T> T query(Connection conn, String sql, ResultSetExtractor<T> rse, Object ... args) throws AWSDataAccessException {
        Object object;
        Connection tmp = conn == null ? DBSql.open() : null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String realSql = SQLSERVER_ROWLOCK;
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            ps = DBSql.createPreparedStatement(conn == null ? tmp : conn, sql, args);
            rs = ps.executeQuery();
            Object t = rse.extractData(rs);
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
            object = t;
        }
        catch (SQLException e) {
            try {
                realSql = DBSql.getRealSQL(ps, sql);
                DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, args);
            }
            catch (Throwable throwable) {
                DBSql.close(tmp, ps, rs);
                throw throwable;
            }
            DBSql.close(tmp, ps, rs);
            return null;
        }
        DBSql.close(tmp, ps, rs);
        return (T)object;
    }

    public static <T> T query(Connection conn, String sql, Map<String, Object> args, ResultSetExtractor<T> rse) throws AWSDataAccessException {
        Object object;
        Connection tmp = conn == null ? DBSql.open() : null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String realSql = SQLSERVER_ROWLOCK;
        try {
            SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
            ps = DBSql.createPreparedStatement(conn == null ? tmp : conn, sql, args);
            rs = ps.executeQuery();
            Object t = rse.extractData(rs);
            LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
            object = t;
        }
        catch (SQLException e) {
            try {
                realSql = DBSql.getRealSQL(ps, sql);
                DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, args);
            }
            catch (Throwable throwable) {
                DBSql.close(tmp, ps, rs);
                throw throwable;
            }
            DBSql.close(tmp, ps, rs);
            return null;
        }
        DBSql.close(tmp, ps, rs);
        return (T)object;
    }

    private static Statement createStatement(Connection conn) throws SQLException {
        return conn.createStatement();
    }

    private static PreparedStatement createPreparedStatement(Connection conn, String sql, Map<String, Object> paraMap) throws SQLException {
        JQueryParser jQueryParser = new JQueryParser(sql, paraMap);
        return jQueryParser.buildStatement(conn, paraMap);
    }

    private static PreparedStatement createPreparedStatement(Connection conn, String sql, Object[] params) throws SQLException {
        return DBUtils.createPreparedStatement((Connection)conn, (String)sql, (Object[])params);
    }

    private static ResultSet query(Connection conn, Statement stmt, String sql) throws SQLException {
        sql = DBSql.decodeSQL(sql);
        if (stmt instanceof PreparedStatement) {
            return ((PreparedStatement)stmt).executeQuery();
        }
        return stmt.executeQuery(sql);
    }

    private static void throwTranslateException(String[] sql, SQLException e, Object ... arg) {
        if (DBSql.isSLA()) {
            LocalDatabasePush.getInstance().dbFailing("batch sql:" + UtilString.join(Arrays.asList(sql), ","), e);
            System.err.println(sql);
        }
        throw new AWSDataAccessException(e);
    }

    private static void throwQueryException(String sql, SQLException e, Object ... arg) {
        DBSql.throwTranslateException(sql, e, true, arg);
    }

    private static void throwTranslateException(String sql, SQLException e, boolean query, Object ... arg) {
        if (DBSql.isSLA()) {
            e.printStackTrace();
            if (!query) {
                LocalDatabasePush.getInstance().dbFailing(sql, e);
                System.err.println(sql);
            }
        }
        throw new AWSDataAccessException(e.toString(), e);
    }

    public static <T> T getObject(String sql, RowMapper<T> rowMapper, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            T t = DBSql.getObject(conn, sql, rowMapper, args);
            return t;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> T getObject(Connection conn, String sql, RowMapper<T> rowMapper, Object ... args) throws AWSDataAccessException {
        return DBSql.query(conn, sql, new SingleRowExtractor(rowMapper), args);
    }

    public static <T> List<T> getList(String sql, Class<T> requiredType, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            List<T> list = DBSql.getList(conn, sql, requiredType, args);
            return list;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static <T> List<T> getList(Connection conn, String sql, final Class<T> requiredType, Object ... args) throws AWSDataAccessException {
        RowMapper rowMapper = new RowMapper<T>(){

            public T mapRow(ResultSet rs, int rowNum) throws SQLException {
                Object result = DBUtils.getResultSetValue((ResultSet)rs, (int)1, (Class)requiredType);
                if (result != null && requiredType != null && !requiredType.isInstance(result)) {
                    if (String.class == requiredType) {
                        result = result.toString();
                    } else {
                        Number.class.isAssignableFrom(requiredType);
                    }
                }
                return result;
            }
        };
        return DBSql.query(conn, sql, rowMapper, args);
    }

    public static RowMap getMap(String sql, Object ... args) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        try {
            RowMap rowMap = DBSql.getMap(conn, sql, args);
            return rowMap;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static RowMap getMap(Connection conn, String sql, Object ... args) throws AWSDataAccessException {
        return (RowMap)DBSql.query(conn, sql, new SingleRowExtractor((RowMapper)new ColumnRowMapRowMapper()), args);
    }

    public static List<RowMap> getMaps(String sql, Map<String, Object> args) throws AWSDataAccessException {
        return (List)DBSql.query(sql, args, new RowMapperResultSetExtractor((RowMapper)new ColumnRowMapRowMapper()));
    }

    public static List<RowMap> getMaps(Connection conn, String sql, Map<String, Object> args) throws AWSDataAccessException {
        return (List)DBSql.query(conn, sql, args, new RowMapperResultSetExtractor((RowMapper)new ColumnRowMapRowMapper()));
    }

    public static List<RowMap> getMaps(String sql, Object ... args) throws AWSDataAccessException {
        return (List)DBSql.query(sql, new RowMapperResultSetExtractor((RowMapper)new ColumnRowMapRowMapper()), args);
    }

    public static List<RowMap> getMaps(Connection conn, String sql, Object ... args) throws AWSDataAccessException {
        return (List)DBSql.query(conn, sql, new RowMapperResultSetExtractor((RowMapper)new ColumnRowMapRowMapper()), args);
    }

    @Deprecated
    public static List<RowMap> getList(String sql, Map<String, Object> args) throws AWSDataAccessException {
        return DBSql.getMaps(sql, args);
    }

    @Deprecated
    public static List<RowMap> getList(Connection conn, String sql, Map<String, Object> args) throws AWSDataAccessException {
        return DBSql.getMaps(conn, sql, args);
    }

    public static String getInsertStatement(String tableName, Map<String, ?> paraMap) {
        StringBuffer fields = new StringBuffer();
        StringBuffer vars = new StringBuffer();
        for (Map.Entry<String, ?> entry : paraMap.entrySet()) {
            fields.append(entry.getKey()).append(",");
            vars.append(":").append(entry.getKey()).append(",");
        }
        if (fields.toString().endsWith(",")) {
            fields.setLength(fields.length() - 1);
        }
        if (vars.toString().endsWith(",")) {
            vars.setLength(vars.length() - 1);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName).append("(").append(fields.toString()).append(")");
        sql.append(" VALUES ").append("(").append(vars.toString()).append(")");
        return sql.toString();
    }

    public static double getDouble(String sql, String filedName) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        double r = 0.0;
        try {
            r = DBSql.getDouble(conn, sql, filedName);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static double getDouble(String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        double r = 0.0;
        try {
            r = DBSql.getDouble(conn, sql, filedName, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static double getDouble(Connection conn, String sql, String filedName) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            Statement stmt;
            block4: {
                double d;
                stmt = null;
                rset = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rset = DBSql.query(conn, stmt, sql);
                    if (!rset.next()) break block4;
                    Double r = rset.getDouble(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    d = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return d;
            }
            DBSql.close(stmt, rset);
        }
        return 0.0;
    }

    public static double getDouble(Connection conn, String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            PreparedStatement stmt;
            block4: {
                double d;
                stmt = null;
                rset = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block4;
                    Double r = rset.getDouble(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    d = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return d;
            }
            DBSql.close(stmt, rset);
        }
        return 0.0;
    }

    public static int getInt(String sql, String filedName) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        int r = 0;
        try {
            r = DBSql.getInt(conn, sql, filedName);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int getInt(String sql, Object[] args) {
        Connection conn = null;
        int r = 0;
        try {
            conn = DBSql.open();
            r = DBSql.getInt(conn, sql, args);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int getInt(String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        int r = 0;
        try {
            r = DBSql.getInt(conn, sql, filedName, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static int getInt(Connection conn, String sql) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            Statement stmt;
            block4: {
                int n;
                stmt = null;
                rset = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rset = DBSql.query(conn, stmt, sql);
                    if (!rset.next()) break block4;
                    int r = rset.getInt(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    n = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return n;
            }
            DBSql.close(stmt, rset);
        }
        return 0;
    }

    public static int getInt(Connection conn, String sql, String filedName) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            Statement stmt;
            block4: {
                int n;
                stmt = null;
                rset = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rset = DBSql.query(conn, stmt, sql);
                    if (!rset.next()) break block4;
                    int r = rset.getInt(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    n = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return n;
            }
            DBSql.close(stmt, rset);
        }
        return 0;
    }

    public static int getInt(Connection conn, String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            PreparedStatement stmt;
            block4: {
                int n;
                stmt = null;
                rset = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block4;
                    int r = rset.getInt(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    n = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return n;
            }
            DBSql.close(stmt, rset);
        }
        return 0;
    }

    public static int getInt(Connection conn, String sql, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            PreparedStatement stmt;
            block4: {
                int n;
                stmt = null;
                rset = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block4;
                    int r = rset.getInt(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    n = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return n;
            }
            DBSql.close(stmt, rset);
        }
        return 0;
    }

    public static int getInt(Connection conn, String sql, Object[] args) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            PreparedStatement stmt;
            block4: {
                int n;
                stmt = null;
                rset = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, args);
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block4;
                    int r = rset.getInt(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    n = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, args);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return n;
            }
            DBSql.close(stmt, rset);
        }
        return 0;
    }

    public static long getLong(String sql, String filedName) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        long r = 0L;
        try {
            r = DBSql.getLong(conn, sql, filedName);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static long getLong(String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        long r = 0L;
        try {
            r = DBSql.getLong(conn, sql, filedName, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static long getLong(Connection conn, String sql) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            Statement stmt;
            block4: {
                long l;
                stmt = null;
                rset = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rset = DBSql.query(conn, stmt, sql);
                    if (!rset.next()) break block4;
                    Long r = rset.getLong(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    l = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return l;
            }
            DBSql.close(stmt, rset);
        }
        return 0L;
    }

    public static long getLong(Connection conn, String sql, String filedName) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            Statement stmt;
            block4: {
                long l;
                stmt = null;
                rset = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rset = DBSql.query(conn, stmt, sql);
                    if (!rset.next()) break block4;
                    Long r = rset.getLong(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    l = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return l;
            }
            DBSql.close(stmt, rset);
        }
        return 0L;
    }

    public static long getLong(Connection conn, String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rset;
            PreparedStatement stmt;
            block4: {
                long l;
                stmt = null;
                rset = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rset = stmt.executeQuery();
                    if (!rset.next()) break block4;
                    Long r = rset.getLong(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    l = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rset);
                        throw throwable;
                    }
                    DBSql.close(stmt, rset);
                    break block5;
                }
                DBSql.close(stmt, rset);
                return l;
            }
            DBSql.close(stmt, rset);
        }
        return 0L;
    }

    public static String getString(String sql) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        String r = SQLSERVER_ROWLOCK;
        try {
            r = DBSql.getString(conn, sql);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static String getString(String sql, String filedName) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        String r = SQLSERVER_ROWLOCK;
        try {
            r = DBSql.getString(conn, sql, filedName);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static String getString(String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        String r = SQLSERVER_ROWLOCK;
        try {
            r = DBSql.getString(conn, sql, filedName, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static String getString(String sql, Object[] args) throws AWSDataAccessException {
        Connection conn = null;
        String r = SQLSERVER_ROWLOCK;
        try {
            conn = DBSql.open();
            r = DBSql.getString(conn, sql, args);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static String getString(Connection conn, String sql, String filedName) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            Statement stmt;
            block4: {
                String string;
                stmt = null;
                rs = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    String r = rs.getString(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    string = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return string;
            }
            DBSql.close(stmt, rs);
        }
        return SQLSERVER_ROWLOCK;
    }

    public static String getString(Connection conn, String sql) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            Statement stmt;
            block4: {
                String string;
                stmt = null;
                rs = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    String r = rs.getString(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    string = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return string;
            }
            DBSql.close(stmt, rs);
        }
        return SQLSERVER_ROWLOCK;
    }

    public static String getString(Connection conn, String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            PreparedStatement stmt;
            block4: {
                String string;
                stmt = null;
                rs = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    String r = rs.getString(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    string = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return string;
            }
            DBSql.close(stmt, rs);
        }
        return SQLSERVER_ROWLOCK;
    }

    public static String getString(Connection conn, String sql, Object[] args) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            PreparedStatement stmt;
            block4: {
                String string;
                stmt = null;
                rs = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, args);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    String r = rs.getString(1);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    string = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, args);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return string;
            }
            DBSql.close(stmt, rs);
        }
        return SQLSERVER_ROWLOCK;
    }

    public static Timestamp getTimestamp(String sql, String filedName) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        Timestamp r = null;
        try {
            r = DBSql.getTimestamp(conn, sql, filedName);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static Timestamp getTimestamp(String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        Connection conn = DBSql.open();
        Timestamp r = null;
        try {
            r = DBSql.getTimestamp(conn, sql, filedName, paraMap);
        }
        finally {
            DBSql.close(conn);
        }
        return r;
    }

    public static Timestamp getTimestamp(Connection conn, String sql, String filedName) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            Statement stmt;
            block4: {
                Timestamp timestamp;
                stmt = null;
                rs = null;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createStatement(conn);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    Timestamp r = rs.getTimestamp(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    timestamp = r;
                }
                catch (SQLException e) {
                    try {
                        DBSql.throwQueryException(sql, e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return timestamp;
            }
            DBSql.close(stmt, rs);
        }
        return null;
    }

    public static Timestamp getTimestamp(Connection conn, String sql, String filedName, Map<String, Object> paraMap) throws AWSDataAccessException {
        block5: {
            ResultSet rs;
            PreparedStatement stmt;
            block4: {
                Timestamp timestamp;
                stmt = null;
                rs = null;
                String realSql = SQLSERVER_ROWLOCK;
                try {
                    SLATimeCollectionContext ctx = LocalDatabasePush.getInstance().begin();
                    stmt = DBSql.createPreparedStatement(conn, sql, paraMap);
                    rs = DBSql.query(conn, stmt, sql);
                    if (!rs.next()) break block4;
                    Timestamp r = rs.getTimestamp(filedName);
                    LocalDatabasePush.getInstance().sqlEnd(ctx, sql);
                    timestamp = r;
                }
                catch (SQLException e) {
                    try {
                        realSql = DBSql.getRealSQL(stmt, sql);
                        DBSql.throwQueryException(UtilString.isEmpty(realSql) ? sql : realSql, e, paraMap);
                    }
                    catch (Throwable throwable) {
                        DBSql.close(stmt, rs);
                        throw throwable;
                    }
                    DBSql.close(stmt, rs);
                    break block5;
                }
                DBSql.close(stmt, rs);
                return timestamp;
            }
            DBSql.close(stmt, rs);
        }
        return null;
    }

    public static String getDBDateFunction() {
        if (AWSServerConf.getDatabaseProvider().equals("oracle")) {
            return " sysdate ";
        }
        if (AWSServerConf.getDatabaseProvider().equals("mysql")) {
            return " now() ";
        }
        if (AWSServerConf.getDatabaseProvider().equals("sqlserver")) {
            return " getdate() ";
        }
        if (AWSServerConf.getDatabaseProvider().equals("db2")) {
            return " CURRENT TIMESTAMP ";
        }
        if (AWSServerConf.getDatabaseProvider().equals("sybase")) {
            return " getdate() ";
        }
        return "''";
    }

    public static String getDBFunctionOfDatetime(String date) {
        if (date == null || date.trim().length() == 0) {
            return "null";
        }
        if (AWSServerConf.getDatabaseProvider().equals("oracle")) {
            return "to_date('" + date + "','YYYY-mm-dd hh24:mi:ss')";
        }
        if (AWSServerConf.getDatabaseProvider().equals("mysql")) {
            return "'" + date + "'";
        }
        if (AWSServerConf.getDatabaseProvider().equals("db2")) {
            return "'" + date + "'";
        }
        return "'" + date + "'";
    }

    public static String getDBFunctionOfDate(String date) {
        if (date == null || date.trim().length() == 0) {
            return "null";
        }
        if (AWSServerConf.getDatabaseProvider().equals("oracle")) {
            return "to_date('" + date + "','YYYY-mm-dd')";
        }
        if (AWSServerConf.getDatabaseProvider().equals("mysql")) {
            if (date.indexOf(" ") > 0) {
                date = date.substring(0, date.indexOf(" "));
            }
            return "'" + date + "'";
        }
        if (AWSServerConf.getDatabaseProvider().equals("db2")) {
            if (date.indexOf(" ") > 0) {
                date = date.substring(0, date.indexOf(" "));
            }
            return "'" + date + "'";
        }
        if (AWSServerConf.getDatabaseProvider().equals("sybase")) {
            if (date.indexOf(" ") > 0) {
                date = date.substring(0, date.indexOf(" "));
            }
            return "'" + date + "'";
        }
        return "'" + date + "'";
    }

    public static boolean isExists(String tableName, String fieldName) {
        Connection conn = null;
        try {
            conn = DBSql.open();
            boolean bl = DBSql.isExists(conn, tableName, fieldName);
            return bl;
        }
        finally {
            DBSql.close(conn);
        }
    }

    public static boolean isExists(Connection conn, String tableName, String fieldName) {
        try {
            String dbType = AWSServerConf.getDatabaseProvider();
            String sql = SQLPagination.getPaginitionSQL(dbType, "select " + fieldName + " from " + tableName.toUpperCase(), 1, 1);
            DBSql.getString(conn, sql);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static String getRealSQL(Statement stmt, String sql) {
        String realSql = sql;
        if (AWSServerConf.isMySQL() && stmt != null) {
            realSql = stmt.toString();
        }
        return realSql;
    }

    public static boolean checkAWSDB() {
        try {
            if (!DBPoolsManager.getInstance().isInit()) {
                DBPoolsManager.getInstance().init();
            }
            DBSql.getString(SQLPagination.getPaginitionSQL("SELECT ID from WFC_TASK", 0, 1));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String convertLike(String str) {
        if (UtilString.isEmpty(str)) {
            return str;
        }
        str = str.replace("%", "\\%");
        str = str.replace("_", "\\_");
        str = str.replace("\\", "\\\\");
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        return str;
    }

    public static Connection open() {
        return DBPoolsManager.getInstance().getConnection();
    }

    public static void close(Connection conn) {
        DBSql.close(conn, null, null);
    }

    public static void close(Statement stmt, ResultSet rset) {
        DBSql.close(null, stmt, rset);
    }

    public static void close(Connection conn, Statement stmt, ResultSet rset) {
        try {
            if (rset != null) {
                rset.close();
                rset = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LocalDatabasePush.getInstance().dbFailing("close a ResultSet error", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LocalDatabasePush.getInstance().dbFailing("close a Statement error", e);
        }
        if (conn != null) {
            DBPoolsManager.getInstance().freeConnection(conn);
        }
    }

    public static long nextSequenceNum(String sequenceName) {
        return Sequence.nextValue(sequenceName);
    }

    public static String nextSequenceStr() {
        return UUIDGener.getUUID();
    }

    private static String decodeSQL(String sql) {
        return sql;
    }

    public static void stopSLA() {
        DoSlaLog.set(true);
    }

    public static boolean isSLA() {
        return DoSlaLog.get() == null;
    }

    public static void stopClear() {
        DoSlaLog.remove();
    }

    private static class HandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final ResultSetHandler rh;

        public HandlerResultSetExtractor(ResultSetHandler rh) {
            this.rh = rh;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            this.rh.handle(rs);
            return null;
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }
}

