/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import esapi.DefaultSecurityConfiguration;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;

public class Html {
    static {
        System.setProperty("org.owasp.esapi.resources", "./conf");
        System.setProperty("org.owasp.esapi.SecurityConfiguration", DefaultSecurityConfiguration.class.getName());
    }

    public static String encodeHtml(String responseType, String s) {
        if ("W".equalsIgnoreCase(responseType)) {
            return Html.encodeForHTML(s);
        }
        return s;
    }

    public static String escape(String v) {
        return v == null ? v : Html.escapeFull(v);
    }

    private static String escapeFull(String s) {
        s = s.replaceAll("\\\\\"", "~~~%%%");
        StringBuilder b = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '&' || ch == '\"' || ch == '<' || ch == '>' || ch == '\'' || ch == '\"' || ch == '/') {
                b.append("&#").append((int)ch).append(';');
            } else {
                b.append(ch);
            }
            ++i;
        }
        String t = b.toString();
        t = t.replaceAll("~~~%%%", "\\\\\"");
        return t;
    }

    public static Object toJSObj(String s) {
        return new JSObjWrap(s);
    }

    public static String toCallJS(String fn, Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(fn);
        sb.append("(");
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                Object arg = args[i];
                if (arg.getClass() == JSObjWrap.class) {
                    sb.append(arg);
                } else if (arg.getClass() == String.class) {
                    sb.append("'");
                    sb.append(Html.escape(((String)arg).replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")).replaceAll("\\\"", "\\\\\"").replaceAll("'", Matcher.quoteReplacement("\\'"))).replaceAll("\\n", "\\\\n"));
                    sb.append("'");
                } else if (Map.class.isAssignableFrom(arg.getClass())) {
                    sb.append(Html.escape(JSONObject.parseObject((String)JSON.toJSONString((Object)arg)).toString()));
                } else if (Collection.class.isAssignableFrom(arg.getClass())) {
                    sb.append(Html.escape(JSONArray.parseArray((String)JSON.toJSONString((Object)arg)).toString()));
                } else {
                    sb.append(Html.escape(arg.toString()));
                }
                if (i != args.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(");");
        return sb.toString();
    }

    public static String toHtmlJSEvent(String evt, String fn, Object[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(evt);
        sb.append("=");
        sb.append("\"");
        sb.append(Html.toCallJS(fn, args));
        sb.append("return false;\"");
        return sb.toString();
    }

    public static String encodeURLUtf8(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        try {
            return URLEncoder.encode(s, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeForHTMLAttribute(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        return ESAPI.encoder().encodeForHTMLAttribute(s);
    }

    public static String encodeForHTML(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        return ESAPI.encoder().encodeForHTML(s);
    }

    public static String encodeForJavaScript(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        return ESAPI.encoder().encodeForJavaScript(s);
    }

    public static String escapeDN(String name) {
        StringBuffer sb = new StringBuffer();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        int i = 0;
        while (i < name.length()) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case ',': {
                    sb.append("\\,");
                    break;
                }
                case '+': {
                    sb.append("\\+");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '<': {
                    sb.append("\\<");
                    break;
                }
                case '>': {
                    sb.append("\\>");
                    break;
                }
                case ';': {
                    sb.append("\\;");
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < filter.length()) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    break;
                }
                case '*': {
                    sb.append("\\2a");
                    break;
                }
                case '(': {
                    sb.append("\\28");
                    break;
                }
                case ')': {
                    sb.append("\\29");
                    break;
                }
                case '\u0000': {
                    sb.append("\\00");
                    break;
                }
                default: {
                    sb.append(curChar);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String encodeForCSS(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        return ESAPI.encoder().encodeForCSS(s);
    }

    public static String encodeForXML(String s) {
        return ESAPI.encoder().encodeForXML(s);
    }

    public static String encodeForXMLAttribute(String s) {
        return ESAPI.encoder().encodeForXMLAttribute(s);
    }

    public static String encodeForJSON(String s) {
        if (UtilString.isEmpty(s)) {
            return s;
        }
        return s.replace("<", "\\u003c");
    }

    public static void main(String[] args) {
        String a = "onclic=\"alert('asd')\"";
        System.out.println(a);
        a = a.replaceAll("\\\"", "\\\\\"");
        System.out.println(a);
    }

    public static String replaceHtmlEditorContent(String html, Map<String, String> values) {
        for (String key : values.keySet()) {
            String value = values.get(key);
            Pattern pattern = Pattern.compile(String.valueOf(key) + "=([^&]*)");
            Matcher matcher = pattern.matcher(html);
            while (matcher.find()) {
                String tmpFind = matcher.group();
                String tmp = "";
                tmp = String.valueOf(key) + "=" + value;
                html = html.replace(tmpFind, tmp);
            }
        }
        html = html.replaceAll("font-family:Wingdings", "");
        return html;
    }

    private static class JSObjWrap {
        private String jsObj;

        private JSObjWrap(String jsObj) {
            this.jsObj = jsObj;
        }

        public String toString() {
            return this.jsObj;
        }
    }
}

