/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.PaginationModel;

public class PaginationIndex {
    private long recordsTotalCount;
    private int pageLimit;
    private int currentPage;
    private String id;
    private PaginationModel paginationModel = new PaginationModel();

    public static void main(String[] args) {
        PaginationModel model = new PaginationModel();
        model.setCallback("alert(1)");
        PaginationIndex p = new PaginationIndex("Test", 4, 16L, 30, model);
        System.out.println(p.toString());
    }

    public PaginationIndex(String id, int currentPage, long recordsTotalCount, int pageLimit, PaginationModel paginationModel) {
        this.recordsTotalCount = recordsTotalCount;
        this.pageLimit = pageLimit;
        this.currentPage = currentPage;
        this.id = id;
        paginationModel.setPageLimit(pageLimit);
        this.paginationModel = paginationModel;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public String getId() {
        return this.id;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public PaginationModel getPaginationModel() {
        return this.paginationModel;
    }

    public long getRecordsTotalCount() {
        return this.recordsTotalCount;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }

    public void setPaginationModel(PaginationModel paginationModel) {
        this.paginationModel = paginationModel;
    }

    public void setRecordsTotalCount(long recordsTotalCount) {
        this.recordsTotalCount = recordsTotalCount;
    }

    public String toString() {
        String id = "Pagination" + this.getId();
        StringBuilder sb = new StringBuilder();
        sb.append("<div id='").append(id).append("'></div>\n");
        sb.append("<script>");
        sb.append("$('#").append(id).append("').pagination(").append(this.getRecordsTotalCount()).append(",");
        sb.append(this.getPaginationModel().toString());
        sb.append(");").append("\n");
        sb.append("</script>");
        return sb.toString();
    }
}

