/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.io.IOException;

public class PromptIO {
    public static String readStr(String prompt) {
        PromptIO.printPrompt(prompt);
        return PromptIO.readLine();
    }

    public static int readInt(String prompt) {
        while (true) {
            PromptIO.printPrompt(prompt);
            try {
                return Integer.valueOf(PromptIO.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not an integer. Please try again!");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String prompt) {
        while (true) {
            PromptIO.printPrompt(prompt);
            try {
                return Double.parseDouble(PromptIO.readLine().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Not a floating point number. Please try again!");
                continue;
            }
            break;
        }
    }

    private static void printPrompt(String str) {
        System.out.print(str);
        System.out.flush();
    }

    private static String readLine() {
        String r = "";
        boolean done = false;
        while (!done) {
            try {
                int ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                if ((char)ch == '\r') continue;
                r = String.valueOf(r) + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return r;
    }
}

