/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Hex;

public class RSA {
    public static boolean genKeys(String fileName, int keySize) {
        ObjectOutputStream oos = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.getProvider().setProperty("Provider", "www.actionsoft.com.cn");
            keyPairGen.getProvider().setProperty("Create Date", new Date().toString());
            keyPairGen.initialize(keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            System.out.println("Public Key Modulus (hex):");
            System.out.println(publicKey.getModulus().toString(16));
            oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(fileName) + ".cer"));
            oos.writeObject(publicKey);
            oos.close();
            oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(fileName) + ".pfx"));
            oos.writeObject(privateKey);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buf.length) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static boolean genKeys(String fileName) {
        return RSA.genKeys(fileName, 2048);
    }

    public static byte[] encrypt(String publicKeyFile, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        RSAPublicKey pubKey = RSA.getRSAPublicKey(publicKeyFile);
        if (pubKey == null) {
            return null;
        }
        return RSA.encrypt(pubKey, data);
    }

    public static byte[] decrypt(String privateKeyFile, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        RSAPrivateKey privateKey = RSA.getRSAPrivateKey(privateKeyFile);
        if (privateKey == null) {
            return null;
        }
        return RSA.decrypt(privateKey, data);
    }

    public static String decryptJsValue(String privateKeyFile, String jsValue) throws Exception {
        byte[] input = Hex.decode((String)jsValue);
        byte[] raw = RSA.decrypt(privateKeyFile, input);
        int i = raw.length - 1;
        while (i >= 0 && raw[i] != 0) {
            --i;
        }
        byte[] data = new byte[raw.length - ++i];
        int j = i;
        while (j < raw.length) {
            data[j - i] = raw[j];
            ++j;
        }
        return new String(data, "UTF-8");
    }

    private static RSAPublicKey getRSAPublicKey(String publicKeyFile) {
        RSAPublicKey pubKey = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(publicKeyFile));
            RSAPublicKey rSAPublicKey = pubKey = (RSAPublicKey)ois.readObject();
            return rSAPublicKey;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception exception) {}
        }
        return pubKey;
    }

    private static RSAPrivateKey getRSAPrivateKey(String privateKeyFile) {
        RSAPrivateKey privateKey = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(privateKeyFile));
            RSAPrivateKey rSAPrivateKey = privateKey = (RSAPrivateKey)ois.readObject();
            return rSAPrivateKey;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception exception) {}
        }
        return privateKey;
    }

    private static byte[] encrypt(RSAPublicKey publicKey, byte[] srcBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (publicKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            byte[] resultBytes = cipher.doFinal(srcBytes);
            return resultBytes;
        }
        return null;
    }

    private static byte[] decrypt(RSAPrivateKey privateKey, byte[] srcBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (privateKey != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            byte[] resultBytes = cipher.doFinal(srcBytes);
            return resultBytes;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("-----------------------------------------");
            System.out.println("RSA\u8bc1\u4e66\u751f\u6210\u5de5\u5177");
            System.out.println("RSA Certificate Generation Tool");
            System.out.println("-----------------------------------------\n");
            System.out.print("1.\u8bf7\u8f93\u5165\u8bc1\u4e66\u540d(Please Input File Name):\n");
            String fileName = in.readLine();
            System.out.print("2.\u8bf7\u8f93\u5165\u5bc6\u94a5\u957f\u5ea6\uff0c\u6700\u5c111024(Please Input Key Size):\n");
            String sizeStr = in.readLine();
            int keySize = 1024;
            try {
                keySize = Integer.parseInt(sizeStr.trim());
            }
            catch (Exception e) {
                System.out.print("\u5bc6\u94a5\u957f\u5ea6\u975e\u6cd5\uff0c\u9ed8\u8ba4\u4f7f\u75281024\u4f4d\n");
            }
            RSA.genKeys(fileName, keySize);
            System.out.print("\u8bc1\u4e66\u5df2\u751f\u6210\uff0c\u6309\u4efb\u610f\u952e\u7ed3\u675f(Certificate File Generated)\n");
            System.in.read();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

