/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.Hex;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SHA256 {
    public static final String KEY_ALGORITHM = "HmacSHA256";

    public static String generateKey() {
        return Hex.parseHexBinary(SHA256.getKey());
    }

    private static byte[] getKey() {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static String toDigest(String str, String password) throws Exception {
        return SHA256.toDigest(str, password.getBytes());
    }

    public static String toDigest(String str, byte[] password) throws Exception {
        Mac mac = null;
        SecretKeySpec signingKey = new SecretKeySpec(password, KEY_ALGORITHM);
        mac = Mac.getInstance(KEY_ALGORITHM);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(str.getBytes());
        return Hex.parseHexBinary(rawHmac);
    }

    public static void main(String[] args) throws Exception {
        String password = SHA256.generateKey();
        System.out.println("\u6458\u8981\u53e3\u4ee4=" + password);
        System.out.println(SHA256.toDigest("BPM\u4e1a\u52a1\u6d41\u7a0b\u7ba1\u7406", password));
    }
}

